/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.core.accounts;

import com.stripe.exception.StripeException;
import com.stripe.model.v2.core.AccountPersonToken;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.core.accounts.PersonTokenCreateParams;
import java.lang.reflect.Type;

public final class PersonTokenService
extends ApiService {
    public PersonTokenService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public AccountPersonToken create(String accountId, PersonTokenCreateParams params) throws StripeException {
        return this.create(accountId, params, null);
    }

    public AccountPersonToken create(String accountId, RequestOptions options) throws StripeException {
        return this.create(accountId, null, options);
    }

    public AccountPersonToken create(String accountId) throws StripeException {
        return this.create(accountId, null, null);
    }

    public AccountPersonToken create(String accountId, PersonTokenCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/accounts/%s/person_tokens", ApiResource.urlEncodeId(accountId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (AccountPersonToken)this.request(request, (Type)((Object)AccountPersonToken.class));
    }

    public AccountPersonToken retrieve(String accountId, String id) throws StripeException {
        return this.retrieve(accountId, id, null);
    }

    public AccountPersonToken retrieve(String accountId, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/accounts/%s/person_tokens/%s", ApiResource.urlEncodeId(accountId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (AccountPersonToken)this.request(request, (Type)((Object)AccountPersonToken.class));
    }
}

