/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.Transfer;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.TransferCreateParams;
import com.stripe.param.TransferListParams;
import com.stripe.param.TransferRetrieveParams;
import com.stripe.param.TransferUpdateParams;
import com.stripe.service.TransferReversalService;
import java.lang.reflect.Type;

public final class TransferService
extends ApiService {
    public TransferService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Transfer> list(TransferListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Transfer> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Transfer> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Transfer> list(TransferListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/transfers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Transfer>>(){}.getType());
    }

    public Transfer create(TransferCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Transfer create(TransferCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/transfers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Transfer)this.request(request, (Type)((Object)Transfer.class));
    }

    public Transfer retrieve(String transfer, TransferRetrieveParams params) throws StripeException {
        return this.retrieve(transfer, params, null);
    }

    public Transfer retrieve(String transfer, RequestOptions options) throws StripeException {
        return this.retrieve(transfer, null, options);
    }

    public Transfer retrieve(String transfer) throws StripeException {
        return this.retrieve(transfer, null, null);
    }

    public Transfer retrieve(String transfer, TransferRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/transfers/%s", ApiResource.urlEncodeId(transfer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Transfer)this.request(request, (Type)((Object)Transfer.class));
    }

    public Transfer update(String transfer, TransferUpdateParams params) throws StripeException {
        return this.update(transfer, params, null);
    }

    public Transfer update(String transfer, RequestOptions options) throws StripeException {
        return this.update(transfer, null, options);
    }

    public Transfer update(String transfer) throws StripeException {
        return this.update(transfer, null, null);
    }

    public Transfer update(String transfer, TransferUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/transfers/%s", ApiResource.urlEncodeId(transfer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Transfer)this.request(request, (Type)((Object)Transfer.class));
    }

    public TransferReversalService reversals() {
        return new TransferReversalService(this.getResponseGetter());
    }
}

