/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.InvoiceRenderingTemplate;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.InvoiceRenderingTemplateArchiveParams;
import com.stripe.param.InvoiceRenderingTemplateListParams;
import com.stripe.param.InvoiceRenderingTemplateRetrieveParams;
import com.stripe.param.InvoiceRenderingTemplateUnarchiveParams;
import java.lang.reflect.Type;

public final class InvoiceRenderingTemplateService
extends ApiService {
    public InvoiceRenderingTemplateService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<InvoiceRenderingTemplate> list(InvoiceRenderingTemplateListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<InvoiceRenderingTemplate> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<InvoiceRenderingTemplate> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<InvoiceRenderingTemplate> list(InvoiceRenderingTemplateListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/invoice_rendering_templates";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<InvoiceRenderingTemplate>>(){}.getType());
    }

    public InvoiceRenderingTemplate retrieve(String template, InvoiceRenderingTemplateRetrieveParams params) throws StripeException {
        return this.retrieve(template, params, null);
    }

    public InvoiceRenderingTemplate retrieve(String template, RequestOptions options) throws StripeException {
        return this.retrieve(template, null, options);
    }

    public InvoiceRenderingTemplate retrieve(String template) throws StripeException {
        return this.retrieve(template, null, null);
    }

    public InvoiceRenderingTemplate retrieve(String template, InvoiceRenderingTemplateRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoice_rendering_templates/%s", ApiResource.urlEncodeId(template));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceRenderingTemplate)this.request(request, (Type)((Object)InvoiceRenderingTemplate.class));
    }

    public InvoiceRenderingTemplate archive(String template, InvoiceRenderingTemplateArchiveParams params) throws StripeException {
        return this.archive(template, params, null);
    }

    public InvoiceRenderingTemplate archive(String template, RequestOptions options) throws StripeException {
        return this.archive(template, null, options);
    }

    public InvoiceRenderingTemplate archive(String template) throws StripeException {
        return this.archive(template, null, null);
    }

    public InvoiceRenderingTemplate archive(String template, InvoiceRenderingTemplateArchiveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoice_rendering_templates/%s/archive", ApiResource.urlEncodeId(template));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceRenderingTemplate)this.request(request, (Type)((Object)InvoiceRenderingTemplate.class));
    }

    public InvoiceRenderingTemplate unarchive(String template, InvoiceRenderingTemplateUnarchiveParams params) throws StripeException {
        return this.unarchive(template, params, null);
    }

    public InvoiceRenderingTemplate unarchive(String template, RequestOptions options) throws StripeException {
        return this.unarchive(template, null, options);
    }

    public InvoiceRenderingTemplate unarchive(String template) throws StripeException {
        return this.unarchive(template, null, null);
    }

    public InvoiceRenderingTemplate unarchive(String template, InvoiceRenderingTemplateUnarchiveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoice_rendering_templates/%s/unarchive", ApiResource.urlEncodeId(template));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceRenderingTemplate)this.request(request, (Type)((Object)InvoiceRenderingTemplate.class));
    }
}

