/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.InvoiceItem;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.InvoiceItemCreateParams;
import com.stripe.param.InvoiceItemListParams;
import com.stripe.param.InvoiceItemRetrieveParams;
import com.stripe.param.InvoiceItemUpdateParams;
import java.lang.reflect.Type;

public final class InvoiceItemService
extends ApiService {
    public InvoiceItemService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public InvoiceItem delete(String invoiceitem) throws StripeException {
        return this.delete(invoiceitem, null);
    }

    public InvoiceItem delete(String invoiceitem, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoiceitems/%s", ApiResource.urlEncodeId(invoiceitem));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options);
        return (InvoiceItem)this.request(request, (Type)((Object)InvoiceItem.class));
    }

    public InvoiceItem retrieve(String invoiceitem, InvoiceItemRetrieveParams params) throws StripeException {
        return this.retrieve(invoiceitem, params, null);
    }

    public InvoiceItem retrieve(String invoiceitem, RequestOptions options) throws StripeException {
        return this.retrieve(invoiceitem, null, options);
    }

    public InvoiceItem retrieve(String invoiceitem) throws StripeException {
        return this.retrieve(invoiceitem, null, null);
    }

    public InvoiceItem retrieve(String invoiceitem, InvoiceItemRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoiceitems/%s", ApiResource.urlEncodeId(invoiceitem));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceItem)this.request(request, (Type)((Object)InvoiceItem.class));
    }

    public InvoiceItem update(String invoiceitem, InvoiceItemUpdateParams params) throws StripeException {
        return this.update(invoiceitem, params, null);
    }

    public InvoiceItem update(String invoiceitem, RequestOptions options) throws StripeException {
        return this.update(invoiceitem, null, options);
    }

    public InvoiceItem update(String invoiceitem) throws StripeException {
        return this.update(invoiceitem, null, null);
    }

    public InvoiceItem update(String invoiceitem, InvoiceItemUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoiceitems/%s", ApiResource.urlEncodeId(invoiceitem));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceItem)this.request(request, (Type)((Object)InvoiceItem.class));
    }

    public StripeCollection<InvoiceItem> list(InvoiceItemListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<InvoiceItem> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<InvoiceItem> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<InvoiceItem> list(InvoiceItemListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/invoiceitems";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<InvoiceItem>>(){}.getType());
    }

    public InvoiceItem create(InvoiceItemCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public InvoiceItem create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public InvoiceItem create() throws StripeException {
        return this.create(null, null);
    }

    public InvoiceItem create(InvoiceItemCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/invoiceitems";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceItem)this.request(request, (Type)((Object)InvoiceItem.class));
    }
}

