/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UntypedMapDeserializer {
    private Strategy strategy;

    public UntypedMapDeserializer() {
        this.strategy = new Strategy(){

            @Override
            public void deserializeAndTransform(Map<String, Object> outerMap, Map.Entry<String, JsonElement> jsonEntry, UntypedMapDeserializer untypedMapDeserializer) {
                outerMap.put(jsonEntry.getKey(), untypedMapDeserializer.deserializeJsonElement(jsonEntry.getValue()));
            }
        };
    }

    UntypedMapDeserializer(Strategy strategy) {
        this.strategy = strategy;
    }

    public Map<String, Object> deserialize(JsonObject jsonObject) {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            this.strategy.deserializeAndTransform(objMap, entry, this);
        }
        return objMap;
    }

    Object deserializeJsonElement(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject()) {
            return this.deserialize(element.getAsJsonObject());
        }
        if (element.isJsonPrimitive()) {
            return this.deserializeJsonPrimitive(element.getAsJsonPrimitive());
        }
        if (element.isJsonArray()) {
            return this.deserializeJsonArray(element.getAsJsonArray());
        }
        System.err.println("Unknown JSON element type for element " + element + ". If you're seeing this message, it's probably a bug in the Stripe Java library. Please contact us by email at support@stripe.com.");
        return null;
    }

    private Object deserializeJsonPrimitive(JsonPrimitive element) {
        if (element.isBoolean()) {
            return element.getAsBoolean();
        }
        if (element.isNumber()) {
            return element.getAsNumber();
        }
        return element.getAsString();
    }

    private List<Object> deserializeJsonArray(JsonArray arr) {
        ArrayList<Object> elems = new ArrayList<Object>(arr.size());
        for (JsonElement elem : arr) {
            elems.add(this.deserializeJsonElement(elem));
        }
        return elems;
    }

    static interface Strategy {
        public void deserializeAndTransform(Map<String, Object> var1, Map.Entry<String, JsonElement> var2, UntypedMapDeserializer var3);
    }
}

