/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.Stripe;
import com.stripe.exception.ApiConnectionException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiResource;
import com.stripe.net.Authenticator;
import com.stripe.net.FormEncoder;
import com.stripe.net.HttpContent;
import com.stripe.net.HttpHeaders;
import com.stripe.net.JsonEncoder;
import com.stripe.net.RequestOptions;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public final class StripeRequest {
    private final ApiResource.RequestMethod method;
    private final URL url;
    private final HttpContent content;
    private final HttpHeaders headers;
    private final Map<String, Object> params;
    private final RequestOptions options;
    private final ApiMode apiMode;

    private StripeRequest(ApiResource.RequestMethod method, String url, HttpContent content, Map<String, Object> params, RequestOptions options, ApiMode apiMode) throws StripeException {
        try {
            this.content = content;
            this.params = params != null ? Collections.unmodifiableMap(params) : null;
            this.options = options != null ? options : RequestOptions.getDefault();
            this.method = method;
            this.url = StripeRequest.buildURL(method, url, params);
            this.headers = StripeRequest.buildHeaders(method, this.options, this.content, apiMode);
            this.apiMode = apiMode;
        }
        catch (IOException e) {
            throw new ApiConnectionException(String.format("IOException during API request to Stripe (%s): %s Please check your internet connection and try again. If this problem persists,you should check Stripe's service status at https://twitter.com/stripestatus, or let us know at support@stripe.com.", Stripe.getApiBase(), e.getMessage()), e);
        }
    }

    StripeRequest(ApiResource.RequestMethod method, String url, Map<String, Object> params, RequestOptions options, ApiMode apiMode) throws StripeException {
        try {
            this.params = params != null ? Collections.unmodifiableMap(params) : null;
            this.options = options;
            this.method = method;
            this.url = StripeRequest.buildURL(method, url, params);
            this.content = StripeRequest.buildContent(method, params, apiMode);
            this.headers = StripeRequest.buildHeaders(method, this.options, this.content, apiMode);
            this.apiMode = apiMode;
        }
        catch (IOException e) {
            throw new ApiConnectionException(String.format("IOException during API request to Stripe (%s): %s Please check your internet connection and try again. If this problem persists,you should check Stripe's service status at https://twitter.com/stripestatus, or let us know at support@stripe.com.", Stripe.getApiBase(), e.getMessage()), e);
        }
    }

    public static StripeRequest create(ApiResource.RequestMethod method, String url, Map<String, Object> params, RequestOptions options, ApiMode apiMode) throws StripeException {
        if (options == null) {
            throw new IllegalArgumentException("options parameter should not be null");
        }
        StripeRequest request = new StripeRequest(method, url, params, options, apiMode);
        Authenticator authenticator = options.getAuthenticator();
        if (authenticator == null) {
            throw new AuthenticationException("No API key provided. Set your API key using `Stripe.apiKey = \"<API-KEY>\"`. You can generate API keys from the Stripe Dashboard. See https://stripe.com/docs/api/authentication for details or contact support at https://support.stripe.com/email if you have any questions.", null, null, 0);
        }
        request = request.options().getAuthenticator().authenticate(request);
        return request;
    }

    public static StripeRequest createWithStringContent(ApiResource.RequestMethod method, String url, String content, RequestOptions options, ApiMode apiMode) throws StripeException {
        StripeRequest request = new StripeRequest(method, url, StripeRequest.buildContentFromString(method, content, apiMode), null, options, apiMode);
        Authenticator authenticator = options.getAuthenticator();
        if (authenticator == null) {
            throw new AuthenticationException("No API key provided. Set your API key using `Stripe.apiKey = \"<API-KEY>\"`. You can generate API keys from the Stripe Dashboard. See https://stripe.com/docs/api/authentication for details or contact support at https://support.stripe.com/email if you have any questions.", null, null, 0);
        }
        request = request.options().getAuthenticator().authenticate(request);
        return request;
    }

    public StripeRequest withAdditionalHeader(String name, String value) {
        return new StripeRequest(this.method, this.url, this.content, this.headers.withAdditionalHeader(name, value), this.params, this.options, this.apiMode);
    }

    private static URL buildURL(ApiResource.RequestMethod method, String spec, Map<String, Object> params) throws IOException {
        String queryString;
        StringBuilder sb = new StringBuilder();
        sb.append(spec);
        URL specUrl = new URL(spec);
        String specQueryString = specUrl.getQuery();
        if (method != ApiResource.RequestMethod.POST && params != null && (queryString = FormEncoder.createQueryString(params)) != null && !queryString.isEmpty()) {
            if (specQueryString != null && !specQueryString.isEmpty()) {
                sb.append("&");
            } else {
                sb.append("?");
            }
            sb.append(queryString);
        }
        return new URL(sb.toString());
    }

    private static HttpContent buildContent(ApiResource.RequestMethod method, Map<String, Object> params, ApiMode apiMode) throws IOException {
        if (method != ApiResource.RequestMethod.POST) {
            return null;
        }
        if (apiMode == ApiMode.V2) {
            return JsonEncoder.createHttpContent(params);
        }
        return FormEncoder.createHttpContent(params);
    }

    private static HttpContent buildContentFromString(ApiResource.RequestMethod method, String content, ApiMode apiMode) throws ApiConnectionException {
        if (method != ApiResource.RequestMethod.POST) {
            return null;
        }
        if (apiMode == ApiMode.V2) {
            return HttpContent.buildJsonContent(content);
        }
        HttpContent httpContent = null;
        try {
            httpContent = HttpContent.buildFormURLEncodedContent(content);
        }
        catch (IOException e) {
            StripeRequest.handleIOException(e);
        }
        return httpContent;
    }

    private static void handleIOException(IOException e) throws ApiConnectionException {
        throw new ApiConnectionException(String.format("IOException during API request to Stripe (%s): %s Please check your internet connection and try again. If this problem persists,you should check Stripe's service status at https://twitter.com/stripestatus, or let us know at support@stripe.com.", Stripe.getApiBase(), e.getMessage()), e);
    }

    private static HttpHeaders buildHeaders(ApiResource.RequestMethod method, RequestOptions options, HttpContent content, ApiMode apiMode) {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        headerMap.put("Accept", Arrays.asList("application/json"));
        headerMap.put("Accept-Charset", Arrays.asList(ApiResource.CHARSET.name()));
        if (RequestOptions.unsafeGetStripeVersionOverride(options) != null) {
            headerMap.put("Stripe-Version", Arrays.asList(RequestOptions.unsafeGetStripeVersionOverride(options)));
        } else if (options.getStripeVersion() != null) {
            headerMap.put("Stripe-Version", Arrays.asList(options.getStripeVersion()));
        }
        if (apiMode == ApiMode.V2 && content != null) {
            headerMap.put("Content-Type", Arrays.asList(content.contentType()));
        }
        if (options.getStripeContext() != null) {
            headerMap.put("Stripe-Context", Arrays.asList(options.getStripeContext()));
        }
        if (options.getStripeAccount() != null) {
            headerMap.put("Stripe-Account", Arrays.asList(options.getStripeAccount()));
        }
        if (options.getIdempotencyKey() != null) {
            headerMap.put("Idempotency-Key", Arrays.asList(options.getIdempotencyKey()));
        } else if (method == ApiResource.RequestMethod.POST || apiMode == ApiMode.V2 && method == ApiResource.RequestMethod.DELETE) {
            headerMap.put("Idempotency-Key", Arrays.asList(UUID.randomUUID().toString()));
        }
        return HttpHeaders.of(headerMap);
    }

    @Generated
    public ApiResource.RequestMethod method() {
        return this.method;
    }

    @Generated
    public URL url() {
        return this.url;
    }

    @Generated
    public HttpContent content() {
        return this.content;
    }

    @Generated
    public HttpHeaders headers() {
        return this.headers;
    }

    @Generated
    public Map<String, Object> params() {
        return this.params;
    }

    @Generated
    public RequestOptions options() {
        return this.options;
    }

    @Generated
    public ApiMode apiMode() {
        return this.apiMode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StripeRequest)) {
            return false;
        }
        StripeRequest other = (StripeRequest)o;
        ApiResource.RequestMethod this$method = this.method();
        ApiResource.RequestMethod other$method = other.method();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        URL this$url = this.url();
        URL other$url = other.url();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        HttpContent this$content = this.content();
        HttpContent other$content = other.content();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        HttpHeaders this$headers = this.headers();
        HttpHeaders other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, Object> this$params = this.params();
        Map<String, Object> other$params = other.params();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        RequestOptions this$options = this.options();
        RequestOptions other$options = other.options();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        ApiMode this$apiMode = this.apiMode();
        ApiMode other$apiMode = other.apiMode();
        return !(this$apiMode == null ? other$apiMode != null : !((Object)((Object)this$apiMode)).equals((Object)other$apiMode));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiResource.RequestMethod $method = this.method();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        URL $url = this.url();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        HttpContent $content = this.content();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        HttpHeaders $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, Object> $params = this.params();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        RequestOptions $options = this.options();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        ApiMode $apiMode = this.apiMode();
        result = result * 59 + ($apiMode == null ? 43 : ((Object)((Object)$apiMode)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StripeRequest(method=" + (Object)((Object)this.method()) + ", url=" + this.url() + ", content=" + this.content() + ", headers=" + this.headers() + ", params=" + this.params() + ", options=" + this.options() + ", apiMode=" + (Object)((Object)this.apiMode()) + ")";
    }

    @Generated
    protected StripeRequest(ApiResource.RequestMethod method, URL url, HttpContent content, HttpHeaders headers, Map<String, Object> params, RequestOptions options, ApiMode apiMode) {
        this.method = method;
        this.url = url;
        this.content = content;
        this.headers = headers;
        this.params = params;
        this.options = options;
        this.apiMode = apiMode;
    }
}

