/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.Authorization;
import com.stripe.model.treasury.CreditReversal;
import com.stripe.model.treasury.DebitReversal;
import com.stripe.model.treasury.InboundTransfer;
import com.stripe.model.treasury.OutboundPayment;
import com.stripe.model.treasury.OutboundTransfer;
import com.stripe.model.treasury.ReceivedCredit;
import com.stripe.model.treasury.ReceivedDebit;
import com.stripe.model.treasury.Transaction;
import com.stripe.model.treasury.TransactionEntryCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.TransactionEntryListParams;
import com.stripe.param.treasury.TransactionEntryRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class TransactionEntry
extends ApiResource
implements HasId {
    @SerializedName(value="balance_impact")
    BalanceImpact balanceImpact;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="effective_at")
    Long effectiveAt;
    @SerializedName(value="financial_account")
    String financialAccount;
    @SerializedName(value="flow")
    String flow;
    @SerializedName(value="flow_details")
    FlowDetails flowDetails;
    @SerializedName(value="flow_type")
    String flowType;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="transaction")
    ExpandableField<Transaction> transaction;
    @SerializedName(value="type")
    String type;

    public String getTransaction() {
        return this.transaction != null ? this.transaction.getId() : null;
    }

    public void setTransaction(String id) {
        this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
    }

    public Transaction getTransactionObject() {
        return this.transaction != null ? this.transaction.getExpanded() : null;
    }

    public void setTransactionObject(Transaction expandableObject) {
        this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
    }

    public static TransactionEntryCollection list(Map<String, Object> params) throws StripeException {
        return TransactionEntry.list(params, (RequestOptions)null);
    }

    public static TransactionEntryCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/transaction_entries";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (TransactionEntryCollection)TransactionEntry.getGlobalResponseGetter().request(request, (Type)((Object)TransactionEntryCollection.class));
    }

    public static TransactionEntryCollection list(TransactionEntryListParams params) throws StripeException {
        return TransactionEntry.list(params, (RequestOptions)null);
    }

    public static TransactionEntryCollection list(TransactionEntryListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/transaction_entries";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (TransactionEntryCollection)TransactionEntry.getGlobalResponseGetter().request(request, (Type)((Object)TransactionEntryCollection.class));
    }

    public static TransactionEntry retrieve(String id) throws StripeException {
        return TransactionEntry.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static TransactionEntry retrieve(String id, RequestOptions options) throws StripeException {
        return TransactionEntry.retrieve(id, (Map<String, Object>)null, options);
    }

    public static TransactionEntry retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/transaction_entries/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (TransactionEntry)TransactionEntry.getGlobalResponseGetter().request(request, (Type)((Object)TransactionEntry.class));
    }

    public static TransactionEntry retrieve(String id, TransactionEntryRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/transaction_entries/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (TransactionEntry)TransactionEntry.getGlobalResponseGetter().request(request, (Type)((Object)TransactionEntry.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.balanceImpact, responseGetter);
        this.trySetResponseGetter(this.flowDetails, responseGetter);
        this.trySetResponseGetter(this.transaction, responseGetter);
    }

    @Generated
    public BalanceImpact getBalanceImpact() {
        return this.balanceImpact;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Long getEffectiveAt() {
        return this.effectiveAt;
    }

    @Generated
    public String getFinancialAccount() {
        return this.financialAccount;
    }

    @Generated
    public String getFlow() {
        return this.flow;
    }

    @Generated
    public FlowDetails getFlowDetails() {
        return this.flowDetails;
    }

    @Generated
    public String getFlowType() {
        return this.flowType;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setBalanceImpact(BalanceImpact balanceImpact) {
        this.balanceImpact = balanceImpact;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setEffectiveAt(Long effectiveAt) {
        this.effectiveAt = effectiveAt;
    }

    @Generated
    public void setFinancialAccount(String financialAccount) {
        this.financialAccount = financialAccount;
    }

    @Generated
    public void setFlow(String flow) {
        this.flow = flow;
    }

    @Generated
    public void setFlowDetails(FlowDetails flowDetails) {
        this.flowDetails = flowDetails;
    }

    @Generated
    public void setFlowType(String flowType) {
        this.flowType = flowType;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionEntry)) {
            return false;
        }
        TransactionEntry other = (TransactionEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$effectiveAt = this.getEffectiveAt();
        Long other$effectiveAt = other.getEffectiveAt();
        if (this$effectiveAt == null ? other$effectiveAt != null : !((Object)this$effectiveAt).equals(other$effectiveAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        BalanceImpact this$balanceImpact = this.getBalanceImpact();
        BalanceImpact other$balanceImpact = other.getBalanceImpact();
        if (this$balanceImpact == null ? other$balanceImpact != null : !((Object)this$balanceImpact).equals(other$balanceImpact)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$financialAccount = this.getFinancialAccount();
        String other$financialAccount = other.getFinancialAccount();
        if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        FlowDetails this$flowDetails = this.getFlowDetails();
        FlowDetails other$flowDetails = other.getFlowDetails();
        if (this$flowDetails == null ? other$flowDetails != null : !((Object)this$flowDetails).equals(other$flowDetails)) {
            return false;
        }
        String this$flowType = this.getFlowType();
        String other$flowType = other.getFlowType();
        if (this$flowType == null ? other$flowType != null : !this$flowType.equals(other$flowType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$transaction = this.getTransaction();
        String other$transaction = other.getTransaction();
        if (this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $effectiveAt = this.getEffectiveAt();
        result = result * 59 + ($effectiveAt == null ? 43 : ((Object)$effectiveAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        BalanceImpact $balanceImpact = this.getBalanceImpact();
        result = result * 59 + ($balanceImpact == null ? 43 : ((Object)$balanceImpact).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $financialAccount = this.getFinancialAccount();
        result = result * 59 + ($financialAccount == null ? 43 : $financialAccount.hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        FlowDetails $flowDetails = this.getFlowDetails();
        result = result * 59 + ($flowDetails == null ? 43 : ((Object)$flowDetails).hashCode());
        String $flowType = this.getFlowType();
        result = result * 59 + ($flowType == null ? 43 : $flowType.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $transaction = this.getTransaction();
        result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class BalanceImpact
    extends StripeObject {
        @SerializedName(value="cash")
        Long cash;
        @SerializedName(value="inbound_pending")
        Long inboundPending;
        @SerializedName(value="outbound_pending")
        Long outboundPending;

        @Generated
        public Long getCash() {
            return this.cash;
        }

        @Generated
        public Long getInboundPending() {
            return this.inboundPending;
        }

        @Generated
        public Long getOutboundPending() {
            return this.outboundPending;
        }

        @Generated
        public void setCash(Long cash) {
            this.cash = cash;
        }

        @Generated
        public void setInboundPending(Long inboundPending) {
            this.inboundPending = inboundPending;
        }

        @Generated
        public void setOutboundPending(Long outboundPending) {
            this.outboundPending = outboundPending;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BalanceImpact)) {
                return false;
            }
            BalanceImpact other = (BalanceImpact)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$cash = this.getCash();
            Long other$cash = other.getCash();
            if (this$cash == null ? other$cash != null : !((Object)this$cash).equals(other$cash)) {
                return false;
            }
            Long this$inboundPending = this.getInboundPending();
            Long other$inboundPending = other.getInboundPending();
            if (this$inboundPending == null ? other$inboundPending != null : !((Object)this$inboundPending).equals(other$inboundPending)) {
                return false;
            }
            Long this$outboundPending = this.getOutboundPending();
            Long other$outboundPending = other.getOutboundPending();
            return !(this$outboundPending == null ? other$outboundPending != null : !((Object)this$outboundPending).equals(other$outboundPending));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BalanceImpact;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $cash = this.getCash();
            result = result * 59 + ($cash == null ? 43 : ((Object)$cash).hashCode());
            Long $inboundPending = this.getInboundPending();
            result = result * 59 + ($inboundPending == null ? 43 : ((Object)$inboundPending).hashCode());
            Long $outboundPending = this.getOutboundPending();
            result = result * 59 + ($outboundPending == null ? 43 : ((Object)$outboundPending).hashCode());
            return result;
        }
    }

    public static class FlowDetails
    extends StripeObject {
        @SerializedName(value="credit_reversal")
        CreditReversal creditReversal;
        @SerializedName(value="debit_reversal")
        DebitReversal debitReversal;
        @SerializedName(value="inbound_transfer")
        InboundTransfer inboundTransfer;
        @SerializedName(value="issuing_authorization")
        Authorization issuingAuthorization;
        @SerializedName(value="outbound_payment")
        OutboundPayment outboundPayment;
        @SerializedName(value="outbound_transfer")
        OutboundTransfer outboundTransfer;
        @SerializedName(value="received_credit")
        ReceivedCredit receivedCredit;
        @SerializedName(value="received_debit")
        ReceivedDebit receivedDebit;
        @SerializedName(value="type")
        String type;

        @Generated
        public CreditReversal getCreditReversal() {
            return this.creditReversal;
        }

        @Generated
        public DebitReversal getDebitReversal() {
            return this.debitReversal;
        }

        @Generated
        public InboundTransfer getInboundTransfer() {
            return this.inboundTransfer;
        }

        @Generated
        public Authorization getIssuingAuthorization() {
            return this.issuingAuthorization;
        }

        @Generated
        public OutboundPayment getOutboundPayment() {
            return this.outboundPayment;
        }

        @Generated
        public OutboundTransfer getOutboundTransfer() {
            return this.outboundTransfer;
        }

        @Generated
        public ReceivedCredit getReceivedCredit() {
            return this.receivedCredit;
        }

        @Generated
        public ReceivedDebit getReceivedDebit() {
            return this.receivedDebit;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setCreditReversal(CreditReversal creditReversal) {
            this.creditReversal = creditReversal;
        }

        @Generated
        public void setDebitReversal(DebitReversal debitReversal) {
            this.debitReversal = debitReversal;
        }

        @Generated
        public void setInboundTransfer(InboundTransfer inboundTransfer) {
            this.inboundTransfer = inboundTransfer;
        }

        @Generated
        public void setIssuingAuthorization(Authorization issuingAuthorization) {
            this.issuingAuthorization = issuingAuthorization;
        }

        @Generated
        public void setOutboundPayment(OutboundPayment outboundPayment) {
            this.outboundPayment = outboundPayment;
        }

        @Generated
        public void setOutboundTransfer(OutboundTransfer outboundTransfer) {
            this.outboundTransfer = outboundTransfer;
        }

        @Generated
        public void setReceivedCredit(ReceivedCredit receivedCredit) {
            this.receivedCredit = receivedCredit;
        }

        @Generated
        public void setReceivedDebit(ReceivedDebit receivedDebit) {
            this.receivedDebit = receivedDebit;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FlowDetails)) {
                return false;
            }
            FlowDetails other = (FlowDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CreditReversal this$creditReversal = this.getCreditReversal();
            CreditReversal other$creditReversal = other.getCreditReversal();
            if (this$creditReversal == null ? other$creditReversal != null : !((Object)this$creditReversal).equals(other$creditReversal)) {
                return false;
            }
            DebitReversal this$debitReversal = this.getDebitReversal();
            DebitReversal other$debitReversal = other.getDebitReversal();
            if (this$debitReversal == null ? other$debitReversal != null : !((Object)this$debitReversal).equals(other$debitReversal)) {
                return false;
            }
            InboundTransfer this$inboundTransfer = this.getInboundTransfer();
            InboundTransfer other$inboundTransfer = other.getInboundTransfer();
            if (this$inboundTransfer == null ? other$inboundTransfer != null : !((Object)this$inboundTransfer).equals(other$inboundTransfer)) {
                return false;
            }
            Authorization this$issuingAuthorization = this.getIssuingAuthorization();
            Authorization other$issuingAuthorization = other.getIssuingAuthorization();
            if (this$issuingAuthorization == null ? other$issuingAuthorization != null : !((Object)this$issuingAuthorization).equals(other$issuingAuthorization)) {
                return false;
            }
            OutboundPayment this$outboundPayment = this.getOutboundPayment();
            OutboundPayment other$outboundPayment = other.getOutboundPayment();
            if (this$outboundPayment == null ? other$outboundPayment != null : !((Object)this$outboundPayment).equals(other$outboundPayment)) {
                return false;
            }
            OutboundTransfer this$outboundTransfer = this.getOutboundTransfer();
            OutboundTransfer other$outboundTransfer = other.getOutboundTransfer();
            if (this$outboundTransfer == null ? other$outboundTransfer != null : !((Object)this$outboundTransfer).equals(other$outboundTransfer)) {
                return false;
            }
            ReceivedCredit this$receivedCredit = this.getReceivedCredit();
            ReceivedCredit other$receivedCredit = other.getReceivedCredit();
            if (this$receivedCredit == null ? other$receivedCredit != null : !((Object)this$receivedCredit).equals(other$receivedCredit)) {
                return false;
            }
            ReceivedDebit this$receivedDebit = this.getReceivedDebit();
            ReceivedDebit other$receivedDebit = other.getReceivedDebit();
            if (this$receivedDebit == null ? other$receivedDebit != null : !((Object)this$receivedDebit).equals(other$receivedDebit)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FlowDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CreditReversal $creditReversal = this.getCreditReversal();
            result = result * 59 + ($creditReversal == null ? 43 : ((Object)$creditReversal).hashCode());
            DebitReversal $debitReversal = this.getDebitReversal();
            result = result * 59 + ($debitReversal == null ? 43 : ((Object)$debitReversal).hashCode());
            InboundTransfer $inboundTransfer = this.getInboundTransfer();
            result = result * 59 + ($inboundTransfer == null ? 43 : ((Object)$inboundTransfer).hashCode());
            Authorization $issuingAuthorization = this.getIssuingAuthorization();
            result = result * 59 + ($issuingAuthorization == null ? 43 : ((Object)$issuingAuthorization).hashCode());
            OutboundPayment $outboundPayment = this.getOutboundPayment();
            result = result * 59 + ($outboundPayment == null ? 43 : ((Object)$outboundPayment).hashCode());
            OutboundTransfer $outboundTransfer = this.getOutboundTransfer();
            result = result * 59 + ($outboundTransfer == null ? 43 : ((Object)$outboundTransfer).hashCode());
            ReceivedCredit $receivedCredit = this.getReceivedCredit();
            result = result * 59 + ($receivedCredit == null ? 43 : ((Object)$receivedCredit).hashCode());
            ReceivedDebit $receivedDebit = this.getReceivedDebit();
            result = result * 59 + ($receivedDebit == null ? 43 : ((Object)$receivedDebit).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }
}

