/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.treasury.FinancialAccountCollection;
import com.stripe.model.treasury.FinancialAccountFeatures;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.FinancialAccountCloseParams;
import com.stripe.param.treasury.FinancialAccountCreateParams;
import com.stripe.param.treasury.FinancialAccountListParams;
import com.stripe.param.treasury.FinancialAccountRetrieveFeaturesParams;
import com.stripe.param.treasury.FinancialAccountRetrieveParams;
import com.stripe.param.treasury.FinancialAccountUpdateFeaturesParams;
import com.stripe.param.treasury.FinancialAccountUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class FinancialAccount
extends ApiResource
implements HasId,
MetadataStore<FinancialAccount> {
    @SerializedName(value="active_features")
    List<String> activeFeatures;
    @SerializedName(value="balance")
    Balance balance;
    @SerializedName(value="country")
    String country;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="features")
    FinancialAccountFeatures features;
    @SerializedName(value="financial_addresses")
    List<FinancialAddress> financialAddresses;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="is_default")
    Boolean isDefault;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="nickname")
    String nickname;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="pending_features")
    List<String> pendingFeatures;
    @SerializedName(value="platform_restrictions")
    PlatformRestrictions platformRestrictions;
    @SerializedName(value="restricted_features")
    List<String> restrictedFeatures;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="status_details")
    StatusDetails statusDetails;
    @SerializedName(value="supported_currencies")
    List<String> supportedCurrencies;

    public FinancialAccount close() throws StripeException {
        return this.close((Map<String, Object>)null, (RequestOptions)null);
    }

    public FinancialAccount close(RequestOptions options) throws StripeException {
        return this.close((Map<String, Object>)null, options);
    }

    public FinancialAccount close(Map<String, Object> params) throws StripeException {
        return this.close(params, (RequestOptions)null);
    }

    public FinancialAccount close(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s/close", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (FinancialAccount)this.getResponseGetter().request(request, (Type)((Object)FinancialAccount.class));
    }

    public FinancialAccount close(FinancialAccountCloseParams params) throws StripeException {
        return this.close(params, (RequestOptions)null);
    }

    public FinancialAccount close(FinancialAccountCloseParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s/close", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (FinancialAccount)this.getResponseGetter().request(request, (Type)((Object)FinancialAccount.class));
    }

    public static FinancialAccount create(Map<String, Object> params) throws StripeException {
        return FinancialAccount.create(params, (RequestOptions)null);
    }

    public static FinancialAccount create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/financial_accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (FinancialAccount)FinancialAccount.getGlobalResponseGetter().request(request, (Type)((Object)FinancialAccount.class));
    }

    public static FinancialAccount create(FinancialAccountCreateParams params) throws StripeException {
        return FinancialAccount.create(params, (RequestOptions)null);
    }

    public static FinancialAccount create(FinancialAccountCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/financial_accounts";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (FinancialAccount)FinancialAccount.getGlobalResponseGetter().request(request, (Type)((Object)FinancialAccount.class));
    }

    public static FinancialAccountCollection list(Map<String, Object> params) throws StripeException {
        return FinancialAccount.list(params, (RequestOptions)null);
    }

    public static FinancialAccountCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/financial_accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (FinancialAccountCollection)FinancialAccount.getGlobalResponseGetter().request(request, (Type)((Object)FinancialAccountCollection.class));
    }

    public static FinancialAccountCollection list(FinancialAccountListParams params) throws StripeException {
        return FinancialAccount.list(params, (RequestOptions)null);
    }

    public static FinancialAccountCollection list(FinancialAccountListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/financial_accounts";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (FinancialAccountCollection)FinancialAccount.getGlobalResponseGetter().request(request, (Type)((Object)FinancialAccountCollection.class));
    }

    public static FinancialAccount retrieve(String financialAccount) throws StripeException {
        return FinancialAccount.retrieve(financialAccount, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static FinancialAccount retrieve(String financialAccount, RequestOptions options) throws StripeException {
        return FinancialAccount.retrieve(financialAccount, (Map<String, Object>)null, options);
    }

    public static FinancialAccount retrieve(String financialAccount, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s", ApiResource.urlEncodeId(financialAccount));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (FinancialAccount)FinancialAccount.getGlobalResponseGetter().request(request, (Type)((Object)FinancialAccount.class));
    }

    public static FinancialAccount retrieve(String financialAccount, FinancialAccountRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s", ApiResource.urlEncodeId(financialAccount));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (FinancialAccount)FinancialAccount.getGlobalResponseGetter().request(request, (Type)((Object)FinancialAccount.class));
    }

    public FinancialAccountFeatures retrieveFeatures() throws StripeException {
        return this.retrieveFeatures((Map<String, Object>)null, (RequestOptions)null);
    }

    public FinancialAccountFeatures retrieveFeatures(Map<String, Object> params) throws StripeException {
        return this.retrieveFeatures(params, (RequestOptions)null);
    }

    public FinancialAccountFeatures retrieveFeatures(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s/features", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (FinancialAccountFeatures)this.getResponseGetter().request(request, (Type)((Object)FinancialAccountFeatures.class));
    }

    public FinancialAccountFeatures retrieveFeatures(FinancialAccountRetrieveFeaturesParams params) throws StripeException {
        return this.retrieveFeatures(params, (RequestOptions)null);
    }

    public FinancialAccountFeatures retrieveFeatures(FinancialAccountRetrieveFeaturesParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s/features", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (FinancialAccountFeatures)this.getResponseGetter().request(request, (Type)((Object)FinancialAccountFeatures.class));
    }

    public FinancialAccount update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public FinancialAccount update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (FinancialAccount)this.getResponseGetter().request(request, (Type)((Object)FinancialAccount.class));
    }

    public FinancialAccount update(FinancialAccountUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public FinancialAccount update(FinancialAccountUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (FinancialAccount)this.getResponseGetter().request(request, (Type)((Object)FinancialAccount.class));
    }

    public FinancialAccountFeatures updateFeatures() throws StripeException {
        return this.updateFeatures((Map<String, Object>)null, (RequestOptions)null);
    }

    public FinancialAccountFeatures updateFeatures(RequestOptions options) throws StripeException {
        return this.updateFeatures((Map<String, Object>)null, options);
    }

    public FinancialAccountFeatures updateFeatures(Map<String, Object> params) throws StripeException {
        return this.updateFeatures(params, (RequestOptions)null);
    }

    public FinancialAccountFeatures updateFeatures(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s/features", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (FinancialAccountFeatures)this.getResponseGetter().request(request, (Type)((Object)FinancialAccountFeatures.class));
    }

    public FinancialAccountFeatures updateFeatures(FinancialAccountUpdateFeaturesParams params) throws StripeException {
        return this.updateFeatures(params, (RequestOptions)null);
    }

    public FinancialAccountFeatures updateFeatures(FinancialAccountUpdateFeaturesParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s/features", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (FinancialAccountFeatures)this.getResponseGetter().request(request, (Type)((Object)FinancialAccountFeatures.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.balance, responseGetter);
        this.trySetResponseGetter(this.features, responseGetter);
        this.trySetResponseGetter(this.platformRestrictions, responseGetter);
        this.trySetResponseGetter(this.statusDetails, responseGetter);
    }

    @Generated
    public List<String> getActiveFeatures() {
        return this.activeFeatures;
    }

    @Generated
    public Balance getBalance() {
        return this.balance;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public FinancialAccountFeatures getFeatures() {
        return this.features;
    }

    @Generated
    public List<FinancialAddress> getFinancialAddresses() {
        return this.financialAddresses;
    }

    @Generated
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getNickname() {
        return this.nickname;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public List<String> getPendingFeatures() {
        return this.pendingFeatures;
    }

    @Generated
    public PlatformRestrictions getPlatformRestrictions() {
        return this.platformRestrictions;
    }

    @Generated
    public List<String> getRestrictedFeatures() {
        return this.restrictedFeatures;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public StatusDetails getStatusDetails() {
        return this.statusDetails;
    }

    @Generated
    public List<String> getSupportedCurrencies() {
        return this.supportedCurrencies;
    }

    @Generated
    public void setActiveFeatures(List<String> activeFeatures) {
        this.activeFeatures = activeFeatures;
    }

    @Generated
    public void setBalance(Balance balance) {
        this.balance = balance;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setFeatures(FinancialAccountFeatures features) {
        this.features = features;
    }

    @Generated
    public void setFinancialAddresses(List<FinancialAddress> financialAddresses) {
        this.financialAddresses = financialAddresses;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPendingFeatures(List<String> pendingFeatures) {
        this.pendingFeatures = pendingFeatures;
    }

    @Generated
    public void setPlatformRestrictions(PlatformRestrictions platformRestrictions) {
        this.platformRestrictions = platformRestrictions;
    }

    @Generated
    public void setRestrictedFeatures(List<String> restrictedFeatures) {
        this.restrictedFeatures = restrictedFeatures;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setStatusDetails(StatusDetails statusDetails) {
        this.statusDetails = statusDetails;
    }

    @Generated
    public void setSupportedCurrencies(List<String> supportedCurrencies) {
        this.supportedCurrencies = supportedCurrencies;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FinancialAccount)) {
            return false;
        }
        FinancialAccount other = (FinancialAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$isDefault = this.getIsDefault();
        Boolean other$isDefault = other.getIsDefault();
        if (this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        List<String> this$activeFeatures = this.getActiveFeatures();
        List<String> other$activeFeatures = other.getActiveFeatures();
        if (this$activeFeatures == null ? other$activeFeatures != null : !((Object)this$activeFeatures).equals(other$activeFeatures)) {
            return false;
        }
        Balance this$balance = this.getBalance();
        Balance other$balance = other.getBalance();
        if (this$balance == null ? other$balance != null : !((Object)this$balance).equals(other$balance)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        FinancialAccountFeatures this$features = this.getFeatures();
        FinancialAccountFeatures other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !((Object)this$features).equals(other$features)) {
            return false;
        }
        List<FinancialAddress> this$financialAddresses = this.getFinancialAddresses();
        List<FinancialAddress> other$financialAddresses = other.getFinancialAddresses();
        if (this$financialAddresses == null ? other$financialAddresses != null : !((Object)this$financialAddresses).equals(other$financialAddresses)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        List<String> this$pendingFeatures = this.getPendingFeatures();
        List<String> other$pendingFeatures = other.getPendingFeatures();
        if (this$pendingFeatures == null ? other$pendingFeatures != null : !((Object)this$pendingFeatures).equals(other$pendingFeatures)) {
            return false;
        }
        PlatformRestrictions this$platformRestrictions = this.getPlatformRestrictions();
        PlatformRestrictions other$platformRestrictions = other.getPlatformRestrictions();
        if (this$platformRestrictions == null ? other$platformRestrictions != null : !((Object)this$platformRestrictions).equals(other$platformRestrictions)) {
            return false;
        }
        List<String> this$restrictedFeatures = this.getRestrictedFeatures();
        List<String> other$restrictedFeatures = other.getRestrictedFeatures();
        if (this$restrictedFeatures == null ? other$restrictedFeatures != null : !((Object)this$restrictedFeatures).equals(other$restrictedFeatures)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        StatusDetails this$statusDetails = this.getStatusDetails();
        StatusDetails other$statusDetails = other.getStatusDetails();
        if (this$statusDetails == null ? other$statusDetails != null : !((Object)this$statusDetails).equals(other$statusDetails)) {
            return false;
        }
        List<String> this$supportedCurrencies = this.getSupportedCurrencies();
        List<String> other$supportedCurrencies = other.getSupportedCurrencies();
        return !(this$supportedCurrencies == null ? other$supportedCurrencies != null : !((Object)this$supportedCurrencies).equals(other$supportedCurrencies));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FinancialAccount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $isDefault = this.getIsDefault();
        result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        List<String> $activeFeatures = this.getActiveFeatures();
        result = result * 59 + ($activeFeatures == null ? 43 : ((Object)$activeFeatures).hashCode());
        Balance $balance = this.getBalance();
        result = result * 59 + ($balance == null ? 43 : ((Object)$balance).hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        FinancialAccountFeatures $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        List<FinancialAddress> $financialAddresses = this.getFinancialAddresses();
        result = result * 59 + ($financialAddresses == null ? 43 : ((Object)$financialAddresses).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        List<String> $pendingFeatures = this.getPendingFeatures();
        result = result * 59 + ($pendingFeatures == null ? 43 : ((Object)$pendingFeatures).hashCode());
        PlatformRestrictions $platformRestrictions = this.getPlatformRestrictions();
        result = result * 59 + ($platformRestrictions == null ? 43 : ((Object)$platformRestrictions).hashCode());
        List<String> $restrictedFeatures = this.getRestrictedFeatures();
        result = result * 59 + ($restrictedFeatures == null ? 43 : ((Object)$restrictedFeatures).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        StatusDetails $statusDetails = this.getStatusDetails();
        result = result * 59 + ($statusDetails == null ? 43 : ((Object)$statusDetails).hashCode());
        List<String> $supportedCurrencies = this.getSupportedCurrencies();
        result = result * 59 + ($supportedCurrencies == null ? 43 : ((Object)$supportedCurrencies).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Balance
    extends StripeObject {
        @SerializedName(value="cash")
        Map<String, Long> cash;
        @SerializedName(value="inbound_pending")
        Map<String, Long> inboundPending;
        @SerializedName(value="outbound_pending")
        Map<String, Long> outboundPending;

        @Generated
        public Map<String, Long> getCash() {
            return this.cash;
        }

        @Generated
        public Map<String, Long> getInboundPending() {
            return this.inboundPending;
        }

        @Generated
        public Map<String, Long> getOutboundPending() {
            return this.outboundPending;
        }

        @Generated
        public void setCash(Map<String, Long> cash) {
            this.cash = cash;
        }

        @Generated
        public void setInboundPending(Map<String, Long> inboundPending) {
            this.inboundPending = inboundPending;
        }

        @Generated
        public void setOutboundPending(Map<String, Long> outboundPending) {
            this.outboundPending = outboundPending;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Balance)) {
                return false;
            }
            Balance other = (Balance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Long> this$cash = this.getCash();
            Map<String, Long> other$cash = other.getCash();
            if (this$cash == null ? other$cash != null : !((Object)this$cash).equals(other$cash)) {
                return false;
            }
            Map<String, Long> this$inboundPending = this.getInboundPending();
            Map<String, Long> other$inboundPending = other.getInboundPending();
            if (this$inboundPending == null ? other$inboundPending != null : !((Object)this$inboundPending).equals(other$inboundPending)) {
                return false;
            }
            Map<String, Long> this$outboundPending = this.getOutboundPending();
            Map<String, Long> other$outboundPending = other.getOutboundPending();
            return !(this$outboundPending == null ? other$outboundPending != null : !((Object)this$outboundPending).equals(other$outboundPending));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Balance;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Long> $cash = this.getCash();
            result = result * 59 + ($cash == null ? 43 : ((Object)$cash).hashCode());
            Map<String, Long> $inboundPending = this.getInboundPending();
            result = result * 59 + ($inboundPending == null ? 43 : ((Object)$inboundPending).hashCode());
            Map<String, Long> $outboundPending = this.getOutboundPending();
            result = result * 59 + ($outboundPending == null ? 43 : ((Object)$outboundPending).hashCode());
            return result;
        }
    }

    public static class PlatformRestrictions
    extends StripeObject {
        @SerializedName(value="inbound_flows")
        String inboundFlows;
        @SerializedName(value="outbound_flows")
        String outboundFlows;

        @Generated
        public String getInboundFlows() {
            return this.inboundFlows;
        }

        @Generated
        public String getOutboundFlows() {
            return this.outboundFlows;
        }

        @Generated
        public void setInboundFlows(String inboundFlows) {
            this.inboundFlows = inboundFlows;
        }

        @Generated
        public void setOutboundFlows(String outboundFlows) {
            this.outboundFlows = outboundFlows;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlatformRestrictions)) {
                return false;
            }
            PlatformRestrictions other = (PlatformRestrictions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$inboundFlows = this.getInboundFlows();
            String other$inboundFlows = other.getInboundFlows();
            if (this$inboundFlows == null ? other$inboundFlows != null : !this$inboundFlows.equals(other$inboundFlows)) {
                return false;
            }
            String this$outboundFlows = this.getOutboundFlows();
            String other$outboundFlows = other.getOutboundFlows();
            return !(this$outboundFlows == null ? other$outboundFlows != null : !this$outboundFlows.equals(other$outboundFlows));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PlatformRestrictions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $inboundFlows = this.getInboundFlows();
            result = result * 59 + ($inboundFlows == null ? 43 : $inboundFlows.hashCode());
            String $outboundFlows = this.getOutboundFlows();
            result = result * 59 + ($outboundFlows == null ? 43 : $outboundFlows.hashCode());
            return result;
        }
    }

    public static class StatusDetails
    extends StripeObject {
        @SerializedName(value="closed")
        Closed closed;

        @Generated
        public Closed getClosed() {
            return this.closed;
        }

        @Generated
        public void setClosed(Closed closed) {
            this.closed = closed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatusDetails)) {
                return false;
            }
            StatusDetails other = (StatusDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Closed this$closed = this.getClosed();
            Closed other$closed = other.getClosed();
            return !(this$closed == null ? other$closed != null : !((Object)this$closed).equals(other$closed));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StatusDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Closed $closed = this.getClosed();
            result = result * 59 + ($closed == null ? 43 : ((Object)$closed).hashCode());
            return result;
        }

        public static class Closed
        extends StripeObject {
            @SerializedName(value="reasons")
            List<String> reasons;

            @Generated
            public List<String> getReasons() {
                return this.reasons;
            }

            @Generated
            public void setReasons(List<String> reasons) {
                this.reasons = reasons;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Closed)) {
                    return false;
                }
                Closed other = (Closed)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$reasons = this.getReasons();
                List<String> other$reasons = other.getReasons();
                return !(this$reasons == null ? other$reasons != null : !((Object)this$reasons).equals(other$reasons));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Closed;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $reasons = this.getReasons();
                result = result * 59 + ($reasons == null ? 43 : ((Object)$reasons).hashCode());
                return result;
            }
        }
    }

    public static class FinancialAddress
    extends StripeObject {
        @SerializedName(value="aba")
        Aba aba;
        @SerializedName(value="supported_networks")
        List<String> supportedNetworks;
        @SerializedName(value="type")
        String type;

        @Generated
        public Aba getAba() {
            return this.aba;
        }

        @Generated
        public List<String> getSupportedNetworks() {
            return this.supportedNetworks;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAba(Aba aba) {
            this.aba = aba;
        }

        @Generated
        public void setSupportedNetworks(List<String> supportedNetworks) {
            this.supportedNetworks = supportedNetworks;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FinancialAddress)) {
                return false;
            }
            FinancialAddress other = (FinancialAddress)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Aba this$aba = this.getAba();
            Aba other$aba = other.getAba();
            if (this$aba == null ? other$aba != null : !((Object)this$aba).equals(other$aba)) {
                return false;
            }
            List<String> this$supportedNetworks = this.getSupportedNetworks();
            List<String> other$supportedNetworks = other.getSupportedNetworks();
            if (this$supportedNetworks == null ? other$supportedNetworks != null : !((Object)this$supportedNetworks).equals(other$supportedNetworks)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FinancialAddress;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Aba $aba = this.getAba();
            result = result * 59 + ($aba == null ? 43 : ((Object)$aba).hashCode());
            List<String> $supportedNetworks = this.getSupportedNetworks();
            result = result * 59 + ($supportedNetworks == null ? 43 : ((Object)$supportedNetworks).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Aba
        extends StripeObject {
            @SerializedName(value="account_holder_name")
            String accountHolderName;
            @SerializedName(value="account_number")
            String accountNumber;
            @SerializedName(value="account_number_last4")
            String accountNumberLast4;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="routing_number")
            String routingNumber;

            @Generated
            public String getAccountHolderName() {
                return this.accountHolderName;
            }

            @Generated
            public String getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public String getAccountNumberLast4() {
                return this.accountNumberLast4;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getRoutingNumber() {
                return this.routingNumber;
            }

            @Generated
            public void setAccountHolderName(String accountHolderName) {
                this.accountHolderName = accountHolderName;
            }

            @Generated
            public void setAccountNumber(String accountNumber) {
                this.accountNumber = accountNumber;
            }

            @Generated
            public void setAccountNumberLast4(String accountNumberLast4) {
                this.accountNumberLast4 = accountNumberLast4;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setRoutingNumber(String routingNumber) {
                this.routingNumber = routingNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Aba)) {
                    return false;
                }
                Aba other = (Aba)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountHolderName = this.getAccountHolderName();
                String other$accountHolderName = other.getAccountHolderName();
                if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) {
                    return false;
                }
                String this$accountNumber = this.getAccountNumber();
                String other$accountNumber = other.getAccountNumber();
                if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                    return false;
                }
                String this$accountNumberLast4 = this.getAccountNumberLast4();
                String other$accountNumberLast4 = other.getAccountNumberLast4();
                if (this$accountNumberLast4 == null ? other$accountNumberLast4 != null : !this$accountNumberLast4.equals(other$accountNumberLast4)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$routingNumber = this.getRoutingNumber();
                String other$routingNumber = other.getRoutingNumber();
                return !(this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Aba;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountHolderName = this.getAccountHolderName();
                result = result * 59 + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
                String $accountNumber = this.getAccountNumber();
                result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                String $accountNumberLast4 = this.getAccountNumberLast4();
                result = result * 59 + ($accountNumberLast4 == null ? 43 : $accountNumberLast4.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $routingNumber = this.getRoutingNumber();
                result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
                return result;
            }
        }
    }
}

