/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.tax;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.tax.AssociationFindParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Association
extends ApiResource
implements HasId {
    @SerializedName(value="calculation")
    String calculation;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_intent")
    String paymentIntent;
    @SerializedName(value="tax_transaction_attempts")
    List<TaxTransactionAttempt> taxTransactionAttempts;

    public static Association find(Map<String, Object> params) throws StripeException {
        return Association.find(params, (RequestOptions)null);
    }

    public static Association find(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/associations/find";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Association)Association.getGlobalResponseGetter().request(request, (Type)((Object)Association.class));
    }

    public static Association find(AssociationFindParams params) throws StripeException {
        return Association.find(params, (RequestOptions)null);
    }

    public static Association find(AssociationFindParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/associations/find";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Association)Association.getGlobalResponseGetter().request(request, (Type)((Object)Association.class));
    }

    @Generated
    public String getCalculation() {
        return this.calculation;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getPaymentIntent() {
        return this.paymentIntent;
    }

    @Generated
    public List<TaxTransactionAttempt> getTaxTransactionAttempts() {
        return this.taxTransactionAttempts;
    }

    @Generated
    public void setCalculation(String calculation) {
        this.calculation = calculation;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentIntent(String paymentIntent) {
        this.paymentIntent = paymentIntent;
    }

    @Generated
    public void setTaxTransactionAttempts(List<TaxTransactionAttempt> taxTransactionAttempts) {
        this.taxTransactionAttempts = taxTransactionAttempts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Association)) {
            return false;
        }
        Association other = (Association)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$calculation = this.getCalculation();
        String other$calculation = other.getCalculation();
        if (this$calculation == null ? other$calculation != null : !this$calculation.equals(other$calculation)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$paymentIntent = this.getPaymentIntent();
        String other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
            return false;
        }
        List<TaxTransactionAttempt> this$taxTransactionAttempts = this.getTaxTransactionAttempts();
        List<TaxTransactionAttempt> other$taxTransactionAttempts = other.getTaxTransactionAttempts();
        return !(this$taxTransactionAttempts == null ? other$taxTransactionAttempts != null : !((Object)this$taxTransactionAttempts).equals(other$taxTransactionAttempts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Association;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $calculation = this.getCalculation();
        result = result * 59 + ($calculation == null ? 43 : $calculation.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $paymentIntent = this.getPaymentIntent();
        result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        List<TaxTransactionAttempt> $taxTransactionAttempts = this.getTaxTransactionAttempts();
        result = result * 59 + ($taxTransactionAttempts == null ? 43 : ((Object)$taxTransactionAttempts).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class TaxTransactionAttempt
    extends StripeObject {
        @SerializedName(value="committed")
        Committed committed;
        @SerializedName(value="errored")
        Errored errored;
        @SerializedName(value="source")
        String source;
        @SerializedName(value="status")
        String status;

        @Generated
        public Committed getCommitted() {
            return this.committed;
        }

        @Generated
        public Errored getErrored() {
            return this.errored;
        }

        @Generated
        public String getSource() {
            return this.source;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setCommitted(Committed committed) {
            this.committed = committed;
        }

        @Generated
        public void setErrored(Errored errored) {
            this.errored = errored;
        }

        @Generated
        public void setSource(String source) {
            this.source = source;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaxTransactionAttempt)) {
                return false;
            }
            TaxTransactionAttempt other = (TaxTransactionAttempt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Committed this$committed = this.getCommitted();
            Committed other$committed = other.getCommitted();
            if (this$committed == null ? other$committed != null : !((Object)this$committed).equals(other$committed)) {
                return false;
            }
            Errored this$errored = this.getErrored();
            Errored other$errored = other.getErrored();
            if (this$errored == null ? other$errored != null : !((Object)this$errored).equals(other$errored)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaxTransactionAttempt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Committed $committed = this.getCommitted();
            result = result * 59 + ($committed == null ? 43 : ((Object)$committed).hashCode());
            Errored $errored = this.getErrored();
            result = result * 59 + ($errored == null ? 43 : ((Object)$errored).hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        public static class Committed
        extends StripeObject {
            @SerializedName(value="transaction")
            String transaction;

            @Generated
            public String getTransaction() {
                return this.transaction;
            }

            @Generated
            public void setTransaction(String transaction) {
                this.transaction = transaction;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Committed)) {
                    return false;
                }
                Committed other = (Committed)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$transaction = this.getTransaction();
                String other$transaction = other.getTransaction();
                return !(this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Committed;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $transaction = this.getTransaction();
                result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
                return result;
            }
        }

        public static class Errored
        extends StripeObject {
            @SerializedName(value="reason")
            String reason;

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Errored)) {
                    return false;
                }
                Errored other = (Errored)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Errored;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                return result;
            }
        }
    }
}

