/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ExpandableFieldDeserializer
implements JsonDeserializer<ExpandableField<?>> {
    public ExpandableField<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull()) {
            return null;
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive();
            if (jsonPrimitive.isString()) {
                ExpandableField<Object> expandableField = new ExpandableField<Object>(jsonPrimitive.getAsString(), null);
                return expandableField;
            }
            throw new JsonParseException("ExpandableField is a non-string primitive type.");
        }
        if (json.isJsonObject()) {
            JsonObject fieldAsJsonObject = json.getAsJsonObject();
            String id = fieldAsJsonObject.getAsJsonPrimitive("id").getAsString();
            Type clazz = ((ParameterizedType)typeOfT).getActualTypeArguments()[0];
            ExpandableField<HasId> expandableField = new ExpandableField<HasId>(id, (HasId)context.deserialize(json, clazz));
            return expandableField;
        }
        throw new JsonParseException("ExpandableField is a non-object, non-primitive type.");
    }
}

