// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.InvoiceRenderingTemplateArchiveParams;
import com.stripe.param.InvoiceRenderingTemplateListParams;
import com.stripe.param.InvoiceRenderingTemplateRetrieveParams;
import com.stripe.param.InvoiceRenderingTemplateUnarchiveParams;
import java.util.Map;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * Invoice Rendering Templates are used to configure how invoices are rendered on surfaces like the
 * PDF. Invoice Rendering Templates can be created from within the Dashboard, and they can be used
 * over the API when creating invoices.
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
public class InvoiceRenderingTemplate extends ApiResource implements HasId {
  /** Time at which the object was created. Measured in seconds since the Unix epoch. */
  @SerializedName("created")
  Long created;

  /** Unique identifier for the object. */
  @Getter(onMethod_ = {@Override})
  @SerializedName("id")
  String id;

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;

  /**
   * Set of <a href="https://docs.stripe.com/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;

  /** A brief description of the template, hidden from customers. */
  @SerializedName("nickname")
  String nickname;

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code invoice_rendering_template}.
   */
  @SerializedName("object")
  String object;

  /** The status of the template, one of {@code active} or {@code archived}. */
  @SerializedName("status")
  String status;

  /**
   * Version of this template; version increases by one when an update on the template changes any
   * field that controls invoice rendering.
   */
  @SerializedName("version")
  Long version;

  /**
   * Updates the status of an invoice rendering template to ‘archived’ so no new Stripe objects
   * (customers, invoices, etc.) can reference it. The template can also no longer be updated.
   * However, if the template is already set on a Stripe object, it will continue to be applied on
   * invoices generated by it.
   */
  public InvoiceRenderingTemplate archive() throws StripeException {
    return archive((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Updates the status of an invoice rendering template to ‘archived’ so no new Stripe objects
   * (customers, invoices, etc.) can reference it. The template can also no longer be updated.
   * However, if the template is already set on a Stripe object, it will continue to be applied on
   * invoices generated by it.
   */
  public InvoiceRenderingTemplate archive(RequestOptions options) throws StripeException {
    return archive((Map<String, Object>) null, options);
  }

  /**
   * Updates the status of an invoice rendering template to ‘archived’ so no new Stripe objects
   * (customers, invoices, etc.) can reference it. The template can also no longer be updated.
   * However, if the template is already set on a Stripe object, it will continue to be applied on
   * invoices generated by it.
   */
  public InvoiceRenderingTemplate archive(Map<String, Object> params) throws StripeException {
    return archive(params, (RequestOptions) null);
  }

  /**
   * Updates the status of an invoice rendering template to ‘archived’ so no new Stripe objects
   * (customers, invoices, etc.) can reference it. The template can also no longer be updated.
   * However, if the template is already set on a Stripe object, it will continue to be applied on
   * invoices generated by it.
   */
  public InvoiceRenderingTemplate archive(Map<String, Object> params, RequestOptions options)
      throws StripeException {
    String path =
        String.format(
            "/v1/invoice_rendering_templates/%s/archive", ApiResource.urlEncodeId(this.getId()));
    ApiRequest request =
        new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
    return getResponseGetter().request(request, InvoiceRenderingTemplate.class);
  }

  /**
   * Updates the status of an invoice rendering template to ‘archived’ so no new Stripe objects
   * (customers, invoices, etc.) can reference it. The template can also no longer be updated.
   * However, if the template is already set on a Stripe object, it will continue to be applied on
   * invoices generated by it.
   */
  public InvoiceRenderingTemplate archive(InvoiceRenderingTemplateArchiveParams params)
      throws StripeException {
    return archive(params, (RequestOptions) null);
  }

  /**
   * Updates the status of an invoice rendering template to ‘archived’ so no new Stripe objects
   * (customers, invoices, etc.) can reference it. The template can also no longer be updated.
   * However, if the template is already set on a Stripe object, it will continue to be applied on
   * invoices generated by it.
   */
  public InvoiceRenderingTemplate archive(
      InvoiceRenderingTemplateArchiveParams params, RequestOptions options) throws StripeException {
    String path =
        String.format(
            "/v1/invoice_rendering_templates/%s/archive", ApiResource.urlEncodeId(this.getId()));
    ApiResource.checkNullTypedParams(path, params);
    ApiRequest request =
        new ApiRequest(
            BaseAddress.API,
            ApiResource.RequestMethod.POST,
            path,
            ApiRequestParams.paramsToMap(params),
            options);
    return getResponseGetter().request(request, InvoiceRenderingTemplate.class);
  }

  /**
   * List all templates, ordered by creation date, with the most recently created template appearing
   * first.
   */
  public static InvoiceRenderingTemplateCollection list(Map<String, Object> params)
      throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List all templates, ordered by creation date, with the most recently created template appearing
   * first.
   */
  public static InvoiceRenderingTemplateCollection list(
      Map<String, Object> params, RequestOptions options) throws StripeException {
    String path = "/v1/invoice_rendering_templates";
    ApiRequest request =
        new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
    return getGlobalResponseGetter().request(request, InvoiceRenderingTemplateCollection.class);
  }

  /**
   * List all templates, ordered by creation date, with the most recently created template appearing
   * first.
   */
  public static InvoiceRenderingTemplateCollection list(InvoiceRenderingTemplateListParams params)
      throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List all templates, ordered by creation date, with the most recently created template appearing
   * first.
   */
  public static InvoiceRenderingTemplateCollection list(
      InvoiceRenderingTemplateListParams params, RequestOptions options) throws StripeException {
    String path = "/v1/invoice_rendering_templates";
    ApiResource.checkNullTypedParams(path, params);
    ApiRequest request =
        new ApiRequest(
            BaseAddress.API,
            ApiResource.RequestMethod.GET,
            path,
            ApiRequestParams.paramsToMap(params),
            options);
    return getGlobalResponseGetter().request(request, InvoiceRenderingTemplateCollection.class);
  }

  /**
   * Retrieves an invoice rendering template with the given ID. It by default returns the latest
   * version of the template. Optionally, specify a version to see previous versions.
   */
  public static InvoiceRenderingTemplate retrieve(String template) throws StripeException {
    return retrieve(template, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves an invoice rendering template with the given ID. It by default returns the latest
   * version of the template. Optionally, specify a version to see previous versions.
   */
  public static InvoiceRenderingTemplate retrieve(String template, RequestOptions options)
      throws StripeException {
    return retrieve(template, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves an invoice rendering template with the given ID. It by default returns the latest
   * version of the template. Optionally, specify a version to see previous versions.
   */
  public static InvoiceRenderingTemplate retrieve(
      String template, Map<String, Object> params, RequestOptions options) throws StripeException {
    String path =
        String.format("/v1/invoice_rendering_templates/%s", ApiResource.urlEncodeId(template));
    ApiRequest request =
        new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
    return getGlobalResponseGetter().request(request, InvoiceRenderingTemplate.class);
  }

  /**
   * Retrieves an invoice rendering template with the given ID. It by default returns the latest
   * version of the template. Optionally, specify a version to see previous versions.
   */
  public static InvoiceRenderingTemplate retrieve(
      String template, InvoiceRenderingTemplateRetrieveParams params, RequestOptions options)
      throws StripeException {
    String path =
        String.format("/v1/invoice_rendering_templates/%s", ApiResource.urlEncodeId(template));
    ApiResource.checkNullTypedParams(path, params);
    ApiRequest request =
        new ApiRequest(
            BaseAddress.API,
            ApiResource.RequestMethod.GET,
            path,
            ApiRequestParams.paramsToMap(params),
            options);
    return getGlobalResponseGetter().request(request, InvoiceRenderingTemplate.class);
  }

  /** Unarchive an invoice rendering template so it can be used on new Stripe objects again. */
  public InvoiceRenderingTemplate unarchive() throws StripeException {
    return unarchive((Map<String, Object>) null, (RequestOptions) null);
  }

  /** Unarchive an invoice rendering template so it can be used on new Stripe objects again. */
  public InvoiceRenderingTemplate unarchive(RequestOptions options) throws StripeException {
    return unarchive((Map<String, Object>) null, options);
  }

  /** Unarchive an invoice rendering template so it can be used on new Stripe objects again. */
  public InvoiceRenderingTemplate unarchive(Map<String, Object> params) throws StripeException {
    return unarchive(params, (RequestOptions) null);
  }

  /** Unarchive an invoice rendering template so it can be used on new Stripe objects again. */
  public InvoiceRenderingTemplate unarchive(Map<String, Object> params, RequestOptions options)
      throws StripeException {
    String path =
        String.format(
            "/v1/invoice_rendering_templates/%s/unarchive", ApiResource.urlEncodeId(this.getId()));
    ApiRequest request =
        new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
    return getResponseGetter().request(request, InvoiceRenderingTemplate.class);
  }

  /** Unarchive an invoice rendering template so it can be used on new Stripe objects again. */
  public InvoiceRenderingTemplate unarchive(InvoiceRenderingTemplateUnarchiveParams params)
      throws StripeException {
    return unarchive(params, (RequestOptions) null);
  }

  /** Unarchive an invoice rendering template so it can be used on new Stripe objects again. */
  public InvoiceRenderingTemplate unarchive(
      InvoiceRenderingTemplateUnarchiveParams params, RequestOptions options)
      throws StripeException {
    String path =
        String.format(
            "/v1/invoice_rendering_templates/%s/unarchive", ApiResource.urlEncodeId(this.getId()));
    ApiResource.checkNullTypedParams(path, params);
    ApiRequest request =
        new ApiRequest(
            BaseAddress.API,
            ApiResource.RequestMethod.POST,
            path,
            ApiRequestParams.paramsToMap(params),
            options);
    return getResponseGetter().request(request, InvoiceRenderingTemplate.class);
  }
}
