/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.terminal.LocationCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.terminal.LocationCreateParams;
import com.stripe.param.terminal.LocationListParams;
import com.stripe.param.terminal.LocationRetrieveParams;
import com.stripe.param.terminal.LocationUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class Location
extends ApiResource
implements HasId,
MetadataStore<Location> {
    @SerializedName(value="address")
    Address address;
    @SerializedName(value="address_kana")
    AddressKana addressKana;
    @SerializedName(value="address_kanji")
    AddressKanji addressKanji;
    @SerializedName(value="configuration_overrides")
    String configurationOverrides;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="display_name")
    String displayName;
    @SerializedName(value="display_name_kana")
    String displayNameKana;
    @SerializedName(value="display_name_kanji")
    String displayNameKanji;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="phone")
    String phone;

    public static Location create(Map<String, Object> params) throws StripeException {
        return Location.create(params, (RequestOptions)null);
    }

    public static Location create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/locations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Location)Location.getGlobalResponseGetter().request(request, (Type)((Object)Location.class));
    }

    public static Location create(LocationCreateParams params) throws StripeException {
        return Location.create(params, (RequestOptions)null);
    }

    public static Location create(LocationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/locations";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Location)Location.getGlobalResponseGetter().request(request, (Type)((Object)Location.class));
    }

    public Location delete() throws StripeException {
        return this.delete(null, null);
    }

    public Location delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Location delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Location delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/locations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, params, options);
        return (Location)this.getResponseGetter().request(request, (Type)((Object)Location.class));
    }

    public static LocationCollection list(Map<String, Object> params) throws StripeException {
        return Location.list(params, (RequestOptions)null);
    }

    public static LocationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/locations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (LocationCollection)Location.getGlobalResponseGetter().request(request, (Type)((Object)LocationCollection.class));
    }

    public static LocationCollection list(LocationListParams params) throws StripeException {
        return Location.list(params, (RequestOptions)null);
    }

    public static LocationCollection list(LocationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/locations";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (LocationCollection)Location.getGlobalResponseGetter().request(request, (Type)((Object)LocationCollection.class));
    }

    public static Location retrieve(String location) throws StripeException {
        return Location.retrieve(location, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Location retrieve(String location, RequestOptions options) throws StripeException {
        return Location.retrieve(location, (Map<String, Object>)null, options);
    }

    public static Location retrieve(String location, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/locations/%s", ApiResource.urlEncodeId(location));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Location)Location.getGlobalResponseGetter().request(request, (Type)((Object)Location.class));
    }

    public static Location retrieve(String location, LocationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/locations/%s", ApiResource.urlEncodeId(location));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Location)Location.getGlobalResponseGetter().request(request, (Type)((Object)Location.class));
    }

    public Location update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Location update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/locations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Location)this.getResponseGetter().request(request, (Type)((Object)Location.class));
    }

    public Location update(LocationUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Location update(LocationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/locations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Location)this.getResponseGetter().request(request, (Type)((Object)Location.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.address, responseGetter);
        this.trySetResponseGetter(this.addressKana, responseGetter);
        this.trySetResponseGetter(this.addressKanji, responseGetter);
    }

    @Generated
    public Address getAddress() {
        return this.address;
    }

    @Generated
    public AddressKana getAddressKana() {
        return this.addressKana;
    }

    @Generated
    public AddressKanji getAddressKanji() {
        return this.addressKanji;
    }

    @Generated
    public String getConfigurationOverrides() {
        return this.configurationOverrides;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDisplayNameKana() {
        return this.displayNameKana;
    }

    @Generated
    public String getDisplayNameKanji() {
        return this.displayNameKanji;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public void setAddress(Address address) {
        this.address = address;
    }

    @Generated
    public void setAddressKana(AddressKana addressKana) {
        this.addressKana = addressKana;
    }

    @Generated
    public void setAddressKanji(AddressKanji addressKanji) {
        this.addressKanji = addressKanji;
    }

    @Generated
    public void setConfigurationOverrides(String configurationOverrides) {
        this.configurationOverrides = configurationOverrides;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setDisplayNameKana(String displayNameKana) {
        this.displayNameKana = displayNameKana;
    }

    @Generated
    public void setDisplayNameKanji(String displayNameKanji) {
        this.displayNameKanji = displayNameKanji;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        AddressKana this$addressKana = this.getAddressKana();
        AddressKana other$addressKana = other.getAddressKana();
        if (this$addressKana == null ? other$addressKana != null : !((Object)this$addressKana).equals(other$addressKana)) {
            return false;
        }
        AddressKanji this$addressKanji = this.getAddressKanji();
        AddressKanji other$addressKanji = other.getAddressKanji();
        if (this$addressKanji == null ? other$addressKanji != null : !((Object)this$addressKanji).equals(other$addressKanji)) {
            return false;
        }
        String this$configurationOverrides = this.getConfigurationOverrides();
        String other$configurationOverrides = other.getConfigurationOverrides();
        if (this$configurationOverrides == null ? other$configurationOverrides != null : !this$configurationOverrides.equals(other$configurationOverrides)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$displayNameKana = this.getDisplayNameKana();
        String other$displayNameKana = other.getDisplayNameKana();
        if (this$displayNameKana == null ? other$displayNameKana != null : !this$displayNameKana.equals(other$displayNameKana)) {
            return false;
        }
        String this$displayNameKanji = this.getDisplayNameKanji();
        String other$displayNameKanji = other.getDisplayNameKanji();
        if (this$displayNameKanji == null ? other$displayNameKanji != null : !this$displayNameKanji.equals(other$displayNameKanji)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Location;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        AddressKana $addressKana = this.getAddressKana();
        result = result * 59 + ($addressKana == null ? 43 : ((Object)$addressKana).hashCode());
        AddressKanji $addressKanji = this.getAddressKanji();
        result = result * 59 + ($addressKanji == null ? 43 : ((Object)$addressKanji).hashCode());
        String $configurationOverrides = this.getConfigurationOverrides();
        result = result * 59 + ($configurationOverrides == null ? 43 : $configurationOverrides.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $displayNameKana = this.getDisplayNameKana();
        result = result * 59 + ($displayNameKana == null ? 43 : $displayNameKana.hashCode());
        String $displayNameKanji = this.getDisplayNameKanji();
        result = result * 59 + ($displayNameKanji == null ? 43 : $displayNameKanji.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AddressKana
    extends StripeObject {
        @SerializedName(value="city")
        String city;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="line1")
        String line1;
        @SerializedName(value="line2")
        String line2;
        @SerializedName(value="postal_code")
        String postalCode;
        @SerializedName(value="state")
        String state;
        @SerializedName(value="town")
        String town;

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getLine1() {
            return this.line1;
        }

        @Generated
        public String getLine2() {
            return this.line2;
        }

        @Generated
        public String getPostalCode() {
            return this.postalCode;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public String getTown() {
            return this.town;
        }

        @Generated
        public void setCity(String city) {
            this.city = city;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setLine1(String line1) {
            this.line1 = line1;
        }

        @Generated
        public void setLine2(String line2) {
            this.line2 = line2;
        }

        @Generated
        public void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Generated
        public void setState(String state) {
            this.state = state;
        }

        @Generated
        public void setTown(String town) {
            this.town = town;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddressKana)) {
                return false;
            }
            AddressKana other = (AddressKana)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$line1 = this.getLine1();
            String other$line1 = other.getLine1();
            if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                return false;
            }
            String this$line2 = this.getLine2();
            String other$line2 = other.getLine2();
            if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                return false;
            }
            String this$postalCode = this.getPostalCode();
            String other$postalCode = other.getPostalCode();
            if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$town = this.getTown();
            String other$town = other.getTown();
            return !(this$town == null ? other$town != null : !this$town.equals(other$town));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AddressKana;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $line1 = this.getLine1();
            result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
            String $line2 = this.getLine2();
            result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
            String $postalCode = this.getPostalCode();
            result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $town = this.getTown();
            result = result * 59 + ($town == null ? 43 : $town.hashCode());
            return result;
        }
    }

    public static class AddressKanji
    extends StripeObject {
        @SerializedName(value="city")
        String city;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="line1")
        String line1;
        @SerializedName(value="line2")
        String line2;
        @SerializedName(value="postal_code")
        String postalCode;
        @SerializedName(value="state")
        String state;
        @SerializedName(value="town")
        String town;

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getLine1() {
            return this.line1;
        }

        @Generated
        public String getLine2() {
            return this.line2;
        }

        @Generated
        public String getPostalCode() {
            return this.postalCode;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public String getTown() {
            return this.town;
        }

        @Generated
        public void setCity(String city) {
            this.city = city;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setLine1(String line1) {
            this.line1 = line1;
        }

        @Generated
        public void setLine2(String line2) {
            this.line2 = line2;
        }

        @Generated
        public void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Generated
        public void setState(String state) {
            this.state = state;
        }

        @Generated
        public void setTown(String town) {
            this.town = town;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddressKanji)) {
                return false;
            }
            AddressKanji other = (AddressKanji)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$line1 = this.getLine1();
            String other$line1 = other.getLine1();
            if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                return false;
            }
            String this$line2 = this.getLine2();
            String other$line2 = other.getLine2();
            if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                return false;
            }
            String this$postalCode = this.getPostalCode();
            String other$postalCode = other.getPostalCode();
            if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$town = this.getTown();
            String other$town = other.getTown();
            return !(this$town == null ? other$town != null : !this$town.equals(other$town));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AddressKanji;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $line1 = this.getLine1();
            result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
            String $line2 = this.getLine2();
            result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
            String $postalCode = this.getPostalCode();
            result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $town = this.getTown();
            result = result * 59 + ($town == null ? 43 : $town.hashCode());
            return result;
        }
    }
}

