/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.treasury;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.treasury.OutboundTransfer;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.OutboundTransferCancelParams;
import com.stripe.param.treasury.OutboundTransferCreateParams;
import com.stripe.param.treasury.OutboundTransferListParams;
import com.stripe.param.treasury.OutboundTransferRetrieveParams;
import java.lang.reflect.Type;

public final class OutboundTransferService
extends ApiService {
    public OutboundTransferService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<OutboundTransfer> list(OutboundTransferListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<OutboundTransfer> list(OutboundTransferListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/outbound_transfers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<OutboundTransfer>>(){}.getType());
    }

    public OutboundTransfer create(OutboundTransferCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public OutboundTransfer create(OutboundTransferCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/outbound_transfers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (OutboundTransfer)this.request(request, (Type)((Object)OutboundTransfer.class));
    }

    public OutboundTransfer retrieve(String outboundTransfer, OutboundTransferRetrieveParams params) throws StripeException {
        return this.retrieve(outboundTransfer, params, null);
    }

    public OutboundTransfer retrieve(String outboundTransfer, RequestOptions options) throws StripeException {
        return this.retrieve(outboundTransfer, null, options);
    }

    public OutboundTransfer retrieve(String outboundTransfer) throws StripeException {
        return this.retrieve(outboundTransfer, null, null);
    }

    public OutboundTransfer retrieve(String outboundTransfer, OutboundTransferRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/outbound_transfers/%s", ApiResource.urlEncodeId(outboundTransfer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (OutboundTransfer)this.request(request, (Type)((Object)OutboundTransfer.class));
    }

    public OutboundTransfer cancel(String outboundTransfer, OutboundTransferCancelParams params) throws StripeException {
        return this.cancel(outboundTransfer, params, null);
    }

    public OutboundTransfer cancel(String outboundTransfer, RequestOptions options) throws StripeException {
        return this.cancel(outboundTransfer, null, options);
    }

    public OutboundTransfer cancel(String outboundTransfer) throws StripeException {
        return this.cancel(outboundTransfer, null, null);
    }

    public OutboundTransfer cancel(String outboundTransfer, OutboundTransferCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/outbound_transfers/%s/cancel", ApiResource.urlEncodeId(outboundTransfer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (OutboundTransfer)this.request(request, (Type)((Object)OutboundTransfer.class));
    }
}

