/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param.v2.billing;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class MeterEventStreamCreateParams
extends ApiRequestParams {
    @SerializedName(value="events")
    List<Event> events;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;

    private MeterEventStreamCreateParams(List<Event> events, Map<String, Object> extraParams) {
        this.events = events;
        this.extraParams = extraParams;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public List<Event> getEvents() {
        return this.events;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    public static class Builder {
        private List<Event> events;
        private Map<String, Object> extraParams;

        public MeterEventStreamCreateParams build() {
            return new MeterEventStreamCreateParams(this.events, this.extraParams);
        }

        public Builder addEvent(Event element) {
            if (this.events == null) {
                this.events = new ArrayList<Event>();
            }
            this.events.add(element);
            return this;
        }

        public Builder addAllEvent(List<Event> elements) {
            if (this.events == null) {
                this.events = new ArrayList<Event>();
            }
            this.events.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }
    }

    public static class Event {
        @SerializedName(value="event_name")
        String eventName;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="identifier")
        String identifier;
        @SerializedName(value="payload")
        Map<String, String> payload;
        @SerializedName(value="timestamp")
        Instant timestamp;

        private Event(String eventName, Map<String, Object> extraParams, String identifier, Map<String, String> payload, Instant timestamp) {
            this.eventName = eventName;
            this.extraParams = extraParams;
            this.identifier = identifier;
            this.payload = payload;
            this.timestamp = timestamp;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getEventName() {
            return this.eventName;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getIdentifier() {
            return this.identifier;
        }

        @Generated
        public Map<String, String> getPayload() {
            return this.payload;
        }

        @Generated
        public Instant getTimestamp() {
            return this.timestamp;
        }

        public static class Builder {
            private String eventName;
            private Map<String, Object> extraParams;
            private String identifier;
            private Map<String, String> payload;
            private Instant timestamp;

            public Event build() {
                return new Event(this.eventName, this.extraParams, this.identifier, this.payload, this.timestamp);
            }

            public Builder setEventName(String eventName) {
                this.eventName = eventName;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setIdentifier(String identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder putPayload(String key, String value) {
                if (this.payload == null) {
                    this.payload = new HashMap<String, String>();
                }
                this.payload.put(key, value);
                return this;
            }

            public Builder putAllPayload(Map<String, String> map) {
                if (this.payload == null) {
                    this.payload = new HashMap<String, String>();
                }
                this.payload.putAll(map);
                return this;
            }

            public Builder setTimestamp(Instant timestamp) {
                this.timestamp = timestamp;
                return this;
            }
        }
    }
}

