/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class AuthorizationCreateParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="amount_details")
    AmountDetails amountDetails;
    @SerializedName(value="authorization_method")
    AuthorizationMethod authorizationMethod;
    @SerializedName(value="card")
    String card;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="fleet")
    Fleet fleet;
    @SerializedName(value="fuel")
    Fuel fuel;
    @SerializedName(value="is_amount_controllable")
    Boolean isAmountControllable;
    @SerializedName(value="merchant_amount")
    Long merchantAmount;
    @SerializedName(value="merchant_currency")
    String merchantCurrency;
    @SerializedName(value="merchant_data")
    MerchantData merchantData;
    @SerializedName(value="network_data")
    NetworkData networkData;
    @SerializedName(value="verification_data")
    VerificationData verificationData;
    @SerializedName(value="wallet")
    Wallet wallet;

    private AuthorizationCreateParams(Long amount, AmountDetails amountDetails, AuthorizationMethod authorizationMethod, String card, String currency, List<String> expand, Map<String, Object> extraParams, Fleet fleet, Fuel fuel, Boolean isAmountControllable, Long merchantAmount, String merchantCurrency, MerchantData merchantData, NetworkData networkData, VerificationData verificationData, Wallet wallet) {
        this.amount = amount;
        this.amountDetails = amountDetails;
        this.authorizationMethod = authorizationMethod;
        this.card = card;
        this.currency = currency;
        this.expand = expand;
        this.extraParams = extraParams;
        this.fleet = fleet;
        this.fuel = fuel;
        this.isAmountControllable = isAmountControllable;
        this.merchantAmount = merchantAmount;
        this.merchantCurrency = merchantCurrency;
        this.merchantData = merchantData;
        this.networkData = networkData;
        this.verificationData = verificationData;
        this.wallet = wallet;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public AmountDetails getAmountDetails() {
        return this.amountDetails;
    }

    @Generated
    public AuthorizationMethod getAuthorizationMethod() {
        return this.authorizationMethod;
    }

    @Generated
    public String getCard() {
        return this.card;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public Fleet getFleet() {
        return this.fleet;
    }

    @Generated
    public Fuel getFuel() {
        return this.fuel;
    }

    @Generated
    public Boolean getIsAmountControllable() {
        return this.isAmountControllable;
    }

    @Generated
    public Long getMerchantAmount() {
        return this.merchantAmount;
    }

    @Generated
    public String getMerchantCurrency() {
        return this.merchantCurrency;
    }

    @Generated
    public MerchantData getMerchantData() {
        return this.merchantData;
    }

    @Generated
    public NetworkData getNetworkData() {
        return this.networkData;
    }

    @Generated
    public VerificationData getVerificationData() {
        return this.verificationData;
    }

    @Generated
    public Wallet getWallet() {
        return this.wallet;
    }

    public static class AmountDetails {
        @SerializedName(value="atm_fee")
        Long atmFee;
        @SerializedName(value="cashback_amount")
        Long cashbackAmount;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private AmountDetails(Long atmFee, Long cashbackAmount, Map<String, Object> extraParams) {
            this.atmFee = atmFee;
            this.cashbackAmount = cashbackAmount;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getAtmFee() {
            return this.atmFee;
        }

        @Generated
        public Long getCashbackAmount() {
            return this.cashbackAmount;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private Long atmFee;
            private Long cashbackAmount;
            private Map<String, Object> extraParams;

            public AmountDetails build() {
                return new AmountDetails(this.atmFee, this.cashbackAmount, this.extraParams);
            }

            public Builder setAtmFee(Long atmFee) {
                this.atmFee = atmFee;
                return this;
            }

            public Builder setCashbackAmount(Long cashbackAmount) {
                this.cashbackAmount = cashbackAmount;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static enum AuthorizationMethod implements ApiRequestParams.EnumParam
    {
        CHIP("chip"),
        CONTACTLESS("contactless"),
        KEYED_IN("keyed_in"),
        ONLINE("online"),
        SWIPE("swipe");

        private final String value;

        private AuthorizationMethod(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Fleet {
        @SerializedName(value="cardholder_prompt_data")
        CardholderPromptData cardholderPromptData;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="purchase_type")
        PurchaseType purchaseType;
        @SerializedName(value="reported_breakdown")
        ReportedBreakdown reportedBreakdown;
        @SerializedName(value="service_type")
        ServiceType serviceType;

        private Fleet(CardholderPromptData cardholderPromptData, Map<String, Object> extraParams, PurchaseType purchaseType, ReportedBreakdown reportedBreakdown, ServiceType serviceType) {
            this.cardholderPromptData = cardholderPromptData;
            this.extraParams = extraParams;
            this.purchaseType = purchaseType;
            this.reportedBreakdown = reportedBreakdown;
            this.serviceType = serviceType;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public CardholderPromptData getCardholderPromptData() {
            return this.cardholderPromptData;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public PurchaseType getPurchaseType() {
            return this.purchaseType;
        }

        @Generated
        public ReportedBreakdown getReportedBreakdown() {
            return this.reportedBreakdown;
        }

        @Generated
        public ServiceType getServiceType() {
            return this.serviceType;
        }

        public static class CardholderPromptData {
            @SerializedName(value="driver_id")
            String driverId;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="odometer")
            Long odometer;
            @SerializedName(value="unspecified_id")
            String unspecifiedId;
            @SerializedName(value="user_id")
            String userId;
            @SerializedName(value="vehicle_number")
            String vehicleNumber;

            private CardholderPromptData(String driverId, Map<String, Object> extraParams, Long odometer, String unspecifiedId, String userId, String vehicleNumber) {
                this.driverId = driverId;
                this.extraParams = extraParams;
                this.odometer = odometer;
                this.unspecifiedId = unspecifiedId;
                this.userId = userId;
                this.vehicleNumber = vehicleNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getDriverId() {
                return this.driverId;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Long getOdometer() {
                return this.odometer;
            }

            @Generated
            public String getUnspecifiedId() {
                return this.unspecifiedId;
            }

            @Generated
            public String getUserId() {
                return this.userId;
            }

            @Generated
            public String getVehicleNumber() {
                return this.vehicleNumber;
            }

            public static class Builder {
                private String driverId;
                private Map<String, Object> extraParams;
                private Long odometer;
                private String unspecifiedId;
                private String userId;
                private String vehicleNumber;

                public CardholderPromptData build() {
                    return new CardholderPromptData(this.driverId, this.extraParams, this.odometer, this.unspecifiedId, this.userId, this.vehicleNumber);
                }

                public Builder setDriverId(String driverId) {
                    this.driverId = driverId;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setOdometer(Long odometer) {
                    this.odometer = odometer;
                    return this;
                }

                public Builder setUnspecifiedId(String unspecifiedId) {
                    this.unspecifiedId = unspecifiedId;
                    return this;
                }

                public Builder setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public Builder setVehicleNumber(String vehicleNumber) {
                    this.vehicleNumber = vehicleNumber;
                    return this;
                }
            }
        }

        public static enum PurchaseType implements ApiRequestParams.EnumParam
        {
            FUEL_AND_NON_FUEL_PURCHASE("fuel_and_non_fuel_purchase"),
            FUEL_PURCHASE("fuel_purchase"),
            NON_FUEL_PURCHASE("non_fuel_purchase");

            private final String value;

            private PurchaseType(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class ReportedBreakdown {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="fuel")
            Fuel fuel;
            @SerializedName(value="non_fuel")
            NonFuel nonFuel;
            @SerializedName(value="tax")
            Tax tax;

            private ReportedBreakdown(Map<String, Object> extraParams, Fuel fuel, NonFuel nonFuel, Tax tax) {
                this.extraParams = extraParams;
                this.fuel = fuel;
                this.nonFuel = nonFuel;
                this.tax = tax;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Fuel getFuel() {
                return this.fuel;
            }

            @Generated
            public NonFuel getNonFuel() {
                return this.nonFuel;
            }

            @Generated
            public Tax getTax() {
                return this.tax;
            }

            public static class Fuel {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="gross_amount_decimal")
                BigDecimal grossAmountDecimal;

                private Fuel(Map<String, Object> extraParams, BigDecimal grossAmountDecimal) {
                    this.extraParams = extraParams;
                    this.grossAmountDecimal = grossAmountDecimal;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public BigDecimal getGrossAmountDecimal() {
                    return this.grossAmountDecimal;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private BigDecimal grossAmountDecimal;

                    public Fuel build() {
                        return new Fuel(this.extraParams, this.grossAmountDecimal);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setGrossAmountDecimal(BigDecimal grossAmountDecimal) {
                        this.grossAmountDecimal = grossAmountDecimal;
                        return this;
                    }
                }
            }

            public static class NonFuel {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="gross_amount_decimal")
                BigDecimal grossAmountDecimal;

                private NonFuel(Map<String, Object> extraParams, BigDecimal grossAmountDecimal) {
                    this.extraParams = extraParams;
                    this.grossAmountDecimal = grossAmountDecimal;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public BigDecimal getGrossAmountDecimal() {
                    return this.grossAmountDecimal;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private BigDecimal grossAmountDecimal;

                    public NonFuel build() {
                        return new NonFuel(this.extraParams, this.grossAmountDecimal);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setGrossAmountDecimal(BigDecimal grossAmountDecimal) {
                        this.grossAmountDecimal = grossAmountDecimal;
                        return this;
                    }
                }
            }

            public static class Tax {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="local_amount_decimal")
                BigDecimal localAmountDecimal;
                @SerializedName(value="national_amount_decimal")
                BigDecimal nationalAmountDecimal;

                private Tax(Map<String, Object> extraParams, BigDecimal localAmountDecimal, BigDecimal nationalAmountDecimal) {
                    this.extraParams = extraParams;
                    this.localAmountDecimal = localAmountDecimal;
                    this.nationalAmountDecimal = nationalAmountDecimal;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public BigDecimal getLocalAmountDecimal() {
                    return this.localAmountDecimal;
                }

                @Generated
                public BigDecimal getNationalAmountDecimal() {
                    return this.nationalAmountDecimal;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private BigDecimal localAmountDecimal;
                    private BigDecimal nationalAmountDecimal;

                    public Tax build() {
                        return new Tax(this.extraParams, this.localAmountDecimal, this.nationalAmountDecimal);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLocalAmountDecimal(BigDecimal localAmountDecimal) {
                        this.localAmountDecimal = localAmountDecimal;
                        return this;
                    }

                    public Builder setNationalAmountDecimal(BigDecimal nationalAmountDecimal) {
                        this.nationalAmountDecimal = nationalAmountDecimal;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Fuel fuel;
                private NonFuel nonFuel;
                private Tax tax;

                public ReportedBreakdown build() {
                    return new ReportedBreakdown(this.extraParams, this.fuel, this.nonFuel, this.tax);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFuel(Fuel fuel) {
                    this.fuel = fuel;
                    return this;
                }

                public Builder setNonFuel(NonFuel nonFuel) {
                    this.nonFuel = nonFuel;
                    return this;
                }

                public Builder setTax(Tax tax) {
                    this.tax = tax;
                    return this;
                }
            }
        }

        public static enum ServiceType implements ApiRequestParams.EnumParam
        {
            FULL_SERVICE("full_service"),
            NON_FUEL_TRANSACTION("non_fuel_transaction"),
            SELF_SERVICE("self_service");

            private final String value;

            private ServiceType(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private CardholderPromptData cardholderPromptData;
            private Map<String, Object> extraParams;
            private PurchaseType purchaseType;
            private ReportedBreakdown reportedBreakdown;
            private ServiceType serviceType;

            public Fleet build() {
                return new Fleet(this.cardholderPromptData, this.extraParams, this.purchaseType, this.reportedBreakdown, this.serviceType);
            }

            public Builder setCardholderPromptData(CardholderPromptData cardholderPromptData) {
                this.cardholderPromptData = cardholderPromptData;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setPurchaseType(PurchaseType purchaseType) {
                this.purchaseType = purchaseType;
                return this;
            }

            public Builder setReportedBreakdown(ReportedBreakdown reportedBreakdown) {
                this.reportedBreakdown = reportedBreakdown;
                return this;
            }

            public Builder setServiceType(ServiceType serviceType) {
                this.serviceType = serviceType;
                return this;
            }
        }
    }

    public static class Fuel {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="industry_product_code")
        String industryProductCode;
        @SerializedName(value="quantity_decimal")
        BigDecimal quantityDecimal;
        @SerializedName(value="type")
        Type type;
        @SerializedName(value="unit")
        Unit unit;
        @SerializedName(value="unit_cost_decimal")
        BigDecimal unitCostDecimal;

        private Fuel(Map<String, Object> extraParams, String industryProductCode, BigDecimal quantityDecimal, Type type, Unit unit, BigDecimal unitCostDecimal) {
            this.extraParams = extraParams;
            this.industryProductCode = industryProductCode;
            this.quantityDecimal = quantityDecimal;
            this.type = type;
            this.unit = unit;
            this.unitCostDecimal = unitCostDecimal;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getIndustryProductCode() {
            return this.industryProductCode;
        }

        @Generated
        public BigDecimal getQuantityDecimal() {
            return this.quantityDecimal;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public Unit getUnit() {
            return this.unit;
        }

        @Generated
        public BigDecimal getUnitCostDecimal() {
            return this.unitCostDecimal;
        }

        public static enum Type implements ApiRequestParams.EnumParam
        {
            DIESEL("diesel"),
            OTHER("other"),
            UNLEADED_PLUS("unleaded_plus"),
            UNLEADED_REGULAR("unleaded_regular"),
            UNLEADED_SUPER("unleaded_super");

            private final String value;

            private Type(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum Unit implements ApiRequestParams.EnumParam
        {
            CHARGING_MINUTE("charging_minute"),
            IMPERIAL_GALLON("imperial_gallon"),
            KILOGRAM("kilogram"),
            KILOWATT_HOUR("kilowatt_hour"),
            LITER("liter"),
            OTHER("other"),
            POUND("pound"),
            US_GALLON("us_gallon");

            private final String value;

            private Unit(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private String industryProductCode;
            private BigDecimal quantityDecimal;
            private Type type;
            private Unit unit;
            private BigDecimal unitCostDecimal;

            public Fuel build() {
                return new Fuel(this.extraParams, this.industryProductCode, this.quantityDecimal, this.type, this.unit, this.unitCostDecimal);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setIndustryProductCode(String industryProductCode) {
                this.industryProductCode = industryProductCode;
                return this;
            }

            public Builder setQuantityDecimal(BigDecimal quantityDecimal) {
                this.quantityDecimal = quantityDecimal;
                return this;
            }

            public Builder setType(Type type) {
                this.type = type;
                return this;
            }

            public Builder setUnit(Unit unit) {
                this.unit = unit;
                return this;
            }

            public Builder setUnitCostDecimal(BigDecimal unitCostDecimal) {
                this.unitCostDecimal = unitCostDecimal;
                return this;
            }
        }
    }

    public static class MerchantData {
        @SerializedName(value="category")
        Category category;
        @SerializedName(value="city")
        String city;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="network_id")
        String networkId;
        @SerializedName(value="postal_code")
        String postalCode;
        @SerializedName(value="state")
        String state;
        @SerializedName(value="terminal_id")
        String terminalId;
        @SerializedName(value="url")
        String url;

        private MerchantData(Category category, String city, String country, Map<String, Object> extraParams, String name, String networkId, String postalCode, String state, String terminalId, String url) {
            this.category = category;
            this.city = city;
            this.country = country;
            this.extraParams = extraParams;
            this.name = name;
            this.networkId = networkId;
            this.postalCode = postalCode;
            this.state = state;
            this.terminalId = terminalId;
            this.url = url;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Category getCategory() {
            return this.category;
        }

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getNetworkId() {
            return this.networkId;
        }

        @Generated
        public String getPostalCode() {
            return this.postalCode;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public String getTerminalId() {
            return this.terminalId;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        public static enum Category implements ApiRequestParams.EnumParam
        {
            AC_REFRIGERATION_REPAIR("ac_refrigeration_repair"),
            ACCOUNTING_BOOKKEEPING_SERVICES("accounting_bookkeeping_services"),
            ADVERTISING_SERVICES("advertising_services"),
            AGRICULTURAL_COOPERATIVE("agricultural_cooperative"),
            AIRLINES_AIR_CARRIERS("airlines_air_carriers"),
            AIRPORTS_FLYING_FIELDS("airports_flying_fields"),
            AMBULANCE_SERVICES("ambulance_services"),
            AMUSEMENT_PARKS_CARNIVALS("amusement_parks_carnivals"),
            ANTIQUE_REPRODUCTIONS("antique_reproductions"),
            ANTIQUE_SHOPS("antique_shops"),
            AQUARIUMS("aquariums"),
            ARCHITECTURAL_SURVEYING_SERVICES("architectural_surveying_services"),
            ART_DEALERS_AND_GALLERIES("art_dealers_and_galleries"),
            ARTISTS_SUPPLY_AND_CRAFT_SHOPS("artists_supply_and_craft_shops"),
            AUTO_AND_HOME_SUPPLY_STORES("auto_and_home_supply_stores"),
            AUTO_BODY_REPAIR_SHOPS("auto_body_repair_shops"),
            AUTO_PAINT_SHOPS("auto_paint_shops"),
            AUTO_SERVICE_SHOPS("auto_service_shops"),
            AUTOMATED_CASH_DISBURSE("automated_cash_disburse"),
            AUTOMATED_FUEL_DISPENSERS("automated_fuel_dispensers"),
            AUTOMOBILE_ASSOCIATIONS("automobile_associations"),
            AUTOMOTIVE_PARTS_AND_ACCESSORIES_STORES("automotive_parts_and_accessories_stores"),
            AUTOMOTIVE_TIRE_STORES("automotive_tire_stores"),
            BAIL_AND_BOND_PAYMENTS("bail_and_bond_payments"),
            BAKERIES("bakeries"),
            BANDS_ORCHESTRAS("bands_orchestras"),
            BARBER_AND_BEAUTY_SHOPS("barber_and_beauty_shops"),
            BETTING_CASINO_GAMBLING("betting_casino_gambling"),
            BICYCLE_SHOPS("bicycle_shops"),
            BILLIARD_POOL_ESTABLISHMENTS("billiard_pool_establishments"),
            BOAT_DEALERS("boat_dealers"),
            BOAT_RENTALS_AND_LEASES("boat_rentals_and_leases"),
            BOOK_STORES("book_stores"),
            BOOKS_PERIODICALS_AND_NEWSPAPERS("books_periodicals_and_newspapers"),
            BOWLING_ALLEYS("bowling_alleys"),
            BUS_LINES("bus_lines"),
            BUSINESS_SECRETARIAL_SCHOOLS("business_secretarial_schools"),
            BUYING_SHOPPING_SERVICES("buying_shopping_services"),
            CABLE_SATELLITE_AND_OTHER_PAY_TELEVISION_AND_RADIO("cable_satellite_and_other_pay_television_and_radio"),
            CAMERA_AND_PHOTOGRAPHIC_SUPPLY_STORES("camera_and_photographic_supply_stores"),
            CANDY_NUT_AND_CONFECTIONERY_STORES("candy_nut_and_confectionery_stores"),
            CAR_AND_TRUCK_DEALERS_NEW_USED("car_and_truck_dealers_new_used"),
            CAR_AND_TRUCK_DEALERS_USED_ONLY("car_and_truck_dealers_used_only"),
            CAR_RENTAL_AGENCIES("car_rental_agencies"),
            CAR_WASHES("car_washes"),
            CARPENTRY_SERVICES("carpentry_services"),
            CARPET_UPHOLSTERY_CLEANING("carpet_upholstery_cleaning"),
            CATERERS("caterers"),
            CHARITABLE_AND_SOCIAL_SERVICE_ORGANIZATIONS_FUNDRAISING("charitable_and_social_service_organizations_fundraising"),
            CHEMICALS_AND_ALLIED_PRODUCTS("chemicals_and_allied_products"),
            CHILD_CARE_SERVICES("child_care_services"),
            CHILDRENS_AND_INFANTS_WEAR_STORES("childrens_and_infants_wear_stores"),
            CHIROPODISTS_PODIATRISTS("chiropodists_podiatrists"),
            CHIROPRACTORS("chiropractors"),
            CIGAR_STORES_AND_STANDS("cigar_stores_and_stands"),
            CIVIC_SOCIAL_FRATERNAL_ASSOCIATIONS("civic_social_fraternal_associations"),
            CLEANING_AND_MAINTENANCE("cleaning_and_maintenance"),
            CLOTHING_RENTAL("clothing_rental"),
            COLLEGES_UNIVERSITIES("colleges_universities"),
            COMMERCIAL_EQUIPMENT("commercial_equipment"),
            COMMERCIAL_FOOTWEAR("commercial_footwear"),
            COMMERCIAL_PHOTOGRAPHY_ART_AND_GRAPHICS("commercial_photography_art_and_graphics"),
            COMMUTER_TRANSPORT_AND_FERRIES("commuter_transport_and_ferries"),
            COMPUTER_NETWORK_SERVICES("computer_network_services"),
            COMPUTER_PROGRAMMING("computer_programming"),
            COMPUTER_REPAIR("computer_repair"),
            COMPUTER_SOFTWARE_STORES("computer_software_stores"),
            COMPUTERS_PERIPHERALS_AND_SOFTWARE("computers_peripherals_and_software"),
            CONCRETE_WORK_SERVICES("concrete_work_services"),
            CONSTRUCTION_MATERIALS("construction_materials"),
            CONSULTING_PUBLIC_RELATIONS("consulting_public_relations"),
            CORRESPONDENCE_SCHOOLS("correspondence_schools"),
            COSMETIC_STORES("cosmetic_stores"),
            COUNSELING_SERVICES("counseling_services"),
            COUNTRY_CLUBS("country_clubs"),
            COURIER_SERVICES("courier_services"),
            COURT_COSTS("court_costs"),
            CREDIT_REPORTING_AGENCIES("credit_reporting_agencies"),
            CRUISE_LINES("cruise_lines"),
            DAIRY_PRODUCTS_STORES("dairy_products_stores"),
            DANCE_HALL_STUDIOS_SCHOOLS("dance_hall_studios_schools"),
            DATING_ESCORT_SERVICES("dating_escort_services"),
            DENTISTS_ORTHODONTISTS("dentists_orthodontists"),
            DEPARTMENT_STORES("department_stores"),
            DETECTIVE_AGENCIES("detective_agencies"),
            DIGITAL_GOODS_APPLICATIONS("digital_goods_applications"),
            DIGITAL_GOODS_GAMES("digital_goods_games"),
            DIGITAL_GOODS_LARGE_VOLUME("digital_goods_large_volume"),
            DIGITAL_GOODS_MEDIA("digital_goods_media"),
            DIRECT_MARKETING_CATALOG_MERCHANT("direct_marketing_catalog_merchant"),
            DIRECT_MARKETING_COMBINATION_CATALOG_AND_RETAIL_MERCHANT("direct_marketing_combination_catalog_and_retail_merchant"),
            DIRECT_MARKETING_INBOUND_TELEMARKETING("direct_marketing_inbound_telemarketing"),
            DIRECT_MARKETING_INSURANCE_SERVICES("direct_marketing_insurance_services"),
            DIRECT_MARKETING_OTHER("direct_marketing_other"),
            DIRECT_MARKETING_OUTBOUND_TELEMARKETING("direct_marketing_outbound_telemarketing"),
            DIRECT_MARKETING_SUBSCRIPTION("direct_marketing_subscription"),
            DIRECT_MARKETING_TRAVEL("direct_marketing_travel"),
            DISCOUNT_STORES("discount_stores"),
            DOCTORS("doctors"),
            DOOR_TO_DOOR_SALES("door_to_door_sales"),
            DRAPERY_WINDOW_COVERING_AND_UPHOLSTERY_STORES("drapery_window_covering_and_upholstery_stores"),
            DRINKING_PLACES("drinking_places"),
            DRUG_STORES_AND_PHARMACIES("drug_stores_and_pharmacies"),
            DRUGS_DRUG_PROPRIETARIES_AND_DRUGGIST_SUNDRIES("drugs_drug_proprietaries_and_druggist_sundries"),
            DRY_CLEANERS("dry_cleaners"),
            DURABLE_GOODS("durable_goods"),
            DUTY_FREE_STORES("duty_free_stores"),
            EATING_PLACES_RESTAURANTS("eating_places_restaurants"),
            EDUCATIONAL_SERVICES("educational_services"),
            ELECTRIC_RAZOR_STORES("electric_razor_stores"),
            ELECTRIC_VEHICLE_CHARGING("electric_vehicle_charging"),
            ELECTRICAL_PARTS_AND_EQUIPMENT("electrical_parts_and_equipment"),
            ELECTRICAL_SERVICES("electrical_services"),
            ELECTRONICS_REPAIR_SHOPS("electronics_repair_shops"),
            ELECTRONICS_STORES("electronics_stores"),
            ELEMENTARY_SECONDARY_SCHOOLS("elementary_secondary_schools"),
            EMERGENCY_SERVICES_GCAS_VISA_USE_ONLY("emergency_services_gcas_visa_use_only"),
            EMPLOYMENT_TEMP_AGENCIES("employment_temp_agencies"),
            EQUIPMENT_RENTAL("equipment_rental"),
            EXTERMINATING_SERVICES("exterminating_services"),
            FAMILY_CLOTHING_STORES("family_clothing_stores"),
            FAST_FOOD_RESTAURANTS("fast_food_restaurants"),
            FINANCIAL_INSTITUTIONS("financial_institutions"),
            FINES_GOVERNMENT_ADMINISTRATIVE_ENTITIES("fines_government_administrative_entities"),
            FIREPLACE_FIREPLACE_SCREENS_AND_ACCESSORIES_STORES("fireplace_fireplace_screens_and_accessories_stores"),
            FLOOR_COVERING_STORES("floor_covering_stores"),
            FLORISTS("florists"),
            FLORISTS_SUPPLIES_NURSERY_STOCK_AND_FLOWERS("florists_supplies_nursery_stock_and_flowers"),
            FREEZER_AND_LOCKER_MEAT_PROVISIONERS("freezer_and_locker_meat_provisioners"),
            FUEL_DEALERS_NON_AUTOMOTIVE("fuel_dealers_non_automotive"),
            FUNERAL_SERVICES_CREMATORIES("funeral_services_crematories"),
            FURNITURE_HOME_FURNISHINGS_AND_EQUIPMENT_STORES_EXCEPT_APPLIANCES("furniture_home_furnishings_and_equipment_stores_except_appliances"),
            FURNITURE_REPAIR_REFINISHING("furniture_repair_refinishing"),
            FURRIERS_AND_FUR_SHOPS("furriers_and_fur_shops"),
            GENERAL_SERVICES("general_services"),
            GIFT_CARD_NOVELTY_AND_SOUVENIR_SHOPS("gift_card_novelty_and_souvenir_shops"),
            GLASS_PAINT_AND_WALLPAPER_STORES("glass_paint_and_wallpaper_stores"),
            GLASSWARE_CRYSTAL_STORES("glassware_crystal_stores"),
            GOLF_COURSES_PUBLIC("golf_courses_public"),
            GOVERNMENT_LICENSED_HORSE_DOG_RACING_US_REGION_ONLY("government_licensed_horse_dog_racing_us_region_only"),
            GOVERNMENT_LICENSED_ONLINE_CASIONS_ONLINE_GAMBLING_US_REGION_ONLY("government_licensed_online_casions_online_gambling_us_region_only"),
            GOVERNMENT_OWNED_LOTTERIES_NON_US_REGION("government_owned_lotteries_non_us_region"),
            GOVERNMENT_OWNED_LOTTERIES_US_REGION_ONLY("government_owned_lotteries_us_region_only"),
            GOVERNMENT_SERVICES("government_services"),
            GROCERY_STORES_SUPERMARKETS("grocery_stores_supermarkets"),
            HARDWARE_EQUIPMENT_AND_SUPPLIES("hardware_equipment_and_supplies"),
            HARDWARE_STORES("hardware_stores"),
            HEALTH_AND_BEAUTY_SPAS("health_and_beauty_spas"),
            HEARING_AIDS_SALES_AND_SUPPLIES("hearing_aids_sales_and_supplies"),
            HEATING_PLUMBING_A_C("heating_plumbing_a_c"),
            HOBBY_TOY_AND_GAME_SHOPS("hobby_toy_and_game_shops"),
            HOME_SUPPLY_WAREHOUSE_STORES("home_supply_warehouse_stores"),
            HOSPITALS("hospitals"),
            HOTELS_MOTELS_AND_RESORTS("hotels_motels_and_resorts"),
            HOUSEHOLD_APPLIANCE_STORES("household_appliance_stores"),
            INDUSTRIAL_SUPPLIES("industrial_supplies"),
            INFORMATION_RETRIEVAL_SERVICES("information_retrieval_services"),
            INSURANCE_DEFAULT("insurance_default"),
            INSURANCE_UNDERWRITING_PREMIUMS("insurance_underwriting_premiums"),
            INTRA_COMPANY_PURCHASES("intra_company_purchases"),
            JEWELRY_STORES_WATCHES_CLOCKS_AND_SILVERWARE_STORES("jewelry_stores_watches_clocks_and_silverware_stores"),
            LANDSCAPING_SERVICES("landscaping_services"),
            LAUNDRIES("laundries"),
            LAUNDRY_CLEANING_SERVICES("laundry_cleaning_services"),
            LEGAL_SERVICES_ATTORNEYS("legal_services_attorneys"),
            LUGGAGE_AND_LEATHER_GOODS_STORES("luggage_and_leather_goods_stores"),
            LUMBER_BUILDING_MATERIALS_STORES("lumber_building_materials_stores"),
            MANUAL_CASH_DISBURSE("manual_cash_disburse"),
            MARINAS_SERVICE_AND_SUPPLIES("marinas_service_and_supplies"),
            MARKETPLACES("marketplaces"),
            MASONRY_STONEWORK_AND_PLASTER("masonry_stonework_and_plaster"),
            MASSAGE_PARLORS("massage_parlors"),
            MEDICAL_AND_DENTAL_LABS("medical_and_dental_labs"),
            MEDICAL_DENTAL_OPHTHALMIC_AND_HOSPITAL_EQUIPMENT_AND_SUPPLIES("medical_dental_ophthalmic_and_hospital_equipment_and_supplies"),
            MEDICAL_SERVICES("medical_services"),
            MEMBERSHIP_ORGANIZATIONS("membership_organizations"),
            MENS_AND_BOYS_CLOTHING_AND_ACCESSORIES_STORES("mens_and_boys_clothing_and_accessories_stores"),
            MENS_WOMENS_CLOTHING_STORES("mens_womens_clothing_stores"),
            METAL_SERVICE_CENTERS("metal_service_centers"),
            MISCELLANEOUS_APPAREL_AND_ACCESSORY_SHOPS("miscellaneous_apparel_and_accessory_shops"),
            MISCELLANEOUS_AUTO_DEALERS("miscellaneous_auto_dealers"),
            MISCELLANEOUS_BUSINESS_SERVICES("miscellaneous_business_services"),
            MISCELLANEOUS_FOOD_STORES("miscellaneous_food_stores"),
            MISCELLANEOUS_GENERAL_MERCHANDISE("miscellaneous_general_merchandise"),
            MISCELLANEOUS_GENERAL_SERVICES("miscellaneous_general_services"),
            MISCELLANEOUS_HOME_FURNISHING_SPECIALTY_STORES("miscellaneous_home_furnishing_specialty_stores"),
            MISCELLANEOUS_PUBLISHING_AND_PRINTING("miscellaneous_publishing_and_printing"),
            MISCELLANEOUS_RECREATION_SERVICES("miscellaneous_recreation_services"),
            MISCELLANEOUS_REPAIR_SHOPS("miscellaneous_repair_shops"),
            MISCELLANEOUS_SPECIALTY_RETAIL("miscellaneous_specialty_retail"),
            MOBILE_HOME_DEALERS("mobile_home_dealers"),
            MOTION_PICTURE_THEATERS("motion_picture_theaters"),
            MOTOR_FREIGHT_CARRIERS_AND_TRUCKING("motor_freight_carriers_and_trucking"),
            MOTOR_HOMES_DEALERS("motor_homes_dealers"),
            MOTOR_VEHICLE_SUPPLIES_AND_NEW_PARTS("motor_vehicle_supplies_and_new_parts"),
            MOTORCYCLE_SHOPS_AND_DEALERS("motorcycle_shops_and_dealers"),
            MOTORCYCLE_SHOPS_DEALERS("motorcycle_shops_dealers"),
            MUSIC_STORES_MUSICAL_INSTRUMENTS_PIANOS_AND_SHEET_MUSIC("music_stores_musical_instruments_pianos_and_sheet_music"),
            NEWS_DEALERS_AND_NEWSSTANDS("news_dealers_and_newsstands"),
            NON_FI_MONEY_ORDERS("non_fi_money_orders"),
            NON_FI_STORED_VALUE_CARD_PURCHASE_LOAD("non_fi_stored_value_card_purchase_load"),
            NONDURABLE_GOODS("nondurable_goods"),
            NURSERIES_LAWN_AND_GARDEN_SUPPLY_STORES("nurseries_lawn_and_garden_supply_stores"),
            NURSING_PERSONAL_CARE("nursing_personal_care"),
            OFFICE_AND_COMMERCIAL_FURNITURE("office_and_commercial_furniture"),
            OPTICIANS_EYEGLASSES("opticians_eyeglasses"),
            OPTOMETRISTS_OPHTHALMOLOGIST("optometrists_ophthalmologist"),
            ORTHOPEDIC_GOODS_PROSTHETIC_DEVICES("orthopedic_goods_prosthetic_devices"),
            OSTEOPATHS("osteopaths"),
            PACKAGE_STORES_BEER_WINE_AND_LIQUOR("package_stores_beer_wine_and_liquor"),
            PAINTS_VARNISHES_AND_SUPPLIES("paints_varnishes_and_supplies"),
            PARKING_LOTS_GARAGES("parking_lots_garages"),
            PASSENGER_RAILWAYS("passenger_railways"),
            PAWN_SHOPS("pawn_shops"),
            PET_SHOPS_PET_FOOD_AND_SUPPLIES("pet_shops_pet_food_and_supplies"),
            PETROLEUM_AND_PETROLEUM_PRODUCTS("petroleum_and_petroleum_products"),
            PHOTO_DEVELOPING("photo_developing"),
            PHOTOGRAPHIC_PHOTOCOPY_MICROFILM_EQUIPMENT_AND_SUPPLIES("photographic_photocopy_microfilm_equipment_and_supplies"),
            PHOTOGRAPHIC_STUDIOS("photographic_studios"),
            PICTURE_VIDEO_PRODUCTION("picture_video_production"),
            PIECE_GOODS_NOTIONS_AND_OTHER_DRY_GOODS("piece_goods_notions_and_other_dry_goods"),
            PLUMBING_HEATING_EQUIPMENT_AND_SUPPLIES("plumbing_heating_equipment_and_supplies"),
            POLITICAL_ORGANIZATIONS("political_organizations"),
            POSTAL_SERVICES_GOVERNMENT_ONLY("postal_services_government_only"),
            PRECIOUS_STONES_AND_METALS_WATCHES_AND_JEWELRY("precious_stones_and_metals_watches_and_jewelry"),
            PROFESSIONAL_SERVICES("professional_services"),
            PUBLIC_WAREHOUSING_AND_STORAGE("public_warehousing_and_storage"),
            QUICK_COPY_REPRO_AND_BLUEPRINT("quick_copy_repro_and_blueprint"),
            RAILROADS("railroads"),
            REAL_ESTATE_AGENTS_AND_MANAGERS_RENTALS("real_estate_agents_and_managers_rentals"),
            RECORD_STORES("record_stores"),
            RECREATIONAL_VEHICLE_RENTALS("recreational_vehicle_rentals"),
            RELIGIOUS_GOODS_STORES("religious_goods_stores"),
            RELIGIOUS_ORGANIZATIONS("religious_organizations"),
            ROOFING_SIDING_SHEET_METAL("roofing_siding_sheet_metal"),
            SECRETARIAL_SUPPORT_SERVICES("secretarial_support_services"),
            SECURITY_BROKERS_DEALERS("security_brokers_dealers"),
            SERVICE_STATIONS("service_stations"),
            SEWING_NEEDLEWORK_FABRIC_AND_PIECE_GOODS_STORES("sewing_needlework_fabric_and_piece_goods_stores"),
            SHOE_REPAIR_HAT_CLEANING("shoe_repair_hat_cleaning"),
            SHOE_STORES("shoe_stores"),
            SMALL_APPLIANCE_REPAIR("small_appliance_repair"),
            SNOWMOBILE_DEALERS("snowmobile_dealers"),
            SPECIAL_TRADE_SERVICES("special_trade_services"),
            SPECIALTY_CLEANING("specialty_cleaning"),
            SPORTING_GOODS_STORES("sporting_goods_stores"),
            SPORTING_RECREATION_CAMPS("sporting_recreation_camps"),
            SPORTS_AND_RIDING_APPAREL_STORES("sports_and_riding_apparel_stores"),
            SPORTS_CLUBS_FIELDS("sports_clubs_fields"),
            STAMP_AND_COIN_STORES("stamp_and_coin_stores"),
            STATIONARY_OFFICE_SUPPLIES_PRINTING_AND_WRITING_PAPER("stationary_office_supplies_printing_and_writing_paper"),
            STATIONERY_STORES_OFFICE_AND_SCHOOL_SUPPLY_STORES("stationery_stores_office_and_school_supply_stores"),
            SWIMMING_POOLS_SALES("swimming_pools_sales"),
            T_UI_TRAVEL_GERMANY("t_ui_travel_germany"),
            TAILORS_ALTERATIONS("tailors_alterations"),
            TAX_PAYMENTS_GOVERNMENT_AGENCIES("tax_payments_government_agencies"),
            TAX_PREPARATION_SERVICES("tax_preparation_services"),
            TAXICABS_LIMOUSINES("taxicabs_limousines"),
            TELECOMMUNICATION_EQUIPMENT_AND_TELEPHONE_SALES("telecommunication_equipment_and_telephone_sales"),
            TELECOMMUNICATION_SERVICES("telecommunication_services"),
            TELEGRAPH_SERVICES("telegraph_services"),
            TENT_AND_AWNING_SHOPS("tent_and_awning_shops"),
            TESTING_LABORATORIES("testing_laboratories"),
            THEATRICAL_TICKET_AGENCIES("theatrical_ticket_agencies"),
            TIMESHARES("timeshares"),
            TIRE_RETREADING_AND_REPAIR("tire_retreading_and_repair"),
            TOLLS_BRIDGE_FEES("tolls_bridge_fees"),
            TOURIST_ATTRACTIONS_AND_EXHIBITS("tourist_attractions_and_exhibits"),
            TOWING_SERVICES("towing_services"),
            TRAILER_PARKS_CAMPGROUNDS("trailer_parks_campgrounds"),
            TRANSPORTATION_SERVICES("transportation_services"),
            TRAVEL_AGENCIES_TOUR_OPERATORS("travel_agencies_tour_operators"),
            TRUCK_STOP_ITERATION("truck_stop_iteration"),
            TRUCK_UTILITY_TRAILER_RENTALS("truck_utility_trailer_rentals"),
            TYPESETTING_PLATE_MAKING_AND_RELATED_SERVICES("typesetting_plate_making_and_related_services"),
            TYPEWRITER_STORES("typewriter_stores"),
            U_S_FEDERAL_GOVERNMENT_AGENCIES_OR_DEPARTMENTS("u_s_federal_government_agencies_or_departments"),
            UNIFORMS_COMMERCIAL_CLOTHING("uniforms_commercial_clothing"),
            USED_MERCHANDISE_AND_SECONDHAND_STORES("used_merchandise_and_secondhand_stores"),
            UTILITIES("utilities"),
            VARIETY_STORES("variety_stores"),
            VETERINARY_SERVICES("veterinary_services"),
            VIDEO_AMUSEMENT_GAME_SUPPLIES("video_amusement_game_supplies"),
            VIDEO_GAME_ARCADES("video_game_arcades"),
            VIDEO_TAPE_RENTAL_STORES("video_tape_rental_stores"),
            VOCATIONAL_TRADE_SCHOOLS("vocational_trade_schools"),
            WATCH_JEWELRY_REPAIR("watch_jewelry_repair"),
            WELDING_REPAIR("welding_repair"),
            WHOLESALE_CLUBS("wholesale_clubs"),
            WIG_AND_TOUPEE_STORES("wig_and_toupee_stores"),
            WIRES_MONEY_ORDERS("wires_money_orders"),
            WOMENS_ACCESSORY_AND_SPECIALTY_SHOPS("womens_accessory_and_specialty_shops"),
            WOMENS_READY_TO_WEAR_STORES("womens_ready_to_wear_stores"),
            WRECKING_AND_SALVAGE_YARDS("wrecking_and_salvage_yards");

            private final String value;

            private Category(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Category category;
            private String city;
            private String country;
            private Map<String, Object> extraParams;
            private String name;
            private String networkId;
            private String postalCode;
            private String state;
            private String terminalId;
            private String url;

            public MerchantData build() {
                return new MerchantData(this.category, this.city, this.country, this.extraParams, this.name, this.networkId, this.postalCode, this.state, this.terminalId, this.url);
            }

            public Builder setCategory(Category category) {
                this.category = category;
                return this;
            }

            public Builder setCity(String city) {
                this.city = city;
                return this;
            }

            public Builder setCountry(String country) {
                this.country = country;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setNetworkId(String networkId) {
                this.networkId = networkId;
                return this;
            }

            public Builder setPostalCode(String postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            public Builder setState(String state) {
                this.state = state;
                return this;
            }

            public Builder setTerminalId(String terminalId) {
                this.terminalId = terminalId;
                return this;
            }

            public Builder setUrl(String url) {
                this.url = url;
                return this;
            }
        }
    }

    public static class NetworkData {
        @SerializedName(value="acquiring_institution_id")
        String acquiringInstitutionId;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private NetworkData(String acquiringInstitutionId, Map<String, Object> extraParams) {
            this.acquiringInstitutionId = acquiringInstitutionId;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getAcquiringInstitutionId() {
            return this.acquiringInstitutionId;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private String acquiringInstitutionId;
            private Map<String, Object> extraParams;

            public NetworkData build() {
                return new NetworkData(this.acquiringInstitutionId, this.extraParams);
            }

            public Builder setAcquiringInstitutionId(String acquiringInstitutionId) {
                this.acquiringInstitutionId = acquiringInstitutionId;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class VerificationData {
        @SerializedName(value="address_line1_check")
        AddressLine1Check addressLine1Check;
        @SerializedName(value="address_postal_code_check")
        AddressPostalCodeCheck addressPostalCodeCheck;
        @SerializedName(value="authentication_exemption")
        AuthenticationExemption authenticationExemption;
        @SerializedName(value="cvc_check")
        CvcCheck cvcCheck;
        @SerializedName(value="expiry_check")
        ExpiryCheck expiryCheck;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="three_d_secure")
        ThreeDSecure threeDSecure;

        private VerificationData(AddressLine1Check addressLine1Check, AddressPostalCodeCheck addressPostalCodeCheck, AuthenticationExemption authenticationExemption, CvcCheck cvcCheck, ExpiryCheck expiryCheck, Map<String, Object> extraParams, ThreeDSecure threeDSecure) {
            this.addressLine1Check = addressLine1Check;
            this.addressPostalCodeCheck = addressPostalCodeCheck;
            this.authenticationExemption = authenticationExemption;
            this.cvcCheck = cvcCheck;
            this.expiryCheck = expiryCheck;
            this.extraParams = extraParams;
            this.threeDSecure = threeDSecure;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public AddressLine1Check getAddressLine1Check() {
            return this.addressLine1Check;
        }

        @Generated
        public AddressPostalCodeCheck getAddressPostalCodeCheck() {
            return this.addressPostalCodeCheck;
        }

        @Generated
        public AuthenticationExemption getAuthenticationExemption() {
            return this.authenticationExemption;
        }

        @Generated
        public CvcCheck getCvcCheck() {
            return this.cvcCheck;
        }

        @Generated
        public ExpiryCheck getExpiryCheck() {
            return this.expiryCheck;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public ThreeDSecure getThreeDSecure() {
            return this.threeDSecure;
        }

        public static enum AddressLine1Check implements ApiRequestParams.EnumParam
        {
            MATCH("match"),
            MISMATCH("mismatch"),
            NOT_PROVIDED("not_provided");

            private final String value;

            private AddressLine1Check(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum AddressPostalCodeCheck implements ApiRequestParams.EnumParam
        {
            MATCH("match"),
            MISMATCH("mismatch"),
            NOT_PROVIDED("not_provided");

            private final String value;

            private AddressPostalCodeCheck(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class AuthenticationExemption {
            @SerializedName(value="claimed_by")
            ClaimedBy claimedBy;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="type")
            Type type;

            private AuthenticationExemption(ClaimedBy claimedBy, Map<String, Object> extraParams, Type type) {
                this.claimedBy = claimedBy;
                this.extraParams = extraParams;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ClaimedBy getClaimedBy() {
                return this.claimedBy;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static enum ClaimedBy implements ApiRequestParams.EnumParam
            {
                ACQUIRER("acquirer"),
                ISSUER("issuer");

                private final String value;

                private ClaimedBy(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                LOW_VALUE_TRANSACTION("low_value_transaction"),
                TRANSACTION_RISK_ANALYSIS("transaction_risk_analysis"),
                UNKNOWN("unknown");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private ClaimedBy claimedBy;
                private Map<String, Object> extraParams;
                private Type type;

                public AuthenticationExemption build() {
                    return new AuthenticationExemption(this.claimedBy, this.extraParams, this.type);
                }

                public Builder setClaimedBy(ClaimedBy claimedBy) {
                    this.claimedBy = claimedBy;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }

        public static enum CvcCheck implements ApiRequestParams.EnumParam
        {
            MATCH("match"),
            MISMATCH("mismatch"),
            NOT_PROVIDED("not_provided");

            private final String value;

            private CvcCheck(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum ExpiryCheck implements ApiRequestParams.EnumParam
        {
            MATCH("match"),
            MISMATCH("mismatch"),
            NOT_PROVIDED("not_provided");

            private final String value;

            private ExpiryCheck(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class ThreeDSecure {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="result")
            Result result;

            private ThreeDSecure(Map<String, Object> extraParams, Result result) {
                this.extraParams = extraParams;
                this.result = result;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Result getResult() {
                return this.result;
            }

            public static enum Result implements ApiRequestParams.EnumParam
            {
                ATTEMPT_ACKNOWLEDGED("attempt_acknowledged"),
                AUTHENTICATED("authenticated"),
                FAILED("failed"),
                REQUIRED("required");

                private final String value;

                private Result(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Result result;

                public ThreeDSecure build() {
                    return new ThreeDSecure(this.extraParams, this.result);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setResult(Result result) {
                    this.result = result;
                    return this;
                }
            }
        }

        public static class Builder {
            private AddressLine1Check addressLine1Check;
            private AddressPostalCodeCheck addressPostalCodeCheck;
            private AuthenticationExemption authenticationExemption;
            private CvcCheck cvcCheck;
            private ExpiryCheck expiryCheck;
            private Map<String, Object> extraParams;
            private ThreeDSecure threeDSecure;

            public VerificationData build() {
                return new VerificationData(this.addressLine1Check, this.addressPostalCodeCheck, this.authenticationExemption, this.cvcCheck, this.expiryCheck, this.extraParams, this.threeDSecure);
            }

            public Builder setAddressLine1Check(AddressLine1Check addressLine1Check) {
                this.addressLine1Check = addressLine1Check;
                return this;
            }

            public Builder setAddressPostalCodeCheck(AddressPostalCodeCheck addressPostalCodeCheck) {
                this.addressPostalCodeCheck = addressPostalCodeCheck;
                return this;
            }

            public Builder setAuthenticationExemption(AuthenticationExemption authenticationExemption) {
                this.authenticationExemption = authenticationExemption;
                return this;
            }

            public Builder setCvcCheck(CvcCheck cvcCheck) {
                this.cvcCheck = cvcCheck;
                return this;
            }

            public Builder setExpiryCheck(ExpiryCheck expiryCheck) {
                this.expiryCheck = expiryCheck;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setThreeDSecure(ThreeDSecure threeDSecure) {
                this.threeDSecure = threeDSecure;
                return this;
            }
        }
    }

    public static enum Wallet implements ApiRequestParams.EnumParam
    {
        APPLE_PAY("apple_pay"),
        GOOGLE_PAY("google_pay"),
        SAMSUNG_PAY("samsung_pay");

        private final String value;

        private Wallet(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private Long amount;
        private AmountDetails amountDetails;
        private AuthorizationMethod authorizationMethod;
        private String card;
        private String currency;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Fleet fleet;
        private Fuel fuel;
        private Boolean isAmountControllable;
        private Long merchantAmount;
        private String merchantCurrency;
        private MerchantData merchantData;
        private NetworkData networkData;
        private VerificationData verificationData;
        private Wallet wallet;

        public AuthorizationCreateParams build() {
            return new AuthorizationCreateParams(this.amount, this.amountDetails, this.authorizationMethod, this.card, this.currency, this.expand, this.extraParams, this.fleet, this.fuel, this.isAmountControllable, this.merchantAmount, this.merchantCurrency, this.merchantData, this.networkData, this.verificationData, this.wallet);
        }

        public Builder setAmount(Long amount) {
            this.amount = amount;
            return this;
        }

        public Builder setAmountDetails(AmountDetails amountDetails) {
            this.amountDetails = amountDetails;
            return this;
        }

        public Builder setAuthorizationMethod(AuthorizationMethod authorizationMethod) {
            this.authorizationMethod = authorizationMethod;
            return this;
        }

        public Builder setCard(String card) {
            this.card = card;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setFleet(Fleet fleet) {
            this.fleet = fleet;
            return this;
        }

        public Builder setFuel(Fuel fuel) {
            this.fuel = fuel;
            return this;
        }

        public Builder setIsAmountControllable(Boolean isAmountControllable) {
            this.isAmountControllable = isAmountControllable;
            return this;
        }

        public Builder setMerchantAmount(Long merchantAmount) {
            this.merchantAmount = merchantAmount;
            return this;
        }

        public Builder setMerchantCurrency(String merchantCurrency) {
            this.merchantCurrency = merchantCurrency;
            return this;
        }

        public Builder setMerchantData(MerchantData merchantData) {
            this.merchantData = merchantData;
            return this;
        }

        public Builder setNetworkData(NetworkData networkData) {
            this.networkData = networkData;
            return this;
        }

        public Builder setVerificationData(VerificationData verificationData) {
            this.verificationData = verificationData;
            return this;
        }

        public Builder setWallet(Wallet wallet) {
            this.wallet = wallet;
            return this;
        }
    }
}

