/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Capability;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.AccountCapabilityListParams;
import com.stripe.param.AccountCapabilityRetrieveParams;
import com.stripe.param.AccountCapabilityUpdateParams;
import java.lang.reflect.Type;

public final class AccountCapabilityService
extends ApiService {
    public AccountCapabilityService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Capability> list(String account, AccountCapabilityListParams params) throws StripeException {
        return this.list(account, params, null);
    }

    public StripeCollection<Capability> list(String account, RequestOptions options) throws StripeException {
        return this.list(account, null, options);
    }

    public StripeCollection<Capability> list(String account) throws StripeException {
        return this.list(account, null, null);
    }

    public StripeCollection<Capability> list(String account, AccountCapabilityListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/capabilities", ApiResource.urlEncodeId(account));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Capability>>(){}.getType());
    }

    public Capability retrieve(String account, String capability, AccountCapabilityRetrieveParams params) throws StripeException {
        return this.retrieve(account, capability, params, null);
    }

    public Capability retrieve(String account, String capability, RequestOptions options) throws StripeException {
        return this.retrieve(account, capability, null, options);
    }

    public Capability retrieve(String account, String capability) throws StripeException {
        return this.retrieve(account, capability, null, null);
    }

    public Capability retrieve(String account, String capability, AccountCapabilityRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/capabilities/%s", ApiResource.urlEncodeId(account), ApiResource.urlEncodeId(capability));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Capability)this.request(request, (Type)((Object)Capability.class));
    }

    public Capability update(String account, String capability, AccountCapabilityUpdateParams params) throws StripeException {
        return this.update(account, capability, params, null);
    }

    public Capability update(String account, String capability, RequestOptions options) throws StripeException {
        return this.update(account, capability, null, options);
    }

    public Capability update(String account, String capability) throws StripeException {
        return this.update(account, capability, null, null);
    }

    public Capability update(String account, String capability, AccountCapabilityUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/capabilities/%s", ApiResource.urlEncodeId(account), ApiResource.urlEncodeId(capability));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Capability)this.request(request, (Type)((Object)Capability.class));
    }
}

