/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.tax;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.tax.RegistrationCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.tax.RegistrationCreateParams;
import com.stripe.param.tax.RegistrationListParams;
import com.stripe.param.tax.RegistrationRetrieveParams;
import com.stripe.param.tax.RegistrationUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class Registration
extends ApiResource
implements HasId {
    @SerializedName(value="active_from")
    Long activeFrom;
    @SerializedName(value="country")
    String country;
    @SerializedName(value="country_options")
    CountryOptions countryOptions;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="status")
    String status;

    public static Registration create(Map<String, Object> params) throws StripeException {
        return Registration.create(params, (RequestOptions)null);
    }

    public static Registration create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/registrations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Registration)Registration.getGlobalResponseGetter().request(request, (Type)((Object)Registration.class));
    }

    public static Registration create(RegistrationCreateParams params) throws StripeException {
        return Registration.create(params, (RequestOptions)null);
    }

    public static Registration create(RegistrationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/registrations";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Registration)Registration.getGlobalResponseGetter().request(request, (Type)((Object)Registration.class));
    }

    public static RegistrationCollection list(Map<String, Object> params) throws StripeException {
        return Registration.list(params, (RequestOptions)null);
    }

    public static RegistrationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/registrations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (RegistrationCollection)Registration.getGlobalResponseGetter().request(request, (Type)((Object)RegistrationCollection.class));
    }

    public static RegistrationCollection list(RegistrationListParams params) throws StripeException {
        return Registration.list(params, (RequestOptions)null);
    }

    public static RegistrationCollection list(RegistrationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/registrations";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (RegistrationCollection)Registration.getGlobalResponseGetter().request(request, (Type)((Object)RegistrationCollection.class));
    }

    public static Registration retrieve(String id) throws StripeException {
        return Registration.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Registration retrieve(String id, RequestOptions options) throws StripeException {
        return Registration.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Registration retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/registrations/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Registration)Registration.getGlobalResponseGetter().request(request, (Type)((Object)Registration.class));
    }

    public static Registration retrieve(String id, RegistrationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/registrations/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Registration)Registration.getGlobalResponseGetter().request(request, (Type)((Object)Registration.class));
    }

    public Registration update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Registration update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/registrations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Registration)this.getResponseGetter().request(request, (Type)((Object)Registration.class));
    }

    public Registration update(RegistrationUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Registration update(RegistrationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/registrations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Registration)this.getResponseGetter().request(request, (Type)((Object)Registration.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.countryOptions, responseGetter);
    }

    @Generated
    public Long getActiveFrom() {
        return this.activeFrom;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public CountryOptions getCountryOptions() {
        return this.countryOptions;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setActiveFrom(Long activeFrom) {
        this.activeFrom = activeFrom;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public void setCountryOptions(CountryOptions countryOptions) {
        this.countryOptions = countryOptions;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Registration)) {
            return false;
        }
        Registration other = (Registration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$activeFrom = this.getActiveFrom();
        Long other$activeFrom = other.getActiveFrom();
        if (this$activeFrom == null ? other$activeFrom != null : !((Object)this$activeFrom).equals(other$activeFrom)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        CountryOptions this$countryOptions = this.getCountryOptions();
        CountryOptions other$countryOptions = other.getCountryOptions();
        if (this$countryOptions == null ? other$countryOptions != null : !((Object)this$countryOptions).equals(other$countryOptions)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Registration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $activeFrom = this.getActiveFrom();
        result = result * 59 + ($activeFrom == null ? 43 : ((Object)$activeFrom).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        CountryOptions $countryOptions = this.getCountryOptions();
        result = result * 59 + ($countryOptions == null ? 43 : ((Object)$countryOptions).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class CountryOptions
    extends StripeObject {
        @SerializedName(value="ae")
        Ae ae;
        @SerializedName(value="at")
        At at;
        @SerializedName(value="au")
        Au au;
        @SerializedName(value="be")
        Be be;
        @SerializedName(value="bg")
        Bg bg;
        @SerializedName(value="bh")
        Bh bh;
        @SerializedName(value="ca")
        Ca ca;
        @SerializedName(value="ch")
        Ch ch;
        @SerializedName(value="cl")
        Cl cl;
        @SerializedName(value="co")
        Co co;
        @SerializedName(value="cy")
        Cy cy;
        @SerializedName(value="cz")
        Cz cz;
        @SerializedName(value="de")
        De de;
        @SerializedName(value="dk")
        Dk dk;
        @SerializedName(value="ee")
        Ee ee;
        @SerializedName(value="eg")
        Eg eg;
        @SerializedName(value="es")
        Es es;
        @SerializedName(value="fi")
        Fi fi;
        @SerializedName(value="fr")
        Fr fr;
        @SerializedName(value="gb")
        Gb gb;
        @SerializedName(value="ge")
        Ge ge;
        @SerializedName(value="gr")
        Gr gr;
        @SerializedName(value="hr")
        Hr hr;
        @SerializedName(value="hu")
        Hu hu;
        @SerializedName(value="id")
        Id id;
        @SerializedName(value="ie")
        Ie ie;
        @SerializedName(value="is")
        Is is;
        @SerializedName(value="it")
        It it;
        @SerializedName(value="jp")
        Jp jp;
        @SerializedName(value="ke")
        Ke ke;
        @SerializedName(value="kr")
        Kr kr;
        @SerializedName(value="kz")
        Kz kz;
        @SerializedName(value="lt")
        Lt lt;
        @SerializedName(value="lu")
        Lu lu;
        @SerializedName(value="lv")
        Lv lv;
        @SerializedName(value="mt")
        Mt mt;
        @SerializedName(value="mx")
        Mx mx;
        @SerializedName(value="my")
        My my;
        @SerializedName(value="ng")
        Ng ng;
        @SerializedName(value="nl")
        Nl nl;
        @SerializedName(value="no")
        No no;
        @SerializedName(value="nz")
        Nz nz;
        @SerializedName(value="om")
        Om om;
        @SerializedName(value="pl")
        Pl pl;
        @SerializedName(value="pt")
        Pt pt;
        @SerializedName(value="ro")
        Ro ro;
        @SerializedName(value="sa")
        Sa sa;
        @SerializedName(value="se")
        Se se;
        @SerializedName(value="sg")
        Sg sg;
        @SerializedName(value="si")
        Si si;
        @SerializedName(value="sk")
        Sk sk;
        @SerializedName(value="th")
        Th th;
        @SerializedName(value="tr")
        Tr tr;
        @SerializedName(value="us")
        Us us;
        @SerializedName(value="vn")
        Vn vn;
        @SerializedName(value="za")
        Za za;

        @Generated
        public Ae getAe() {
            return this.ae;
        }

        @Generated
        public At getAt() {
            return this.at;
        }

        @Generated
        public Au getAu() {
            return this.au;
        }

        @Generated
        public Be getBe() {
            return this.be;
        }

        @Generated
        public Bg getBg() {
            return this.bg;
        }

        @Generated
        public Bh getBh() {
            return this.bh;
        }

        @Generated
        public Ca getCa() {
            return this.ca;
        }

        @Generated
        public Ch getCh() {
            return this.ch;
        }

        @Generated
        public Cl getCl() {
            return this.cl;
        }

        @Generated
        public Co getCo() {
            return this.co;
        }

        @Generated
        public Cy getCy() {
            return this.cy;
        }

        @Generated
        public Cz getCz() {
            return this.cz;
        }

        @Generated
        public De getDe() {
            return this.de;
        }

        @Generated
        public Dk getDk() {
            return this.dk;
        }

        @Generated
        public Ee getEe() {
            return this.ee;
        }

        @Generated
        public Eg getEg() {
            return this.eg;
        }

        @Generated
        public Es getEs() {
            return this.es;
        }

        @Generated
        public Fi getFi() {
            return this.fi;
        }

        @Generated
        public Fr getFr() {
            return this.fr;
        }

        @Generated
        public Gb getGb() {
            return this.gb;
        }

        @Generated
        public Ge getGe() {
            return this.ge;
        }

        @Generated
        public Gr getGr() {
            return this.gr;
        }

        @Generated
        public Hr getHr() {
            return this.hr;
        }

        @Generated
        public Hu getHu() {
            return this.hu;
        }

        @Generated
        public Id getId() {
            return this.id;
        }

        @Generated
        public Ie getIe() {
            return this.ie;
        }

        @Generated
        public Is getIs() {
            return this.is;
        }

        @Generated
        public It getIt() {
            return this.it;
        }

        @Generated
        public Jp getJp() {
            return this.jp;
        }

        @Generated
        public Ke getKe() {
            return this.ke;
        }

        @Generated
        public Kr getKr() {
            return this.kr;
        }

        @Generated
        public Kz getKz() {
            return this.kz;
        }

        @Generated
        public Lt getLt() {
            return this.lt;
        }

        @Generated
        public Lu getLu() {
            return this.lu;
        }

        @Generated
        public Lv getLv() {
            return this.lv;
        }

        @Generated
        public Mt getMt() {
            return this.mt;
        }

        @Generated
        public Mx getMx() {
            return this.mx;
        }

        @Generated
        public My getMy() {
            return this.my;
        }

        @Generated
        public Ng getNg() {
            return this.ng;
        }

        @Generated
        public Nl getNl() {
            return this.nl;
        }

        @Generated
        public No getNo() {
            return this.no;
        }

        @Generated
        public Nz getNz() {
            return this.nz;
        }

        @Generated
        public Om getOm() {
            return this.om;
        }

        @Generated
        public Pl getPl() {
            return this.pl;
        }

        @Generated
        public Pt getPt() {
            return this.pt;
        }

        @Generated
        public Ro getRo() {
            return this.ro;
        }

        @Generated
        public Sa getSa() {
            return this.sa;
        }

        @Generated
        public Se getSe() {
            return this.se;
        }

        @Generated
        public Sg getSg() {
            return this.sg;
        }

        @Generated
        public Si getSi() {
            return this.si;
        }

        @Generated
        public Sk getSk() {
            return this.sk;
        }

        @Generated
        public Th getTh() {
            return this.th;
        }

        @Generated
        public Tr getTr() {
            return this.tr;
        }

        @Generated
        public Us getUs() {
            return this.us;
        }

        @Generated
        public Vn getVn() {
            return this.vn;
        }

        @Generated
        public Za getZa() {
            return this.za;
        }

        @Generated
        public void setAe(Ae ae) {
            this.ae = ae;
        }

        @Generated
        public void setAt(At at) {
            this.at = at;
        }

        @Generated
        public void setAu(Au au) {
            this.au = au;
        }

        @Generated
        public void setBe(Be be) {
            this.be = be;
        }

        @Generated
        public void setBg(Bg bg) {
            this.bg = bg;
        }

        @Generated
        public void setBh(Bh bh) {
            this.bh = bh;
        }

        @Generated
        public void setCa(Ca ca) {
            this.ca = ca;
        }

        @Generated
        public void setCh(Ch ch) {
            this.ch = ch;
        }

        @Generated
        public void setCl(Cl cl) {
            this.cl = cl;
        }

        @Generated
        public void setCo(Co co) {
            this.co = co;
        }

        @Generated
        public void setCy(Cy cy) {
            this.cy = cy;
        }

        @Generated
        public void setCz(Cz cz) {
            this.cz = cz;
        }

        @Generated
        public void setDe(De de) {
            this.de = de;
        }

        @Generated
        public void setDk(Dk dk) {
            this.dk = dk;
        }

        @Generated
        public void setEe(Ee ee) {
            this.ee = ee;
        }

        @Generated
        public void setEg(Eg eg) {
            this.eg = eg;
        }

        @Generated
        public void setEs(Es es) {
            this.es = es;
        }

        @Generated
        public void setFi(Fi fi) {
            this.fi = fi;
        }

        @Generated
        public void setFr(Fr fr) {
            this.fr = fr;
        }

        @Generated
        public void setGb(Gb gb) {
            this.gb = gb;
        }

        @Generated
        public void setGe(Ge ge) {
            this.ge = ge;
        }

        @Generated
        public void setGr(Gr gr) {
            this.gr = gr;
        }

        @Generated
        public void setHr(Hr hr) {
            this.hr = hr;
        }

        @Generated
        public void setHu(Hu hu) {
            this.hu = hu;
        }

        @Generated
        public void setId(Id id) {
            this.id = id;
        }

        @Generated
        public void setIe(Ie ie) {
            this.ie = ie;
        }

        @Generated
        public void setIs(Is is) {
            this.is = is;
        }

        @Generated
        public void setIt(It it) {
            this.it = it;
        }

        @Generated
        public void setJp(Jp jp) {
            this.jp = jp;
        }

        @Generated
        public void setKe(Ke ke) {
            this.ke = ke;
        }

        @Generated
        public void setKr(Kr kr) {
            this.kr = kr;
        }

        @Generated
        public void setKz(Kz kz) {
            this.kz = kz;
        }

        @Generated
        public void setLt(Lt lt) {
            this.lt = lt;
        }

        @Generated
        public void setLu(Lu lu) {
            this.lu = lu;
        }

        @Generated
        public void setLv(Lv lv) {
            this.lv = lv;
        }

        @Generated
        public void setMt(Mt mt) {
            this.mt = mt;
        }

        @Generated
        public void setMx(Mx mx) {
            this.mx = mx;
        }

        @Generated
        public void setMy(My my) {
            this.my = my;
        }

        @Generated
        public void setNg(Ng ng) {
            this.ng = ng;
        }

        @Generated
        public void setNl(Nl nl) {
            this.nl = nl;
        }

        @Generated
        public void setNo(No no) {
            this.no = no;
        }

        @Generated
        public void setNz(Nz nz) {
            this.nz = nz;
        }

        @Generated
        public void setOm(Om om) {
            this.om = om;
        }

        @Generated
        public void setPl(Pl pl) {
            this.pl = pl;
        }

        @Generated
        public void setPt(Pt pt) {
            this.pt = pt;
        }

        @Generated
        public void setRo(Ro ro) {
            this.ro = ro;
        }

        @Generated
        public void setSa(Sa sa) {
            this.sa = sa;
        }

        @Generated
        public void setSe(Se se) {
            this.se = se;
        }

        @Generated
        public void setSg(Sg sg) {
            this.sg = sg;
        }

        @Generated
        public void setSi(Si si) {
            this.si = si;
        }

        @Generated
        public void setSk(Sk sk) {
            this.sk = sk;
        }

        @Generated
        public void setTh(Th th) {
            this.th = th;
        }

        @Generated
        public void setTr(Tr tr) {
            this.tr = tr;
        }

        @Generated
        public void setUs(Us us) {
            this.us = us;
        }

        @Generated
        public void setVn(Vn vn) {
            this.vn = vn;
        }

        @Generated
        public void setZa(Za za) {
            this.za = za;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CountryOptions)) {
                return false;
            }
            CountryOptions other = (CountryOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Ae this$ae = this.getAe();
            Ae other$ae = other.getAe();
            if (this$ae == null ? other$ae != null : !((Object)this$ae).equals(other$ae)) {
                return false;
            }
            At this$at = this.getAt();
            At other$at = other.getAt();
            if (this$at == null ? other$at != null : !((Object)this$at).equals(other$at)) {
                return false;
            }
            Au this$au = this.getAu();
            Au other$au = other.getAu();
            if (this$au == null ? other$au != null : !((Object)this$au).equals(other$au)) {
                return false;
            }
            Be this$be = this.getBe();
            Be other$be = other.getBe();
            if (this$be == null ? other$be != null : !((Object)this$be).equals(other$be)) {
                return false;
            }
            Bg this$bg = this.getBg();
            Bg other$bg = other.getBg();
            if (this$bg == null ? other$bg != null : !((Object)this$bg).equals(other$bg)) {
                return false;
            }
            Bh this$bh = this.getBh();
            Bh other$bh = other.getBh();
            if (this$bh == null ? other$bh != null : !((Object)this$bh).equals(other$bh)) {
                return false;
            }
            Ca this$ca = this.getCa();
            Ca other$ca = other.getCa();
            if (this$ca == null ? other$ca != null : !((Object)this$ca).equals(other$ca)) {
                return false;
            }
            Ch this$ch = this.getCh();
            Ch other$ch = other.getCh();
            if (this$ch == null ? other$ch != null : !((Object)this$ch).equals(other$ch)) {
                return false;
            }
            Cl this$cl = this.getCl();
            Cl other$cl = other.getCl();
            if (this$cl == null ? other$cl != null : !((Object)this$cl).equals(other$cl)) {
                return false;
            }
            Co this$co = this.getCo();
            Co other$co = other.getCo();
            if (this$co == null ? other$co != null : !((Object)this$co).equals(other$co)) {
                return false;
            }
            Cy this$cy = this.getCy();
            Cy other$cy = other.getCy();
            if (this$cy == null ? other$cy != null : !((Object)this$cy).equals(other$cy)) {
                return false;
            }
            Cz this$cz = this.getCz();
            Cz other$cz = other.getCz();
            if (this$cz == null ? other$cz != null : !((Object)this$cz).equals(other$cz)) {
                return false;
            }
            De this$de = this.getDe();
            De other$de = other.getDe();
            if (this$de == null ? other$de != null : !((Object)this$de).equals(other$de)) {
                return false;
            }
            Dk this$dk = this.getDk();
            Dk other$dk = other.getDk();
            if (this$dk == null ? other$dk != null : !((Object)this$dk).equals(other$dk)) {
                return false;
            }
            Ee this$ee = this.getEe();
            Ee other$ee = other.getEe();
            if (this$ee == null ? other$ee != null : !((Object)this$ee).equals(other$ee)) {
                return false;
            }
            Eg this$eg = this.getEg();
            Eg other$eg = other.getEg();
            if (this$eg == null ? other$eg != null : !((Object)this$eg).equals(other$eg)) {
                return false;
            }
            Es this$es = this.getEs();
            Es other$es = other.getEs();
            if (this$es == null ? other$es != null : !((Object)this$es).equals(other$es)) {
                return false;
            }
            Fi this$fi = this.getFi();
            Fi other$fi = other.getFi();
            if (this$fi == null ? other$fi != null : !((Object)this$fi).equals(other$fi)) {
                return false;
            }
            Fr this$fr = this.getFr();
            Fr other$fr = other.getFr();
            if (this$fr == null ? other$fr != null : !((Object)this$fr).equals(other$fr)) {
                return false;
            }
            Gb this$gb = this.getGb();
            Gb other$gb = other.getGb();
            if (this$gb == null ? other$gb != null : !((Object)this$gb).equals(other$gb)) {
                return false;
            }
            Ge this$ge = this.getGe();
            Ge other$ge = other.getGe();
            if (this$ge == null ? other$ge != null : !((Object)this$ge).equals(other$ge)) {
                return false;
            }
            Gr this$gr = this.getGr();
            Gr other$gr = other.getGr();
            if (this$gr == null ? other$gr != null : !((Object)this$gr).equals(other$gr)) {
                return false;
            }
            Hr this$hr = this.getHr();
            Hr other$hr = other.getHr();
            if (this$hr == null ? other$hr != null : !((Object)this$hr).equals(other$hr)) {
                return false;
            }
            Hu this$hu = this.getHu();
            Hu other$hu = other.getHu();
            if (this$hu == null ? other$hu != null : !((Object)this$hu).equals(other$hu)) {
                return false;
            }
            Id this$id = this.getId();
            Id other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Ie this$ie = this.getIe();
            Ie other$ie = other.getIe();
            if (this$ie == null ? other$ie != null : !((Object)this$ie).equals(other$ie)) {
                return false;
            }
            Is this$is = this.getIs();
            Is other$is = other.getIs();
            if (this$is == null ? other$is != null : !((Object)this$is).equals(other$is)) {
                return false;
            }
            It this$it = this.getIt();
            It other$it = other.getIt();
            if (this$it == null ? other$it != null : !((Object)this$it).equals(other$it)) {
                return false;
            }
            Jp this$jp = this.getJp();
            Jp other$jp = other.getJp();
            if (this$jp == null ? other$jp != null : !((Object)this$jp).equals(other$jp)) {
                return false;
            }
            Ke this$ke = this.getKe();
            Ke other$ke = other.getKe();
            if (this$ke == null ? other$ke != null : !((Object)this$ke).equals(other$ke)) {
                return false;
            }
            Kr this$kr = this.getKr();
            Kr other$kr = other.getKr();
            if (this$kr == null ? other$kr != null : !((Object)this$kr).equals(other$kr)) {
                return false;
            }
            Kz this$kz = this.getKz();
            Kz other$kz = other.getKz();
            if (this$kz == null ? other$kz != null : !((Object)this$kz).equals(other$kz)) {
                return false;
            }
            Lt this$lt = this.getLt();
            Lt other$lt = other.getLt();
            if (this$lt == null ? other$lt != null : !((Object)this$lt).equals(other$lt)) {
                return false;
            }
            Lu this$lu = this.getLu();
            Lu other$lu = other.getLu();
            if (this$lu == null ? other$lu != null : !((Object)this$lu).equals(other$lu)) {
                return false;
            }
            Lv this$lv = this.getLv();
            Lv other$lv = other.getLv();
            if (this$lv == null ? other$lv != null : !((Object)this$lv).equals(other$lv)) {
                return false;
            }
            Mt this$mt = this.getMt();
            Mt other$mt = other.getMt();
            if (this$mt == null ? other$mt != null : !((Object)this$mt).equals(other$mt)) {
                return false;
            }
            Mx this$mx = this.getMx();
            Mx other$mx = other.getMx();
            if (this$mx == null ? other$mx != null : !((Object)this$mx).equals(other$mx)) {
                return false;
            }
            My this$my = this.getMy();
            My other$my = other.getMy();
            if (this$my == null ? other$my != null : !((Object)this$my).equals(other$my)) {
                return false;
            }
            Ng this$ng = this.getNg();
            Ng other$ng = other.getNg();
            if (this$ng == null ? other$ng != null : !((Object)this$ng).equals(other$ng)) {
                return false;
            }
            Nl this$nl = this.getNl();
            Nl other$nl = other.getNl();
            if (this$nl == null ? other$nl != null : !((Object)this$nl).equals(other$nl)) {
                return false;
            }
            No this$no = this.getNo();
            No other$no = other.getNo();
            if (this$no == null ? other$no != null : !((Object)this$no).equals(other$no)) {
                return false;
            }
            Nz this$nz = this.getNz();
            Nz other$nz = other.getNz();
            if (this$nz == null ? other$nz != null : !((Object)this$nz).equals(other$nz)) {
                return false;
            }
            Om this$om = this.getOm();
            Om other$om = other.getOm();
            if (this$om == null ? other$om != null : !((Object)this$om).equals(other$om)) {
                return false;
            }
            Pl this$pl = this.getPl();
            Pl other$pl = other.getPl();
            if (this$pl == null ? other$pl != null : !((Object)this$pl).equals(other$pl)) {
                return false;
            }
            Pt this$pt = this.getPt();
            Pt other$pt = other.getPt();
            if (this$pt == null ? other$pt != null : !((Object)this$pt).equals(other$pt)) {
                return false;
            }
            Ro this$ro = this.getRo();
            Ro other$ro = other.getRo();
            if (this$ro == null ? other$ro != null : !((Object)this$ro).equals(other$ro)) {
                return false;
            }
            Sa this$sa = this.getSa();
            Sa other$sa = other.getSa();
            if (this$sa == null ? other$sa != null : !((Object)this$sa).equals(other$sa)) {
                return false;
            }
            Se this$se = this.getSe();
            Se other$se = other.getSe();
            if (this$se == null ? other$se != null : !((Object)this$se).equals(other$se)) {
                return false;
            }
            Sg this$sg = this.getSg();
            Sg other$sg = other.getSg();
            if (this$sg == null ? other$sg != null : !((Object)this$sg).equals(other$sg)) {
                return false;
            }
            Si this$si = this.getSi();
            Si other$si = other.getSi();
            if (this$si == null ? other$si != null : !((Object)this$si).equals(other$si)) {
                return false;
            }
            Sk this$sk = this.getSk();
            Sk other$sk = other.getSk();
            if (this$sk == null ? other$sk != null : !((Object)this$sk).equals(other$sk)) {
                return false;
            }
            Th this$th = this.getTh();
            Th other$th = other.getTh();
            if (this$th == null ? other$th != null : !((Object)this$th).equals(other$th)) {
                return false;
            }
            Tr this$tr = this.getTr();
            Tr other$tr = other.getTr();
            if (this$tr == null ? other$tr != null : !((Object)this$tr).equals(other$tr)) {
                return false;
            }
            Us this$us = this.getUs();
            Us other$us = other.getUs();
            if (this$us == null ? other$us != null : !((Object)this$us).equals(other$us)) {
                return false;
            }
            Vn this$vn = this.getVn();
            Vn other$vn = other.getVn();
            if (this$vn == null ? other$vn != null : !((Object)this$vn).equals(other$vn)) {
                return false;
            }
            Za this$za = this.getZa();
            Za other$za = other.getZa();
            return !(this$za == null ? other$za != null : !((Object)this$za).equals(other$za));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CountryOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Ae $ae = this.getAe();
            result = result * 59 + ($ae == null ? 43 : ((Object)$ae).hashCode());
            At $at = this.getAt();
            result = result * 59 + ($at == null ? 43 : ((Object)$at).hashCode());
            Au $au = this.getAu();
            result = result * 59 + ($au == null ? 43 : ((Object)$au).hashCode());
            Be $be = this.getBe();
            result = result * 59 + ($be == null ? 43 : ((Object)$be).hashCode());
            Bg $bg = this.getBg();
            result = result * 59 + ($bg == null ? 43 : ((Object)$bg).hashCode());
            Bh $bh = this.getBh();
            result = result * 59 + ($bh == null ? 43 : ((Object)$bh).hashCode());
            Ca $ca = this.getCa();
            result = result * 59 + ($ca == null ? 43 : ((Object)$ca).hashCode());
            Ch $ch = this.getCh();
            result = result * 59 + ($ch == null ? 43 : ((Object)$ch).hashCode());
            Cl $cl = this.getCl();
            result = result * 59 + ($cl == null ? 43 : ((Object)$cl).hashCode());
            Co $co = this.getCo();
            result = result * 59 + ($co == null ? 43 : ((Object)$co).hashCode());
            Cy $cy = this.getCy();
            result = result * 59 + ($cy == null ? 43 : ((Object)$cy).hashCode());
            Cz $cz = this.getCz();
            result = result * 59 + ($cz == null ? 43 : ((Object)$cz).hashCode());
            De $de = this.getDe();
            result = result * 59 + ($de == null ? 43 : ((Object)$de).hashCode());
            Dk $dk = this.getDk();
            result = result * 59 + ($dk == null ? 43 : ((Object)$dk).hashCode());
            Ee $ee = this.getEe();
            result = result * 59 + ($ee == null ? 43 : ((Object)$ee).hashCode());
            Eg $eg = this.getEg();
            result = result * 59 + ($eg == null ? 43 : ((Object)$eg).hashCode());
            Es $es = this.getEs();
            result = result * 59 + ($es == null ? 43 : ((Object)$es).hashCode());
            Fi $fi = this.getFi();
            result = result * 59 + ($fi == null ? 43 : ((Object)$fi).hashCode());
            Fr $fr = this.getFr();
            result = result * 59 + ($fr == null ? 43 : ((Object)$fr).hashCode());
            Gb $gb = this.getGb();
            result = result * 59 + ($gb == null ? 43 : ((Object)$gb).hashCode());
            Ge $ge = this.getGe();
            result = result * 59 + ($ge == null ? 43 : ((Object)$ge).hashCode());
            Gr $gr = this.getGr();
            result = result * 59 + ($gr == null ? 43 : ((Object)$gr).hashCode());
            Hr $hr = this.getHr();
            result = result * 59 + ($hr == null ? 43 : ((Object)$hr).hashCode());
            Hu $hu = this.getHu();
            result = result * 59 + ($hu == null ? 43 : ((Object)$hu).hashCode());
            Id $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Ie $ie = this.getIe();
            result = result * 59 + ($ie == null ? 43 : ((Object)$ie).hashCode());
            Is $is = this.getIs();
            result = result * 59 + ($is == null ? 43 : ((Object)$is).hashCode());
            It $it = this.getIt();
            result = result * 59 + ($it == null ? 43 : ((Object)$it).hashCode());
            Jp $jp = this.getJp();
            result = result * 59 + ($jp == null ? 43 : ((Object)$jp).hashCode());
            Ke $ke = this.getKe();
            result = result * 59 + ($ke == null ? 43 : ((Object)$ke).hashCode());
            Kr $kr = this.getKr();
            result = result * 59 + ($kr == null ? 43 : ((Object)$kr).hashCode());
            Kz $kz = this.getKz();
            result = result * 59 + ($kz == null ? 43 : ((Object)$kz).hashCode());
            Lt $lt = this.getLt();
            result = result * 59 + ($lt == null ? 43 : ((Object)$lt).hashCode());
            Lu $lu = this.getLu();
            result = result * 59 + ($lu == null ? 43 : ((Object)$lu).hashCode());
            Lv $lv = this.getLv();
            result = result * 59 + ($lv == null ? 43 : ((Object)$lv).hashCode());
            Mt $mt = this.getMt();
            result = result * 59 + ($mt == null ? 43 : ((Object)$mt).hashCode());
            Mx $mx = this.getMx();
            result = result * 59 + ($mx == null ? 43 : ((Object)$mx).hashCode());
            My $my = this.getMy();
            result = result * 59 + ($my == null ? 43 : ((Object)$my).hashCode());
            Ng $ng = this.getNg();
            result = result * 59 + ($ng == null ? 43 : ((Object)$ng).hashCode());
            Nl $nl = this.getNl();
            result = result * 59 + ($nl == null ? 43 : ((Object)$nl).hashCode());
            No $no = this.getNo();
            result = result * 59 + ($no == null ? 43 : ((Object)$no).hashCode());
            Nz $nz = this.getNz();
            result = result * 59 + ($nz == null ? 43 : ((Object)$nz).hashCode());
            Om $om = this.getOm();
            result = result * 59 + ($om == null ? 43 : ((Object)$om).hashCode());
            Pl $pl = this.getPl();
            result = result * 59 + ($pl == null ? 43 : ((Object)$pl).hashCode());
            Pt $pt = this.getPt();
            result = result * 59 + ($pt == null ? 43 : ((Object)$pt).hashCode());
            Ro $ro = this.getRo();
            result = result * 59 + ($ro == null ? 43 : ((Object)$ro).hashCode());
            Sa $sa = this.getSa();
            result = result * 59 + ($sa == null ? 43 : ((Object)$sa).hashCode());
            Se $se = this.getSe();
            result = result * 59 + ($se == null ? 43 : ((Object)$se).hashCode());
            Sg $sg = this.getSg();
            result = result * 59 + ($sg == null ? 43 : ((Object)$sg).hashCode());
            Si $si = this.getSi();
            result = result * 59 + ($si == null ? 43 : ((Object)$si).hashCode());
            Sk $sk = this.getSk();
            result = result * 59 + ($sk == null ? 43 : ((Object)$sk).hashCode());
            Th $th = this.getTh();
            result = result * 59 + ($th == null ? 43 : ((Object)$th).hashCode());
            Tr $tr = this.getTr();
            result = result * 59 + ($tr == null ? 43 : ((Object)$tr).hashCode());
            Us $us = this.getUs();
            result = result * 59 + ($us == null ? 43 : ((Object)$us).hashCode());
            Vn $vn = this.getVn();
            result = result * 59 + ($vn == null ? 43 : ((Object)$vn).hashCode());
            Za $za = this.getZa();
            result = result * 59 + ($za == null ? 43 : ((Object)$za).hashCode());
            return result;
        }

        public static class Ae
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ae)) {
                    return false;
                }
                Ae other = (Ae)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ae;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class At
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof At)) {
                    return false;
                }
                At other = (At)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof At;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Au
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Au)) {
                    return false;
                }
                Au other = (Au)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Au;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Be
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Be)) {
                    return false;
                }
                Be other = (Be)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Be;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Bg
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bg)) {
                    return false;
                }
                Bg other = (Bg)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bg;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Bh
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bh)) {
                    return false;
                }
                Bh other = (Bh)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bh;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ca
        extends StripeObject {
            @SerializedName(value="province_standard")
            ProvinceStandard provinceStandard;
            @SerializedName(value="type")
            String type;

            @Generated
            public ProvinceStandard getProvinceStandard() {
                return this.provinceStandard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setProvinceStandard(ProvinceStandard provinceStandard) {
                this.provinceStandard = provinceStandard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ca)) {
                    return false;
                }
                Ca other = (Ca)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ProvinceStandard this$provinceStandard = this.getProvinceStandard();
                ProvinceStandard other$provinceStandard = other.getProvinceStandard();
                if (this$provinceStandard == null ? other$provinceStandard != null : !((Object)this$provinceStandard).equals(other$provinceStandard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ca;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ProvinceStandard $provinceStandard = this.getProvinceStandard();
                result = result * 59 + ($provinceStandard == null ? 43 : ((Object)$provinceStandard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class ProvinceStandard
            extends StripeObject {
                @SerializedName(value="province")
                String province;

                @Generated
                public String getProvince() {
                    return this.province;
                }

                @Generated
                public void setProvince(String province) {
                    this.province = province;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ProvinceStandard)) {
                        return false;
                    }
                    ProvinceStandard other = (ProvinceStandard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$province = this.getProvince();
                    String other$province = other.getProvince();
                    return !(this$province == null ? other$province != null : !this$province.equals(other$province));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ProvinceStandard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $province = this.getProvince();
                    result = result * 59 + ($province == null ? 43 : $province.hashCode());
                    return result;
                }
            }
        }

        public static class Ch
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ch)) {
                    return false;
                }
                Ch other = (Ch)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ch;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Cl
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cl)) {
                    return false;
                }
                Cl other = (Cl)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cl;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Co
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Co)) {
                    return false;
                }
                Co other = (Co)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Co;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Cy
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cy)) {
                    return false;
                }
                Cy other = (Cy)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cy;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Cz
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cz)) {
                    return false;
                }
                Cz other = (Cz)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cz;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class De
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof De)) {
                    return false;
                }
                De other = (De)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof De;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Dk
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dk)) {
                    return false;
                }
                Dk other = (Dk)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Dk;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Ee
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ee)) {
                    return false;
                }
                Ee other = (Ee)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ee;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Eg
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Eg)) {
                    return false;
                }
                Eg other = (Eg)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Eg;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Es
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Es)) {
                    return false;
                }
                Es other = (Es)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Es;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Fi
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fi)) {
                    return false;
                }
                Fi other = (Fi)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fi;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Fr
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fr)) {
                    return false;
                }
                Fr other = (Fr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Gb
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Gb)) {
                    return false;
                }
                Gb other = (Gb)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Gb;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ge
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ge)) {
                    return false;
                }
                Ge other = (Ge)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ge;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Gr
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Gr)) {
                    return false;
                }
                Gr other = (Gr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Gr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Hr
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Hr)) {
                    return false;
                }
                Hr other = (Hr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Hr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Hu
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Hu)) {
                    return false;
                }
                Hu other = (Hu)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Hu;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Id
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Id)) {
                    return false;
                }
                Id other = (Id)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Id;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ie
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ie)) {
                    return false;
                }
                Ie other = (Ie)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ie;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Is
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Is)) {
                    return false;
                }
                Is other = (Is)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Is;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class It
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof It)) {
                    return false;
                }
                It other = (It)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof It;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Jp
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Jp)) {
                    return false;
                }
                Jp other = (Jp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Jp;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ke
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ke)) {
                    return false;
                }
                Ke other = (Ke)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ke;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Kr
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Kr)) {
                    return false;
                }
                Kr other = (Kr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Kr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Kz
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Kz)) {
                    return false;
                }
                Kz other = (Kz)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Kz;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Lt
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Lt)) {
                    return false;
                }
                Lt other = (Lt)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Lt;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Lu
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Lu)) {
                    return false;
                }
                Lu other = (Lu)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Lu;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Lv
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Lv)) {
                    return false;
                }
                Lv other = (Lv)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Lv;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Mt
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Mt)) {
                    return false;
                }
                Mt other = (Mt)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Mt;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Mx
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Mx)) {
                    return false;
                }
                Mx other = (Mx)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Mx;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class My
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof My)) {
                    return false;
                }
                My other = (My)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof My;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ng
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ng)) {
                    return false;
                }
                Ng other = (Ng)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ng;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Nl
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Nl)) {
                    return false;
                }
                Nl other = (Nl)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Nl;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class No
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof No)) {
                    return false;
                }
                No other = (No)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof No;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Nz
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Nz)) {
                    return false;
                }
                Nz other = (Nz)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Nz;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Om
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Om)) {
                    return false;
                }
                Om other = (Om)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Om;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Pl
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pl)) {
                    return false;
                }
                Pl other = (Pl)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pl;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Pt
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pt)) {
                    return false;
                }
                Pt other = (Pt)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pt;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Ro
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ro)) {
                    return false;
                }
                Ro other = (Ro)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ro;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Sa
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sa)) {
                    return false;
                }
                Sa other = (Sa)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sa;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Se
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Se)) {
                    return false;
                }
                Se other = (Se)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Se;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Sg
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sg)) {
                    return false;
                }
                Sg other = (Sg)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sg;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Si
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Si)) {
                    return false;
                }
                Si other = (Si)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Si;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Sk
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sk)) {
                    return false;
                }
                Sk other = (Sk)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sk;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Th
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Th)) {
                    return false;
                }
                Th other = (Th)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Th;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Tr
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Tr)) {
                    return false;
                }
                Tr other = (Tr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Tr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Us
        extends StripeObject {
            @SerializedName(value="local_amusement_tax")
            LocalAmusementTax localAmusementTax;
            @SerializedName(value="local_lease_tax")
            LocalLeaseTax localLeaseTax;
            @SerializedName(value="state")
            String state;
            @SerializedName(value="type")
            String type;

            @Generated
            public LocalAmusementTax getLocalAmusementTax() {
                return this.localAmusementTax;
            }

            @Generated
            public LocalLeaseTax getLocalLeaseTax() {
                return this.localLeaseTax;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setLocalAmusementTax(LocalAmusementTax localAmusementTax) {
                this.localAmusementTax = localAmusementTax;
            }

            @Generated
            public void setLocalLeaseTax(LocalLeaseTax localLeaseTax) {
                this.localLeaseTax = localLeaseTax;
            }

            @Generated
            public void setState(String state) {
                this.state = state;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Us)) {
                    return false;
                }
                Us other = (Us)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                LocalAmusementTax this$localAmusementTax = this.getLocalAmusementTax();
                LocalAmusementTax other$localAmusementTax = other.getLocalAmusementTax();
                if (this$localAmusementTax == null ? other$localAmusementTax != null : !((Object)this$localAmusementTax).equals(other$localAmusementTax)) {
                    return false;
                }
                LocalLeaseTax this$localLeaseTax = this.getLocalLeaseTax();
                LocalLeaseTax other$localLeaseTax = other.getLocalLeaseTax();
                if (this$localLeaseTax == null ? other$localLeaseTax != null : !((Object)this$localLeaseTax).equals(other$localLeaseTax)) {
                    return false;
                }
                String this$state = this.getState();
                String other$state = other.getState();
                if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Us;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                LocalAmusementTax $localAmusementTax = this.getLocalAmusementTax();
                result = result * 59 + ($localAmusementTax == null ? 43 : ((Object)$localAmusementTax).hashCode());
                LocalLeaseTax $localLeaseTax = this.getLocalLeaseTax();
                result = result * 59 + ($localLeaseTax == null ? 43 : ((Object)$localLeaseTax).hashCode());
                String $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class LocalAmusementTax
            extends StripeObject {
                @SerializedName(value="jurisdiction")
                String jurisdiction;

                @Generated
                public String getJurisdiction() {
                    return this.jurisdiction;
                }

                @Generated
                public void setJurisdiction(String jurisdiction) {
                    this.jurisdiction = jurisdiction;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LocalAmusementTax)) {
                        return false;
                    }
                    LocalAmusementTax other = (LocalAmusementTax)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$jurisdiction = this.getJurisdiction();
                    String other$jurisdiction = other.getJurisdiction();
                    return !(this$jurisdiction == null ? other$jurisdiction != null : !this$jurisdiction.equals(other$jurisdiction));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof LocalAmusementTax;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $jurisdiction = this.getJurisdiction();
                    result = result * 59 + ($jurisdiction == null ? 43 : $jurisdiction.hashCode());
                    return result;
                }
            }

            public static class LocalLeaseTax
            extends StripeObject {
                @SerializedName(value="jurisdiction")
                String jurisdiction;

                @Generated
                public String getJurisdiction() {
                    return this.jurisdiction;
                }

                @Generated
                public void setJurisdiction(String jurisdiction) {
                    this.jurisdiction = jurisdiction;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LocalLeaseTax)) {
                        return false;
                    }
                    LocalLeaseTax other = (LocalLeaseTax)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$jurisdiction = this.getJurisdiction();
                    String other$jurisdiction = other.getJurisdiction();
                    return !(this$jurisdiction == null ? other$jurisdiction != null : !this$jurisdiction.equals(other$jurisdiction));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof LocalLeaseTax;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $jurisdiction = this.getJurisdiction();
                    result = result * 59 + ($jurisdiction == null ? 43 : $jurisdiction.hashCode());
                    return result;
                }
            }
        }

        public static class Vn
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Vn)) {
                    return false;
                }
                Vn other = (Vn)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Vn;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Za
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Za)) {
                    return false;
                }
                Za other = (Za)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Za;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }
    }
}

