/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.PaymentMethod;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CustomerPaymentMethodListParams;
import com.stripe.param.CustomerPaymentMethodRetrieveParams;
import java.lang.reflect.Type;

public final class CustomerPaymentMethodService
extends ApiService {
    public CustomerPaymentMethodService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<PaymentMethod> list(String customer, CustomerPaymentMethodListParams params) throws StripeException {
        return this.list(customer, params, null);
    }

    public StripeCollection<PaymentMethod> list(String customer, RequestOptions options) throws StripeException {
        return this.list(customer, null, options);
    }

    public StripeCollection<PaymentMethod> list(String customer) throws StripeException {
        return this.list(customer, null, null);
    }

    public StripeCollection<PaymentMethod> list(String customer, CustomerPaymentMethodListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/payment_methods", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<PaymentMethod>>(){}.getType());
    }

    public PaymentMethod retrieve(String customer, String paymentMethod, CustomerPaymentMethodRetrieveParams params) throws StripeException {
        return this.retrieve(customer, paymentMethod, params, null);
    }

    public PaymentMethod retrieve(String customer, String paymentMethod, RequestOptions options) throws StripeException {
        return this.retrieve(customer, paymentMethod, null, options);
    }

    public PaymentMethod retrieve(String customer, String paymentMethod) throws StripeException {
        return this.retrieve(customer, paymentMethod, null, null);
    }

    public PaymentMethod retrieve(String customer, String paymentMethod, CustomerPaymentMethodRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/payment_methods/%s", ApiResource.urlEncodeId(customer), ApiResource.urlEncodeId(paymentMethod));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentMethod)this.request(request, (Type)((Object)PaymentMethod.class));
    }
}

