/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CustomerCreateFundingInstructionsParams
extends ApiRequestParams {
    @SerializedName(value="bank_transfer")
    BankTransfer bankTransfer;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="funding_type")
    FundingType fundingType;

    private CustomerCreateFundingInstructionsParams(BankTransfer bankTransfer, String currency, List<String> expand, Map<String, Object> extraParams, FundingType fundingType) {
        this.bankTransfer = bankTransfer;
        this.currency = currency;
        this.expand = expand;
        this.extraParams = extraParams;
        this.fundingType = fundingType;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public BankTransfer getBankTransfer() {
        return this.bankTransfer;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public FundingType getFundingType() {
        return this.fundingType;
    }

    public static class BankTransfer {
        @SerializedName(value="eu_bank_transfer")
        EuBankTransfer euBankTransfer;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="requested_address_types")
        List<RequestedAddressType> requestedAddressTypes;
        @SerializedName(value="type")
        Type type;

        private BankTransfer(EuBankTransfer euBankTransfer, Map<String, Object> extraParams, List<RequestedAddressType> requestedAddressTypes, Type type) {
            this.euBankTransfer = euBankTransfer;
            this.extraParams = extraParams;
            this.requestedAddressTypes = requestedAddressTypes;
            this.type = type;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public EuBankTransfer getEuBankTransfer() {
            return this.euBankTransfer;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public List<RequestedAddressType> getRequestedAddressTypes() {
            return this.requestedAddressTypes;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        public static class EuBankTransfer {
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private EuBankTransfer(String country, Map<String, Object> extraParams) {
                this.country = country;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private String country;
                private Map<String, Object> extraParams;

                public EuBankTransfer build() {
                    return new EuBankTransfer(this.country, this.extraParams);
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static enum Type implements ApiRequestParams.EnumParam
        {
            EU_BANK_TRANSFER("eu_bank_transfer"),
            GB_BANK_TRANSFER("gb_bank_transfer"),
            JP_BANK_TRANSFER("jp_bank_transfer"),
            MX_BANK_TRANSFER("mx_bank_transfer"),
            US_BANK_TRANSFER("us_bank_transfer");

            private final String value;

            private Type(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private EuBankTransfer euBankTransfer;
            private Map<String, Object> extraParams;
            private List<RequestedAddressType> requestedAddressTypes;
            private Type type;

            public BankTransfer build() {
                return new BankTransfer(this.euBankTransfer, this.extraParams, this.requestedAddressTypes, this.type);
            }

            public Builder setEuBankTransfer(EuBankTransfer euBankTransfer) {
                this.euBankTransfer = euBankTransfer;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder addRequestedAddressType(RequestedAddressType element) {
                if (this.requestedAddressTypes == null) {
                    this.requestedAddressTypes = new ArrayList<RequestedAddressType>();
                }
                this.requestedAddressTypes.add(element);
                return this;
            }

            public Builder addAllRequestedAddressType(List<RequestedAddressType> elements) {
                if (this.requestedAddressTypes == null) {
                    this.requestedAddressTypes = new ArrayList<RequestedAddressType>();
                }
                this.requestedAddressTypes.addAll(elements);
                return this;
            }

            public Builder setType(Type type) {
                this.type = type;
                return this;
            }
        }

        public static enum RequestedAddressType implements ApiRequestParams.EnumParam
        {
            IBAN("iban"),
            SORT_CODE("sort_code"),
            SPEI("spei"),
            ZENGIN("zengin");

            private final String value;

            private RequestedAddressType(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }
    }

    public static enum FundingType implements ApiRequestParams.EnumParam
    {
        BANK_TRANSFER("bank_transfer");

        private final String value;

        private FundingType(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private BankTransfer bankTransfer;
        private String currency;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private FundingType fundingType;

        public CustomerCreateFundingInstructionsParams build() {
            return new CustomerCreateFundingInstructionsParams(this.bankTransfer, this.currency, this.expand, this.extraParams, this.fundingType);
        }

        public Builder setBankTransfer(BankTransfer bankTransfer) {
            this.bankTransfer = bankTransfer;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setFundingType(FundingType fundingType) {
            this.fundingType = fundingType;
            return this;
        }
    }
}

