/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Charge;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentIntent;
import com.stripe.model.Refund;
import com.stripe.model.SetupIntent;
import com.stripe.model.StripeObject;
import com.stripe.model.terminal.Location;
import com.stripe.model.terminal.ReaderCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.terminal.ReaderCancelActionParams;
import com.stripe.param.terminal.ReaderCreateParams;
import com.stripe.param.terminal.ReaderListParams;
import com.stripe.param.terminal.ReaderPresentPaymentMethodParams;
import com.stripe.param.terminal.ReaderProcessPaymentIntentParams;
import com.stripe.param.terminal.ReaderProcessSetupIntentParams;
import com.stripe.param.terminal.ReaderRefundPaymentParams;
import com.stripe.param.terminal.ReaderRetrieveParams;
import com.stripe.param.terminal.ReaderSetReaderDisplayParams;
import com.stripe.param.terminal.ReaderUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Reader
extends ApiResource
implements HasId,
MetadataStore<Reader> {
    @SerializedName(value="action")
    Action action;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="device_sw_version")
    String deviceSwVersion;
    @SerializedName(value="device_type")
    String deviceType;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="ip_address")
    String ipAddress;
    @SerializedName(value="label")
    String label;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="location")
    ExpandableField<Location> location;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="serial_number")
    String serialNumber;
    @SerializedName(value="status")
    String status;

    public String getLocation() {
        return this.location != null ? this.location.getId() : null;
    }

    public void setLocation(String id) {
        this.location = ApiResource.setExpandableFieldId(id, this.location);
    }

    public Location getLocationObject() {
        return this.location != null ? this.location.getExpanded() : null;
    }

    public void setLocationObject(Location expandableObject) {
        this.location = new ExpandableField<Location>(expandableObject.getId(), expandableObject);
    }

    public Reader cancelAction() throws StripeException {
        return this.cancelAction((Map<String, Object>)null, (RequestOptions)null);
    }

    public Reader cancelAction(RequestOptions options) throws StripeException {
        return this.cancelAction((Map<String, Object>)null, options);
    }

    public Reader cancelAction(Map<String, Object> params) throws StripeException {
        return this.cancelAction(params, (RequestOptions)null);
    }

    public Reader cancelAction(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/cancel_action", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader cancelAction(ReaderCancelActionParams params) throws StripeException {
        return this.cancelAction(params, (RequestOptions)null);
    }

    public Reader cancelAction(ReaderCancelActionParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/cancel_action", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public static Reader create(Map<String, Object> params) throws StripeException {
        return Reader.create(params, (RequestOptions)null);
    }

    public static Reader create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/readers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Reader)Reader.getGlobalResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public static Reader create(ReaderCreateParams params) throws StripeException {
        return Reader.create(params, (RequestOptions)null);
    }

    public static Reader create(ReaderCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/readers";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Reader)Reader.getGlobalResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader delete() throws StripeException {
        return this.delete(null, null);
    }

    public Reader delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Reader delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Reader delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, params, options, ApiMode.V1);
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public static ReaderCollection list(Map<String, Object> params) throws StripeException {
        return Reader.list(params, (RequestOptions)null);
    }

    public static ReaderCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/readers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (ReaderCollection)Reader.getGlobalResponseGetter().request(request, (Type)((Object)ReaderCollection.class));
    }

    public static ReaderCollection list(ReaderListParams params) throws StripeException {
        return Reader.list(params, (RequestOptions)null);
    }

    public static ReaderCollection list(ReaderListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/readers";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ReaderCollection)Reader.getGlobalResponseGetter().request(request, (Type)((Object)ReaderCollection.class));
    }

    public Reader processPaymentIntent(Map<String, Object> params) throws StripeException {
        return this.processPaymentIntent(params, (RequestOptions)null);
    }

    public Reader processPaymentIntent(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/process_payment_intent", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader processPaymentIntent(ReaderProcessPaymentIntentParams params) throws StripeException {
        return this.processPaymentIntent(params, (RequestOptions)null);
    }

    public Reader processPaymentIntent(ReaderProcessPaymentIntentParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/process_payment_intent", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader processSetupIntent(Map<String, Object> params) throws StripeException {
        return this.processSetupIntent(params, (RequestOptions)null);
    }

    public Reader processSetupIntent(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/process_setup_intent", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader processSetupIntent(ReaderProcessSetupIntentParams params) throws StripeException {
        return this.processSetupIntent(params, (RequestOptions)null);
    }

    public Reader processSetupIntent(ReaderProcessSetupIntentParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/process_setup_intent", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader refundPayment() throws StripeException {
        return this.refundPayment((Map<String, Object>)null, (RequestOptions)null);
    }

    public Reader refundPayment(RequestOptions options) throws StripeException {
        return this.refundPayment((Map<String, Object>)null, options);
    }

    public Reader refundPayment(Map<String, Object> params) throws StripeException {
        return this.refundPayment(params, (RequestOptions)null);
    }

    public Reader refundPayment(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/refund_payment", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader refundPayment(ReaderRefundPaymentParams params) throws StripeException {
        return this.refundPayment(params, (RequestOptions)null);
    }

    public Reader refundPayment(ReaderRefundPaymentParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/refund_payment", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public static Reader retrieve(String reader) throws StripeException {
        return Reader.retrieve(reader, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Reader retrieve(String reader, RequestOptions options) throws StripeException {
        return Reader.retrieve(reader, (Map<String, Object>)null, options);
    }

    public static Reader retrieve(String reader, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(reader));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (Reader)Reader.getGlobalResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public static Reader retrieve(String reader, ReaderRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(reader));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Reader)Reader.getGlobalResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader setReaderDisplay(Map<String, Object> params) throws StripeException {
        return this.setReaderDisplay(params, (RequestOptions)null);
    }

    public Reader setReaderDisplay(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/set_reader_display", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader setReaderDisplay(ReaderSetReaderDisplayParams params) throws StripeException {
        return this.setReaderDisplay(params, (RequestOptions)null);
    }

    public Reader setReaderDisplay(ReaderSetReaderDisplayParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/set_reader_display", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Reader update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader update(ReaderUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Reader update(ReaderUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public TestHelpers getTestHelpers() {
        return new TestHelpers(this);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.action, responseGetter);
        this.trySetResponseGetter(this.location, responseGetter);
    }

    @Generated
    public Action getAction() {
        return this.action;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDeviceSwVersion() {
        return this.deviceSwVersion;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setAction(Action action) {
        this.action = action;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDeviceSwVersion(String deviceSwVersion) {
        this.deviceSwVersion = deviceSwVersion;
    }

    @Generated
    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reader)) {
            return false;
        }
        Reader other = (Reader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)this$action).equals(other$action)) {
            return false;
        }
        String this$deviceSwVersion = this.getDeviceSwVersion();
        String other$deviceSwVersion = other.getDeviceSwVersion();
        if (this$deviceSwVersion == null ? other$deviceSwVersion != null : !this$deviceSwVersion.equals(other$deviceSwVersion)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$serialNumber = this.getSerialNumber();
        String other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Reader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
        String $deviceSwVersion = this.getDeviceSwVersion();
        result = result * 59 + ($deviceSwVersion == null ? 43 : $deviceSwVersion.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TestHelpers {
        private final Reader resource;

        private TestHelpers(Reader resource) {
            this.resource = resource;
        }

        public Reader presentPaymentMethod() throws StripeException {
            return this.presentPaymentMethod((Map<String, Object>)null, (RequestOptions)null);
        }

        public Reader presentPaymentMethod(RequestOptions options) throws StripeException {
            return this.presentPaymentMethod((Map<String, Object>)null, options);
        }

        public Reader presentPaymentMethod(Map<String, Object> params) throws StripeException {
            return this.presentPaymentMethod(params, (RequestOptions)null);
        }

        public Reader presentPaymentMethod(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/terminal/readers/%s/present_payment_method", ApiResource.urlEncodeId(this.resource.getId()));
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
            return (Reader)this.resource.getResponseGetter().request(request, (Type)((Object)Reader.class));
        }

        public Reader presentPaymentMethod(ReaderPresentPaymentMethodParams params) throws StripeException {
            return this.presentPaymentMethod(params, (RequestOptions)null);
        }

        public Reader presentPaymentMethod(ReaderPresentPaymentMethodParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/terminal/readers/%s/present_payment_method", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
            return (Reader)this.resource.getResponseGetter().request(request, (Type)((Object)Reader.class));
        }
    }

    public static class Action
    extends StripeObject {
        @SerializedName(value="failure_code")
        String failureCode;
        @SerializedName(value="failure_message")
        String failureMessage;
        @SerializedName(value="process_payment_intent")
        ProcessPaymentIntent processPaymentIntent;
        @SerializedName(value="process_setup_intent")
        ProcessSetupIntent processSetupIntent;
        @SerializedName(value="refund_payment")
        RefundPayment refundPayment;
        @SerializedName(value="set_reader_display")
        SetReaderDisplay setReaderDisplay;
        @SerializedName(value="status")
        String status;
        @SerializedName(value="type")
        String type;

        @Generated
        public String getFailureCode() {
            return this.failureCode;
        }

        @Generated
        public String getFailureMessage() {
            return this.failureMessage;
        }

        @Generated
        public ProcessPaymentIntent getProcessPaymentIntent() {
            return this.processPaymentIntent;
        }

        @Generated
        public ProcessSetupIntent getProcessSetupIntent() {
            return this.processSetupIntent;
        }

        @Generated
        public RefundPayment getRefundPayment() {
            return this.refundPayment;
        }

        @Generated
        public SetReaderDisplay getSetReaderDisplay() {
            return this.setReaderDisplay;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Generated
        public void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Generated
        public void setProcessPaymentIntent(ProcessPaymentIntent processPaymentIntent) {
            this.processPaymentIntent = processPaymentIntent;
        }

        @Generated
        public void setProcessSetupIntent(ProcessSetupIntent processSetupIntent) {
            this.processSetupIntent = processSetupIntent;
        }

        @Generated
        public void setRefundPayment(RefundPayment refundPayment) {
            this.refundPayment = refundPayment;
        }

        @Generated
        public void setSetReaderDisplay(SetReaderDisplay setReaderDisplay) {
            this.setReaderDisplay = setReaderDisplay;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Action)) {
                return false;
            }
            Action other = (Action)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$failureCode = this.getFailureCode();
            String other$failureCode = other.getFailureCode();
            if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) {
                return false;
            }
            String this$failureMessage = this.getFailureMessage();
            String other$failureMessage = other.getFailureMessage();
            if (this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage)) {
                return false;
            }
            ProcessPaymentIntent this$processPaymentIntent = this.getProcessPaymentIntent();
            ProcessPaymentIntent other$processPaymentIntent = other.getProcessPaymentIntent();
            if (this$processPaymentIntent == null ? other$processPaymentIntent != null : !((Object)this$processPaymentIntent).equals(other$processPaymentIntent)) {
                return false;
            }
            ProcessSetupIntent this$processSetupIntent = this.getProcessSetupIntent();
            ProcessSetupIntent other$processSetupIntent = other.getProcessSetupIntent();
            if (this$processSetupIntent == null ? other$processSetupIntent != null : !((Object)this$processSetupIntent).equals(other$processSetupIntent)) {
                return false;
            }
            RefundPayment this$refundPayment = this.getRefundPayment();
            RefundPayment other$refundPayment = other.getRefundPayment();
            if (this$refundPayment == null ? other$refundPayment != null : !((Object)this$refundPayment).equals(other$refundPayment)) {
                return false;
            }
            SetReaderDisplay this$setReaderDisplay = this.getSetReaderDisplay();
            SetReaderDisplay other$setReaderDisplay = other.getSetReaderDisplay();
            if (this$setReaderDisplay == null ? other$setReaderDisplay != null : !((Object)this$setReaderDisplay).equals(other$setReaderDisplay)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Action;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $failureCode = this.getFailureCode();
            result = result * 59 + ($failureCode == null ? 43 : $failureCode.hashCode());
            String $failureMessage = this.getFailureMessage();
            result = result * 59 + ($failureMessage == null ? 43 : $failureMessage.hashCode());
            ProcessPaymentIntent $processPaymentIntent = this.getProcessPaymentIntent();
            result = result * 59 + ($processPaymentIntent == null ? 43 : ((Object)$processPaymentIntent).hashCode());
            ProcessSetupIntent $processSetupIntent = this.getProcessSetupIntent();
            result = result * 59 + ($processSetupIntent == null ? 43 : ((Object)$processSetupIntent).hashCode());
            RefundPayment $refundPayment = this.getRefundPayment();
            result = result * 59 + ($refundPayment == null ? 43 : ((Object)$refundPayment).hashCode());
            SetReaderDisplay $setReaderDisplay = this.getSetReaderDisplay();
            result = result * 59 + ($setReaderDisplay == null ? 43 : ((Object)$setReaderDisplay).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class ProcessPaymentIntent
        extends StripeObject {
            @SerializedName(value="payment_intent")
            ExpandableField<PaymentIntent> paymentIntent;
            @SerializedName(value="process_config")
            ProcessConfig processConfig;

            public String getPaymentIntent() {
                return this.paymentIntent != null ? this.paymentIntent.getId() : null;
            }

            public void setPaymentIntent(String id) {
                this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
            }

            public PaymentIntent getPaymentIntentObject() {
                return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
            }

            public void setPaymentIntentObject(PaymentIntent expandableObject) {
                this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public ProcessConfig getProcessConfig() {
                return this.processConfig;
            }

            @Generated
            public void setProcessConfig(ProcessConfig processConfig) {
                this.processConfig = processConfig;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ProcessPaymentIntent)) {
                    return false;
                }
                ProcessPaymentIntent other = (ProcessPaymentIntent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$paymentIntent = this.getPaymentIntent();
                String other$paymentIntent = other.getPaymentIntent();
                if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
                    return false;
                }
                ProcessConfig this$processConfig = this.getProcessConfig();
                ProcessConfig other$processConfig = other.getProcessConfig();
                return !(this$processConfig == null ? other$processConfig != null : !((Object)this$processConfig).equals(other$processConfig));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ProcessPaymentIntent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $paymentIntent = this.getPaymentIntent();
                result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
                ProcessConfig $processConfig = this.getProcessConfig();
                result = result * 59 + ($processConfig == null ? 43 : ((Object)$processConfig).hashCode());
                return result;
            }

            public static class ProcessConfig
            extends StripeObject {
                @SerializedName(value="enable_customer_cancellation")
                Boolean enableCustomerCancellation;
                @SerializedName(value="skip_tipping")
                Boolean skipTipping;
                @SerializedName(value="tipping")
                Tipping tipping;

                @Generated
                public Boolean getEnableCustomerCancellation() {
                    return this.enableCustomerCancellation;
                }

                @Generated
                public Boolean getSkipTipping() {
                    return this.skipTipping;
                }

                @Generated
                public Tipping getTipping() {
                    return this.tipping;
                }

                @Generated
                public void setEnableCustomerCancellation(Boolean enableCustomerCancellation) {
                    this.enableCustomerCancellation = enableCustomerCancellation;
                }

                @Generated
                public void setSkipTipping(Boolean skipTipping) {
                    this.skipTipping = skipTipping;
                }

                @Generated
                public void setTipping(Tipping tipping) {
                    this.tipping = tipping;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ProcessConfig)) {
                        return false;
                    }
                    ProcessConfig other = (ProcessConfig)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$enableCustomerCancellation = this.getEnableCustomerCancellation();
                    Boolean other$enableCustomerCancellation = other.getEnableCustomerCancellation();
                    if (this$enableCustomerCancellation == null ? other$enableCustomerCancellation != null : !((Object)this$enableCustomerCancellation).equals(other$enableCustomerCancellation)) {
                        return false;
                    }
                    Boolean this$skipTipping = this.getSkipTipping();
                    Boolean other$skipTipping = other.getSkipTipping();
                    if (this$skipTipping == null ? other$skipTipping != null : !((Object)this$skipTipping).equals(other$skipTipping)) {
                        return false;
                    }
                    Tipping this$tipping = this.getTipping();
                    Tipping other$tipping = other.getTipping();
                    return !(this$tipping == null ? other$tipping != null : !((Object)this$tipping).equals(other$tipping));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ProcessConfig;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $enableCustomerCancellation = this.getEnableCustomerCancellation();
                    result = result * 59 + ($enableCustomerCancellation == null ? 43 : ((Object)$enableCustomerCancellation).hashCode());
                    Boolean $skipTipping = this.getSkipTipping();
                    result = result * 59 + ($skipTipping == null ? 43 : ((Object)$skipTipping).hashCode());
                    Tipping $tipping = this.getTipping();
                    result = result * 59 + ($tipping == null ? 43 : ((Object)$tipping).hashCode());
                    return result;
                }

                public static class Tipping
                extends StripeObject {
                    @SerializedName(value="amount_eligible")
                    Long amountEligible;

                    @Generated
                    public Long getAmountEligible() {
                        return this.amountEligible;
                    }

                    @Generated
                    public void setAmountEligible(Long amountEligible) {
                        this.amountEligible = amountEligible;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Tipping)) {
                            return false;
                        }
                        Tipping other = (Tipping)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$amountEligible = this.getAmountEligible();
                        Long other$amountEligible = other.getAmountEligible();
                        return !(this$amountEligible == null ? other$amountEligible != null : !((Object)this$amountEligible).equals(other$amountEligible));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Tipping;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $amountEligible = this.getAmountEligible();
                        result = result * 59 + ($amountEligible == null ? 43 : ((Object)$amountEligible).hashCode());
                        return result;
                    }
                }
            }
        }

        public static class ProcessSetupIntent
        extends StripeObject {
            @SerializedName(value="generated_card")
            String generatedCard;
            @SerializedName(value="process_config")
            ProcessConfig processConfig;
            @SerializedName(value="setup_intent")
            ExpandableField<SetupIntent> setupIntent;

            public String getSetupIntent() {
                return this.setupIntent != null ? this.setupIntent.getId() : null;
            }

            public void setSetupIntent(String id) {
                this.setupIntent = ApiResource.setExpandableFieldId(id, this.setupIntent);
            }

            public SetupIntent getSetupIntentObject() {
                return this.setupIntent != null ? this.setupIntent.getExpanded() : null;
            }

            public void setSetupIntentObject(SetupIntent expandableObject) {
                this.setupIntent = new ExpandableField<SetupIntent>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getGeneratedCard() {
                return this.generatedCard;
            }

            @Generated
            public ProcessConfig getProcessConfig() {
                return this.processConfig;
            }

            @Generated
            public void setGeneratedCard(String generatedCard) {
                this.generatedCard = generatedCard;
            }

            @Generated
            public void setProcessConfig(ProcessConfig processConfig) {
                this.processConfig = processConfig;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ProcessSetupIntent)) {
                    return false;
                }
                ProcessSetupIntent other = (ProcessSetupIntent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$generatedCard = this.getGeneratedCard();
                String other$generatedCard = other.getGeneratedCard();
                if (this$generatedCard == null ? other$generatedCard != null : !this$generatedCard.equals(other$generatedCard)) {
                    return false;
                }
                ProcessConfig this$processConfig = this.getProcessConfig();
                ProcessConfig other$processConfig = other.getProcessConfig();
                if (this$processConfig == null ? other$processConfig != null : !((Object)this$processConfig).equals(other$processConfig)) {
                    return false;
                }
                String this$setupIntent = this.getSetupIntent();
                String other$setupIntent = other.getSetupIntent();
                return !(this$setupIntent == null ? other$setupIntent != null : !this$setupIntent.equals(other$setupIntent));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ProcessSetupIntent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $generatedCard = this.getGeneratedCard();
                result = result * 59 + ($generatedCard == null ? 43 : $generatedCard.hashCode());
                ProcessConfig $processConfig = this.getProcessConfig();
                result = result * 59 + ($processConfig == null ? 43 : ((Object)$processConfig).hashCode());
                String $setupIntent = this.getSetupIntent();
                result = result * 59 + ($setupIntent == null ? 43 : $setupIntent.hashCode());
                return result;
            }

            public static class ProcessConfig
            extends StripeObject {
                @SerializedName(value="enable_customer_cancellation")
                Boolean enableCustomerCancellation;

                @Generated
                public Boolean getEnableCustomerCancellation() {
                    return this.enableCustomerCancellation;
                }

                @Generated
                public void setEnableCustomerCancellation(Boolean enableCustomerCancellation) {
                    this.enableCustomerCancellation = enableCustomerCancellation;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ProcessConfig)) {
                        return false;
                    }
                    ProcessConfig other = (ProcessConfig)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$enableCustomerCancellation = this.getEnableCustomerCancellation();
                    Boolean other$enableCustomerCancellation = other.getEnableCustomerCancellation();
                    return !(this$enableCustomerCancellation == null ? other$enableCustomerCancellation != null : !((Object)this$enableCustomerCancellation).equals(other$enableCustomerCancellation));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ProcessConfig;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $enableCustomerCancellation = this.getEnableCustomerCancellation();
                    result = result * 59 + ($enableCustomerCancellation == null ? 43 : ((Object)$enableCustomerCancellation).hashCode());
                    return result;
                }
            }
        }

        public static class RefundPayment
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="charge")
            ExpandableField<Charge> charge;
            @SerializedName(value="metadata")
            Map<String, String> metadata;
            @SerializedName(value="payment_intent")
            ExpandableField<PaymentIntent> paymentIntent;
            @SerializedName(value="reason")
            String reason;
            @SerializedName(value="refund")
            ExpandableField<Refund> refund;
            @SerializedName(value="refund_application_fee")
            Boolean refundApplicationFee;
            @SerializedName(value="refund_payment_config")
            RefundPaymentConfig refundPaymentConfig;
            @SerializedName(value="reverse_transfer")
            Boolean reverseTransfer;

            public String getCharge() {
                return this.charge != null ? this.charge.getId() : null;
            }

            public void setCharge(String id) {
                this.charge = ApiResource.setExpandableFieldId(id, this.charge);
            }

            public Charge getChargeObject() {
                return this.charge != null ? this.charge.getExpanded() : null;
            }

            public void setChargeObject(Charge expandableObject) {
                this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
            }

            public String getPaymentIntent() {
                return this.paymentIntent != null ? this.paymentIntent.getId() : null;
            }

            public void setPaymentIntent(String id) {
                this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
            }

            public PaymentIntent getPaymentIntentObject() {
                return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
            }

            public void setPaymentIntentObject(PaymentIntent expandableObject) {
                this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
            }

            public String getRefund() {
                return this.refund != null ? this.refund.getId() : null;
            }

            public void setRefund(String id) {
                this.refund = ApiResource.setExpandableFieldId(id, this.refund);
            }

            public Refund getRefundObject() {
                return this.refund != null ? this.refund.getExpanded() : null;
            }

            public void setRefundObject(Refund expandableObject) {
                this.refund = new ExpandableField<Refund>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public Map<String, String> getMetadata() {
                return this.metadata;
            }

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public Boolean getRefundApplicationFee() {
                return this.refundApplicationFee;
            }

            @Generated
            public RefundPaymentConfig getRefundPaymentConfig() {
                return this.refundPaymentConfig;
            }

            @Generated
            public Boolean getReverseTransfer() {
                return this.reverseTransfer;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public void setRefundApplicationFee(Boolean refundApplicationFee) {
                this.refundApplicationFee = refundApplicationFee;
            }

            @Generated
            public void setRefundPaymentConfig(RefundPaymentConfig refundPaymentConfig) {
                this.refundPaymentConfig = refundPaymentConfig;
            }

            @Generated
            public void setReverseTransfer(Boolean reverseTransfer) {
                this.reverseTransfer = reverseTransfer;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RefundPayment)) {
                    return false;
                }
                RefundPayment other = (RefundPayment)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                Boolean this$refundApplicationFee = this.getRefundApplicationFee();
                Boolean other$refundApplicationFee = other.getRefundApplicationFee();
                if (this$refundApplicationFee == null ? other$refundApplicationFee != null : !((Object)this$refundApplicationFee).equals(other$refundApplicationFee)) {
                    return false;
                }
                Boolean this$reverseTransfer = this.getReverseTransfer();
                Boolean other$reverseTransfer = other.getReverseTransfer();
                if (this$reverseTransfer == null ? other$reverseTransfer != null : !((Object)this$reverseTransfer).equals(other$reverseTransfer)) {
                    return false;
                }
                String this$charge = this.getCharge();
                String other$charge = other.getCharge();
                if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
                    return false;
                }
                Map<String, String> this$metadata = this.getMetadata();
                Map<String, String> other$metadata = other.getMetadata();
                if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                    return false;
                }
                String this$paymentIntent = this.getPaymentIntent();
                String other$paymentIntent = other.getPaymentIntent();
                if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                    return false;
                }
                String this$refund = this.getRefund();
                String other$refund = other.getRefund();
                if (this$refund == null ? other$refund != null : !this$refund.equals(other$refund)) {
                    return false;
                }
                RefundPaymentConfig this$refundPaymentConfig = this.getRefundPaymentConfig();
                RefundPaymentConfig other$refundPaymentConfig = other.getRefundPaymentConfig();
                return !(this$refundPaymentConfig == null ? other$refundPaymentConfig != null : !((Object)this$refundPaymentConfig).equals(other$refundPaymentConfig));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RefundPayment;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                Boolean $refundApplicationFee = this.getRefundApplicationFee();
                result = result * 59 + ($refundApplicationFee == null ? 43 : ((Object)$refundApplicationFee).hashCode());
                Boolean $reverseTransfer = this.getReverseTransfer();
                result = result * 59 + ($reverseTransfer == null ? 43 : ((Object)$reverseTransfer).hashCode());
                String $charge = this.getCharge();
                result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
                Map<String, String> $metadata = this.getMetadata();
                result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
                String $paymentIntent = this.getPaymentIntent();
                result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                String $refund = this.getRefund();
                result = result * 59 + ($refund == null ? 43 : $refund.hashCode());
                RefundPaymentConfig $refundPaymentConfig = this.getRefundPaymentConfig();
                result = result * 59 + ($refundPaymentConfig == null ? 43 : ((Object)$refundPaymentConfig).hashCode());
                return result;
            }

            public static class RefundPaymentConfig
            extends StripeObject {
                @SerializedName(value="enable_customer_cancellation")
                Boolean enableCustomerCancellation;

                @Generated
                public Boolean getEnableCustomerCancellation() {
                    return this.enableCustomerCancellation;
                }

                @Generated
                public void setEnableCustomerCancellation(Boolean enableCustomerCancellation) {
                    this.enableCustomerCancellation = enableCustomerCancellation;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof RefundPaymentConfig)) {
                        return false;
                    }
                    RefundPaymentConfig other = (RefundPaymentConfig)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$enableCustomerCancellation = this.getEnableCustomerCancellation();
                    Boolean other$enableCustomerCancellation = other.getEnableCustomerCancellation();
                    return !(this$enableCustomerCancellation == null ? other$enableCustomerCancellation != null : !((Object)this$enableCustomerCancellation).equals(other$enableCustomerCancellation));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof RefundPaymentConfig;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $enableCustomerCancellation = this.getEnableCustomerCancellation();
                    result = result * 59 + ($enableCustomerCancellation == null ? 43 : ((Object)$enableCustomerCancellation).hashCode());
                    return result;
                }
            }
        }

        public static class SetReaderDisplay
        extends StripeObject {
            @SerializedName(value="cart")
            Cart cart;
            @SerializedName(value="type")
            String type;

            @Generated
            public Cart getCart() {
                return this.cart;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setCart(Cart cart) {
                this.cart = cart;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SetReaderDisplay)) {
                    return false;
                }
                SetReaderDisplay other = (SetReaderDisplay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Cart this$cart = this.getCart();
                Cart other$cart = other.getCart();
                if (this$cart == null ? other$cart != null : !((Object)this$cart).equals(other$cart)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SetReaderDisplay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Cart $cart = this.getCart();
                result = result * 59 + ($cart == null ? 43 : ((Object)$cart).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Cart
            extends StripeObject {
                @SerializedName(value="currency")
                String currency;
                @SerializedName(value="line_items")
                List<LineItem> lineItems;
                @SerializedName(value="tax")
                Long tax;
                @SerializedName(value="total")
                Long total;

                @Generated
                public String getCurrency() {
                    return this.currency;
                }

                @Generated
                public List<LineItem> getLineItems() {
                    return this.lineItems;
                }

                @Generated
                public Long getTax() {
                    return this.tax;
                }

                @Generated
                public Long getTotal() {
                    return this.total;
                }

                @Generated
                public void setCurrency(String currency) {
                    this.currency = currency;
                }

                @Generated
                public void setLineItems(List<LineItem> lineItems) {
                    this.lineItems = lineItems;
                }

                @Generated
                public void setTax(Long tax) {
                    this.tax = tax;
                }

                @Generated
                public void setTotal(Long total) {
                    this.total = total;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Cart)) {
                        return false;
                    }
                    Cart other = (Cart)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$tax = this.getTax();
                    Long other$tax = other.getTax();
                    if (this$tax == null ? other$tax != null : !((Object)this$tax).equals(other$tax)) {
                        return false;
                    }
                    Long this$total = this.getTotal();
                    Long other$total = other.getTotal();
                    if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
                        return false;
                    }
                    String this$currency = this.getCurrency();
                    String other$currency = other.getCurrency();
                    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                        return false;
                    }
                    List<LineItem> this$lineItems = this.getLineItems();
                    List<LineItem> other$lineItems = other.getLineItems();
                    return !(this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Cart;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $tax = this.getTax();
                    result = result * 59 + ($tax == null ? 43 : ((Object)$tax).hashCode());
                    Long $total = this.getTotal();
                    result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
                    String $currency = this.getCurrency();
                    result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                    List<LineItem> $lineItems = this.getLineItems();
                    result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
                    return result;
                }

                public static class LineItem
                extends StripeObject {
                    @SerializedName(value="amount")
                    Long amount;
                    @SerializedName(value="description")
                    String description;
                    @SerializedName(value="quantity")
                    Long quantity;

                    @Generated
                    public Long getAmount() {
                        return this.amount;
                    }

                    @Generated
                    public String getDescription() {
                        return this.description;
                    }

                    @Generated
                    public Long getQuantity() {
                        return this.quantity;
                    }

                    @Generated
                    public void setAmount(Long amount) {
                        this.amount = amount;
                    }

                    @Generated
                    public void setDescription(String description) {
                        this.description = description;
                    }

                    @Generated
                    public void setQuantity(Long quantity) {
                        this.quantity = quantity;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof LineItem)) {
                            return false;
                        }
                        LineItem other = (LineItem)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$amount = this.getAmount();
                        Long other$amount = other.getAmount();
                        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                            return false;
                        }
                        Long this$quantity = this.getQuantity();
                        Long other$quantity = other.getQuantity();
                        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                            return false;
                        }
                        String this$description = this.getDescription();
                        String other$description = other.getDescription();
                        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof LineItem;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $amount = this.getAmount();
                        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                        Long $quantity = this.getQuantity();
                        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
                        String $description = this.getDescription();
                        result = result * 59 + ($description == null ? 43 : $description.hashCode());
                        return result;
                    }
                }
            }
        }
    }
}

