/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.Person;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.PersonCollectionCreateParams;
import com.stripe.param.PersonCollectionListParams;
import com.stripe.param.PersonCollectionRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;

public class PersonCollection
extends StripeCollection<Person> {
    public Person create(Map<String, Object> params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public Person create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Person)this.getResponseGetter().request(request, (Type)((Object)Person.class));
    }

    public Person create(PersonCollectionCreateParams params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public Person create(PersonCollectionCreateParams params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Person)this.getResponseGetter().request(request, (Type)((Object)Person.class));
    }

    public PersonCollection list(Map<String, Object> params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public PersonCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (PersonCollection)this.getResponseGetter().request(request, (Type)((Object)PersonCollection.class));
    }

    public PersonCollection list(PersonCollectionListParams params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public PersonCollection list(PersonCollectionListParams params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PersonCollection)this.getResponseGetter().request(request, (Type)((Object)PersonCollection.class));
    }

    public Person retrieve(String id) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public Person retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, options);
    }

    public Person retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (Person)this.getResponseGetter().request(request, (Type)((Object)Person.class));
    }

    public Person retrieve(String id, PersonCollectionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Person)this.getResponseGetter().request(request, (Type)((Object)Person.class));
    }
}

