/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccount;
import com.stripe.model.MetadataStore;
import com.stripe.model.PayoutCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PayoutCancelParams;
import com.stripe.param.PayoutCreateParams;
import com.stripe.param.PayoutListParams;
import com.stripe.param.PayoutRetrieveParams;
import com.stripe.param.PayoutReverseParams;
import com.stripe.param.PayoutUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class Payout
extends ApiResource
implements MetadataStore<Payout>,
BalanceTransactionSource {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="arrival_date")
    Long arrivalDate;
    @SerializedName(value="automatic")
    Boolean automatic;
    @SerializedName(value="balance_transaction")
    ExpandableField<BalanceTransaction> balanceTransaction;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="destination")
    ExpandableField<ExternalAccount> destination;
    @SerializedName(value="failure_balance_transaction")
    ExpandableField<BalanceTransaction> failureBalanceTransaction;
    @SerializedName(value="failure_code")
    String failureCode;
    @SerializedName(value="failure_message")
    String failureMessage;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="method")
    String method;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="original_payout")
    ExpandableField<Payout> originalPayout;
    @SerializedName(value="reconciliation_status")
    String reconciliationStatus;
    @SerializedName(value="reversed_by")
    ExpandableField<Payout> reversedBy;
    @SerializedName(value="source_type")
    String sourceType;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="type")
    String type;

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String id) {
        this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getDestination() {
        return this.destination != null ? this.destination.getId() : null;
    }

    public void setDestination(String id) {
        this.destination = ApiResource.setExpandableFieldId(id, this.destination);
    }

    public ExternalAccount getDestinationObject() {
        return this.destination != null ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(ExternalAccount expandableObject) {
        this.destination = new ExpandableField<ExternalAccount>(expandableObject.getId(), expandableObject);
    }

    public String getFailureBalanceTransaction() {
        return this.failureBalanceTransaction != null ? this.failureBalanceTransaction.getId() : null;
    }

    public void setFailureBalanceTransaction(String id) {
        this.failureBalanceTransaction = ApiResource.setExpandableFieldId(id, this.failureBalanceTransaction);
    }

    public BalanceTransaction getFailureBalanceTransactionObject() {
        return this.failureBalanceTransaction != null ? this.failureBalanceTransaction.getExpanded() : null;
    }

    public void setFailureBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.failureBalanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getOriginalPayout() {
        return this.originalPayout != null ? this.originalPayout.getId() : null;
    }

    public void setOriginalPayout(String id) {
        this.originalPayout = ApiResource.setExpandableFieldId(id, this.originalPayout);
    }

    public Payout getOriginalPayoutObject() {
        return this.originalPayout != null ? this.originalPayout.getExpanded() : null;
    }

    public void setOriginalPayoutObject(Payout expandableObject) {
        this.originalPayout = new ExpandableField<Payout>(expandableObject.getId(), expandableObject);
    }

    public String getReversedBy() {
        return this.reversedBy != null ? this.reversedBy.getId() : null;
    }

    public void setReversedBy(String id) {
        this.reversedBy = ApiResource.setExpandableFieldId(id, this.reversedBy);
    }

    public Payout getReversedByObject() {
        return this.reversedBy != null ? this.reversedBy.getExpanded() : null;
    }

    public void setReversedByObject(Payout expandableObject) {
        this.reversedBy = new ExpandableField<Payout>(expandableObject.getId(), expandableObject);
    }

    public Payout cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public Payout cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public Payout cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Payout cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payouts/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Payout)this.getResponseGetter().request(request, (Type)((Object)Payout.class));
    }

    public Payout cancel(PayoutCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Payout cancel(PayoutCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payouts/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Payout)this.getResponseGetter().request(request, (Type)((Object)Payout.class));
    }

    public static Payout create(Map<String, Object> params) throws StripeException {
        return Payout.create(params, (RequestOptions)null);
    }

    public static Payout create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/payouts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Payout)Payout.getGlobalResponseGetter().request(request, (Type)((Object)Payout.class));
    }

    public static Payout create(PayoutCreateParams params) throws StripeException {
        return Payout.create(params, (RequestOptions)null);
    }

    public static Payout create(PayoutCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payouts";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Payout)Payout.getGlobalResponseGetter().request(request, (Type)((Object)Payout.class));
    }

    public static PayoutCollection list(Map<String, Object> params) throws StripeException {
        return Payout.list(params, (RequestOptions)null);
    }

    public static PayoutCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/payouts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (PayoutCollection)Payout.getGlobalResponseGetter().request(request, (Type)((Object)PayoutCollection.class));
    }

    public static PayoutCollection list(PayoutListParams params) throws StripeException {
        return Payout.list(params, (RequestOptions)null);
    }

    public static PayoutCollection list(PayoutListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payouts";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PayoutCollection)Payout.getGlobalResponseGetter().request(request, (Type)((Object)PayoutCollection.class));
    }

    public static Payout retrieve(String payout) throws StripeException {
        return Payout.retrieve(payout, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Payout retrieve(String payout, RequestOptions options) throws StripeException {
        return Payout.retrieve(payout, (Map<String, Object>)null, options);
    }

    public static Payout retrieve(String payout, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payouts/%s", ApiResource.urlEncodeId(payout));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (Payout)Payout.getGlobalResponseGetter().request(request, (Type)((Object)Payout.class));
    }

    public static Payout retrieve(String payout, PayoutRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payouts/%s", ApiResource.urlEncodeId(payout));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Payout)Payout.getGlobalResponseGetter().request(request, (Type)((Object)Payout.class));
    }

    public Payout reverse() throws StripeException {
        return this.reverse((Map<String, Object>)null, (RequestOptions)null);
    }

    public Payout reverse(RequestOptions options) throws StripeException {
        return this.reverse((Map<String, Object>)null, options);
    }

    public Payout reverse(Map<String, Object> params) throws StripeException {
        return this.reverse(params, (RequestOptions)null);
    }

    public Payout reverse(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payouts/%s/reverse", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Payout)this.getResponseGetter().request(request, (Type)((Object)Payout.class));
    }

    public Payout reverse(PayoutReverseParams params) throws StripeException {
        return this.reverse(params, (RequestOptions)null);
    }

    public Payout reverse(PayoutReverseParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payouts/%s/reverse", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Payout)this.getResponseGetter().request(request, (Type)((Object)Payout.class));
    }

    public Payout update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Payout update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payouts/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Payout)this.getResponseGetter().request(request, (Type)((Object)Payout.class));
    }

    public Payout update(PayoutUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Payout update(PayoutUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payouts/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Payout)this.getResponseGetter().request(request, (Type)((Object)Payout.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.balanceTransaction, responseGetter);
        this.trySetResponseGetter(this.destination, responseGetter);
        this.trySetResponseGetter(this.failureBalanceTransaction, responseGetter);
        this.trySetResponseGetter(this.originalPayout, responseGetter);
        this.trySetResponseGetter(this.reversedBy, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getArrivalDate() {
        return this.arrivalDate;
    }

    @Generated
    public Boolean getAutomatic() {
        return this.automatic;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getFailureCode() {
        return this.failureCode;
    }

    @Generated
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getReconciliationStatus() {
        return this.reconciliationStatus;
    }

    @Generated
    public String getSourceType() {
        return this.sourceType;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setArrivalDate(Long arrivalDate) {
        this.arrivalDate = arrivalDate;
    }

    @Generated
    public void setAutomatic(Boolean automatic) {
        this.automatic = automatic;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    @Generated
    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReconciliationStatus(String reconciliationStatus) {
        this.reconciliationStatus = reconciliationStatus;
    }

    @Generated
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Payout)) {
            return false;
        }
        Payout other = (Payout)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$arrivalDate = this.getArrivalDate();
        Long other$arrivalDate = other.getArrivalDate();
        if (this$arrivalDate == null ? other$arrivalDate != null : !((Object)this$arrivalDate).equals(other$arrivalDate)) {
            return false;
        }
        Boolean this$automatic = this.getAutomatic();
        Boolean other$automatic = other.getAutomatic();
        if (this$automatic == null ? other$automatic != null : !((Object)this$automatic).equals(other$automatic)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$failureBalanceTransaction = this.getFailureBalanceTransaction();
        String other$failureBalanceTransaction = other.getFailureBalanceTransaction();
        if (this$failureBalanceTransaction == null ? other$failureBalanceTransaction != null : !this$failureBalanceTransaction.equals(other$failureBalanceTransaction)) {
            return false;
        }
        String this$failureCode = this.getFailureCode();
        String other$failureCode = other.getFailureCode();
        if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) {
            return false;
        }
        String this$failureMessage = this.getFailureMessage();
        String other$failureMessage = other.getFailureMessage();
        if (this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$originalPayout = this.getOriginalPayout();
        String other$originalPayout = other.getOriginalPayout();
        if (this$originalPayout == null ? other$originalPayout != null : !this$originalPayout.equals(other$originalPayout)) {
            return false;
        }
        String this$reconciliationStatus = this.getReconciliationStatus();
        String other$reconciliationStatus = other.getReconciliationStatus();
        if (this$reconciliationStatus == null ? other$reconciliationStatus != null : !this$reconciliationStatus.equals(other$reconciliationStatus)) {
            return false;
        }
        String this$reversedBy = this.getReversedBy();
        String other$reversedBy = other.getReversedBy();
        if (this$reversedBy == null ? other$reversedBy != null : !this$reversedBy.equals(other$reversedBy)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Payout;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $arrivalDate = this.getArrivalDate();
        result = result * 59 + ($arrivalDate == null ? 43 : ((Object)$arrivalDate).hashCode());
        Boolean $automatic = this.getAutomatic();
        result = result * 59 + ($automatic == null ? 43 : ((Object)$automatic).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $failureBalanceTransaction = this.getFailureBalanceTransaction();
        result = result * 59 + ($failureBalanceTransaction == null ? 43 : $failureBalanceTransaction.hashCode());
        String $failureCode = this.getFailureCode();
        result = result * 59 + ($failureCode == null ? 43 : $failureCode.hashCode());
        String $failureMessage = this.getFailureMessage();
        result = result * 59 + ($failureMessage == null ? 43 : $failureMessage.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $originalPayout = this.getOriginalPayout();
        result = result * 59 + ($originalPayout == null ? 43 : $originalPayout.hashCode());
        String $reconciliationStatus = this.getReconciliationStatus();
        result = result * 59 + ($reconciliationStatus == null ? 43 : $reconciliationStatus.hashCode());
        String $reversedBy = this.getReversedBy();
        result = result * 59 + ($reversedBy == null ? 43 : $reversedBy.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

