/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.EphemeralKeyCreateParams;
import com.stripe.param.EphemeralKeyDeleteParams;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class EphemeralKey
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="expires")
    Long expires;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="secret")
    String secret;
    transient String rawJson;

    public static EphemeralKey create(Map<String, Object> params) throws StripeException {
        return EphemeralKey.create(params, (RequestOptions)null);
    }

    public static EphemeralKey create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String versionOverride;
        if (!params.containsKey("stripe-version")) {
            throw new IllegalArgumentException("`stripe-version` must be explicitly specified in `params` as the stripe version of your mobile client.");
        }
        try {
            versionOverride = (String)params.get("stripe-version");
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("`stripe-version` must be explicitly specified in `params` as a string");
        }
        if (options == null) {
            options = RequestOptions.getDefault();
        }
        RequestOptions overriddenOptions = RequestOptions.RequestOptionsBuilder.unsafeSetStripeVersionOverride(options.toBuilderFullCopy(), versionOverride).build();
        HashMap<String, Object> overriddenParams = new HashMap<String, Object>(params);
        overriddenParams.remove("stripe-version");
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, "/v1/ephemeral_keys", overriddenParams, overriddenOptions, ApiMode.V1);
        return (EphemeralKey)EphemeralKey.getGlobalResponseGetter().request(request, (Type)((Object)EphemeralKey.class));
    }

    public static EphemeralKey create(EphemeralKeyCreateParams params) throws StripeException {
        return EphemeralKey.create(params, (RequestOptions)null);
    }

    public static EphemeralKey create(EphemeralKeyCreateParams params, RequestOptions options) throws StripeException {
        EphemeralKey.checkNullTypedParams("/v1/ephemeral_keys", params);
        Map<String, Object> paramMap = params.toMap();
        if (!paramMap.containsKey("stripe-version")) {
            throw new IllegalArgumentException("You must .setStripeVersion on EphemeralKeyCreateParams.builder() with the stripe version of your mobile client.");
        }
        return EphemeralKey.create(paramMap, options);
    }

    public EphemeralKey delete() throws StripeException {
        return this.delete((Map<String, Object>)null, (RequestOptions)null);
    }

    public EphemeralKey delete(RequestOptions options) throws StripeException {
        return this.delete((Map<String, Object>)null, options);
    }

    public EphemeralKey delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, (RequestOptions)null);
    }

    public EphemeralKey delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/ephemeral_keys/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, params, options, ApiMode.V1);
        return (EphemeralKey)this.getResponseGetter().request(request, (Type)((Object)EphemeralKey.class));
    }

    public EphemeralKey delete(EphemeralKeyDeleteParams params) throws StripeException {
        return this.delete(params, (RequestOptions)null);
    }

    public EphemeralKey delete(EphemeralKeyDeleteParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/ephemeral_keys/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (EphemeralKey)this.getResponseGetter().request(request, (Type)((Object)EphemeralKey.class));
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getExpires() {
        return this.expires;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getSecret() {
        return this.secret;
    }

    @Generated
    public String getRawJson() {
        return this.rawJson;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setExpires(Long expires) {
        this.expires = expires;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Generated
    public void setRawJson(String rawJson) {
        this.rawJson = rawJson;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EphemeralKey)) {
            return false;
        }
        EphemeralKey other = (EphemeralKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expires = this.getExpires();
        Long other$expires = other.getExpires();
        if (this$expires == null ? other$expires != null : !((Object)this$expires).equals(other$expires)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EphemeralKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expires = this.getExpires();
        result = result * 59 + ($expires == null ? 43 : ((Object)$expires).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

