/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.issuing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.issuing.Authorization;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.AuthorizationApproveParams;
import com.stripe.param.issuing.AuthorizationDeclineParams;
import com.stripe.param.issuing.AuthorizationListParams;
import com.stripe.param.issuing.AuthorizationRetrieveParams;
import com.stripe.param.issuing.AuthorizationUpdateParams;
import java.lang.reflect.Type;

public final class AuthorizationService
extends ApiService {
    public AuthorizationService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Authorization> list(AuthorizationListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Authorization> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Authorization> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Authorization> list(AuthorizationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/authorizations";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<Authorization>>(){}.getType(), options, ApiMode.V1);
    }

    public Authorization retrieve(String authorization, AuthorizationRetrieveParams params) throws StripeException {
        return this.retrieve(authorization, params, null);
    }

    public Authorization retrieve(String authorization, RequestOptions options) throws StripeException {
        return this.retrieve(authorization, null, options);
    }

    public Authorization retrieve(String authorization) throws StripeException {
        return this.retrieve(authorization, null, null);
    }

    public Authorization retrieve(String authorization, AuthorizationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(authorization));
        return (Authorization)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Authorization.class), options, ApiMode.V1);
    }

    public Authorization update(String authorization, AuthorizationUpdateParams params) throws StripeException {
        return this.update(authorization, params, null);
    }

    public Authorization update(String authorization, RequestOptions options) throws StripeException {
        return this.update(authorization, null, options);
    }

    public Authorization update(String authorization) throws StripeException {
        return this.update(authorization, null, null);
    }

    public Authorization update(String authorization, AuthorizationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(authorization));
        return (Authorization)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Authorization.class), options, ApiMode.V1);
    }

    public Authorization approve(String authorization, AuthorizationApproveParams params) throws StripeException {
        return this.approve(authorization, params, null);
    }

    public Authorization approve(String authorization, RequestOptions options) throws StripeException {
        return this.approve(authorization, null, options);
    }

    public Authorization approve(String authorization) throws StripeException {
        return this.approve(authorization, null, null);
    }

    public Authorization approve(String authorization, AuthorizationApproveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/authorizations/%s/approve", ApiResource.urlEncodeId(authorization));
        return (Authorization)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Authorization.class), options, ApiMode.V1);
    }

    public Authorization decline(String authorization, AuthorizationDeclineParams params) throws StripeException {
        return this.decline(authorization, params, null);
    }

    public Authorization decline(String authorization, RequestOptions options) throws StripeException {
        return this.decline(authorization, null, options);
    }

    public Authorization decline(String authorization) throws StripeException {
        return this.decline(authorization, null, null);
    }

    public Authorization decline(String authorization, AuthorizationDeclineParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/authorizations/%s/decline", ApiResource.urlEncodeId(authorization));
        return (Authorization)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Authorization.class), options, ApiMode.V1);
    }
}

