/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.CreditNoteLineItem;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CreditNoteLineItemListParams;

public final class CreditNoteLineItemService
extends ApiService {
    public CreditNoteLineItemService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<CreditNoteLineItem> list(String creditNote, CreditNoteLineItemListParams params) throws StripeException {
        return this.list(creditNote, params, null);
    }

    public StripeCollection<CreditNoteLineItem> list(String creditNote, RequestOptions options) throws StripeException {
        return this.list(creditNote, null, options);
    }

    public StripeCollection<CreditNoteLineItem> list(String creditNote) throws StripeException {
        return this.list(creditNote, null, null);
    }

    public StripeCollection<CreditNoteLineItem> list(String creditNote, CreditNoteLineItemListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/credit_notes/%s/lines", ApiResource.urlEncodeId(creditNote));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<CreditNoteLineItem>>(){}.getType());
    }
}

