// Generated by delombok at Thu Dec 08 23:17:07 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.model.StripeObject;
import java.util.List;

/**
 * Encodes whether a FinancialAccount has access to a particular Feature, with a {@code status} enum
 * and associated {@code status_details}. Stripe or the platform can control Features via the
 * requested field.
 */
public class FinancialAccountFeatures extends StripeObject {
  /**
   * Toggle settings for enabling/disabling a feature.
   */
  @SerializedName("card_issuing")
  CardIssuing cardIssuing;
  /**
   * Toggle settings for enabling/disabling a feature.
   */
  @SerializedName("deposit_insurance")
  DepositInsurance depositInsurance;
  /**
   * Settings related to Financial Addresses features on a Financial Account.
   */
  @SerializedName("financial_addresses")
  FinancialAddresses financialAddresses;
  /**
   * InboundTransfers contains inbound transfers features for a FinancialAccount.
   */
  @SerializedName("inbound_transfers")
  InboundTransfers inboundTransfers;
  /**
   * Toggle settings for enabling/disabling a feature.
   */
  @SerializedName("intra_stripe_flows")
  IntraStripeFlows intraStripeFlows;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.financial_account_features}.
   */
  @SerializedName("object")
  String object;
  /**
   * Settings related to Outbound Payments features on a Financial Account.
   */
  @SerializedName("outbound_payments")
  OutboundPayments outboundPayments;
  /**
   * OutboundTransfers contains outbound transfers features for a FinancialAccount.
   */
  @SerializedName("outbound_transfers")
  OutboundTransfers outboundTransfers;


  /**
   * Toggle settings for enabling/disabling a feature.
   */
  public static class CardIssuing extends StripeObject {
    /**
     * Whether the FinancialAccount should have the Feature.
     */
    @SerializedName("requested")
    Boolean requested;
    /**
     * Whether the Feature is operational.
     *
     * <p>One of {@code active}, {@code pending}, or {@code restricted}.
     */
    @SerializedName("status")
    String status;
    /**
     * Additional details; includes at least one entry when the status is not {@code active}.
     */
    @SerializedName("status_details")
    List<FinancialAccountFeatures.CardIssuing.StatusDetail> statusDetails;


    /**
     * Additional details on the FinancialAccount Features information.
     */
    public static class StatusDetail extends StripeObject {
      /**
       * Represents the reason why the status is {@code pending} or {@code restricted}.
       *
       * <p>One of {@code activating}, {@code capability_not_requested}, {@code
       * financial_account_closed}, {@code rejected_other}, {@code rejected_unsupported_business},
       * {@code requirements_past_due}, {@code requirements_pending_verification}, {@code
       * restricted_by_platform}, or {@code restricted_other}.
       */
      @SerializedName("code")
      String code;
      /**
       * Represents what the user should do, if anything, to activate the Feature.
       *
       * <p>One of {@code contact_stripe}, {@code provide_information}, or {@code
       * remove_restriction}.
       */
      @SerializedName("resolution")
      String resolution;
      /**
       * The {@code platform_restrictions} that are restricting this Feature.
       *
       * <p>One of {@code inbound_flows}, or {@code outbound_flows}.
       */
      @SerializedName("restriction")
      String restriction;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCode() {
        return this.code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getResolution() {
        return this.resolution;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRestriction() {
        return this.restriction;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCode(final String code) {
        this.code = code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setResolution(final String resolution) {
        this.resolution = resolution;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRestriction(final String restriction) {
        this.restriction = restriction;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FinancialAccountFeatures.CardIssuing.StatusDetail)) return false;
        final FinancialAccountFeatures.CardIssuing.StatusDetail other = (FinancialAccountFeatures.CardIssuing.StatusDetail) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$resolution = this.getResolution();
        final java.lang.Object other$resolution = other.getResolution();
        if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) return false;
        final java.lang.Object this$restriction = this.getRestriction();
        final java.lang.Object other$restriction = other.getRestriction();
        if (this$restriction == null ? other$restriction != null : !this$restriction.equals(other$restriction)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FinancialAccountFeatures.CardIssuing.StatusDetail;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $resolution = this.getResolution();
        result = result * PRIME + ($resolution == null ? 43 : $resolution.hashCode());
        final java.lang.Object $restriction = this.getRestriction();
        result = result * PRIME + ($restriction == null ? 43 : $restriction.hashCode());
        return result;
      }
    }

    /**
     * Whether the FinancialAccount should have the Feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getRequested() {
      return this.requested;
    }

    /**
     * Whether the Feature is operational.
     *
     * <p>One of {@code active}, {@code pending}, or {@code restricted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * Additional details; includes at least one entry when the status is not {@code active}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<FinancialAccountFeatures.CardIssuing.StatusDetail> getStatusDetails() {
      return this.statusDetails;
    }

    /**
     * Whether the FinancialAccount should have the Feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRequested(final Boolean requested) {
      this.requested = requested;
    }

    /**
     * Whether the Feature is operational.
     *
     * <p>One of {@code active}, {@code pending}, or {@code restricted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    /**
     * Additional details; includes at least one entry when the status is not {@code active}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatusDetails(final List<FinancialAccountFeatures.CardIssuing.StatusDetail> statusDetails) {
      this.statusDetails = statusDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancialAccountFeatures.CardIssuing)) return false;
      final FinancialAccountFeatures.CardIssuing other = (FinancialAccountFeatures.CardIssuing) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$requested = this.getRequested();
      final java.lang.Object other$requested = other.getRequested();
      if (this$requested == null ? other$requested != null : !this$requested.equals(other$requested)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      final java.lang.Object this$statusDetails = this.getStatusDetails();
      final java.lang.Object other$statusDetails = other.getStatusDetails();
      if (this$statusDetails == null ? other$statusDetails != null : !this$statusDetails.equals(other$statusDetails)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancialAccountFeatures.CardIssuing;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $requested = this.getRequested();
      result = result * PRIME + ($requested == null ? 43 : $requested.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      final java.lang.Object $statusDetails = this.getStatusDetails();
      result = result * PRIME + ($statusDetails == null ? 43 : $statusDetails.hashCode());
      return result;
    }
  }


  /**
   * Toggle settings for enabling/disabling a feature.
   */
  public static class DepositInsurance extends StripeObject {
    /**
     * Whether the FinancialAccount should have the Feature.
     */
    @SerializedName("requested")
    Boolean requested;
    /**
     * Whether the Feature is operational.
     *
     * <p>One of {@code active}, {@code pending}, or {@code restricted}.
     */
    @SerializedName("status")
    String status;
    /**
     * Additional details; includes at least one entry when the status is not {@code active}.
     */
    @SerializedName("status_details")
    List<FinancialAccountFeatures.DepositInsurance.StatusDetail> statusDetails;


    /**
     * Additional details on the FinancialAccount Features information.
     */
    public static class StatusDetail extends StripeObject {
      /**
       * Represents the reason why the status is {@code pending} or {@code restricted}.
       *
       * <p>One of {@code activating}, {@code capability_not_requested}, {@code
       * financial_account_closed}, {@code rejected_other}, {@code rejected_unsupported_business},
       * {@code requirements_past_due}, {@code requirements_pending_verification}, {@code
       * restricted_by_platform}, or {@code restricted_other}.
       */
      @SerializedName("code")
      String code;
      /**
       * Represents what the user should do, if anything, to activate the Feature.
       *
       * <p>One of {@code contact_stripe}, {@code provide_information}, or {@code
       * remove_restriction}.
       */
      @SerializedName("resolution")
      String resolution;
      /**
       * The {@code platform_restrictions} that are restricting this Feature.
       *
       * <p>One of {@code inbound_flows}, or {@code outbound_flows}.
       */
      @SerializedName("restriction")
      String restriction;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCode() {
        return this.code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getResolution() {
        return this.resolution;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRestriction() {
        return this.restriction;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCode(final String code) {
        this.code = code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setResolution(final String resolution) {
        this.resolution = resolution;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRestriction(final String restriction) {
        this.restriction = restriction;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FinancialAccountFeatures.DepositInsurance.StatusDetail)) return false;
        final FinancialAccountFeatures.DepositInsurance.StatusDetail other = (FinancialAccountFeatures.DepositInsurance.StatusDetail) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$resolution = this.getResolution();
        final java.lang.Object other$resolution = other.getResolution();
        if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) return false;
        final java.lang.Object this$restriction = this.getRestriction();
        final java.lang.Object other$restriction = other.getRestriction();
        if (this$restriction == null ? other$restriction != null : !this$restriction.equals(other$restriction)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FinancialAccountFeatures.DepositInsurance.StatusDetail;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $resolution = this.getResolution();
        result = result * PRIME + ($resolution == null ? 43 : $resolution.hashCode());
        final java.lang.Object $restriction = this.getRestriction();
        result = result * PRIME + ($restriction == null ? 43 : $restriction.hashCode());
        return result;
      }
    }

    /**
     * Whether the FinancialAccount should have the Feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getRequested() {
      return this.requested;
    }

    /**
     * Whether the Feature is operational.
     *
     * <p>One of {@code active}, {@code pending}, or {@code restricted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * Additional details; includes at least one entry when the status is not {@code active}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<FinancialAccountFeatures.DepositInsurance.StatusDetail> getStatusDetails() {
      return this.statusDetails;
    }

    /**
     * Whether the FinancialAccount should have the Feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRequested(final Boolean requested) {
      this.requested = requested;
    }

    /**
     * Whether the Feature is operational.
     *
     * <p>One of {@code active}, {@code pending}, or {@code restricted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    /**
     * Additional details; includes at least one entry when the status is not {@code active}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatusDetails(final List<FinancialAccountFeatures.DepositInsurance.StatusDetail> statusDetails) {
      this.statusDetails = statusDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancialAccountFeatures.DepositInsurance)) return false;
      final FinancialAccountFeatures.DepositInsurance other = (FinancialAccountFeatures.DepositInsurance) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$requested = this.getRequested();
      final java.lang.Object other$requested = other.getRequested();
      if (this$requested == null ? other$requested != null : !this$requested.equals(other$requested)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      final java.lang.Object this$statusDetails = this.getStatusDetails();
      final java.lang.Object other$statusDetails = other.getStatusDetails();
      if (this$statusDetails == null ? other$statusDetails != null : !this$statusDetails.equals(other$statusDetails)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancialAccountFeatures.DepositInsurance;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $requested = this.getRequested();
      result = result * PRIME + ($requested == null ? 43 : $requested.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      final java.lang.Object $statusDetails = this.getStatusDetails();
      result = result * PRIME + ($statusDetails == null ? 43 : $statusDetails.hashCode());
      return result;
    }
  }


  /**
   * Settings related to Financial Addresses features on a Financial Account.
   */
  public static class FinancialAddresses extends StripeObject {
    /**
     * Toggle settings for enabling/disabling a feature.
     */
    @SerializedName("aba")
    Aba aba;


    /**
     * Toggle settings for enabling/disabling a feature.
     */
    public static class Aba extends StripeObject {
      /** Whether the FinancialAccount should have the Feature. */
      @SerializedName("requested")
      Boolean requested;
      /**
       * Whether the Feature is operational.
       *
       * <p>One of {@code active}, {@code pending}, or {@code restricted}.
       */
      @SerializedName("status")
      String status;
      /** Additional details; includes at least one entry when the status is not {@code active}. */
      @SerializedName("status_details")
      List<FinancialAccountFeatures.FinancialAddresses.Aba.StatusDetail> statusDetails;

      /** Additional details on the FinancialAccount Features information. */
      public static class StatusDetail extends StripeObject {
        /**
         * Represents the reason why the status is {@code pending} or {@code restricted}.
         *
         * <p>One of {@code activating}, {@code capability_not_requested}, {@code
         * financial_account_closed}, {@code rejected_other}, {@code rejected_unsupported_business},
         * {@code requirements_past_due}, {@code requirements_pending_verification}, {@code
         * restricted_by_platform}, or {@code restricted_other}.
         */
        @SerializedName("code")
        String code;
        /**
         * Represents what the user should do, if anything, to activate the Feature.
         *
         * <p>One of {@code contact_stripe}, {@code provide_information}, or {@code
         * remove_restriction}.
         */
        @SerializedName("resolution")
        String resolution;
        /**
         * The {@code platform_restrictions} that are restricting this Feature.
         *
         * <p>One of {@code inbound_flows}, or {@code outbound_flows}.
         */
        @SerializedName("restriction")
        String restriction;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCode() {
          return this.code;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getResolution() {
          return this.resolution;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getRestriction() {
          return this.restriction;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCode(final String code) {
          this.code = code;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setResolution(final String resolution) {
          this.resolution = resolution;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setRestriction(final String restriction) {
          this.restriction = restriction;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof FinancialAccountFeatures.FinancialAddresses.Aba.StatusDetail)) return false;
          final FinancialAccountFeatures.FinancialAddresses.Aba.StatusDetail other = (FinancialAccountFeatures.FinancialAddresses.Aba.StatusDetail) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$code = this.getCode();
          final java.lang.Object other$code = other.getCode();
          if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
          final java.lang.Object this$resolution = this.getResolution();
          final java.lang.Object other$resolution = other.getResolution();
          if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) return false;
          final java.lang.Object this$restriction = this.getRestriction();
          final java.lang.Object other$restriction = other.getRestriction();
          if (this$restriction == null ? other$restriction != null : !this$restriction.equals(other$restriction)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof FinancialAccountFeatures.FinancialAddresses.Aba.StatusDetail;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $code = this.getCode();
          result = result * PRIME + ($code == null ? 43 : $code.hashCode());
          final java.lang.Object $resolution = this.getResolution();
          result = result * PRIME + ($resolution == null ? 43 : $resolution.hashCode());
          final java.lang.Object $restriction = this.getRestriction();
          result = result * PRIME + ($restriction == null ? 43 : $restriction.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getRequested() {
        return this.requested;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getStatus() {
        return this.status;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<FinancialAccountFeatures.FinancialAddresses.Aba.StatusDetail> getStatusDetails() {
        return this.statusDetails;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequested(final Boolean requested) {
        this.requested = requested;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatus(final String status) {
        this.status = status;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatusDetails(final List<FinancialAccountFeatures.FinancialAddresses.Aba.StatusDetail> statusDetails) {
        this.statusDetails = statusDetails;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FinancialAccountFeatures.FinancialAddresses.Aba)) return false;
        final FinancialAccountFeatures.FinancialAddresses.Aba other = (FinancialAccountFeatures.FinancialAddresses.Aba) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$requested = this.getRequested();
        final java.lang.Object other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !this$requested.equals(other$requested)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        final java.lang.Object this$statusDetails = this.getStatusDetails();
        final java.lang.Object other$statusDetails = other.getStatusDetails();
        if (this$statusDetails == null ? other$statusDetails != null : !this$statusDetails.equals(other$statusDetails)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FinancialAccountFeatures.FinancialAddresses.Aba;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $requested = this.getRequested();
        result = result * PRIME + ($requested == null ? 43 : $requested.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        final java.lang.Object $statusDetails = this.getStatusDetails();
        result = result * PRIME + ($statusDetails == null ? 43 : $statusDetails.hashCode());
        return result;
      }
    }

    /**
     * Toggle settings for enabling/disabling a feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Aba getAba() {
      return this.aba;
    }

    /**
     * Toggle settings for enabling/disabling a feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAba(final Aba aba) {
      this.aba = aba;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancialAccountFeatures.FinancialAddresses)) return false;
      final FinancialAccountFeatures.FinancialAddresses other = (FinancialAccountFeatures.FinancialAddresses) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$aba = this.getAba();
      final java.lang.Object other$aba = other.getAba();
      if (this$aba == null ? other$aba != null : !this$aba.equals(other$aba)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancialAccountFeatures.FinancialAddresses;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $aba = this.getAba();
      result = result * PRIME + ($aba == null ? 43 : $aba.hashCode());
      return result;
    }
  }


  /**
   * InboundTransfers contains inbound transfers features for a FinancialAccount.
   */
  public static class InboundTransfers extends StripeObject {
    /**
     * Toggle settings for enabling/disabling an ACH specific feature.
     */
    @SerializedName("ach")
    Ach ach;


    /**
     * Toggle settings for enabling/disabling an ACH specific feature.
     */
    public static class Ach extends StripeObject {
      /** Whether the FinancialAccount should have the Feature. */
      @SerializedName("requested")
      Boolean requested;
      /**
       * Whether the Feature is operational.
       *
       * <p>One of {@code active}, {@code pending}, or {@code restricted}.
       */
      @SerializedName("status")
      String status;
      /** Additional details; includes at least one entry when the status is not {@code active}. */
      @SerializedName("status_details")
      List<FinancialAccountFeatures.InboundTransfers.Ach.StatusDetail> statusDetails;

      /** Additional details on the FinancialAccount Features information. */
      public static class StatusDetail extends StripeObject {
        /**
         * Represents the reason why the status is {@code pending} or {@code restricted}.
         *
         * <p>One of {@code activating}, {@code capability_not_requested}, {@code
         * financial_account_closed}, {@code rejected_other}, {@code rejected_unsupported_business},
         * {@code requirements_past_due}, {@code requirements_pending_verification}, {@code
         * restricted_by_platform}, or {@code restricted_other}.
         */
        @SerializedName("code")
        String code;
        /**
         * Represents what the user should do, if anything, to activate the Feature.
         *
         * <p>One of {@code contact_stripe}, {@code provide_information}, or {@code
         * remove_restriction}.
         */
        @SerializedName("resolution")
        String resolution;
        /**
         * The {@code platform_restrictions} that are restricting this Feature.
         *
         * <p>One of {@code inbound_flows}, or {@code outbound_flows}.
         */
        @SerializedName("restriction")
        String restriction;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCode() {
          return this.code;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getResolution() {
          return this.resolution;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getRestriction() {
          return this.restriction;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCode(final String code) {
          this.code = code;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setResolution(final String resolution) {
          this.resolution = resolution;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setRestriction(final String restriction) {
          this.restriction = restriction;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof FinancialAccountFeatures.InboundTransfers.Ach.StatusDetail)) return false;
          final FinancialAccountFeatures.InboundTransfers.Ach.StatusDetail other = (FinancialAccountFeatures.InboundTransfers.Ach.StatusDetail) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$code = this.getCode();
          final java.lang.Object other$code = other.getCode();
          if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
          final java.lang.Object this$resolution = this.getResolution();
          final java.lang.Object other$resolution = other.getResolution();
          if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) return false;
          final java.lang.Object this$restriction = this.getRestriction();
          final java.lang.Object other$restriction = other.getRestriction();
          if (this$restriction == null ? other$restriction != null : !this$restriction.equals(other$restriction)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof FinancialAccountFeatures.InboundTransfers.Ach.StatusDetail;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $code = this.getCode();
          result = result * PRIME + ($code == null ? 43 : $code.hashCode());
          final java.lang.Object $resolution = this.getResolution();
          result = result * PRIME + ($resolution == null ? 43 : $resolution.hashCode());
          final java.lang.Object $restriction = this.getRestriction();
          result = result * PRIME + ($restriction == null ? 43 : $restriction.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getRequested() {
        return this.requested;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getStatus() {
        return this.status;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<FinancialAccountFeatures.InboundTransfers.Ach.StatusDetail> getStatusDetails() {
        return this.statusDetails;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequested(final Boolean requested) {
        this.requested = requested;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatus(final String status) {
        this.status = status;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatusDetails(final List<FinancialAccountFeatures.InboundTransfers.Ach.StatusDetail> statusDetails) {
        this.statusDetails = statusDetails;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FinancialAccountFeatures.InboundTransfers.Ach)) return false;
        final FinancialAccountFeatures.InboundTransfers.Ach other = (FinancialAccountFeatures.InboundTransfers.Ach) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$requested = this.getRequested();
        final java.lang.Object other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !this$requested.equals(other$requested)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        final java.lang.Object this$statusDetails = this.getStatusDetails();
        final java.lang.Object other$statusDetails = other.getStatusDetails();
        if (this$statusDetails == null ? other$statusDetails != null : !this$statusDetails.equals(other$statusDetails)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FinancialAccountFeatures.InboundTransfers.Ach;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $requested = this.getRequested();
        result = result * PRIME + ($requested == null ? 43 : $requested.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        final java.lang.Object $statusDetails = this.getStatusDetails();
        result = result * PRIME + ($statusDetails == null ? 43 : $statusDetails.hashCode());
        return result;
      }
    }

    /**
     * Toggle settings for enabling/disabling an ACH specific feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Ach getAch() {
      return this.ach;
    }

    /**
     * Toggle settings for enabling/disabling an ACH specific feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAch(final Ach ach) {
      this.ach = ach;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancialAccountFeatures.InboundTransfers)) return false;
      final FinancialAccountFeatures.InboundTransfers other = (FinancialAccountFeatures.InboundTransfers) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$ach = this.getAch();
      final java.lang.Object other$ach = other.getAch();
      if (this$ach == null ? other$ach != null : !this$ach.equals(other$ach)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancialAccountFeatures.InboundTransfers;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $ach = this.getAch();
      result = result * PRIME + ($ach == null ? 43 : $ach.hashCode());
      return result;
    }
  }


  /**
   * Toggle settings for enabling/disabling a feature.
   */
  public static class IntraStripeFlows extends StripeObject {
    /**
     * Whether the FinancialAccount should have the Feature.
     */
    @SerializedName("requested")
    Boolean requested;
    /**
     * Whether the Feature is operational.
     *
     * <p>One of {@code active}, {@code pending}, or {@code restricted}.
     */
    @SerializedName("status")
    String status;
    /**
     * Additional details; includes at least one entry when the status is not {@code active}.
     */
    @SerializedName("status_details")
    List<FinancialAccountFeatures.IntraStripeFlows.StatusDetail> statusDetails;


    /**
     * Additional details on the FinancialAccount Features information.
     */
    public static class StatusDetail extends StripeObject {
      /**
       * Represents the reason why the status is {@code pending} or {@code restricted}.
       *
       * <p>One of {@code activating}, {@code capability_not_requested}, {@code
       * financial_account_closed}, {@code rejected_other}, {@code rejected_unsupported_business},
       * {@code requirements_past_due}, {@code requirements_pending_verification}, {@code
       * restricted_by_platform}, or {@code restricted_other}.
       */
      @SerializedName("code")
      String code;
      /**
       * Represents what the user should do, if anything, to activate the Feature.
       *
       * <p>One of {@code contact_stripe}, {@code provide_information}, or {@code
       * remove_restriction}.
       */
      @SerializedName("resolution")
      String resolution;
      /**
       * The {@code platform_restrictions} that are restricting this Feature.
       *
       * <p>One of {@code inbound_flows}, or {@code outbound_flows}.
       */
      @SerializedName("restriction")
      String restriction;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCode() {
        return this.code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getResolution() {
        return this.resolution;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRestriction() {
        return this.restriction;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCode(final String code) {
        this.code = code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setResolution(final String resolution) {
        this.resolution = resolution;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRestriction(final String restriction) {
        this.restriction = restriction;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FinancialAccountFeatures.IntraStripeFlows.StatusDetail)) return false;
        final FinancialAccountFeatures.IntraStripeFlows.StatusDetail other = (FinancialAccountFeatures.IntraStripeFlows.StatusDetail) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$resolution = this.getResolution();
        final java.lang.Object other$resolution = other.getResolution();
        if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) return false;
        final java.lang.Object this$restriction = this.getRestriction();
        final java.lang.Object other$restriction = other.getRestriction();
        if (this$restriction == null ? other$restriction != null : !this$restriction.equals(other$restriction)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FinancialAccountFeatures.IntraStripeFlows.StatusDetail;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $resolution = this.getResolution();
        result = result * PRIME + ($resolution == null ? 43 : $resolution.hashCode());
        final java.lang.Object $restriction = this.getRestriction();
        result = result * PRIME + ($restriction == null ? 43 : $restriction.hashCode());
        return result;
      }
    }

    /**
     * Whether the FinancialAccount should have the Feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getRequested() {
      return this.requested;
    }

    /**
     * Whether the Feature is operational.
     *
     * <p>One of {@code active}, {@code pending}, or {@code restricted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * Additional details; includes at least one entry when the status is not {@code active}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<FinancialAccountFeatures.IntraStripeFlows.StatusDetail> getStatusDetails() {
      return this.statusDetails;
    }

    /**
     * Whether the FinancialAccount should have the Feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRequested(final Boolean requested) {
      this.requested = requested;
    }

    /**
     * Whether the Feature is operational.
     *
     * <p>One of {@code active}, {@code pending}, or {@code restricted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    /**
     * Additional details; includes at least one entry when the status is not {@code active}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatusDetails(final List<FinancialAccountFeatures.IntraStripeFlows.StatusDetail> statusDetails) {
      this.statusDetails = statusDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancialAccountFeatures.IntraStripeFlows)) return false;
      final FinancialAccountFeatures.IntraStripeFlows other = (FinancialAccountFeatures.IntraStripeFlows) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$requested = this.getRequested();
      final java.lang.Object other$requested = other.getRequested();
      if (this$requested == null ? other$requested != null : !this$requested.equals(other$requested)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      final java.lang.Object this$statusDetails = this.getStatusDetails();
      final java.lang.Object other$statusDetails = other.getStatusDetails();
      if (this$statusDetails == null ? other$statusDetails != null : !this$statusDetails.equals(other$statusDetails)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancialAccountFeatures.IntraStripeFlows;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $requested = this.getRequested();
      result = result * PRIME + ($requested == null ? 43 : $requested.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      final java.lang.Object $statusDetails = this.getStatusDetails();
      result = result * PRIME + ($statusDetails == null ? 43 : $statusDetails.hashCode());
      return result;
    }
  }


  /**
   * Settings related to Outbound Payments features on a Financial Account.
   */
  public static class OutboundPayments extends StripeObject {
    /**
     * Toggle settings for enabling/disabling an ACH specific feature.
     */
    @SerializedName("ach")
    Ach ach;
    /**
     * Toggle settings for enabling/disabling a feature.
     */
    @SerializedName("us_domestic_wire")
    UsDomesticWire usDomesticWire;


    /**
     * Toggle settings for enabling/disabling an ACH specific feature.
     */
    public static class Ach extends StripeObject {
      /**
       * Whether the FinancialAccount should have the Feature.
       */
      @SerializedName("requested")
      Boolean requested;
      /**
       * Whether the Feature is operational.
       *
       * <p>One of {@code active}, {@code pending}, or {@code restricted}.
       */
      @SerializedName("status")
      String status;
      /**
       * Additional details; includes at least one entry when the status is not {@code active}.
       */
      @SerializedName("status_details")
      List<FinancialAccountFeatures.OutboundPayments.Ach.StatusDetail> statusDetails;


      /**
       * Additional details on the FinancialAccount Features information.
       */
      public static class StatusDetail extends StripeObject {
        /**
         * Represents the reason why the status is {@code pending} or {@code restricted}.
         *
         * <p>One of {@code activating}, {@code capability_not_requested}, {@code
         * financial_account_closed}, {@code rejected_other}, {@code rejected_unsupported_business},
         * {@code requirements_past_due}, {@code requirements_pending_verification}, {@code
         * restricted_by_platform}, or {@code restricted_other}.
         */
        @SerializedName("code")
        String code;
        /**
         * Represents what the user should do, if anything, to activate the Feature.
         *
         * <p>One of {@code contact_stripe}, {@code provide_information}, or {@code
         * remove_restriction}.
         */
        @SerializedName("resolution")
        String resolution;
        /**
         * The {@code platform_restrictions} that are restricting this Feature.
         *
         * <p>One of {@code inbound_flows}, or {@code outbound_flows}.
         */
        @SerializedName("restriction")
        String restriction;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCode() {
          return this.code;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getResolution() {
          return this.resolution;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getRestriction() {
          return this.restriction;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCode(final String code) {
          this.code = code;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setResolution(final String resolution) {
          this.resolution = resolution;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setRestriction(final String restriction) {
          this.restriction = restriction;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof FinancialAccountFeatures.OutboundPayments.Ach.StatusDetail)) return false;
          final FinancialAccountFeatures.OutboundPayments.Ach.StatusDetail other = (FinancialAccountFeatures.OutboundPayments.Ach.StatusDetail) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$code = this.getCode();
          final java.lang.Object other$code = other.getCode();
          if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
          final java.lang.Object this$resolution = this.getResolution();
          final java.lang.Object other$resolution = other.getResolution();
          if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) return false;
          final java.lang.Object this$restriction = this.getRestriction();
          final java.lang.Object other$restriction = other.getRestriction();
          if (this$restriction == null ? other$restriction != null : !this$restriction.equals(other$restriction)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof FinancialAccountFeatures.OutboundPayments.Ach.StatusDetail;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $code = this.getCode();
          result = result * PRIME + ($code == null ? 43 : $code.hashCode());
          final java.lang.Object $resolution = this.getResolution();
          result = result * PRIME + ($resolution == null ? 43 : $resolution.hashCode());
          final java.lang.Object $restriction = this.getRestriction();
          result = result * PRIME + ($restriction == null ? 43 : $restriction.hashCode());
          return result;
        }
      }

      /**
       * Whether the FinancialAccount should have the Feature.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getRequested() {
        return this.requested;
      }

      /**
       * Whether the Feature is operational.
       *
       * <p>One of {@code active}, {@code pending}, or {@code restricted}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getStatus() {
        return this.status;
      }

      /**
       * Additional details; includes at least one entry when the status is not {@code active}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<FinancialAccountFeatures.OutboundPayments.Ach.StatusDetail> getStatusDetails() {
        return this.statusDetails;
      }

      /**
       * Whether the FinancialAccount should have the Feature.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequested(final Boolean requested) {
        this.requested = requested;
      }

      /**
       * Whether the Feature is operational.
       *
       * <p>One of {@code active}, {@code pending}, or {@code restricted}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatus(final String status) {
        this.status = status;
      }

      /**
       * Additional details; includes at least one entry when the status is not {@code active}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatusDetails(final List<FinancialAccountFeatures.OutboundPayments.Ach.StatusDetail> statusDetails) {
        this.statusDetails = statusDetails;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FinancialAccountFeatures.OutboundPayments.Ach)) return false;
        final FinancialAccountFeatures.OutboundPayments.Ach other = (FinancialAccountFeatures.OutboundPayments.Ach) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$requested = this.getRequested();
        final java.lang.Object other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !this$requested.equals(other$requested)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        final java.lang.Object this$statusDetails = this.getStatusDetails();
        final java.lang.Object other$statusDetails = other.getStatusDetails();
        if (this$statusDetails == null ? other$statusDetails != null : !this$statusDetails.equals(other$statusDetails)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FinancialAccountFeatures.OutboundPayments.Ach;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $requested = this.getRequested();
        result = result * PRIME + ($requested == null ? 43 : $requested.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        final java.lang.Object $statusDetails = this.getStatusDetails();
        result = result * PRIME + ($statusDetails == null ? 43 : $statusDetails.hashCode());
        return result;
      }
    }


    /**
     * Toggle settings for enabling/disabling a feature.
     */
    public static class UsDomesticWire extends StripeObject {
      /** Whether the FinancialAccount should have the Feature. */
      @SerializedName("requested")
      Boolean requested;
      /**
       * Whether the Feature is operational.
       *
       * <p>One of {@code active}, {@code pending}, or {@code restricted}.
       */
      @SerializedName("status")
      String status;
      /** Additional details; includes at least one entry when the status is not {@code active}. */
      @SerializedName("status_details")
      List<FinancialAccountFeatures.OutboundPayments.UsDomesticWire.StatusDetail> statusDetails;

      /** Additional details on the FinancialAccount Features information. */
      public static class StatusDetail extends StripeObject {
        /**
         * Represents the reason why the status is {@code pending} or {@code restricted}.
         *
         * <p>One of {@code activating}, {@code capability_not_requested}, {@code
         * financial_account_closed}, {@code rejected_other}, {@code rejected_unsupported_business},
         * {@code requirements_past_due}, {@code requirements_pending_verification}, {@code
         * restricted_by_platform}, or {@code restricted_other}.
         */
        @SerializedName("code")
        String code;
        /**
         * Represents what the user should do, if anything, to activate the Feature.
         *
         * <p>One of {@code contact_stripe}, {@code provide_information}, or {@code
         * remove_restriction}.
         */
        @SerializedName("resolution")
        String resolution;
        /**
         * The {@code platform_restrictions} that are restricting this Feature.
         *
         * <p>One of {@code inbound_flows}, or {@code outbound_flows}.
         */
        @SerializedName("restriction")
        String restriction;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCode() {
          return this.code;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getResolution() {
          return this.resolution;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getRestriction() {
          return this.restriction;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCode(final String code) {
          this.code = code;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setResolution(final String resolution) {
          this.resolution = resolution;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setRestriction(final String restriction) {
          this.restriction = restriction;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof FinancialAccountFeatures.OutboundPayments.UsDomesticWire.StatusDetail)) return false;
          final FinancialAccountFeatures.OutboundPayments.UsDomesticWire.StatusDetail other = (FinancialAccountFeatures.OutboundPayments.UsDomesticWire.StatusDetail) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$code = this.getCode();
          final java.lang.Object other$code = other.getCode();
          if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
          final java.lang.Object this$resolution = this.getResolution();
          final java.lang.Object other$resolution = other.getResolution();
          if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) return false;
          final java.lang.Object this$restriction = this.getRestriction();
          final java.lang.Object other$restriction = other.getRestriction();
          if (this$restriction == null ? other$restriction != null : !this$restriction.equals(other$restriction)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof FinancialAccountFeatures.OutboundPayments.UsDomesticWire.StatusDetail;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $code = this.getCode();
          result = result * PRIME + ($code == null ? 43 : $code.hashCode());
          final java.lang.Object $resolution = this.getResolution();
          result = result * PRIME + ($resolution == null ? 43 : $resolution.hashCode());
          final java.lang.Object $restriction = this.getRestriction();
          result = result * PRIME + ($restriction == null ? 43 : $restriction.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getRequested() {
        return this.requested;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getStatus() {
        return this.status;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<FinancialAccountFeatures.OutboundPayments.UsDomesticWire.StatusDetail> getStatusDetails() {
        return this.statusDetails;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequested(final Boolean requested) {
        this.requested = requested;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatus(final String status) {
        this.status = status;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatusDetails(final List<FinancialAccountFeatures.OutboundPayments.UsDomesticWire.StatusDetail> statusDetails) {
        this.statusDetails = statusDetails;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FinancialAccountFeatures.OutboundPayments.UsDomesticWire)) return false;
        final FinancialAccountFeatures.OutboundPayments.UsDomesticWire other = (FinancialAccountFeatures.OutboundPayments.UsDomesticWire) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$requested = this.getRequested();
        final java.lang.Object other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !this$requested.equals(other$requested)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        final java.lang.Object this$statusDetails = this.getStatusDetails();
        final java.lang.Object other$statusDetails = other.getStatusDetails();
        if (this$statusDetails == null ? other$statusDetails != null : !this$statusDetails.equals(other$statusDetails)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FinancialAccountFeatures.OutboundPayments.UsDomesticWire;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $requested = this.getRequested();
        result = result * PRIME + ($requested == null ? 43 : $requested.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        final java.lang.Object $statusDetails = this.getStatusDetails();
        result = result * PRIME + ($statusDetails == null ? 43 : $statusDetails.hashCode());
        return result;
      }
    }

    /**
     * Toggle settings for enabling/disabling an ACH specific feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Ach getAch() {
      return this.ach;
    }

    /**
     * Toggle settings for enabling/disabling a feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UsDomesticWire getUsDomesticWire() {
      return this.usDomesticWire;
    }

    /**
     * Toggle settings for enabling/disabling an ACH specific feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAch(final Ach ach) {
      this.ach = ach;
    }

    /**
     * Toggle settings for enabling/disabling a feature.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsDomesticWire(final UsDomesticWire usDomesticWire) {
      this.usDomesticWire = usDomesticWire;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancialAccountFeatures.OutboundPayments)) return false;
      final FinancialAccountFeatures.OutboundPayments other = (FinancialAccountFeatures.OutboundPayments) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$ach = this.getAch();
      final java.lang.Object other$ach = other.getAch();
      if (this$ach == null ? other$ach != null : !this$ach.equals(other$ach)) return false;
      final java.lang.Object this$usDomesticWire = this.getUsDomesticWire();
      final java.lang.Object other$usDomesticWire = other.getUsDomesticWire();
      if (this$usDomesticWire == null ? other$usDomesticWire != null : !this$usDomesticWire.equals(other$usDomesticWire)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancialAccountFeatures.OutboundPayments;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $ach = this.getAch();
      result = result * PRIME + ($ach == null ? 43 : $ach.hashCode());
      final java.lang.Object $usDomesticWire = this.getUsDomesticWire();
      result = result * PRIME + ($usDomesticWire == null ? 43 : $usDomesticWire.hashCode());
      return result;
    }
  }


  /**
   * OutboundTransfers contains outbound transfers features for a FinancialAccount.
   */
  public static class OutboundTransfers extends StripeObject {
    /** Toggle settings for enabling/disabling an ACH specific feature. */
    @SerializedName("ach")
    Ach ach;
    /** Toggle settings for enabling/disabling a feature. */
    @SerializedName("us_domestic_wire")
    UsDomesticWire usDomesticWire;

    /** Toggle settings for enabling/disabling an ACH specific feature. */
    public static class Ach extends StripeObject {
      /** Whether the FinancialAccount should have the Feature. */
      @SerializedName("requested")
      Boolean requested;
      /**
       * Whether the Feature is operational.
       *
       * <p>One of {@code active}, {@code pending}, or {@code restricted}.
       */
      @SerializedName("status")
      String status;
      /** Additional details; includes at least one entry when the status is not {@code active}. */
      @SerializedName("status_details")
      List<FinancialAccountFeatures.OutboundTransfers.Ach.StatusDetail> statusDetails;

      /** Additional details on the FinancialAccount Features information. */
      public static class StatusDetail extends StripeObject {
        /**
         * Represents the reason why the status is {@code pending} or {@code restricted}.
         *
         * <p>One of {@code activating}, {@code capability_not_requested}, {@code
         * financial_account_closed}, {@code rejected_other}, {@code rejected_unsupported_business},
         * {@code requirements_past_due}, {@code requirements_pending_verification}, {@code
         * restricted_by_platform}, or {@code restricted_other}.
         */
        @SerializedName("code")
        String code;
        /**
         * Represents what the user should do, if anything, to activate the Feature.
         *
         * <p>One of {@code contact_stripe}, {@code provide_information}, or {@code
         * remove_restriction}.
         */
        @SerializedName("resolution")
        String resolution;
        /**
         * The {@code platform_restrictions} that are restricting this Feature.
         *
         * <p>One of {@code inbound_flows}, or {@code outbound_flows}.
         */
        @SerializedName("restriction")
        String restriction;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCode() {
          return this.code;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getResolution() {
          return this.resolution;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getRestriction() {
          return this.restriction;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCode(final String code) {
          this.code = code;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setResolution(final String resolution) {
          this.resolution = resolution;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setRestriction(final String restriction) {
          this.restriction = restriction;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof FinancialAccountFeatures.OutboundTransfers.Ach.StatusDetail)) return false;
          final FinancialAccountFeatures.OutboundTransfers.Ach.StatusDetail other = (FinancialAccountFeatures.OutboundTransfers.Ach.StatusDetail) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$code = this.getCode();
          final java.lang.Object other$code = other.getCode();
          if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
          final java.lang.Object this$resolution = this.getResolution();
          final java.lang.Object other$resolution = other.getResolution();
          if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) return false;
          final java.lang.Object this$restriction = this.getRestriction();
          final java.lang.Object other$restriction = other.getRestriction();
          if (this$restriction == null ? other$restriction != null : !this$restriction.equals(other$restriction)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof FinancialAccountFeatures.OutboundTransfers.Ach.StatusDetail;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $code = this.getCode();
          result = result * PRIME + ($code == null ? 43 : $code.hashCode());
          final java.lang.Object $resolution = this.getResolution();
          result = result * PRIME + ($resolution == null ? 43 : $resolution.hashCode());
          final java.lang.Object $restriction = this.getRestriction();
          result = result * PRIME + ($restriction == null ? 43 : $restriction.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getRequested() {
        return this.requested;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getStatus() {
        return this.status;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<FinancialAccountFeatures.OutboundTransfers.Ach.StatusDetail> getStatusDetails() {
        return this.statusDetails;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequested(final Boolean requested) {
        this.requested = requested;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatus(final String status) {
        this.status = status;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatusDetails(final List<FinancialAccountFeatures.OutboundTransfers.Ach.StatusDetail> statusDetails) {
        this.statusDetails = statusDetails;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FinancialAccountFeatures.OutboundTransfers.Ach)) return false;
        final FinancialAccountFeatures.OutboundTransfers.Ach other = (FinancialAccountFeatures.OutboundTransfers.Ach) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$requested = this.getRequested();
        final java.lang.Object other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !this$requested.equals(other$requested)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        final java.lang.Object this$statusDetails = this.getStatusDetails();
        final java.lang.Object other$statusDetails = other.getStatusDetails();
        if (this$statusDetails == null ? other$statusDetails != null : !this$statusDetails.equals(other$statusDetails)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FinancialAccountFeatures.OutboundTransfers.Ach;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $requested = this.getRequested();
        result = result * PRIME + ($requested == null ? 43 : $requested.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        final java.lang.Object $statusDetails = this.getStatusDetails();
        result = result * PRIME + ($statusDetails == null ? 43 : $statusDetails.hashCode());
        return result;
      }
    }

    /** Toggle settings for enabling/disabling a feature. */
    public static class UsDomesticWire extends StripeObject {
      /** Whether the FinancialAccount should have the Feature. */
      @SerializedName("requested")
      Boolean requested;
      /**
       * Whether the Feature is operational.
       *
       * <p>One of {@code active}, {@code pending}, or {@code restricted}.
       */
      @SerializedName("status")
      String status;
      /** Additional details; includes at least one entry when the status is not {@code active}. */
      @SerializedName("status_details")
      List<FinancialAccountFeatures.OutboundTransfers.UsDomesticWire.StatusDetail> statusDetails;

      /** Additional details on the FinancialAccount Features information. */
      public static class StatusDetail extends StripeObject {
        /**
         * Represents the reason why the status is {@code pending} or {@code restricted}.
         *
         * <p>One of {@code activating}, {@code capability_not_requested}, {@code
         * financial_account_closed}, {@code rejected_other}, {@code rejected_unsupported_business},
         * {@code requirements_past_due}, {@code requirements_pending_verification}, {@code
         * restricted_by_platform}, or {@code restricted_other}.
         */
        @SerializedName("code")
        String code;
        /**
         * Represents what the user should do, if anything, to activate the Feature.
         *
         * <p>One of {@code contact_stripe}, {@code provide_information}, or {@code
         * remove_restriction}.
         */
        @SerializedName("resolution")
        String resolution;
        /**
         * The {@code platform_restrictions} that are restricting this Feature.
         *
         * <p>One of {@code inbound_flows}, or {@code outbound_flows}.
         */
        @SerializedName("restriction")
        String restriction;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCode() {
          return this.code;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getResolution() {
          return this.resolution;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getRestriction() {
          return this.restriction;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCode(final String code) {
          this.code = code;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setResolution(final String resolution) {
          this.resolution = resolution;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setRestriction(final String restriction) {
          this.restriction = restriction;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof FinancialAccountFeatures.OutboundTransfers.UsDomesticWire.StatusDetail)) return false;
          final FinancialAccountFeatures.OutboundTransfers.UsDomesticWire.StatusDetail other = (FinancialAccountFeatures.OutboundTransfers.UsDomesticWire.StatusDetail) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$code = this.getCode();
          final java.lang.Object other$code = other.getCode();
          if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
          final java.lang.Object this$resolution = this.getResolution();
          final java.lang.Object other$resolution = other.getResolution();
          if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) return false;
          final java.lang.Object this$restriction = this.getRestriction();
          final java.lang.Object other$restriction = other.getRestriction();
          if (this$restriction == null ? other$restriction != null : !this$restriction.equals(other$restriction)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof FinancialAccountFeatures.OutboundTransfers.UsDomesticWire.StatusDetail;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $code = this.getCode();
          result = result * PRIME + ($code == null ? 43 : $code.hashCode());
          final java.lang.Object $resolution = this.getResolution();
          result = result * PRIME + ($resolution == null ? 43 : $resolution.hashCode());
          final java.lang.Object $restriction = this.getRestriction();
          result = result * PRIME + ($restriction == null ? 43 : $restriction.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getRequested() {
        return this.requested;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getStatus() {
        return this.status;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<FinancialAccountFeatures.OutboundTransfers.UsDomesticWire.StatusDetail> getStatusDetails() {
        return this.statusDetails;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequested(final Boolean requested) {
        this.requested = requested;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatus(final String status) {
        this.status = status;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatusDetails(final List<FinancialAccountFeatures.OutboundTransfers.UsDomesticWire.StatusDetail> statusDetails) {
        this.statusDetails = statusDetails;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FinancialAccountFeatures.OutboundTransfers.UsDomesticWire)) return false;
        final FinancialAccountFeatures.OutboundTransfers.UsDomesticWire other = (FinancialAccountFeatures.OutboundTransfers.UsDomesticWire) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$requested = this.getRequested();
        final java.lang.Object other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !this$requested.equals(other$requested)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        final java.lang.Object this$statusDetails = this.getStatusDetails();
        final java.lang.Object other$statusDetails = other.getStatusDetails();
        if (this$statusDetails == null ? other$statusDetails != null : !this$statusDetails.equals(other$statusDetails)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FinancialAccountFeatures.OutboundTransfers.UsDomesticWire;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $requested = this.getRequested();
        result = result * PRIME + ($requested == null ? 43 : $requested.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        final java.lang.Object $statusDetails = this.getStatusDetails();
        result = result * PRIME + ($statusDetails == null ? 43 : $statusDetails.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Ach getAch() {
      return this.ach;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UsDomesticWire getUsDomesticWire() {
      return this.usDomesticWire;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAch(final Ach ach) {
      this.ach = ach;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsDomesticWire(final UsDomesticWire usDomesticWire) {
      this.usDomesticWire = usDomesticWire;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancialAccountFeatures.OutboundTransfers)) return false;
      final FinancialAccountFeatures.OutboundTransfers other = (FinancialAccountFeatures.OutboundTransfers) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$ach = this.getAch();
      final java.lang.Object other$ach = other.getAch();
      if (this$ach == null ? other$ach != null : !this$ach.equals(other$ach)) return false;
      final java.lang.Object this$usDomesticWire = this.getUsDomesticWire();
      final java.lang.Object other$usDomesticWire = other.getUsDomesticWire();
      if (this$usDomesticWire == null ? other$usDomesticWire != null : !this$usDomesticWire.equals(other$usDomesticWire)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancialAccountFeatures.OutboundTransfers;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $ach = this.getAch();
      result = result * PRIME + ($ach == null ? 43 : $ach.hashCode());
      final java.lang.Object $usDomesticWire = this.getUsDomesticWire();
      result = result * PRIME + ($usDomesticWire == null ? 43 : $usDomesticWire.hashCode());
      return result;
    }
  }

  /**
   * Toggle settings for enabling/disabling a feature.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CardIssuing getCardIssuing() {
    return this.cardIssuing;
  }

  /**
   * Toggle settings for enabling/disabling a feature.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DepositInsurance getDepositInsurance() {
    return this.depositInsurance;
  }

  /**
   * Settings related to Financial Addresses features on a Financial Account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FinancialAddresses getFinancialAddresses() {
    return this.financialAddresses;
  }

  /**
   * InboundTransfers contains inbound transfers features for a FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public InboundTransfers getInboundTransfers() {
    return this.inboundTransfers;
  }

  /**
   * Toggle settings for enabling/disabling a feature.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public IntraStripeFlows getIntraStripeFlows() {
    return this.intraStripeFlows;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.financial_account_features}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Settings related to Outbound Payments features on a Financial Account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public OutboundPayments getOutboundPayments() {
    return this.outboundPayments;
  }

  /**
   * OutboundTransfers contains outbound transfers features for a FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public OutboundTransfers getOutboundTransfers() {
    return this.outboundTransfers;
  }

  /**
   * Toggle settings for enabling/disabling a feature.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCardIssuing(final CardIssuing cardIssuing) {
    this.cardIssuing = cardIssuing;
  }

  /**
   * Toggle settings for enabling/disabling a feature.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDepositInsurance(final DepositInsurance depositInsurance) {
    this.depositInsurance = depositInsurance;
  }

  /**
   * Settings related to Financial Addresses features on a Financial Account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinancialAddresses(final FinancialAddresses financialAddresses) {
    this.financialAddresses = financialAddresses;
  }

  /**
   * InboundTransfers contains inbound transfers features for a FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInboundTransfers(final InboundTransfers inboundTransfers) {
    this.inboundTransfers = inboundTransfers;
  }

  /**
   * Toggle settings for enabling/disabling a feature.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIntraStripeFlows(final IntraStripeFlows intraStripeFlows) {
    this.intraStripeFlows = intraStripeFlows;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.financial_account_features}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Settings related to Outbound Payments features on a Financial Account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutboundPayments(final OutboundPayments outboundPayments) {
    this.outboundPayments = outboundPayments;
  }

  /**
   * OutboundTransfers contains outbound transfers features for a FinancialAccount.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutboundTransfers(final OutboundTransfers outboundTransfers) {
    this.outboundTransfers = outboundTransfers;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof FinancialAccountFeatures)) return false;
    final FinancialAccountFeatures other = (FinancialAccountFeatures) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$cardIssuing = this.getCardIssuing();
    final java.lang.Object other$cardIssuing = other.getCardIssuing();
    if (this$cardIssuing == null ? other$cardIssuing != null : !this$cardIssuing.equals(other$cardIssuing)) return false;
    final java.lang.Object this$depositInsurance = this.getDepositInsurance();
    final java.lang.Object other$depositInsurance = other.getDepositInsurance();
    if (this$depositInsurance == null ? other$depositInsurance != null : !this$depositInsurance.equals(other$depositInsurance)) return false;
    final java.lang.Object this$financialAddresses = this.getFinancialAddresses();
    final java.lang.Object other$financialAddresses = other.getFinancialAddresses();
    if (this$financialAddresses == null ? other$financialAddresses != null : !this$financialAddresses.equals(other$financialAddresses)) return false;
    final java.lang.Object this$inboundTransfers = this.getInboundTransfers();
    final java.lang.Object other$inboundTransfers = other.getInboundTransfers();
    if (this$inboundTransfers == null ? other$inboundTransfers != null : !this$inboundTransfers.equals(other$inboundTransfers)) return false;
    final java.lang.Object this$intraStripeFlows = this.getIntraStripeFlows();
    final java.lang.Object other$intraStripeFlows = other.getIntraStripeFlows();
    if (this$intraStripeFlows == null ? other$intraStripeFlows != null : !this$intraStripeFlows.equals(other$intraStripeFlows)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$outboundPayments = this.getOutboundPayments();
    final java.lang.Object other$outboundPayments = other.getOutboundPayments();
    if (this$outboundPayments == null ? other$outboundPayments != null : !this$outboundPayments.equals(other$outboundPayments)) return false;
    final java.lang.Object this$outboundTransfers = this.getOutboundTransfers();
    final java.lang.Object other$outboundTransfers = other.getOutboundTransfers();
    if (this$outboundTransfers == null ? other$outboundTransfers != null : !this$outboundTransfers.equals(other$outboundTransfers)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof FinancialAccountFeatures;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $cardIssuing = this.getCardIssuing();
    result = result * PRIME + ($cardIssuing == null ? 43 : $cardIssuing.hashCode());
    final java.lang.Object $depositInsurance = this.getDepositInsurance();
    result = result * PRIME + ($depositInsurance == null ? 43 : $depositInsurance.hashCode());
    final java.lang.Object $financialAddresses = this.getFinancialAddresses();
    result = result * PRIME + ($financialAddresses == null ? 43 : $financialAddresses.hashCode());
    final java.lang.Object $inboundTransfers = this.getInboundTransfers();
    result = result * PRIME + ($inboundTransfers == null ? 43 : $inboundTransfers.hashCode());
    final java.lang.Object $intraStripeFlows = this.getIntraStripeFlows();
    result = result * PRIME + ($intraStripeFlows == null ? 43 : $intraStripeFlows.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $outboundPayments = this.getOutboundPayments();
    result = result * PRIME + ($outboundPayments == null ? 43 : $outboundPayments.hashCode());
    final java.lang.Object $outboundTransfers = this.getOutboundTransfers();
    result = result * PRIME + ($outboundTransfers == null ? 43 : $outboundTransfers.hashCode());
    return result;
  }
}
