// Generated by delombok at Thu Dec 08 23:17:07 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.EphemeralKeyCreateParams;
import com.stripe.param.EphemeralKeyDeleteParams;
import java.util.Map;

public class EphemeralKey extends ApiResource implements HasId {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Time at which the key will expire. Measured in seconds since the Unix epoch.
   */
  @SerializedName("expires")
  Long expires;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code ephemeral_key}.
   */
  @SerializedName("object")
  String object;
  /**
   * The key's secret. You can use this value to make authorized requests to the Stripe API.
   */
  @SerializedName("secret")
  String secret;
  transient String rawJson;

  /**
   * Creates a short-lived API key for a given resource.
   */
  public static EphemeralKey create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a short-lived API key for a given resource.
   */
  public static EphemeralKey create(EphemeralKeyCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Invalidates a short-lived API key for a given resource.
   */
  public EphemeralKey delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Invalidates a short-lived API key for a given resource.
   */
  public EphemeralKey delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * Invalidates a short-lived API key for a given resource.
   */
  public EphemeralKey delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Invalidates a short-lived API key for a given resource.
   */
  public EphemeralKey delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/ephemeral_keys/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, EphemeralKey.class, options);
  }

  /**
   * Invalidates a short-lived API key for a given resource.
   */
  public EphemeralKey delete(EphemeralKeyDeleteParams params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Invalidates a short-lived API key for a given resource.
   */
  public EphemeralKey delete(EphemeralKeyDeleteParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/ephemeral_keys/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, EphemeralKey.class, options);
  }

  /**
   * Creates a short-lived API key for a given resource.
   */
  public static EphemeralKey create(Map<String, Object> params, RequestOptions options) throws StripeException {
    final String versionOverride;
    if (!params.containsKey("stripe-version")) {
      throw new IllegalArgumentException("`stripe-version` must be explicitly specified in " + "`params` as the stripe version of your mobile client.");
    }
    try {
      versionOverride = (String) params.get("stripe-version");
    } catch (ClassCastException e) {
      throw new IllegalArgumentException("`stripe-version` must be explicitly specified in " + "`params` as a string");
    }
    if (options == null) {
      options = RequestOptions.getDefault();
    }
    // Take "stripe-version" from params and plug it into RequestOptions
    // so it will be sent in the Stripe-Version header
    final RequestOptions overriddenOptions = com.stripe.net.RequestOptions.RequestOptionsBuilder.unsafeSetStripeVersionOverride(options.toBuilderFullCopy(), versionOverride).build();
    // Remove "stripe-version" from params so that it is not sent in the
    // request body.
    final Map<String, Object> overriddenParams = new java.util.HashMap<String, Object>(params);
    overriddenParams.remove("stripe-version");
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/ephemeral_keys");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, overriddenParams, EphemeralKey.class, overriddenOptions);
  }

  /**
   * Creates a short-lived API key for a given resource.
   */
  public static EphemeralKey create(EphemeralKeyCreateParams params, RequestOptions options) throws StripeException {
    checkNullTypedParams("/v1/ephemeral_keys", params);
    Map<String, Object> paramMap = params.toMap();
    if (!paramMap.containsKey("stripe-version")) {
      throw new IllegalArgumentException("You must .setStripeVersion on EphemeralKeyCreateParams.builder() with" + " the stripe version of your mobile client.");
    }
    return create(paramMap, options);
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Time at which the key will expire. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getExpires() {
    return this.expires;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code ephemeral_key}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The key's secret. You can use this value to make authorized requests to the Stripe API.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSecret() {
    return this.secret;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRawJson() {
    return this.rawJson;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Time at which the key will expire. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExpires(final Long expires) {
    this.expires = expires;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code ephemeral_key}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The key's secret. You can use this value to make authorized requests to the Stripe API.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSecret(final String secret) {
    this.secret = secret;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRawJson(final String rawJson) {
    this.rawJson = rawJson;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof EphemeralKey)) return false;
    final EphemeralKey other = (EphemeralKey) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$expires = this.getExpires();
    final java.lang.Object other$expires = other.getExpires();
    if (this$expires == null ? other$expires != null : !this$expires.equals(other$expires)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$secret = this.getSecret();
    final java.lang.Object other$secret = other.getSecret();
    if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof EphemeralKey;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $expires = this.getExpires();
    result = result * PRIME + ($expires == null ? 43 : $expires.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $secret = this.getSecret();
    result = result * PRIME + ($secret == null ? 43 : $secret.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
