// Generated by delombok at Thu Sep 22 21:16:35 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.financialconnections;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.financialconnections.SessionCreateParams;
import com.stripe.param.financialconnections.SessionRetrieveParams;
import java.util.List;
import java.util.Map;

/**
 * A Financial Connections Session is the secure way to programmatically launch the client-side
 * Stripe.js modal that lets your users link their accounts.
 */
public class Session extends ApiResource implements HasId {
  /**
   * The account holder for whom accounts are collected in this session.
   */
  @SerializedName("account_holder")
  AccountHolder accountHolder;
  /**
   * The accounts that were collected as part of this Session.
   */
  @SerializedName("accounts")
  AccountCollection accounts;
  /**
   * A value that will be passed to the client to launch the authentication flow.
   */
  @SerializedName("client_secret")
  String clientSecret;
  @SerializedName("filters")
  Filters filters;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code financial_connections.session}.
   */
  @SerializedName("object")
  String object;
  /**
   * Permissions requested for accounts collected during this session.
   */
  @SerializedName("permissions")
  List<String> permissions;
  /**
   * For webview integrations only. Upon completing OAuth login in the native browser, the user will
   * be redirected to this URL to return to your app.
   */
  @SerializedName("return_url")
  String returnUrl;

  /**
   * To launch the Financial Connections authorization flow, create a <code>Session</code>. The
   * session’s <code>client_secret</code> can be used to launch the flow using Stripe.js.
   */
  public static Session create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * To launch the Financial Connections authorization flow, create a <code>Session</code>. The
   * session’s <code>client_secret</code> can be used to launch the flow using Stripe.js.
   */
  public static Session create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/financial_connections/sessions");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
  }

  /**
   * To launch the Financial Connections authorization flow, create a <code>Session</code>. The
   * session’s <code>client_secret</code> can be used to launch the flow using Stripe.js.
   */
  public static Session create(SessionCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * To launch the Financial Connections authorization flow, create a <code>Session</code>. The
   * session’s <code>client_secret</code> can be used to launch the flow using Stripe.js.
   */
  public static Session create(SessionCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/financial_connections/sessions");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
  }

  /**
   * Retrieves the details of a Financial Connections <code>Session</code>.
   */
  public static Session retrieve(String session) throws StripeException {
    return retrieve(session, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of a Financial Connections <code>Session</code>.
   */
  public static Session retrieve(String session, RequestOptions options) throws StripeException {
    return retrieve(session, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of a Financial Connections <code>Session</code>.
   */
  public static Session retrieve(String session, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/financial_connections/sessions/%s", ApiResource.urlEncodeId(session)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Session.class, options);
  }

  /**
   * Retrieves the details of a Financial Connections <code>Session</code>.
   */
  public static Session retrieve(String session, SessionRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/financial_connections/sessions/%s", ApiResource.urlEncodeId(session)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Session.class, options);
  }


  public static class AccountHolder extends StripeObject {
    /**
     * The ID of the Stripe account this account belongs to. Should only be present if {@code
     * account_holder.type} is {@code account}.
     */
    @SerializedName("account")
    ExpandableField<Account> account;
    /**
     * ID of the Stripe customer this account belongs to. Present if and only if {@code
     * account_holder.type} is {@code customer}.
     */
    @SerializedName("customer")
    ExpandableField<Customer> customer;
    /**
     * Type of account holder that this account belongs to.
     *
     * <p>One of {@code account}, or {@code customer}.
     */
    @SerializedName("type")
    String type;

    /**
     * Get ID of expandable {@code account} object.
     */
    public String getAccount() {
      return (this.account != null) ? this.account.getId() : null;
    }

    public void setAccount(String id) {
      this.account = ApiResource.setExpandableFieldId(id, this.account);
    }

    /**
     * Get expanded {@code account}.
     */
    public Account getAccountObject() {
      return (this.account != null) ? this.account.getExpanded() : null;
    }

    public void setAccountObject(Account expandableObject) {
      this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code customer} object.
     */
    public String getCustomer() {
      return (this.customer != null) ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
      this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    /**
     * Get expanded {@code customer}.
     */
    public Customer getCustomerObject() {
      return (this.customer != null) ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
      this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    /**
     * Type of account holder that this account belongs to.
     *
     * <p>One of {@code account}, or {@code customer}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * Type of account holder that this account belongs to.
     *
     * <p>One of {@code account}, or {@code customer}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Session.AccountHolder)) return false;
      final Session.AccountHolder other = (Session.AccountHolder) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$account = this.getAccount();
      final java.lang.Object other$account = other.getAccount();
      if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
      final java.lang.Object this$customer = this.getCustomer();
      final java.lang.Object other$customer = other.getCustomer();
      if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Session.AccountHolder;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $account = this.getAccount();
      result = result * PRIME + ($account == null ? 43 : $account.hashCode());
      final java.lang.Object $customer = this.getCustomer();
      result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  public static class Filters extends StripeObject {
    /** List of countries from which to filter accounts. */
    @SerializedName("countries")
    List<String> countries;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getCountries() {
      return this.countries;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountries(final List<String> countries) {
      this.countries = countries;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Session.Filters)) return false;
      final Session.Filters other = (Session.Filters) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$countries = this.getCountries();
      final java.lang.Object other$countries = other.getCountries();
      if (this$countries == null ? other$countries != null : !this$countries.equals(other$countries)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Session.Filters;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $countries = this.getCountries();
      result = result * PRIME + ($countries == null ? 43 : $countries.hashCode());
      return result;
    }
  }

  /**
   * The account holder for whom accounts are collected in this session.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AccountHolder getAccountHolder() {
    return this.accountHolder;
  }

  /**
   * The accounts that were collected as part of this Session.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AccountCollection getAccounts() {
    return this.accounts;
  }

  /**
   * A value that will be passed to the client to launch the authentication flow.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getClientSecret() {
    return this.clientSecret;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Filters getFilters() {
    return this.filters;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code financial_connections.session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Permissions requested for accounts collected during this session.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getPermissions() {
    return this.permissions;
  }

  /**
   * For webview integrations only. Upon completing OAuth login in the native browser, the user will
   * be redirected to this URL to return to your app.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReturnUrl() {
    return this.returnUrl;
  }

  /**
   * The account holder for whom accounts are collected in this session.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccountHolder(final AccountHolder accountHolder) {
    this.accountHolder = accountHolder;
  }

  /**
   * The accounts that were collected as part of this Session.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccounts(final AccountCollection accounts) {
    this.accounts = accounts;
  }

  /**
   * A value that will be passed to the client to launch the authentication flow.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setClientSecret(final String clientSecret) {
    this.clientSecret = clientSecret;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFilters(final Filters filters) {
    this.filters = filters;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code financial_connections.session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Permissions requested for accounts collected during this session.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPermissions(final List<String> permissions) {
    this.permissions = permissions;
  }

  /**
   * For webview integrations only. Upon completing OAuth login in the native browser, the user will
   * be redirected to this URL to return to your app.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReturnUrl(final String returnUrl) {
    this.returnUrl = returnUrl;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Session)) return false;
    final Session other = (Session) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$accountHolder = this.getAccountHolder();
    final java.lang.Object other$accountHolder = other.getAccountHolder();
    if (this$accountHolder == null ? other$accountHolder != null : !this$accountHolder.equals(other$accountHolder)) return false;
    final java.lang.Object this$accounts = this.getAccounts();
    final java.lang.Object other$accounts = other.getAccounts();
    if (this$accounts == null ? other$accounts != null : !this$accounts.equals(other$accounts)) return false;
    final java.lang.Object this$clientSecret = this.getClientSecret();
    final java.lang.Object other$clientSecret = other.getClientSecret();
    if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) return false;
    final java.lang.Object this$filters = this.getFilters();
    final java.lang.Object other$filters = other.getFilters();
    if (this$filters == null ? other$filters != null : !this$filters.equals(other$filters)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$permissions = this.getPermissions();
    final java.lang.Object other$permissions = other.getPermissions();
    if (this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions)) return false;
    final java.lang.Object this$returnUrl = this.getReturnUrl();
    final java.lang.Object other$returnUrl = other.getReturnUrl();
    if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Session;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $accountHolder = this.getAccountHolder();
    result = result * PRIME + ($accountHolder == null ? 43 : $accountHolder.hashCode());
    final java.lang.Object $accounts = this.getAccounts();
    result = result * PRIME + ($accounts == null ? 43 : $accounts.hashCode());
    final java.lang.Object $clientSecret = this.getClientSecret();
    result = result * PRIME + ($clientSecret == null ? 43 : $clientSecret.hashCode());
    final java.lang.Object $filters = this.getFilters();
    result = result * PRIME + ($filters == null ? 43 : $filters.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $permissions = this.getPermissions();
    result = result * PRIME + ($permissions == null ? 43 : $permissions.hashCode());
    final java.lang.Object $returnUrl = this.getReturnUrl();
    result = result * PRIME + ($returnUrl == null ? 43 : $returnUrl.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
