/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class AccountCreateParams
extends ApiRequestParams {
    @SerializedName(value="account_token")
    String accountToken;
    @SerializedName(value="business_profile")
    BusinessProfile businessProfile;
    @SerializedName(value="business_type")
    Object businessType;
    @SerializedName(value="capabilities")
    Capabilities capabilities;
    @SerializedName(value="company")
    Company company;
    @SerializedName(value="country")
    String country;
    @SerializedName(value="default_currency")
    String defaultCurrency;
    @SerializedName(value="email")
    String email;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="external_account")
    String externalAccount;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="individual")
    Individual individual;
    @SerializedName(value="metadata")
    Object metadata;
    @SerializedName(value="settings")
    Settings settings;
    @SerializedName(value="tos_acceptance")
    TosAcceptance tosAcceptance;
    @SerializedName(value="type")
    Type type;

    private AccountCreateParams(String accountToken, BusinessProfile businessProfile, Object businessType, Capabilities capabilities, Company company, String country, String defaultCurrency, String email, List<String> expand, String externalAccount, Map<String, Object> extraParams, Individual individual, Object metadata, Settings settings, TosAcceptance tosAcceptance, Type type) {
        this.accountToken = accountToken;
        this.businessProfile = businessProfile;
        this.businessType = businessType;
        this.capabilities = capabilities;
        this.company = company;
        this.country = country;
        this.defaultCurrency = defaultCurrency;
        this.email = email;
        this.expand = expand;
        this.externalAccount = externalAccount;
        this.extraParams = extraParams;
        this.individual = individual;
        this.metadata = metadata;
        this.settings = settings;
        this.tosAcceptance = tosAcceptance;
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String getAccountToken() {
        return this.accountToken;
    }

    @Generated
    public BusinessProfile getBusinessProfile() {
        return this.businessProfile;
    }

    @Generated
    public Object getBusinessType() {
        return this.businessType;
    }

    @Generated
    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    @Generated
    public Company getCompany() {
        return this.company;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public String getExternalAccount() {
        return this.externalAccount;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public Individual getIndividual() {
        return this.individual;
    }

    @Generated
    public Object getMetadata() {
        return this.metadata;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public TosAcceptance getTosAcceptance() {
        return this.tosAcceptance;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    public static enum Type implements ApiRequestParams.EnumParam
    {
        CUSTOM("custom"),
        EXPRESS("express"),
        STANDARD("standard");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum BusinessType implements ApiRequestParams.EnumParam
    {
        COMPANY("company"),
        GOVERNMENT_ENTITY("government_entity"),
        INDIVIDUAL("individual"),
        NON_PROFIT("non_profit");

        private final String value;

        private BusinessType(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class TosAcceptance {
        @SerializedName(value="date")
        Long date;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="ip")
        String ip;
        @SerializedName(value="service_agreement")
        String serviceAgreement;
        @SerializedName(value="user_agent")
        String userAgent;

        private TosAcceptance(Long date, Map<String, Object> extraParams, String ip, String serviceAgreement, String userAgent) {
            this.date = date;
            this.extraParams = extraParams;
            this.ip = ip;
            this.serviceAgreement = serviceAgreement;
            this.userAgent = userAgent;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getDate() {
            return this.date;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getIp() {
            return this.ip;
        }

        @Generated
        public String getServiceAgreement() {
            return this.serviceAgreement;
        }

        @Generated
        public String getUserAgent() {
            return this.userAgent;
        }

        public static class Builder {
            private Long date;
            private Map<String, Object> extraParams;
            private String ip;
            private String serviceAgreement;
            private String userAgent;

            public TosAcceptance build() {
                return new TosAcceptance(this.date, this.extraParams, this.ip, this.serviceAgreement, this.userAgent);
            }

            public Builder setDate(Long date) {
                this.date = date;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setIp(String ip) {
                this.ip = ip;
                return this;
            }

            public Builder setServiceAgreement(String serviceAgreement) {
                this.serviceAgreement = serviceAgreement;
                return this;
            }

            public Builder setUserAgent(String userAgent) {
                this.userAgent = userAgent;
                return this;
            }
        }
    }

    public static class Settings {
        @SerializedName(value="branding")
        Branding branding;
        @SerializedName(value="card_payments")
        CardPayments cardPayments;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="payments")
        Payments payments;
        @SerializedName(value="payouts")
        Payouts payouts;

        private Settings(Branding branding, CardPayments cardPayments, Map<String, Object> extraParams, Payments payments, Payouts payouts) {
            this.branding = branding;
            this.cardPayments = cardPayments;
            this.extraParams = extraParams;
            this.payments = payments;
            this.payouts = payouts;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Branding getBranding() {
            return this.branding;
        }

        @Generated
        public CardPayments getCardPayments() {
            return this.cardPayments;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Payments getPayments() {
            return this.payments;
        }

        @Generated
        public Payouts getPayouts() {
            return this.payouts;
        }

        public static class Payouts {
            @SerializedName(value="debit_negative_balances")
            Boolean debitNegativeBalances;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="schedule")
            Schedule schedule;
            @SerializedName(value="statement_descriptor")
            String statementDescriptor;

            private Payouts(Boolean debitNegativeBalances, Map<String, Object> extraParams, Schedule schedule, String statementDescriptor) {
                this.debitNegativeBalances = debitNegativeBalances;
                this.extraParams = extraParams;
                this.schedule = schedule;
                this.statementDescriptor = statementDescriptor;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Boolean getDebitNegativeBalances() {
                return this.debitNegativeBalances;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Schedule getSchedule() {
                return this.schedule;
            }

            @Generated
            public String getStatementDescriptor() {
                return this.statementDescriptor;
            }

            public static class Schedule {
                @SerializedName(value="delay_days")
                Object delayDays;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval")
                Interval interval;
                @SerializedName(value="monthly_anchor")
                Long monthlyAnchor;
                @SerializedName(value="weekly_anchor")
                WeeklyAnchor weeklyAnchor;

                private Schedule(Object delayDays, Map<String, Object> extraParams, Interval interval, Long monthlyAnchor, WeeklyAnchor weeklyAnchor) {
                    this.delayDays = delayDays;
                    this.extraParams = extraParams;
                    this.interval = interval;
                    this.monthlyAnchor = monthlyAnchor;
                    this.weeklyAnchor = weeklyAnchor;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getDelayDays() {
                    return this.delayDays;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Interval getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getMonthlyAnchor() {
                    return this.monthlyAnchor;
                }

                @Generated
                public WeeklyAnchor getWeeklyAnchor() {
                    return this.weeklyAnchor;
                }

                public static enum WeeklyAnchor implements ApiRequestParams.EnumParam
                {
                    FRIDAY("friday"),
                    MONDAY("monday"),
                    SATURDAY("saturday"),
                    SUNDAY("sunday"),
                    THURSDAY("thursday"),
                    TUESDAY("tuesday"),
                    WEDNESDAY("wednesday");

                    private final String value;

                    private WeeklyAnchor(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAILY("daily"),
                    MANUAL("manual"),
                    MONTHLY("monthly"),
                    WEEKLY("weekly");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum DelayDays implements ApiRequestParams.EnumParam
                {
                    MINIMUM("minimum");

                    private final String value;

                    private DelayDays(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Object delayDays;
                    private Map<String, Object> extraParams;
                    private Interval interval;
                    private Long monthlyAnchor;
                    private WeeklyAnchor weeklyAnchor;

                    public Schedule build() {
                        return new Schedule(this.delayDays, this.extraParams, this.interval, this.monthlyAnchor, this.weeklyAnchor);
                    }

                    public Builder setDelayDays(DelayDays delayDays) {
                        this.delayDays = delayDays;
                        return this;
                    }

                    public Builder setDelayDays(Long delayDays) {
                        this.delayDays = delayDays;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }

                    public Builder setMonthlyAnchor(Long monthlyAnchor) {
                        this.monthlyAnchor = monthlyAnchor;
                        return this;
                    }

                    public Builder setWeeklyAnchor(WeeklyAnchor weeklyAnchor) {
                        this.weeklyAnchor = weeklyAnchor;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Boolean debitNegativeBalances;
                private Map<String, Object> extraParams;
                private Schedule schedule;
                private String statementDescriptor;

                public Payouts build() {
                    return new Payouts(this.debitNegativeBalances, this.extraParams, this.schedule, this.statementDescriptor);
                }

                public Builder setDebitNegativeBalances(Boolean debitNegativeBalances) {
                    this.debitNegativeBalances = debitNegativeBalances;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSchedule(Schedule schedule) {
                    this.schedule = schedule;
                    return this;
                }

                public Builder setStatementDescriptor(String statementDescriptor) {
                    this.statementDescriptor = statementDescriptor;
                    return this;
                }
            }
        }

        public static class Payments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="statement_descriptor")
            String statementDescriptor;
            @SerializedName(value="statement_descriptor_kana")
            String statementDescriptorKana;
            @SerializedName(value="statement_descriptor_kanji")
            String statementDescriptorKanji;

            private Payments(Map<String, Object> extraParams, String statementDescriptor, String statementDescriptorKana, String statementDescriptorKanji) {
                this.extraParams = extraParams;
                this.statementDescriptor = statementDescriptor;
                this.statementDescriptorKana = statementDescriptorKana;
                this.statementDescriptorKanji = statementDescriptorKanji;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getStatementDescriptor() {
                return this.statementDescriptor;
            }

            @Generated
            public String getStatementDescriptorKana() {
                return this.statementDescriptorKana;
            }

            @Generated
            public String getStatementDescriptorKanji() {
                return this.statementDescriptorKanji;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String statementDescriptor;
                private String statementDescriptorKana;
                private String statementDescriptorKanji;

                public Payments build() {
                    return new Payments(this.extraParams, this.statementDescriptor, this.statementDescriptorKana, this.statementDescriptorKanji);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setStatementDescriptor(String statementDescriptor) {
                    this.statementDescriptor = statementDescriptor;
                    return this;
                }

                public Builder setStatementDescriptorKana(String statementDescriptorKana) {
                    this.statementDescriptorKana = statementDescriptorKana;
                    return this;
                }

                public Builder setStatementDescriptorKanji(String statementDescriptorKanji) {
                    this.statementDescriptorKanji = statementDescriptorKanji;
                    return this;
                }
            }
        }

        public static class CardPayments {
            @SerializedName(value="decline_on")
            DeclineOn declineOn;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="statement_descriptor_prefix")
            String statementDescriptorPrefix;

            private CardPayments(DeclineOn declineOn, Map<String, Object> extraParams, String statementDescriptorPrefix) {
                this.declineOn = declineOn;
                this.extraParams = extraParams;
                this.statementDescriptorPrefix = statementDescriptorPrefix;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public DeclineOn getDeclineOn() {
                return this.declineOn;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getStatementDescriptorPrefix() {
                return this.statementDescriptorPrefix;
            }

            public static class DeclineOn {
                @SerializedName(value="avs_failure")
                Boolean avsFailure;
                @SerializedName(value="cvc_failure")
                Boolean cvcFailure;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private DeclineOn(Boolean avsFailure, Boolean cvcFailure, Map<String, Object> extraParams) {
                    this.avsFailure = avsFailure;
                    this.cvcFailure = cvcFailure;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Boolean getAvsFailure() {
                    return this.avsFailure;
                }

                @Generated
                public Boolean getCvcFailure() {
                    return this.cvcFailure;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private Boolean avsFailure;
                    private Boolean cvcFailure;
                    private Map<String, Object> extraParams;

                    public DeclineOn build() {
                        return new DeclineOn(this.avsFailure, this.cvcFailure, this.extraParams);
                    }

                    public Builder setAvsFailure(Boolean avsFailure) {
                        this.avsFailure = avsFailure;
                        return this;
                    }

                    public Builder setCvcFailure(Boolean cvcFailure) {
                        this.cvcFailure = cvcFailure;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static class Builder {
                private DeclineOn declineOn;
                private Map<String, Object> extraParams;
                private String statementDescriptorPrefix;

                public CardPayments build() {
                    return new CardPayments(this.declineOn, this.extraParams, this.statementDescriptorPrefix);
                }

                public Builder setDeclineOn(DeclineOn declineOn) {
                    this.declineOn = declineOn;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setStatementDescriptorPrefix(String statementDescriptorPrefix) {
                    this.statementDescriptorPrefix = statementDescriptorPrefix;
                    return this;
                }
            }
        }

        public static class Branding {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="icon")
            String icon;
            @SerializedName(value="logo")
            String logo;
            @SerializedName(value="primary_color")
            String primaryColor;
            @SerializedName(value="secondary_color")
            String secondaryColor;

            private Branding(Map<String, Object> extraParams, String icon, String logo, String primaryColor, String secondaryColor) {
                this.extraParams = extraParams;
                this.icon = icon;
                this.logo = logo;
                this.primaryColor = primaryColor;
                this.secondaryColor = secondaryColor;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getIcon() {
                return this.icon;
            }

            @Generated
            public String getLogo() {
                return this.logo;
            }

            @Generated
            public String getPrimaryColor() {
                return this.primaryColor;
            }

            @Generated
            public String getSecondaryColor() {
                return this.secondaryColor;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String icon;
                private String logo;
                private String primaryColor;
                private String secondaryColor;

                public Branding build() {
                    return new Branding(this.extraParams, this.icon, this.logo, this.primaryColor, this.secondaryColor);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setIcon(String icon) {
                    this.icon = icon;
                    return this;
                }

                public Builder setLogo(String logo) {
                    this.logo = logo;
                    return this;
                }

                public Builder setPrimaryColor(String primaryColor) {
                    this.primaryColor = primaryColor;
                    return this;
                }

                public Builder setSecondaryColor(String secondaryColor) {
                    this.secondaryColor = secondaryColor;
                    return this;
                }
            }
        }

        public static class Builder {
            private Branding branding;
            private CardPayments cardPayments;
            private Map<String, Object> extraParams;
            private Payments payments;
            private Payouts payouts;

            public Settings build() {
                return new Settings(this.branding, this.cardPayments, this.extraParams, this.payments, this.payouts);
            }

            public Builder setBranding(Branding branding) {
                this.branding = branding;
                return this;
            }

            public Builder setCardPayments(CardPayments cardPayments) {
                this.cardPayments = cardPayments;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setPayments(Payments payments) {
                this.payments = payments;
                return this;
            }

            public Builder setPayouts(Payouts payouts) {
                this.payouts = payouts;
                return this;
            }
        }
    }

    public static class Individual {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="address_kana")
        AddressKana addressKana;
        @SerializedName(value="address_kanji")
        AddressKanji addressKanji;
        @SerializedName(value="dob")
        Object dob;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="first_name")
        String firstName;
        @SerializedName(value="first_name_kana")
        String firstNameKana;
        @SerializedName(value="first_name_kanji")
        String firstNameKanji;
        @SerializedName(value="gender")
        String gender;
        @SerializedName(value="id_number")
        String idNumber;
        @SerializedName(value="last_name")
        String lastName;
        @SerializedName(value="last_name_kana")
        String lastNameKana;
        @SerializedName(value="last_name_kanji")
        String lastNameKanji;
        @SerializedName(value="maiden_name")
        String maidenName;
        @SerializedName(value="metadata")
        Object metadata;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="political_exposure")
        PoliticalExposure politicalExposure;
        @SerializedName(value="ssn_last_4")
        String ssnLast4;
        @SerializedName(value="verification")
        Verification verification;

        private Individual(Address address, AddressKana addressKana, AddressKanji addressKanji, Object dob, String email, Map<String, Object> extraParams, String firstName, String firstNameKana, String firstNameKanji, String gender, String idNumber, String lastName, String lastNameKana, String lastNameKanji, String maidenName, Object metadata, String phone, PoliticalExposure politicalExposure, String ssnLast4, Verification verification) {
            this.address = address;
            this.addressKana = addressKana;
            this.addressKanji = addressKanji;
            this.dob = dob;
            this.email = email;
            this.extraParams = extraParams;
            this.firstName = firstName;
            this.firstNameKana = firstNameKana;
            this.firstNameKanji = firstNameKanji;
            this.gender = gender;
            this.idNumber = idNumber;
            this.lastName = lastName;
            this.lastNameKana = lastNameKana;
            this.lastNameKanji = lastNameKanji;
            this.maidenName = maidenName;
            this.metadata = metadata;
            this.phone = phone;
            this.politicalExposure = politicalExposure;
            this.ssnLast4 = ssnLast4;
            this.verification = verification;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public AddressKana getAddressKana() {
            return this.addressKana;
        }

        @Generated
        public AddressKanji getAddressKanji() {
            return this.addressKanji;
        }

        @Generated
        public Object getDob() {
            return this.dob;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getFirstName() {
            return this.firstName;
        }

        @Generated
        public String getFirstNameKana() {
            return this.firstNameKana;
        }

        @Generated
        public String getFirstNameKanji() {
            return this.firstNameKanji;
        }

        @Generated
        public String getGender() {
            return this.gender;
        }

        @Generated
        public String getIdNumber() {
            return this.idNumber;
        }

        @Generated
        public String getLastName() {
            return this.lastName;
        }

        @Generated
        public String getLastNameKana() {
            return this.lastNameKana;
        }

        @Generated
        public String getLastNameKanji() {
            return this.lastNameKanji;
        }

        @Generated
        public String getMaidenName() {
            return this.maidenName;
        }

        @Generated
        public Object getMetadata() {
            return this.metadata;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public PoliticalExposure getPoliticalExposure() {
            return this.politicalExposure;
        }

        @Generated
        public String getSsnLast4() {
            return this.ssnLast4;
        }

        @Generated
        public Verification getVerification() {
            return this.verification;
        }

        public static enum PoliticalExposure implements ApiRequestParams.EnumParam
        {
            EXISTING("existing"),
            NONE("none");

            private final String value;

            private PoliticalExposure(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Verification {
            @SerializedName(value="additional_document")
            AdditionalDocument additionalDocument;
            @SerializedName(value="document")
            Document document;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Verification(AdditionalDocument additionalDocument, Document document, Map<String, Object> extraParams) {
                this.additionalDocument = additionalDocument;
                this.document = document;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public AdditionalDocument getAdditionalDocument() {
                return this.additionalDocument;
            }

            @Generated
            public Document getDocument() {
                return this.document;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Document {
                @SerializedName(value="back")
                String back;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="front")
                String front;

                private Document(String back, Map<String, Object> extraParams, String front) {
                    this.back = back;
                    this.extraParams = extraParams;
                    this.front = front;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getBack() {
                    return this.back;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getFront() {
                    return this.front;
                }

                public static class Builder {
                    private String back;
                    private Map<String, Object> extraParams;
                    private String front;

                    public Document build() {
                        return new Document(this.back, this.extraParams, this.front);
                    }

                    public Builder setBack(String back) {
                        this.back = back;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setFront(String front) {
                        this.front = front;
                        return this;
                    }
                }
            }

            public static class AdditionalDocument {
                @SerializedName(value="back")
                String back;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="front")
                String front;

                private AdditionalDocument(String back, Map<String, Object> extraParams, String front) {
                    this.back = back;
                    this.extraParams = extraParams;
                    this.front = front;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getBack() {
                    return this.back;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getFront() {
                    return this.front;
                }

                public static class Builder {
                    private String back;
                    private Map<String, Object> extraParams;
                    private String front;

                    public AdditionalDocument build() {
                        return new AdditionalDocument(this.back, this.extraParams, this.front);
                    }

                    public Builder setBack(String back) {
                        this.back = back;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setFront(String front) {
                        this.front = front;
                        return this;
                    }
                }
            }

            public static class Builder {
                private AdditionalDocument additionalDocument;
                private Document document;
                private Map<String, Object> extraParams;

                public Verification build() {
                    return new Verification(this.additionalDocument, this.document, this.extraParams);
                }

                public Builder setAdditionalDocument(AdditionalDocument additionalDocument) {
                    this.additionalDocument = additionalDocument;
                    return this;
                }

                public Builder setDocument(Document document) {
                    this.document = document;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Dob {
            @SerializedName(value="day")
            Long day;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="month")
            Long month;
            @SerializedName(value="year")
            Long year;

            private Dob(Long day, Map<String, Object> extraParams, Long month, Long year) {
                this.day = day;
                this.extraParams = extraParams;
                this.month = month;
                this.year = year;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getDay() {
                return this.day;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Long getMonth() {
                return this.month;
            }

            @Generated
            public Long getYear() {
                return this.year;
            }

            public static class Builder {
                private Long day;
                private Map<String, Object> extraParams;
                private Long month;
                private Long year;

                public Dob build() {
                    return new Dob(this.day, this.extraParams, this.month, this.year);
                }

                public Builder setDay(Long day) {
                    this.day = day;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setMonth(Long month) {
                    this.month = month;
                    return this;
                }

                public Builder setYear(Long year) {
                    this.year = year;
                    return this;
                }
            }
        }

        public static class AddressKanji {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;
            @SerializedName(value="town")
            String town;

            private AddressKanji(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state, String town) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
                this.town = town;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public String getTown() {
                return this.town;
            }

            public static class Builder {
                private String city;
                private String country;
                private Map<String, Object> extraParams;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;
                private String town;

                public AddressKanji build() {
                    return new AddressKanji(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state, this.town);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setTown(String town) {
                    this.town = town;
                    return this;
                }
            }
        }

        public static class AddressKana {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;
            @SerializedName(value="town")
            String town;

            private AddressKana(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state, String town) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
                this.town = town;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public String getTown() {
                return this.town;
            }

            public static class Builder {
                private String city;
                private String country;
                private Map<String, Object> extraParams;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;
                private String town;

                public AddressKana build() {
                    return new AddressKana(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state, this.town);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setTown(String town) {
                    this.town = town;
                    return this;
                }
            }
        }

        public static class Address {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            public static class Builder {
                private String city;
                private String country;
                private Map<String, Object> extraParams;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public Address build() {
                    return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private AddressKana addressKana;
            private AddressKanji addressKanji;
            private Object dob;
            private String email;
            private Map<String, Object> extraParams;
            private String firstName;
            private String firstNameKana;
            private String firstNameKanji;
            private String gender;
            private String idNumber;
            private String lastName;
            private String lastNameKana;
            private String lastNameKanji;
            private String maidenName;
            private Object metadata;
            private String phone;
            private PoliticalExposure politicalExposure;
            private String ssnLast4;
            private Verification verification;

            public Individual build() {
                return new Individual(this.address, this.addressKana, this.addressKanji, this.dob, this.email, this.extraParams, this.firstName, this.firstNameKana, this.firstNameKanji, this.gender, this.idNumber, this.lastName, this.lastNameKana, this.lastNameKanji, this.maidenName, this.metadata, this.phone, this.politicalExposure, this.ssnLast4, this.verification);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setAddressKana(AddressKana addressKana) {
                this.addressKana = addressKana;
                return this;
            }

            public Builder setAddressKanji(AddressKanji addressKanji) {
                this.addressKanji = addressKanji;
                return this;
            }

            public Builder setDob(Dob dob) {
                this.dob = dob;
                return this;
            }

            public Builder setDob(EmptyParam dob) {
                this.dob = dob;
                return this;
            }

            public Builder setEmail(String email) {
                this.email = email;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFirstName(String firstName) {
                this.firstName = firstName;
                return this;
            }

            public Builder setFirstNameKana(String firstNameKana) {
                this.firstNameKana = firstNameKana;
                return this;
            }

            public Builder setFirstNameKanji(String firstNameKanji) {
                this.firstNameKanji = firstNameKanji;
                return this;
            }

            public Builder setGender(String gender) {
                this.gender = gender;
                return this;
            }

            public Builder setIdNumber(String idNumber) {
                this.idNumber = idNumber;
                return this;
            }

            public Builder setLastName(String lastName) {
                this.lastName = lastName;
                return this;
            }

            public Builder setLastNameKana(String lastNameKana) {
                this.lastNameKana = lastNameKana;
                return this;
            }

            public Builder setLastNameKanji(String lastNameKanji) {
                this.lastNameKanji = lastNameKanji;
                return this;
            }

            public Builder setMaidenName(String maidenName) {
                this.maidenName = maidenName;
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null || this.metadata instanceof EmptyParam) {
                    this.metadata = new HashMap();
                }
                ((Map)this.metadata).put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null || this.metadata instanceof EmptyParam) {
                    this.metadata = new HashMap();
                }
                ((Map)this.metadata).putAll(map);
                return this;
            }

            public Builder setMetadata(EmptyParam metadata) {
                this.metadata = metadata;
                return this;
            }

            public Builder setMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }

            public Builder setPoliticalExposure(PoliticalExposure politicalExposure) {
                this.politicalExposure = politicalExposure;
                return this;
            }

            public Builder setSsnLast4(String ssnLast4) {
                this.ssnLast4 = ssnLast4;
                return this;
            }

            public Builder setVerification(Verification verification) {
                this.verification = verification;
                return this;
            }
        }
    }

    public static class Company {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="address_kana")
        AddressKana addressKana;
        @SerializedName(value="address_kanji")
        AddressKanji addressKanji;
        @SerializedName(value="directors_provided")
        Boolean directorsProvided;
        @SerializedName(value="executives_provided")
        Boolean executivesProvided;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="name_kana")
        String nameKana;
        @SerializedName(value="name_kanji")
        String nameKanji;
        @SerializedName(value="owners_provided")
        Boolean ownersProvided;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="structure")
        ApiRequestParams.EnumParam structure;
        @SerializedName(value="tax_id")
        String taxId;
        @SerializedName(value="tax_id_registrar")
        String taxIdRegistrar;
        @SerializedName(value="vat_id")
        String vatId;
        @SerializedName(value="verification")
        Verification verification;

        private Company(Address address, AddressKana addressKana, AddressKanji addressKanji, Boolean directorsProvided, Boolean executivesProvided, Map<String, Object> extraParams, String name, String nameKana, String nameKanji, Boolean ownersProvided, String phone, ApiRequestParams.EnumParam structure, String taxId, String taxIdRegistrar, String vatId, Verification verification) {
            this.address = address;
            this.addressKana = addressKana;
            this.addressKanji = addressKanji;
            this.directorsProvided = directorsProvided;
            this.executivesProvided = executivesProvided;
            this.extraParams = extraParams;
            this.name = name;
            this.nameKana = nameKana;
            this.nameKanji = nameKanji;
            this.ownersProvided = ownersProvided;
            this.phone = phone;
            this.structure = structure;
            this.taxId = taxId;
            this.taxIdRegistrar = taxIdRegistrar;
            this.vatId = vatId;
            this.verification = verification;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public AddressKana getAddressKana() {
            return this.addressKana;
        }

        @Generated
        public AddressKanji getAddressKanji() {
            return this.addressKanji;
        }

        @Generated
        public Boolean getDirectorsProvided() {
            return this.directorsProvided;
        }

        @Generated
        public Boolean getExecutivesProvided() {
            return this.executivesProvided;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getNameKana() {
            return this.nameKana;
        }

        @Generated
        public String getNameKanji() {
            return this.nameKanji;
        }

        @Generated
        public Boolean getOwnersProvided() {
            return this.ownersProvided;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public ApiRequestParams.EnumParam getStructure() {
            return this.structure;
        }

        @Generated
        public String getTaxId() {
            return this.taxId;
        }

        @Generated
        public String getTaxIdRegistrar() {
            return this.taxIdRegistrar;
        }

        @Generated
        public String getVatId() {
            return this.vatId;
        }

        @Generated
        public Verification getVerification() {
            return this.verification;
        }

        public static enum Structure implements ApiRequestParams.EnumParam
        {
            GOVERNMENT_INSTRUMENTALITY("government_instrumentality"),
            GOVERNMENTAL_UNIT("governmental_unit"),
            INCORPORATED_NON_PROFIT("incorporated_non_profit"),
            LIMITED_LIABILITY_PARTNERSHIP("limited_liability_partnership"),
            MULTI_MEMBER_LLC("multi_member_llc"),
            PRIVATE_COMPANY("private_company"),
            PRIVATE_CORPORATION("private_corporation"),
            PRIVATE_PARTNERSHIP("private_partnership"),
            PUBLIC_COMPANY("public_company"),
            PUBLIC_CORPORATION("public_corporation"),
            PUBLIC_PARTNERSHIP("public_partnership"),
            SOLE_PROPRIETORSHIP("sole_proprietorship"),
            TAX_EXEMPT_GOVERNMENT_INSTRUMENTALITY("tax_exempt_government_instrumentality"),
            UNINCORPORATED_ASSOCIATION("unincorporated_association"),
            UNINCORPORATED_NON_PROFIT("unincorporated_non_profit");

            private final String value;

            private Structure(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Verification {
            @SerializedName(value="document")
            Document document;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Verification(Document document, Map<String, Object> extraParams) {
                this.document = document;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Document getDocument() {
                return this.document;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Document {
                @SerializedName(value="back")
                String back;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="front")
                String front;

                private Document(String back, Map<String, Object> extraParams, String front) {
                    this.back = back;
                    this.extraParams = extraParams;
                    this.front = front;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getBack() {
                    return this.back;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getFront() {
                    return this.front;
                }

                public static class Builder {
                    private String back;
                    private Map<String, Object> extraParams;
                    private String front;

                    public Document build() {
                        return new Document(this.back, this.extraParams, this.front);
                    }

                    public Builder setBack(String back) {
                        this.back = back;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setFront(String front) {
                        this.front = front;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Document document;
                private Map<String, Object> extraParams;

                public Verification build() {
                    return new Verification(this.document, this.extraParams);
                }

                public Builder setDocument(Document document) {
                    this.document = document;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class AddressKanji {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;
            @SerializedName(value="town")
            String town;

            private AddressKanji(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state, String town) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
                this.town = town;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public String getTown() {
                return this.town;
            }

            public static class Builder {
                private String city;
                private String country;
                private Map<String, Object> extraParams;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;
                private String town;

                public AddressKanji build() {
                    return new AddressKanji(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state, this.town);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setTown(String town) {
                    this.town = town;
                    return this;
                }
            }
        }

        public static class AddressKana {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;
            @SerializedName(value="town")
            String town;

            private AddressKana(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state, String town) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
                this.town = town;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public String getTown() {
                return this.town;
            }

            public static class Builder {
                private String city;
                private String country;
                private Map<String, Object> extraParams;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;
                private String town;

                public AddressKana build() {
                    return new AddressKana(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state, this.town);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setTown(String town) {
                    this.town = town;
                    return this;
                }
            }
        }

        public static class Address {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            public static class Builder {
                private String city;
                private String country;
                private Map<String, Object> extraParams;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public Address build() {
                    return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private AddressKana addressKana;
            private AddressKanji addressKanji;
            private Boolean directorsProvided;
            private Boolean executivesProvided;
            private Map<String, Object> extraParams;
            private String name;
            private String nameKana;
            private String nameKanji;
            private Boolean ownersProvided;
            private String phone;
            private ApiRequestParams.EnumParam structure;
            private String taxId;
            private String taxIdRegistrar;
            private String vatId;
            private Verification verification;

            public Company build() {
                return new Company(this.address, this.addressKana, this.addressKanji, this.directorsProvided, this.executivesProvided, this.extraParams, this.name, this.nameKana, this.nameKanji, this.ownersProvided, this.phone, this.structure, this.taxId, this.taxIdRegistrar, this.vatId, this.verification);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setAddressKana(AddressKana addressKana) {
                this.addressKana = addressKana;
                return this;
            }

            public Builder setAddressKanji(AddressKanji addressKanji) {
                this.addressKanji = addressKanji;
                return this;
            }

            public Builder setDirectorsProvided(Boolean directorsProvided) {
                this.directorsProvided = directorsProvided;
                return this;
            }

            public Builder setExecutivesProvided(Boolean executivesProvided) {
                this.executivesProvided = executivesProvided;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setNameKana(String nameKana) {
                this.nameKana = nameKana;
                return this;
            }

            public Builder setNameKanji(String nameKanji) {
                this.nameKanji = nameKanji;
                return this;
            }

            public Builder setOwnersProvided(Boolean ownersProvided) {
                this.ownersProvided = ownersProvided;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }

            public Builder setStructure(Structure structure) {
                this.structure = structure;
                return this;
            }

            public Builder setStructure(EmptyParam structure) {
                this.structure = structure;
                return this;
            }

            public Builder setTaxId(String taxId) {
                this.taxId = taxId;
                return this;
            }

            public Builder setTaxIdRegistrar(String taxIdRegistrar) {
                this.taxIdRegistrar = taxIdRegistrar;
                return this;
            }

            public Builder setVatId(String vatId) {
                this.vatId = vatId;
                return this;
            }

            public Builder setVerification(Verification verification) {
                this.verification = verification;
                return this;
            }
        }
    }

    public static class Capabilities {
        @SerializedName(value="au_becs_debit_payments")
        AuBecsDebitPayments auBecsDebitPayments;
        @SerializedName(value="bacs_debit_payments")
        BacsDebitPayments bacsDebitPayments;
        @SerializedName(value="bancontact_payments")
        BancontactPayments bancontactPayments;
        @SerializedName(value="card_issuing")
        CardIssuing cardIssuing;
        @SerializedName(value="card_payments")
        CardPayments cardPayments;
        @SerializedName(value="cartes_bancaires_payments")
        CartesBancairesPayments cartesBancairesPayments;
        @SerializedName(value="eps_payments")
        EpsPayments epsPayments;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="fpx_payments")
        FpxPayments fpxPayments;
        @SerializedName(value="giropay_payments")
        GiropayPayments giropayPayments;
        @SerializedName(value="ideal_payments")
        IdealPayments idealPayments;
        @SerializedName(value="jcb_payments")
        JcbPayments jcbPayments;
        @SerializedName(value="legacy_payments")
        LegacyPayments legacyPayments;
        @SerializedName(value="oxxo_payments")
        OxxoPayments oxxoPayments;
        @SerializedName(value="p24_payments")
        P24Payments p24Payments;
        @SerializedName(value="sepa_debit_payments")
        SepaDebitPayments sepaDebitPayments;
        @SerializedName(value="sofort_payments")
        SofortPayments sofortPayments;
        @SerializedName(value="tax_reporting_us_1099_k")
        TaxReportingUs1099K taxReportingUs1099K;
        @SerializedName(value="tax_reporting_us_1099_misc")
        TaxReportingUs1099Misc taxReportingUs1099Misc;
        @SerializedName(value="transfers")
        Transfers transfers;

        private Capabilities(AuBecsDebitPayments auBecsDebitPayments, BacsDebitPayments bacsDebitPayments, BancontactPayments bancontactPayments, CardIssuing cardIssuing, CardPayments cardPayments, CartesBancairesPayments cartesBancairesPayments, EpsPayments epsPayments, Map<String, Object> extraParams, FpxPayments fpxPayments, GiropayPayments giropayPayments, IdealPayments idealPayments, JcbPayments jcbPayments, LegacyPayments legacyPayments, OxxoPayments oxxoPayments, P24Payments p24Payments, SepaDebitPayments sepaDebitPayments, SofortPayments sofortPayments, TaxReportingUs1099K taxReportingUs1099K, TaxReportingUs1099Misc taxReportingUs1099Misc, Transfers transfers) {
            this.auBecsDebitPayments = auBecsDebitPayments;
            this.bacsDebitPayments = bacsDebitPayments;
            this.bancontactPayments = bancontactPayments;
            this.cardIssuing = cardIssuing;
            this.cardPayments = cardPayments;
            this.cartesBancairesPayments = cartesBancairesPayments;
            this.epsPayments = epsPayments;
            this.extraParams = extraParams;
            this.fpxPayments = fpxPayments;
            this.giropayPayments = giropayPayments;
            this.idealPayments = idealPayments;
            this.jcbPayments = jcbPayments;
            this.legacyPayments = legacyPayments;
            this.oxxoPayments = oxxoPayments;
            this.p24Payments = p24Payments;
            this.sepaDebitPayments = sepaDebitPayments;
            this.sofortPayments = sofortPayments;
            this.taxReportingUs1099K = taxReportingUs1099K;
            this.taxReportingUs1099Misc = taxReportingUs1099Misc;
            this.transfers = transfers;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public AuBecsDebitPayments getAuBecsDebitPayments() {
            return this.auBecsDebitPayments;
        }

        @Generated
        public BacsDebitPayments getBacsDebitPayments() {
            return this.bacsDebitPayments;
        }

        @Generated
        public BancontactPayments getBancontactPayments() {
            return this.bancontactPayments;
        }

        @Generated
        public CardIssuing getCardIssuing() {
            return this.cardIssuing;
        }

        @Generated
        public CardPayments getCardPayments() {
            return this.cardPayments;
        }

        @Generated
        public CartesBancairesPayments getCartesBancairesPayments() {
            return this.cartesBancairesPayments;
        }

        @Generated
        public EpsPayments getEpsPayments() {
            return this.epsPayments;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public FpxPayments getFpxPayments() {
            return this.fpxPayments;
        }

        @Generated
        public GiropayPayments getGiropayPayments() {
            return this.giropayPayments;
        }

        @Generated
        public IdealPayments getIdealPayments() {
            return this.idealPayments;
        }

        @Generated
        public JcbPayments getJcbPayments() {
            return this.jcbPayments;
        }

        @Generated
        public LegacyPayments getLegacyPayments() {
            return this.legacyPayments;
        }

        @Generated
        public OxxoPayments getOxxoPayments() {
            return this.oxxoPayments;
        }

        @Generated
        public P24Payments getP24Payments() {
            return this.p24Payments;
        }

        @Generated
        public SepaDebitPayments getSepaDebitPayments() {
            return this.sepaDebitPayments;
        }

        @Generated
        public SofortPayments getSofortPayments() {
            return this.sofortPayments;
        }

        @Generated
        public TaxReportingUs1099K getTaxReportingUs1099K() {
            return this.taxReportingUs1099K;
        }

        @Generated
        public TaxReportingUs1099Misc getTaxReportingUs1099Misc() {
            return this.taxReportingUs1099Misc;
        }

        @Generated
        public Transfers getTransfers() {
            return this.transfers;
        }

        public static class Transfers {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private Transfers(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public Transfers build() {
                    return new Transfers(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class TaxReportingUs1099Misc {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private TaxReportingUs1099Misc(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public TaxReportingUs1099Misc build() {
                    return new TaxReportingUs1099Misc(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class TaxReportingUs1099K {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private TaxReportingUs1099K(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public TaxReportingUs1099K build() {
                    return new TaxReportingUs1099K(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class SofortPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private SofortPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public SofortPayments build() {
                    return new SofortPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class SepaDebitPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private SepaDebitPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public SepaDebitPayments build() {
                    return new SepaDebitPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class P24Payments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private P24Payments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public P24Payments build() {
                    return new P24Payments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class OxxoPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private OxxoPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public OxxoPayments build() {
                    return new OxxoPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class LegacyPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private LegacyPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public LegacyPayments build() {
                    return new LegacyPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class JcbPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private JcbPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public JcbPayments build() {
                    return new JcbPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class IdealPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private IdealPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public IdealPayments build() {
                    return new IdealPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class GiropayPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private GiropayPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public GiropayPayments build() {
                    return new GiropayPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class FpxPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private FpxPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public FpxPayments build() {
                    return new FpxPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class EpsPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private EpsPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public EpsPayments build() {
                    return new EpsPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class CartesBancairesPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private CartesBancairesPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public CartesBancairesPayments build() {
                    return new CartesBancairesPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class CardPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private CardPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public CardPayments build() {
                    return new CardPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class CardIssuing {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private CardIssuing(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public CardIssuing build() {
                    return new CardIssuing(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class BancontactPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private BancontactPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public BancontactPayments build() {
                    return new BancontactPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class BacsDebitPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private BacsDebitPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public BacsDebitPayments build() {
                    return new BacsDebitPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class AuBecsDebitPayments {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="requested")
            Boolean requested;

            private AuBecsDebitPayments(Map<String, Object> extraParams, Boolean requested) {
                this.extraParams = extraParams;
                this.requested = requested;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequested() {
                return this.requested;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requested;

                public AuBecsDebitPayments build() {
                    return new AuBecsDebitPayments(this.extraParams, this.requested);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequested(Boolean requested) {
                    this.requested = requested;
                    return this;
                }
            }
        }

        public static class Builder {
            private AuBecsDebitPayments auBecsDebitPayments;
            private BacsDebitPayments bacsDebitPayments;
            private BancontactPayments bancontactPayments;
            private CardIssuing cardIssuing;
            private CardPayments cardPayments;
            private CartesBancairesPayments cartesBancairesPayments;
            private EpsPayments epsPayments;
            private Map<String, Object> extraParams;
            private FpxPayments fpxPayments;
            private GiropayPayments giropayPayments;
            private IdealPayments idealPayments;
            private JcbPayments jcbPayments;
            private LegacyPayments legacyPayments;
            private OxxoPayments oxxoPayments;
            private P24Payments p24Payments;
            private SepaDebitPayments sepaDebitPayments;
            private SofortPayments sofortPayments;
            private TaxReportingUs1099K taxReportingUs1099K;
            private TaxReportingUs1099Misc taxReportingUs1099Misc;
            private Transfers transfers;

            public Capabilities build() {
                return new Capabilities(this.auBecsDebitPayments, this.bacsDebitPayments, this.bancontactPayments, this.cardIssuing, this.cardPayments, this.cartesBancairesPayments, this.epsPayments, this.extraParams, this.fpxPayments, this.giropayPayments, this.idealPayments, this.jcbPayments, this.legacyPayments, this.oxxoPayments, this.p24Payments, this.sepaDebitPayments, this.sofortPayments, this.taxReportingUs1099K, this.taxReportingUs1099Misc, this.transfers);
            }

            public Builder setAuBecsDebitPayments(AuBecsDebitPayments auBecsDebitPayments) {
                this.auBecsDebitPayments = auBecsDebitPayments;
                return this;
            }

            public Builder setBacsDebitPayments(BacsDebitPayments bacsDebitPayments) {
                this.bacsDebitPayments = bacsDebitPayments;
                return this;
            }

            public Builder setBancontactPayments(BancontactPayments bancontactPayments) {
                this.bancontactPayments = bancontactPayments;
                return this;
            }

            public Builder setCardIssuing(CardIssuing cardIssuing) {
                this.cardIssuing = cardIssuing;
                return this;
            }

            public Builder setCardPayments(CardPayments cardPayments) {
                this.cardPayments = cardPayments;
                return this;
            }

            public Builder setCartesBancairesPayments(CartesBancairesPayments cartesBancairesPayments) {
                this.cartesBancairesPayments = cartesBancairesPayments;
                return this;
            }

            public Builder setEpsPayments(EpsPayments epsPayments) {
                this.epsPayments = epsPayments;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFpxPayments(FpxPayments fpxPayments) {
                this.fpxPayments = fpxPayments;
                return this;
            }

            public Builder setGiropayPayments(GiropayPayments giropayPayments) {
                this.giropayPayments = giropayPayments;
                return this;
            }

            public Builder setIdealPayments(IdealPayments idealPayments) {
                this.idealPayments = idealPayments;
                return this;
            }

            public Builder setJcbPayments(JcbPayments jcbPayments) {
                this.jcbPayments = jcbPayments;
                return this;
            }

            public Builder setLegacyPayments(LegacyPayments legacyPayments) {
                this.legacyPayments = legacyPayments;
                return this;
            }

            public Builder setOxxoPayments(OxxoPayments oxxoPayments) {
                this.oxxoPayments = oxxoPayments;
                return this;
            }

            public Builder setP24Payments(P24Payments p24Payments) {
                this.p24Payments = p24Payments;
                return this;
            }

            public Builder setSepaDebitPayments(SepaDebitPayments sepaDebitPayments) {
                this.sepaDebitPayments = sepaDebitPayments;
                return this;
            }

            public Builder setSofortPayments(SofortPayments sofortPayments) {
                this.sofortPayments = sofortPayments;
                return this;
            }

            public Builder setTaxReportingUs1099K(TaxReportingUs1099K taxReportingUs1099K) {
                this.taxReportingUs1099K = taxReportingUs1099K;
                return this;
            }

            public Builder setTaxReportingUs1099Misc(TaxReportingUs1099Misc taxReportingUs1099Misc) {
                this.taxReportingUs1099Misc = taxReportingUs1099Misc;
                return this;
            }

            public Builder setTransfers(Transfers transfers) {
                this.transfers = transfers;
                return this;
            }
        }
    }

    public static class BusinessProfile {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="mcc")
        String mcc;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="product_description")
        String productDescription;
        @SerializedName(value="support_address")
        SupportAddress supportAddress;
        @SerializedName(value="support_email")
        String supportEmail;
        @SerializedName(value="support_phone")
        String supportPhone;
        @SerializedName(value="support_url")
        String supportUrl;
        @SerializedName(value="url")
        String url;

        private BusinessProfile(Map<String, Object> extraParams, String mcc, String name, String productDescription, SupportAddress supportAddress, String supportEmail, String supportPhone, String supportUrl, String url) {
            this.extraParams = extraParams;
            this.mcc = mcc;
            this.name = name;
            this.productDescription = productDescription;
            this.supportAddress = supportAddress;
            this.supportEmail = supportEmail;
            this.supportPhone = supportPhone;
            this.supportUrl = supportUrl;
            this.url = url;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getMcc() {
            return this.mcc;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getProductDescription() {
            return this.productDescription;
        }

        @Generated
        public SupportAddress getSupportAddress() {
            return this.supportAddress;
        }

        @Generated
        public String getSupportEmail() {
            return this.supportEmail;
        }

        @Generated
        public String getSupportPhone() {
            return this.supportPhone;
        }

        @Generated
        public String getSupportUrl() {
            return this.supportUrl;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        public static class SupportAddress {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private SupportAddress(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            public static class Builder {
                private String city;
                private String country;
                private Map<String, Object> extraParams;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public SupportAddress build() {
                    return new SupportAddress(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private String mcc;
            private String name;
            private String productDescription;
            private SupportAddress supportAddress;
            private String supportEmail;
            private String supportPhone;
            private String supportUrl;
            private String url;

            public BusinessProfile build() {
                return new BusinessProfile(this.extraParams, this.mcc, this.name, this.productDescription, this.supportAddress, this.supportEmail, this.supportPhone, this.supportUrl, this.url);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setMcc(String mcc) {
                this.mcc = mcc;
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setProductDescription(String productDescription) {
                this.productDescription = productDescription;
                return this;
            }

            public Builder setSupportAddress(SupportAddress supportAddress) {
                this.supportAddress = supportAddress;
                return this;
            }

            public Builder setSupportEmail(String supportEmail) {
                this.supportEmail = supportEmail;
                return this;
            }

            public Builder setSupportPhone(String supportPhone) {
                this.supportPhone = supportPhone;
                return this;
            }

            public Builder setSupportUrl(String supportUrl) {
                this.supportUrl = supportUrl;
                return this;
            }

            public Builder setUrl(String url) {
                this.url = url;
                return this;
            }
        }
    }

    public static class Builder {
        private String accountToken;
        private BusinessProfile businessProfile;
        private Object businessType;
        private Capabilities capabilities;
        private Company company;
        private String country;
        private String defaultCurrency;
        private String email;
        private List<String> expand;
        private String externalAccount;
        private Map<String, Object> extraParams;
        private Individual individual;
        private Object metadata;
        private Settings settings;
        private TosAcceptance tosAcceptance;
        private Type type;

        public AccountCreateParams build() {
            return new AccountCreateParams(this.accountToken, this.businessProfile, this.businessType, this.capabilities, this.company, this.country, this.defaultCurrency, this.email, this.expand, this.externalAccount, this.extraParams, this.individual, this.metadata, this.settings, this.tosAcceptance, this.type);
        }

        public Builder setAccountToken(String accountToken) {
            this.accountToken = accountToken;
            return this;
        }

        public Builder setBusinessProfile(BusinessProfile businessProfile) {
            this.businessProfile = businessProfile;
            return this;
        }

        public Builder setBusinessType(BusinessType businessType) {
            this.businessType = businessType;
            return this;
        }

        public Builder setBusinessType(String businessType) {
            this.businessType = businessType;
            return this;
        }

        public Builder setCapabilities(Capabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder setCompany(Company company) {
            this.company = company;
            return this;
        }

        public Builder setCountry(String country) {
            this.country = country;
            return this;
        }

        public Builder setDefaultCurrency(String defaultCurrency) {
            this.defaultCurrency = defaultCurrency;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setExternalAccount(String externalAccount) {
            this.externalAccount = externalAccount;
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setIndividual(Individual individual) {
            this.individual = individual;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).putAll(map);
            return this;
        }

        public Builder setMetadata(EmptyParam metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setSettings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder setTosAcceptance(TosAcceptance tosAcceptance) {
            this.tosAcceptance = tosAcceptance;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }
    }
}

