/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.utils;

import android.util.Log;
import androidx.annotation.RestrictTo;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/core/utils/PluginDetector;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "pluginType", "getPluginType", "()Ljava/lang/String;", "isPlugin", "", "className", "PluginType", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nPluginDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginDetector.kt\ncom/stripe/android/core/utils/PluginDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n295#2,2:42\n*S KotlinDebug\n*F\n+ 1 PluginDetector.kt\ncom/stripe/android/core/utils/PluginDetector\n*L\n18#1:42,2\n*E\n"})
public final class PluginDetector {
    @NotNull
    public static final PluginDetector INSTANCE;
    private static final String TAG;
    @Nullable
    private static final String pluginType;

    private PluginDetector() {
    }

    @Nullable
    public final String getPluginType() {
        return pluginType;
    }

    private final boolean isPlugin(String className) {
        boolean bl;
        try {
            Class.forName(className);
            bl = true;
        }
        catch (ClassNotFoundException e) {
            Log.d((String)TAG, (String)(className + " not found: " + e));
            bl = false;
        }
        return bl;
    }

    static {
        Object v0;
        block1: {
            INSTANCE = new PluginDetector();
            TAG = PluginDetector.class.getSimpleName();
            Iterable $this$firstOrNull$iv = (Iterable)PluginType.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PluginType it = (PluginType)((Object)element$iv);
                boolean bl = false;
                if (!INSTANCE.isPlugin(it.getClassName())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        PluginType pluginType = v0;
        PluginDetector.pluginType = pluginType != null ? pluginType.getPluginName() : null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0087\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/core/utils/PluginDetector$PluginType;", "", "className", "", "pluginName", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "getPluginName", "ReactNative", "Flutter", "Cordova", "Unity", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class PluginType
    extends Enum<PluginType> {
        @NotNull
        private final String className;
        @NotNull
        private final String pluginName;
        public static final /* enum */ PluginType ReactNative = new PluginType("com.facebook.react.bridge.NativeModule", "react-native");
        public static final /* enum */ PluginType Flutter = new PluginType("io.flutter.embedding.engine.FlutterEngine", "flutter");
        public static final /* enum */ PluginType Cordova = new PluginType("org.apache.cordova.CordovaActivity", "cordova");
        public static final /* enum */ PluginType Unity = new PluginType("com.unity3d.player.UnityPlayerActivity", "unity");
        private static final /* synthetic */ PluginType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PluginType(String className, String pluginName) {
            this.className = className;
            this.pluginName = pluginName;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final String getPluginName() {
            return this.pluginName;
        }

        public static PluginType[] values() {
            return (PluginType[])$VALUES.clone();
        }

        public static PluginType valueOf(String value) {
            return Enum.valueOf(PluginType.class, value);
        }

        @NotNull
        public static EnumEntries<PluginType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = pluginTypeArray = new PluginType[]{PluginType.ReactNative, PluginType.Flutter, PluginType.Cordova, PluginType.Unity};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

