/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.utils;

import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0007J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u00020\u00052\b\b\u0001\u0010\r\u001a\u00020\u0005H\u0007J\u001a\u0010\f\u001a\u00020\u00052\b\b\u0001\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/core/utils/DateUtils;", "", "<init>", "()V", "MAX_VALID_YEAR", "", "isExpiryDataValid", "", "expiryMonth", "expiryYear", "calendar", "Ljava/util/Calendar;", "convertTwoDigitYearToFour", "inputYear", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class DateUtils {
    @NotNull
    public static final DateUtils INSTANCE = new DateUtils();
    private static final int MAX_VALID_YEAR = 9980;

    private DateUtils() {
    }

    @JvmStatic
    public static final boolean isExpiryDataValid(int expiryMonth, int expiryYear) {
        int fullExpiryYear = expiryYear < 100 ? INSTANCE.convertTwoDigitYearToFour(expiryYear) : expiryYear;
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"getInstance(...)");
        return DateUtils.isExpiryDataValid(expiryMonth, fullExpiryYear, calendar);
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean isExpiryDataValid(int expiryMonth, int expiryYear, @NotNull Calendar calendar) {
        int readableMonth;
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        if (!(1 <= expiryMonth ? expiryMonth < 13 : false)) {
            return false;
        }
        if (!(0 <= expiryYear ? expiryYear < 9981 : false)) {
            return false;
        }
        int currentYear = calendar.get(1);
        return expiryYear < currentYear ? false : (expiryYear > currentYear ? true : expiryMonth >= (readableMonth = calendar.get(2) + 1));
    }

    @IntRange(from=1000L, to=9999L)
    public final int convertTwoDigitYearToFour(@IntRange(from=0L, to=99L) int inputYear) {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"getInstance(...)");
        return this.convertTwoDigitYearToFour(inputYear, calendar);
    }

    @VisibleForTesting
    @IntRange(from=1000L, to=9999L)
    public final int convertTwoDigitYearToFour(@IntRange(from=0L, to=99L) int inputYear, @NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        int year = calendar.get(1);
        int centuryBase = year / 100;
        if (year % 100 > 80 && inputYear < 20) {
            ++centuryBase;
        } else if (year % 100 < 20 && inputYear > 80) {
            --centuryBase;
        }
        return centuryBase * 100 + inputYear;
    }
}

