/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import androidx.annotation.RestrictTo;
import com.stripe.android.core.exception.APIException;
import com.stripe.android.core.networking.StripeResponse;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0007\u00a8\u0006\u0004"}, d2={"responseJson", "Lorg/json/JSONObject;", "Lcom/stripe/android/core/networking/StripeResponse;", "", "stripe-core_release"})
public final class ResponseJsonKt {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final JSONObject responseJson(@NotNull StripeResponse<String> $this$responseJson) throws APIException {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter($this$responseJson, (String)"<this>");
        String string = $this$responseJson.getBody();
        if (string != null) {
            JSONObject jSONObject2;
            String it = string;
            boolean bl = false;
            try {
                jSONObject2 = new JSONObject(it);
            }
            catch (JSONException e) {
                List<String> list = $this$responseJson.getHeaderValue("Content-Type");
                throw new APIException(null, null, 0, StringsKt.trimIndent((String)("\n                    Exception while parsing response body.\n                      Status code: " + $this$responseJson.getCode() + "\n                      Request-Id: " + $this$responseJson.getRequestId() + "\n                      Content-Type: " + (list != null ? (String)CollectionsKt.firstOrNull(list) : null) + "\n                      Body: \"" + it + "\"\n                ")), e, 7, null);
            }
            jSONObject = jSONObject2;
        } else {
            jSONObject = new JSONObject();
        }
        return jSONObject;
    }
}

