/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.model.parsers;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.core.StripeError;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/core/model/parsers/StripeErrorJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/core/StripeError;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class StripeErrorJsonParser
implements ModelJsonParser<StripeError> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String MALFORMED_RESPONSE_MESSAGE = "An improperly formatted error response was found.";
    @NotNull
    public static final String FIELD_CHARGE = "charge";
    @NotNull
    public static final String FIELD_CODE = "code";
    @NotNull
    public static final String FIELD_DECLINE_CODE = "decline_code";
    @NotNull
    public static final String FIELD_EXTRA_FIELDS = "extra_fields";
    @NotNull
    public static final String FIELD_DOC_URL = "doc_url";
    @NotNull
    public static final String FIELD_ERROR = "error";
    @NotNull
    public static final String FIELD_MESSAGE = "message";
    @NotNull
    public static final String FIELD_PARAM = "param";
    @NotNull
    public static final String FIELD_TYPE = "type";

    @Override
    @NotNull
    public StripeError parse(@NotNull JSONObject json) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Object object2 = this;
        try {
            Map map;
            StripeErrorJsonParser $this$parse_u24lambda_u243 = object2;
            boolean bl = false;
            JSONObject errorObject = json.getJSONObject(FIELD_ERROR);
            boolean bl2 = false;
            String string = StripeJsonUtils.optString(errorObject, FIELD_CHARGE);
            String string2 = StripeJsonUtils.optString(errorObject, FIELD_CODE);
            String string3 = StripeJsonUtils.optString(errorObject, FIELD_DECLINE_CODE);
            String string4 = StripeJsonUtils.optString(errorObject, FIELD_MESSAGE);
            String string5 = StripeJsonUtils.optString(errorObject, FIELD_PARAM);
            String string6 = StripeJsonUtils.optString(errorObject, FIELD_TYPE);
            String string7 = StripeJsonUtils.optString(errorObject, FIELD_DOC_URL);
            JSONObject jSONObject = errorObject.optJSONObject(FIELD_EXTRA_FIELDS);
            if (jSONObject != null) {
                JSONObject extraFieldsJson = jSONObject;
                boolean bl3 = false;
                Iterator iterator = extraFieldsJson.keys();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
                map = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), arg_0 -> StripeErrorJsonParser.parse$lambda$3$lambda$2$lambda$1$lambda$0(extraFieldsJson, arg_0)));
            } else {
                map = null;
            }
            Map map2 = map;
            object = Result.constructor-impl((Object)new StripeError(string6, string4, string2, string5, string3, string, string7, map2));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = new StripeError(null, MALFORMED_RESPONSE_MESSAGE, null, null, null, null, null, null, 253, null);
        return (StripeError)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    private static final Pair parse$lambda$3$lambda$2$lambda$1$lambda$0(JSONObject $extraFieldsJson, String key) {
        return TuplesKt.to((Object)key, (Object)$extraFieldsJson.get(key).toString());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/core/model/parsers/StripeErrorJsonParser$Companion;", "", "<init>", "()V", "MALFORMED_RESPONSE_MESSAGE", "", "getMALFORMED_RESPONSE_MESSAGE$stripe_core_release$annotations", "FIELD_CHARGE", "FIELD_CODE", "FIELD_DECLINE_CODE", "FIELD_EXTRA_FIELDS", "FIELD_DOC_URL", "FIELD_ERROR", "FIELD_MESSAGE", "FIELD_PARAM", "FIELD_TYPE", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMALFORMED_RESPONSE_MESSAGE$stripe_core_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

