/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.mainthread;

import android.os.Looper;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.SavedStateHandle;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002H\b\u00a2\u0006\u0002\u0010\fJ&\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u0001H\bH\u0086\u0002\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u0004\u0018\u0001H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\nH\u0086\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/core/mainthread/MainThreadSavedStateHandle;", "", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "<init>", "(Landroidx/lifecycle/SavedStateHandle;)V", "getStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "T", "key", "", "initialValue", "(Ljava/lang/String;Ljava/lang/Object;)Lkotlinx/coroutines/flow/StateFlow;", "set", "", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MainThreadSavedStateHandle {
    @NotNull
    private final SavedStateHandle savedStateHandle;

    @Inject
    public MainThreadSavedStateHandle(@NotNull SavedStateHandle savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        this.savedStateHandle = savedStateHandle;
    }

    @NotNull
    public final <T> StateFlow<T> getStateFlow(@NotNull String key, T initialValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.savedStateHandle.getStateFlow(key, initialValue);
    }

    public final <T> void set(@NotNull String key, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper())) {
            // empty if block
        }
        this.savedStateHandle.set(key, value);
    }

    @Nullable
    public final <T> T get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (T)this.savedStateHandle.get(key);
    }
}

