/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.frauddetection;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.stripe.android.core.model.StripeModel;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 *2\u00020\u0001:\u0001*B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0013\u0010 \u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\u001fH\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006+"}, d2={"Lcom/stripe/android/core/frauddetection/FraudDetectionData;", "Lcom/stripe/android/core/model/StripeModel;", "guid", "", "muid", "sid", "timestamp", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;J)V", "getGuid", "()Ljava/lang/String;", "getMuid", "getSid", "getTimestamp", "()J", "params", "", "getParams", "()Ljava/util/Map;", "toJson", "Lorg/json/JSONObject;", "isExpired", "", "currentTime", "component1", "component2", "component3", "component4", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Parcelize
public final class FraudDetectionData
implements StripeModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String guid;
    @NotNull
    private final String muid;
    @NotNull
    private final String sid;
    private final long timestamp;
    @NotNull
    public static final Parcelable.Creator<FraudDetectionData> CREATOR;
    @NotNull
    private static final String KEY_GUID = "guid";
    @NotNull
    private static final String KEY_MUID = "muid";
    @NotNull
    private static final String KEY_SID = "sid";
    @NotNull
    public static final String KEY_TIMESTAMP = "timestamp";
    private static final long TTL;

    public FraudDetectionData(@NotNull String guid, @NotNull String muid, @NotNull String sid, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)guid, (String)KEY_GUID);
        Intrinsics.checkNotNullParameter((Object)muid, (String)KEY_MUID);
        Intrinsics.checkNotNullParameter((Object)sid, (String)KEY_SID);
        this.guid = guid;
        this.muid = muid;
        this.sid = sid;
        this.timestamp = timestamp;
    }

    public /* synthetic */ FraudDetectionData(String string, String string2, String string3, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l = 0L;
        }
        this(string, string2, string3, l);
    }

    @NotNull
    public final String getGuid() {
        return this.guid;
    }

    @NotNull
    public final String getMuid() {
        return this.muid;
    }

    @NotNull
    public final String getSid() {
        return this.sid;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final Map<String, String> getParams() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)KEY_GUID, (Object)this.guid), TuplesKt.to((Object)KEY_MUID, (Object)this.muid), TuplesKt.to((Object)KEY_SID, (Object)this.sid)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject().put(KEY_GUID, (Object)this.guid).put(KEY_MUID, (Object)this.muid).put(KEY_SID, (Object)this.sid).put(KEY_TIMESTAMP, this.timestamp);
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"put(...)");
        return jSONObject;
    }

    public final boolean isExpired(long currentTime) {
        return currentTime - this.timestamp > TTL;
    }

    public final void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeString(this.guid);
        dest.writeString(this.muid);
        dest.writeString(this.sid);
        dest.writeLong(this.timestamp);
    }

    public final int describeContents() {
        return 0;
    }

    @NotNull
    public final String component1() {
        return this.guid;
    }

    @NotNull
    public final String component2() {
        return this.muid;
    }

    @NotNull
    public final String component3() {
        return this.sid;
    }

    public final long component4() {
        return this.timestamp;
    }

    @NotNull
    public final FraudDetectionData copy(@NotNull String guid, @NotNull String muid, @NotNull String sid, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)guid, (String)KEY_GUID);
        Intrinsics.checkNotNullParameter((Object)muid, (String)KEY_MUID);
        Intrinsics.checkNotNullParameter((Object)sid, (String)KEY_SID);
        return new FraudDetectionData(guid, muid, sid, timestamp);
    }

    public static /* synthetic */ FraudDetectionData copy$default(FraudDetectionData fraudDetectionData, String string, String string2, String string3, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string = fraudDetectionData.guid;
        }
        if ((n & 2) != 0) {
            string2 = fraudDetectionData.muid;
        }
        if ((n & 4) != 0) {
            string3 = fraudDetectionData.sid;
        }
        if ((n & 8) != 0) {
            l = fraudDetectionData.timestamp;
        }
        return fraudDetectionData.copy(string, string2, string3, l);
    }

    @NotNull
    public String toString() {
        return "FraudDetectionData(guid=" + this.guid + ", muid=" + this.muid + ", sid=" + this.sid + ", timestamp=" + this.timestamp + ")";
    }

    @Override
    public int hashCode() {
        int result = this.guid.hashCode();
        result = result * 31 + this.muid.hashCode();
        result = result * 31 + this.sid.hashCode();
        result = result * 31 + Long.hashCode(this.timestamp);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FraudDetectionData)) {
            return false;
        }
        FraudDetectionData fraudDetectionData = (FraudDetectionData)other;
        if (!Intrinsics.areEqual((Object)this.guid, (Object)fraudDetectionData.guid)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.muid, (Object)fraudDetectionData.muid)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sid, (Object)fraudDetectionData.sid)) {
            return false;
        }
        return this.timestamp == fraudDetectionData.timestamp;
    }

    static {
        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<FraudDetectionData> {
            public final FraudDetectionData[] newArray(int size) {
                return new FraudDetectionData[size];
            }

            public final FraudDetectionData createFromParcel(Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new FraudDetectionData(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readLong());
            }
        }
        CREATOR = new Creator();
        TTL = TimeUnit.MINUTES.toMillis(30L);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/core/frauddetection/FraudDetectionData$Companion;", "", "<init>", "()V", "KEY_GUID", "", "KEY_MUID", "KEY_SID", "KEY_TIMESTAMP", "TTL", "", "stripe-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

