/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import androidx.annotation.RestrictTo;
import com.stripe.android.core.exception.InvalidRequestException;
import com.stripe.android.core.networking.QueryStringFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\u0004J\u001a\u0010\u0007\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0004J\u001a\u0010\b\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0004J\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0004H\u0002J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\r\u001a\u00020\u0005H\u0002J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0002J\u0014\u0010\u0013\u001a\u00020\u00122\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\nH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/core/networking/QueryStringFactory;", "", "()V", "compactParams", "", "", "params", "create", "createFromParamsWithEmptyValues", "flattenParams", "", "Lcom/stripe/android/core/networking/QueryStringFactory$Parameter;", "flattenParamsList", "keyPrefix", "flattenParamsMap", "flattenParamsValue", "value", "isPrimitive", "", "isPrimitiveList", "l", "Parameter", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nQueryStringFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryStringFactory.kt\ncom/stripe/android/core/networking/QueryStringFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,145:1\n1#2:146\n1726#3,3:147\n1360#3:150\n1446#3,5:151\n76#4:156\n96#4,5:157\n*S KotlinDebug\n*F\n+ 1 QueryStringFactory.kt\ncom/stripe/android/core/networking/QueryStringFactory\n*L\n71#1:147,3\n87#1:150\n87#1:151,5\n103#1:156\n103#1:157,5\n*E\n"})
public final class QueryStringFactory {
    @NotNull
    public static final QueryStringFactory INSTANCE = new QueryStringFactory();

    private QueryStringFactory() {
    }

    @NotNull
    public final String create(@Nullable Map<String, ?> params) {
        return CollectionsKt.joinToString$default((Iterable)this.flattenParams(params), (CharSequence)"&", null, null, (int)0, null, (Function1)create.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public final String createFromParamsWithEmptyValues(@Nullable Map<String, ?> params) {
        Map<String, ?> map;
        block3: {
            block2: {
                map = params;
                if (map == null) break block2;
                Map<String, ?> map2 = map;
                Object object = INSTANCE;
                Map<String, ?> p0 = map2;
                boolean bl = false;
                Map<String, Object> map3 = ((QueryStringFactory)object).compactParams(p0);
                map = map3;
                if (map3 == null) break block2;
                object = map;
                QueryStringFactory queryStringFactory = INSTANCE;
                Object p02 = object;
                boolean bl2 = false;
                String string = queryStringFactory.create((Map<String, ?>)p02);
                map = string;
                if (string != null) break block3;
            }
            map = "";
        }
        return map;
    }

    @NotNull
    public final Map<String, Object> compactParams(@NotNull Map<String, ?> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        HashMap compactParams = new HashMap(params);
        for (String key : new HashSet(compactParams.keySet())) {
            Object value = compactParams.get(key);
            if (value instanceof Map) {
                Map map = compactParams;
                Intrinsics.checkNotNull((Object)key);
                map.put(key, this.compactParams((Map)value));
                continue;
            }
            if (value != null) continue;
            compactParams.remove(key);
        }
        return compactParams;
    }

    private final List<Parameter> flattenParams(Map<String, ?> params) throws InvalidRequestException {
        return QueryStringFactory.flattenParamsMap$default(this, params, null, 2, null);
    }

    private final boolean isPrimitive(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character;
    }

    private final boolean isPrimitiveList(List<?> l) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = l;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (INSTANCE.isPrimitive(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Parameter> flattenParamsList(List<?> params, String keyPrefix) throws InvalidRequestException {
        List list;
        if (params.isEmpty()) {
            list = CollectionsKt.listOf((Object)new Parameter(keyPrefix, ""));
        } else if (this.isPrimitiveList(params)) {
            void $this$flatMapTo$iv$iv;
            String newPrefix = keyPrefix + "[]";
            Iterable $this$flatMap$iv = params;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                Object it = element$iv$iv = iterator.next();
                boolean bl = false;
                Iterable list$iv$iv = INSTANCE.flattenParamsValue(it, newPrefix);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            Iterable iterable = params;
            Collection collection = new ArrayList();
            int n = 0;
            for (Object t : iterable) {
                void value;
                int n2;
                if ((n2 = n++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object element$iv$iv = t;
                int index = n2;
                boolean bl = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)INSTANCE.flattenParamsValue(value, keyPrefix + "[" + index + "]"));
            }
            list = (List)collection;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Parameter> flattenParamsMap(Map<String, ?> params, String keyPrefix) throws InvalidRequestException {
        List list;
        block6: {
            block3: {
                void $this$flatMapTo$iv$iv;
                Map<String, ?> map = params;
                if (map == null) break block3;
                Map<String, ?> $this$flatMap$iv = map;
                boolean $i$f$flatMap = false;
                Map<String, ?> map2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object value;
                    block5: {
                        String key;
                        block4: {
                            Map.Entry element$iv$iv;
                            Map.Entry entry = element$iv$iv = iterator.next();
                            boolean bl = false;
                            key = (String)entry.getKey();
                            value = entry.getValue();
                            object = keyPrefix;
                            if (object == null) break block4;
                            String it = object;
                            boolean bl2 = false;
                            String string = it + "[" + key + "]";
                            object = string;
                            if (string != null) break block5;
                        }
                        object = key;
                    }
                    String newPrefix = object;
                    Iterable list$iv$iv = INSTANCE.flattenParamsValue(value, newPrefix);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
                break block6;
            }
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static /* synthetic */ List flattenParamsMap$default(QueryStringFactory queryStringFactory, Map map, String string, int n, Object object) throws InvalidRequestException {
        if ((n & 2) != 0) {
            string = null;
        }
        return queryStringFactory.flattenParamsMap(map, string);
    }

    private final List<Parameter> flattenParamsValue(Object value, String keyPrefix) throws InvalidRequestException {
        Object object = value;
        return object instanceof Map ? this.flattenParamsMap((Map)value, keyPrefix) : (object instanceof List ? this.flattenParamsList((List)value, keyPrefix) : (object == null ? CollectionsKt.listOf((Object)new Parameter(keyPrefix, "")) : CollectionsKt.listOf((Object)new Parameter(keyPrefix, value.toString()))));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0006\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\u001d\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/core/networking/QueryStringFactory$Parameter;", "", "key", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "urlEncode", "str", "stripe-core_release"})
    private static final class Parameter {
        @NotNull
        private final String key;
        @NotNull
        private final String value;

        public Parameter(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.key = key;
            this.value = value;
        }

        @NotNull
        public String toString() {
            String encodedKey = this.urlEncode(this.key);
            String encodedValue = this.urlEncode(this.value);
            return encodedKey + "=" + encodedValue;
        }

        private final String urlEncode(String str) throws UnsupportedEncodingException {
            String string = URLEncoder.encode(str, Charsets.UTF_8.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
            return string;
        }

        private final String component1() {
            return this.key;
        }

        private final String component2() {
            return this.value;
        }

        @NotNull
        public final Parameter copy(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Parameter(key, value);
        }

        public static /* synthetic */ Parameter copy$default(Parameter parameter, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameter.key;
            }
            if ((n & 2) != 0) {
                string2 = parameter.value;
            }
            return parameter.copy(string, string2);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = result * 31 + this.value.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parameter)) {
                return false;
            }
            Parameter parameter = (Parameter)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)parameter.key)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)parameter.value);
        }
    }
}

