/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class SetupIntent
extends StripeModel
implements StripeIntent {
    private static final String VALUE_SETUP_INTENT = "setup_intent";
    static final String FIELD_ID = "id";
    static final String FIELD_OBJECT = "object";
    static final String FIELD_CREATED = "created";
    static final String FIELD_CLIENT_SECRET = "client_secret";
    static final String FIELD_CUSTOMER = "customer";
    static final String FIELD_DESCRIPTION = "description";
    static final String FIELD_LIVEMODE = "livemode";
    static final String FIELD_NEXT_ACTION = "next_action";
    static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    static final String FIELD_STATUS = "status";
    static final String FIELD_USAGE = "usage";
    static final String FIELD_PAYMENT_METHOD = "payment_method";
    private static final String FIELD_NEXT_ACTION_TYPE = "type";
    @Nullable
    private final String mId;
    @Nullable
    private final String mObjectType;
    private final long mCreated;
    @Nullable
    private final String mClientSecret;
    @Nullable
    private final String mCustomerId;
    @Nullable
    private final String mDescription;
    private final boolean mLiveMode;
    @Nullable
    private final Map<String, Object> mNextAction;
    @Nullable
    private final StripeIntent.NextActionType mNextActionType;
    @Nullable
    private final String mPaymentMethodId;
    @Nullable
    private final List<String> mPaymentMethodTypes;
    @Nullable
    private final StripeIntent.Status mStatus;
    @Nullable
    private final StripeIntent.Usage mUsage;

    private SetupIntent(@NonNull Builder builder) {
        this.mId = builder.mId;
        this.mObjectType = builder.mObjectType;
        this.mCreated = builder.mCreated;
        this.mClientSecret = builder.mClientSecret;
        this.mCustomerId = builder.mCustomerId;
        this.mDescription = builder.mDescription;
        this.mLiveMode = builder.mLiveMode;
        this.mNextAction = builder.mNextAction;
        this.mNextActionType = this.mNextAction != null ? StripeIntent.NextActionType.fromCode((String)this.mNextAction.get(FIELD_NEXT_ACTION_TYPE)) : null;
        this.mPaymentMethodId = builder.mPaymentMethodId;
        this.mPaymentMethodTypes = builder.mPaymentMethodTypes;
        this.mStatus = builder.mStatus;
        this.mUsage = builder.mUsage;
    }

    @NonNull
    public static String parseIdFromClientSecret(@NonNull String clientSecret) {
        return clientSecret.split("_secret")[0];
    }

    @Nullable
    public String getId() {
        return this.mId;
    }

    public long getCreated() {
        return this.mCreated;
    }

    @Nullable
    public String getCustomerId() {
        return this.mCustomerId;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    public boolean getLiveMode() {
        return this.mLiveMode;
    }

    @Nullable
    public String getPaymentMethodId() {
        return this.mPaymentMethodId;
    }

    @NonNull
    public List<String> getPaymentMethodTypes() {
        return this.mPaymentMethodTypes;
    }

    @Nullable
    public StripeIntent.Usage getUsage() {
        return this.mUsage;
    }

    @Override
    public boolean requiresAction() {
        return this.mStatus == StripeIntent.Status.RequiresAction;
    }

    @Override
    public boolean requiresConfirmation() {
        return this.mStatus == StripeIntent.Status.RequiresConfirmation;
    }

    @Override
    @Nullable
    public StripeIntent.NextActionType getNextActionType() {
        return this.mNextActionType;
    }

    @Override
    @Nullable
    public StripeIntent.RedirectData getRedirectData() {
        Object redirectToUrl;
        if (StripeIntent.NextActionType.RedirectToUrl != this.mNextActionType) {
            return null;
        }
        Map<String, Object> nextAction = StripeIntent.Status.RequiresAction == this.mStatus ? this.mNextAction : null;
        if (nextAction == null) {
            return null;
        }
        StripeIntent.NextActionType nextActionType = StripeIntent.NextActionType.fromCode((String)nextAction.get(FIELD_NEXT_ACTION_TYPE));
        if (StripeIntent.NextActionType.RedirectToUrl == nextActionType && (redirectToUrl = nextAction.get(nextActionType.code)) instanceof Map) {
            return StripeIntent.RedirectData.create((Map)redirectToUrl);
        }
        return null;
    }

    @Override
    @Nullable
    public String getClientSecret() {
        return this.mClientSecret;
    }

    @Nullable
    public Uri getRedirectUrl() {
        StripeIntent.RedirectData redirectData = this.getRedirectData();
        if (redirectData == null) {
            return null;
        }
        return redirectData.url;
    }

    @Override
    @Nullable
    public StripeIntent.SdkData getStripeSdkData() {
        if (this.mNextAction == null || StripeIntent.NextActionType.UseStripeSdk != this.mNextActionType) {
            return null;
        }
        return new StripeIntent.SdkData((Map)this.mNextAction.get(StripeIntent.NextActionType.UseStripeSdk.code));
    }

    @Override
    @Nullable
    public StripeIntent.Status getStatus() {
        return this.mStatus;
    }

    @Nullable
    public static SetupIntent fromString(@Nullable String jsonString) {
        try {
            return SetupIntent.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static SetupIntent fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null || !VALUE_SETUP_INTENT.equals(jsonObject.optString(FIELD_OBJECT))) {
            return null;
        }
        return new Builder().setId(StripeJsonUtils.optString(jsonObject, FIELD_ID)).setObjectType(StripeJsonUtils.optString(jsonObject, FIELD_OBJECT)).setCreated(jsonObject.optLong(FIELD_CREATED)).setClientSecret(StripeJsonUtils.optString(jsonObject, FIELD_CLIENT_SECRET)).setCustomerId(StripeJsonUtils.optString(jsonObject, FIELD_CUSTOMER)).setDescription(StripeJsonUtils.optString(jsonObject, FIELD_DESCRIPTION)).setLiveMode(jsonObject.optBoolean(FIELD_LIVEMODE)).setPaymentMethodId(StripeJsonUtils.optString(jsonObject, FIELD_PAYMENT_METHOD)).setPaymentMethodTypes(SetupIntent.jsonArrayToList(jsonObject.optJSONArray(FIELD_PAYMENT_METHOD_TYPES))).setStatus(StripeIntent.Status.fromCode(StripeJsonUtils.optString(jsonObject, FIELD_STATUS))).setUsage(StripeIntent.Usage.fromCode(StripeJsonUtils.optString(jsonObject, FIELD_USAGE))).setNextAction(StripeJsonUtils.optMap(jsonObject, FIELD_NEXT_ACTION)).build();
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ((AbstractMap)map).put(FIELD_ID, this.mId);
        ((AbstractMap)map).put(FIELD_OBJECT, this.mObjectType);
        ((AbstractMap)map).put(FIELD_PAYMENT_METHOD, this.mPaymentMethodId);
        ((AbstractMap)map).put(FIELD_PAYMENT_METHOD_TYPES, this.mPaymentMethodTypes);
        ((AbstractMap)map).put(FIELD_CLIENT_SECRET, this.mClientSecret);
        ((AbstractMap)map).put(FIELD_CREATED, this.mCreated);
        ((AbstractMap)map).put(FIELD_CUSTOMER, this.mCustomerId);
        ((AbstractMap)map).put(FIELD_DESCRIPTION, this.mDescription);
        ((AbstractMap)map).put(FIELD_LIVEMODE, this.mLiveMode);
        ((AbstractMap)map).put(FIELD_NEXT_ACTION, this.mNextAction);
        ((AbstractMap)map).put(FIELD_STATUS, this.mStatus != null ? this.mStatus.code : null);
        ((AbstractMap)map).put(FIELD_USAGE, this.mUsage != null ? this.mUsage.code : null);
        StripeNetworkUtils.removeNullAndEmptyParams(map);
        return map;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof SetupIntent && this.typedEquals((SetupIntent)obj);
    }

    private boolean typedEquals(@NonNull SetupIntent setupIntent) {
        return ObjectUtils.equals(this.mId, setupIntent.mId) && ObjectUtils.equals(this.mObjectType, setupIntent.mObjectType) && ObjectUtils.equals(this.mClientSecret, setupIntent.mClientSecret) && ObjectUtils.equals(this.mCreated, setupIntent.mCreated) && ObjectUtils.equals(this.mCustomerId, setupIntent.mCustomerId) && ObjectUtils.equals(this.mDescription, setupIntent.mDescription) && ObjectUtils.equals(this.mLiveMode, setupIntent.mLiveMode) && ObjectUtils.equals((Object)this.mStatus, (Object)setupIntent.mStatus) && ObjectUtils.equals((Object)this.mUsage, (Object)setupIntent.mUsage) && ObjectUtils.equals(this.mPaymentMethodId, setupIntent.mPaymentMethodId) && ObjectUtils.equals(this.mPaymentMethodTypes, setupIntent.mPaymentMethodTypes) && ObjectUtils.equals(this.mNextAction, setupIntent.mNextAction) && ObjectUtils.equals((Object)this.mNextActionType, (Object)setupIntent.mNextActionType);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash(new Object[]{this.mId, this.mObjectType, this.mCustomerId, this.mClientSecret, this.mCreated, this.mDescription, this.mLiveMode, this.mStatus, this.mPaymentMethodId, this.mPaymentMethodTypes, this.mNextAction, this.mNextActionType, this.mUsage});
    }

    static final class Builder
    implements ObjectBuilder<SetupIntent> {
        @Nullable
        String mId;
        @Nullable
        String mObjectType;
        long mCreated;
        @Nullable
        String mClientSecret;
        @Nullable
        String mCustomerId;
        @Nullable
        String mDescription;
        boolean mLiveMode;
        @Nullable
        Map<String, Object> mNextAction;
        @Nullable
        String mPaymentMethodId;
        @Nullable
        List<String> mPaymentMethodTypes;
        @Nullable
        StripeIntent.Status mStatus;
        @Nullable
        StripeIntent.Usage mUsage;

        Builder() {
        }

        @NonNull
        Builder setId(@Nullable String id2) {
            this.mId = id2;
            return this;
        }

        @NonNull
        Builder setObjectType(@Nullable String objectType) {
            this.mObjectType = objectType;
            return this;
        }

        @NonNull
        Builder setCreated(long created) {
            this.mCreated = created;
            return this;
        }

        @NonNull
        Builder setClientSecret(@Nullable String clientSecret) {
            this.mClientSecret = clientSecret;
            return this;
        }

        @NonNull
        Builder setCustomerId(@Nullable String customerId) {
            this.mCustomerId = customerId;
            return this;
        }

        @NonNull
        Builder setDescription(@Nullable String description) {
            this.mDescription = description;
            return this;
        }

        @NonNull
        Builder setLiveMode(boolean liveMode) {
            this.mLiveMode = liveMode;
            return this;
        }

        @NonNull
        Builder setNextAction(@Nullable Map<String, Object> nextAction) {
            this.mNextAction = nextAction;
            return this;
        }

        @NonNull
        Builder setPaymentMethodId(@Nullable String paymentMethodId) {
            this.mPaymentMethodId = paymentMethodId;
            return this;
        }

        @NonNull
        Builder setPaymentMethodTypes(@Nullable List<String> paymentMethodTypes) {
            this.mPaymentMethodTypes = paymentMethodTypes;
            return this;
        }

        @NonNull
        Builder setStatus(@Nullable StripeIntent.Status status) {
            this.mStatus = status;
            return this;
        }

        @NonNull
        Builder setUsage(@Nullable StripeIntent.Usage usage) {
            this.mUsage = usage;
            return this;
        }

        @Override
        @NonNull
        public SetupIntent build() {
            return new SetupIntent(this);
        }
    }
}

