/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Map;
import java.util.Objects;

public interface StripeIntent {
    public boolean requiresAction();

    public boolean requiresConfirmation();

    @Nullable
    public NextActionType getNextActionType();

    @Nullable
    public RedirectData getRedirectData();

    @Nullable
    public String getClientSecret();

    @Nullable
    public SdkData getStripeSdkData();

    @Nullable
    public Status getStatus();

    public static final class RedirectData {
        static final String FIELD_URL = "url";
        static final String FIELD_RETURN_URL = "return_url";
        @NonNull
        public final Uri url;
        @Nullable
        public final Uri returnUrl;

        @Nullable
        static RedirectData create(@NonNull Map<?, ?> redirectToUrlHash) {
            String returnUrl;
            Object urlObj = redirectToUrlHash.get(FIELD_URL);
            Object returnUrlObj = redirectToUrlHash.get(FIELD_RETURN_URL);
            String url = urlObj instanceof String ? urlObj.toString() : null;
            String string = returnUrl = returnUrlObj instanceof String ? returnUrlObj.toString() : null;
            if (url == null) {
                return null;
            }
            return new RedirectData(url, returnUrl);
        }

        RedirectData(@NonNull String url, @Nullable String returnUrl) {
            this.url = Uri.parse((String)url);
            this.returnUrl = returnUrl != null ? Uri.parse((String)returnUrl) : null;
        }
    }

    public static final class SdkData {
        private static final String FIELD_TYPE = "type";
        private static final String TYPE_3DS2 = "stripe_3ds2_fingerprint";
        private static final String TYPE_3DS1 = "three_d_secure_redirect";
        @NonNull
        final String type;
        @NonNull
        final Map<String, ?> data;

        SdkData(@NonNull Map<String, ?> data) {
            this.type = Objects.requireNonNull((String)data.get(FIELD_TYPE));
            this.data = data;
        }

        public boolean is3ds2() {
            return TYPE_3DS2.equals(this.type);
        }

        public boolean is3ds1() {
            return TYPE_3DS1.equals(this.type);
        }
    }

    public static enum Usage {
        OnSession("on_session"),
        OffSession("off_session"),
        OneTime("one_time");

        @NonNull
        public final String code;

        private Usage(String code) {
            this.code = code;
        }

        @Nullable
        public static Usage fromCode(@Nullable String code) {
            if (code == null) {
                return null;
            }
            for (Usage usage : Usage.values()) {
                if (!usage.code.equals(code)) continue;
                return usage;
            }
            return null;
        }

        @NonNull
        public String toString() {
            return this.code;
        }
    }

    public static enum Status {
        Canceled("canceled"),
        Processing("processing"),
        RequiresAction("requires_action"),
        RequiresAuthorization("requires_authorization"),
        RequiresCapture("requires_capture"),
        RequiresConfirmation("requires_confirmation"),
        RequiresPaymentMethod("requires_payment_method"),
        Succeeded("succeeded");

        @NonNull
        public final String code;

        private Status(String code) {
            this.code = code;
        }

        @Nullable
        public static Status fromCode(@Nullable String code) {
            if (code == null) {
                return null;
            }
            for (Status status : Status.values()) {
                if (!status.code.equals(code)) continue;
                return status;
            }
            return null;
        }

        @NonNull
        public String toString() {
            return this.code;
        }
    }

    public static enum NextActionType {
        RedirectToUrl("redirect_to_url"),
        UseStripeSdk("use_stripe_sdk");

        @NonNull
        public final String code;

        private NextActionType(String code) {
            this.code = code;
        }

        @Nullable
        public static NextActionType fromCode(@Nullable String code) {
            if (code == null) {
                return null;
            }
            for (NextActionType nextActionType : NextActionType.values()) {
                if (!nextActionType.code.equals(code)) continue;
                return nextActionType;
            }
            return null;
        }

        @NonNull
        public String toString() {
            return this.code;
        }
    }
}

