/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.PaymentAuthConfig;
import com.stripe.android.PaymentAuthWebViewStarter;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.PaymentRelayStarter;
import com.stripe.android.SetupIntentResult;
import com.stripe.android.Stripe;
import com.stripe.android.Stripe3ds2AuthParams;
import com.stripe.android.Stripe3ds2CompletionStarter;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentIntentParams;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.SetupIntentParams;
import com.stripe.android.model.Stripe3ds2AuthResult;
import com.stripe.android.model.Stripe3ds2Fingerprint;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.StripeIntentParams;
import com.stripe.android.stripe3ds2.init.ConfigParameters;
import com.stripe.android.stripe3ds2.init.StripeConfigParameters;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2Service;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2ServiceImpl;
import com.stripe.android.stripe3ds2.transaction.AuthenticationRequestParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeStatusReceiver;
import com.stripe.android.stripe3ds2.transaction.CompletionEvent;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.ProtocolErrorEvent;
import com.stripe.android.stripe3ds2.transaction.RuntimeErrorEvent;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeStatusReceiver;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.stripe3ds2.views.ChallengeProgressDialogActivity;
import com.stripe.android.view.ActivityStarter;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

class PaymentController {
    static final int PAYMENT_REQUEST_CODE = 50000;
    static final int SETUP_REQUEST_CODE = 50001;
    @NonNull
    private final StripeThreeDs2Service mThreeDs2Service;
    @NonNull
    private final StripeApiHandler mApiHandler;
    @NonNull
    private final MessageVersionRegistry mMessageVersionRegistry;
    @NonNull
    private final PaymentAuthConfig mConfig;
    @NonNull
    private final ApiKeyValidator mApiKeyValidator;

    PaymentController(@NonNull Context context, @NonNull StripeApiHandler apiHandler) {
        this(context, (StripeThreeDs2Service)new StripeThreeDs2ServiceImpl(context), apiHandler, new MessageVersionRegistry(), PaymentAuthConfig.get());
    }

    @VisibleForTesting
    PaymentController(@NonNull Context context, @NonNull StripeThreeDs2Service threeDs2Service, @NonNull StripeApiHandler apiHandler, @NonNull MessageVersionRegistry messageVersionRegistry, @NonNull PaymentAuthConfig config) {
        this.mConfig = config;
        this.mThreeDs2Service = threeDs2Service;
        this.mThreeDs2Service.initialize(context, (ConfigParameters)new StripeConfigParameters(), null, config.stripe3ds2Config.uiCustomization.getUiCustomization());
        this.mApiHandler = apiHandler;
        this.mMessageVersionRegistry = messageVersionRegistry;
        this.mApiKeyValidator = new ApiKeyValidator();
    }

    void startConfirmAndAuth(@NonNull Stripe stripe, @NonNull Activity activity, @NonNull StripeIntentParams stripeIntentParams, @NonNull String publishableKey) {
        this.mApiKeyValidator.requireValid(publishableKey);
        new ConfirmStripeIntentTask(stripe, stripeIntentParams, publishableKey, new ConfirmStripeIntentCallback(activity, publishableKey, this, PaymentController.getRequestCode(stripeIntentParams))).execute(new Void[0]);
    }

    void startAuth(@NonNull Activity activity, @NonNull StripeIntent stripeIntent, @NonNull String publishableKey) {
        this.handleNextAction(activity, stripeIntent, this.mApiKeyValidator.requireValid(publishableKey));
    }

    boolean shouldHandlePaymentResult(int requestCode, int resultCode, @Nullable Intent data) {
        return requestCode == 50000 && resultCode == -1 && data != null;
    }

    boolean shouldHandleSetupResult(int requestCode, int resultCode, @Nullable Intent data) {
        return requestCode == 50001 && resultCode == -1 && data != null;
    }

    void handlePaymentResult(@NonNull Stripe stripe, @NonNull Intent data, @NonNull String publishableKey, final @NonNull ApiResultCallback<PaymentIntentResult> callback) {
        Exception authException = (Exception)data.getSerializableExtra("exception");
        if (authException != null) {
            callback.onError(authException);
            return;
        }
        final int authStatus = data.getIntExtra("status", 0);
        new RetrieveIntentTask(stripe, this.createPaymentIntentParams(data), publishableKey, new ApiResultCallback<StripeIntent>(){

            @Override
            public void onSuccess(@NonNull StripeIntent stripeIntent) {
                if (stripeIntent instanceof PaymentIntent) {
                    callback.onSuccess(new PaymentIntentResult.Builder().setPaymentIntent((PaymentIntent)stripeIntent).setStatus(authStatus).build());
                }
            }

            @Override
            public void onError(@NonNull Exception e) {
                callback.onError(e);
            }
        }).execute(new Void[0]);
    }

    void handleSetupResult(@NonNull Stripe stripe, @NonNull Intent data, @NonNull String publishableKey, final @NonNull ApiResultCallback<SetupIntentResult> callback) {
        Exception authException = (Exception)data.getSerializableExtra("exception");
        if (authException != null) {
            callback.onError(authException);
            return;
        }
        final int authStatus = data.getIntExtra("status", 0);
        new RetrieveIntentTask(stripe, this.createSetupIntentParams(data), publishableKey, new ApiResultCallback<StripeIntent>(){

            @Override
            public void onSuccess(@NonNull StripeIntent stripeIntent) {
                if (stripeIntent instanceof SetupIntent) {
                    callback.onSuccess(new SetupIntentResult.Builder().setSetupIntent((SetupIntent)stripeIntent).setStatus(authStatus).build());
                }
            }

            @Override
            public void onError(@NonNull Exception e) {
                callback.onError(e);
            }
        }).execute(new Void[0]);
    }

    @VisibleForTesting
    @NonNull
    PaymentIntentParams createPaymentIntentParams(@NonNull Intent data) {
        String clientSecret = data.getStringExtra("client_secret");
        return PaymentIntentParams.createRetrievePaymentIntentParams(clientSecret);
    }

    @VisibleForTesting
    @NonNull
    SetupIntentParams createSetupIntentParams(@NonNull Intent data) {
        String clientSecret = data.getStringExtra("client_secret");
        return SetupIntentParams.createRetrieveParams(clientSecret);
    }

    @VisibleForTesting
    void handleNextAction(@NonNull Activity activity, @NonNull StripeIntent stripeIntent, @NonNull String publishableKey) {
        if (stripeIntent.requiresAction()) {
            StripeIntent.NextActionType nextActionType = stripeIntent.getNextActionType();
            if (StripeIntent.NextActionType.UseStripeSdk == nextActionType) {
                StripeIntent.SdkData sdkData = Objects.requireNonNull(stripeIntent.getStripeSdkData());
                if (sdkData.is3ds2()) {
                    this.begin3ds2Auth(activity, stripeIntent, Stripe3ds2Fingerprint.create(sdkData), publishableKey);
                } else {
                    this.bypassAuth(activity, stripeIntent);
                }
            } else if (StripeIntent.NextActionType.RedirectToUrl == nextActionType) {
                this.begin3ds1Auth(activity, PaymentController.getRequestCode(stripeIntent), Objects.requireNonNull(stripeIntent.getRedirectData()));
            } else {
                this.bypassAuth(activity, stripeIntent);
            }
        } else {
            this.bypassAuth(activity, stripeIntent);
        }
    }

    static int getRequestCode(@NonNull StripeIntent intent) {
        if (intent instanceof PaymentIntent) {
            return 50000;
        }
        return 50001;
    }

    static int getRequestCode(@NonNull StripeIntentParams params) {
        if (params instanceof PaymentIntentParams) {
            return 50000;
        }
        return 50001;
    }

    private void bypassAuth(@NonNull Activity activity, @NonNull StripeIntent stripeIntent) {
        new PaymentRelayStarter(activity, PaymentController.getRequestCode(stripeIntent)).start(new PaymentRelayStarter.Data(stripeIntent));
    }

    private void begin3ds2Auth(@NonNull Activity activity, @NonNull StripeIntent stripeIntent, @NonNull Stripe3ds2Fingerprint stripe3ds2Fingerprint, @NonNull String publishableKey) {
        Transaction transaction = this.mThreeDs2Service.createTransaction(stripe3ds2Fingerprint.directoryServer.id, this.mMessageVersionRegistry.getCurrent(), false, stripe3ds2Fingerprint.directoryServer.name);
        ChallengeProgressDialogActivity.show((Context)activity, (String)stripe3ds2Fingerprint.directoryServer.name);
        AuthenticationRequestParameters areqParams = transaction.getAuthenticationRequestParameters();
        int timeout = this.mConfig.stripe3ds2Config.timeout;
        Stripe3ds2AuthParams authParams = new Stripe3ds2AuthParams(stripe3ds2Fingerprint.source, areqParams.getSDKAppID(), areqParams.getSDKReferenceNumber(), areqParams.getSDKTransactionID(), areqParams.getDeviceData(), areqParams.getSDKEphemeralPublicKey(), areqParams.getMessageVersion(), timeout);
        this.mApiHandler.start3ds2Auth(authParams, publishableKey, new Stripe3ds2AuthCallback(activity, this.mApiHandler, transaction, timeout, stripeIntent, stripe3ds2Fingerprint.source, publishableKey));
    }

    private void begin3ds1Auth(@NonNull Activity activity, int requestCode, @NonNull StripeIntent.RedirectData redirectData) {
        new PaymentAuthWebViewStarter(activity, requestCode).start(redirectData);
    }

    private static void handleError(@NonNull Activity activity, int requestCode, @NonNull Exception exception) {
        new PaymentRelayStarter(activity, requestCode).start(new PaymentRelayStarter.Data(exception));
    }

    static final class PaymentAuth3ds2ChallengeStatusReceiver
    extends StripeChallengeStatusReceiver {
        @NonNull
        private final WeakReference<Activity> mActivityRef;
        @NonNull
        private final ActivityStarter<Stripe3ds2CompletionStarter.StartData> mStarter;
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final StripeIntent mStripeIntent;
        @NonNull
        private final String mSourceId;
        @NonNull
        private final String mPublishableKey;

        @NonNull
        static PaymentAuth3ds2ChallengeStatusReceiver create(@NonNull Activity activity, @NonNull StripeApiHandler apiHandler, @NonNull StripeIntent stripeIntent, @NonNull String sourceId, @NonNull String publishableKey) {
            return new PaymentAuth3ds2ChallengeStatusReceiver(activity, new Stripe3ds2CompletionStarter(activity, PaymentController.getRequestCode(stripeIntent)), apiHandler, stripeIntent, sourceId, publishableKey);
        }

        PaymentAuth3ds2ChallengeStatusReceiver(@NonNull Activity activity, @NonNull ActivityStarter<Stripe3ds2CompletionStarter.StartData> starter, @NonNull StripeApiHandler apiHandler, @NonNull StripeIntent stripeIntent, @NonNull String sourceId, @NonNull String publishableKey) {
            this.mActivityRef = new WeakReference<Activity>(activity);
            this.mStarter = starter;
            this.mApiHandler = apiHandler;
            this.mStripeIntent = stripeIntent;
            this.mSourceId = sourceId;
            this.mPublishableKey = publishableKey;
        }

        public void completed(@NonNull CompletionEvent completionEvent) {
            super.completed(completionEvent);
            this.notifyCompletion(Stripe3ds2CompletionStarter.StartData.createForComplete(this.mStripeIntent, completionEvent.getTransactionStatus()));
        }

        public void cancelled() {
            super.cancelled();
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.mStripeIntent, 1));
        }

        public void timedout() {
            super.timedout();
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.mStripeIntent, 2));
        }

        public void protocolError(@NonNull ProtocolErrorEvent protocolErrorEvent) {
            super.protocolError(protocolErrorEvent);
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.mStripeIntent, 3));
        }

        public void runtimeError(@NonNull RuntimeErrorEvent runtimeErrorEvent) {
            super.runtimeError(runtimeErrorEvent);
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.mStripeIntent, 4));
        }

        private void notifyCompletion(final @NonNull Stripe3ds2CompletionStarter.StartData startData) {
            this.mApiHandler.complete3ds2Auth(this.mSourceId, this.mPublishableKey, new ApiResultCallback<Boolean>(){

                @Override
                public void onSuccess(@NonNull Boolean result) {
                    PaymentAuth3ds2ChallengeStatusReceiver.this.mStarter.start(startData);
                }

                @Override
                public void onError(@NonNull Exception e) {
                    Activity activity = (Activity)PaymentAuth3ds2ChallengeStatusReceiver.this.mActivityRef.get();
                    if (activity != null) {
                        PaymentController.handleError(activity, PaymentController.getRequestCode(PaymentAuth3ds2ChallengeStatusReceiver.this.mStripeIntent), e);
                    }
                }
            });
        }
    }

    static final class Stripe3ds2AuthCallback
    implements ApiResultCallback<Stripe3ds2AuthResult> {
        @NonNull
        private final WeakReference<Activity> mActivityRef;
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final Transaction mTransaction;
        private final int mMaxTimeout;
        @NonNull
        private final StripeIntent mStripeIntent;
        @NonNull
        private final String mSourceId;
        @NonNull
        private final String mPublishableKey;
        @NonNull
        private final PaymentRelayStarter mPaymentRelayStarter;
        @NonNull
        private final Handler mBackgroundHandler;

        private Stripe3ds2AuthCallback(@NonNull Activity activity, @NonNull StripeApiHandler apiHandler, @NonNull Transaction transaction, int maxTimeout, @NonNull StripeIntent stripeIntent, @NonNull String sourceId, @NonNull String publishableKey) {
            this(activity, apiHandler, transaction, maxTimeout, stripeIntent, sourceId, publishableKey, new PaymentRelayStarter(activity, PaymentController.getRequestCode(stripeIntent)));
        }

        @VisibleForTesting
        Stripe3ds2AuthCallback(@NonNull Activity activity, @NonNull StripeApiHandler apiHandler, @NonNull Transaction transaction, int maxTimeout, @NonNull StripeIntent stripeIntent, @NonNull String sourceId, @NonNull String publishableKey, @NonNull PaymentRelayStarter paymentRelayStarter) {
            this.mActivityRef = new WeakReference<Activity>(activity);
            this.mApiHandler = apiHandler;
            this.mTransaction = transaction;
            this.mMaxTimeout = maxTimeout;
            this.mStripeIntent = stripeIntent;
            this.mSourceId = sourceId;
            this.mPublishableKey = publishableKey;
            this.mPaymentRelayStarter = paymentRelayStarter;
            HandlerThread handlerThread = new HandlerThread(Stripe3ds2AuthCallback.class.getSimpleName());
            handlerThread.start();
            this.mBackgroundHandler = new Handler(handlerThread.getLooper());
        }

        @Override
        public void onSuccess(@NonNull Stripe3ds2AuthResult result) {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity == null) {
                return;
            }
            Stripe3ds2AuthResult.Ares ares = result.ares;
            if (ares != null) {
                if (ares.shouldChallenge()) {
                    this.startChallengeFlow(activity, ares);
                } else {
                    this.startFrictionlessFlow();
                }
            } else {
                Stripe3ds2AuthResult.ThreeDS2Error error = result.error;
                String errorMessage = error != null ? "Code: " + error.errorCode + ", Detail: " + error.errorDetail + ", Description: " + error.errorDescription + ", Component: " + error.errorComponent : "Invalid 3DS2 authentication response";
                this.onError(new RuntimeException("Error encountered during 3DS2 authentication request. " + errorMessage));
            }
        }

        @Override
        public void onError(@NonNull Exception e) {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity != null) {
                this.mPaymentRelayStarter.start(new PaymentRelayStarter.Data(e));
            }
        }

        private void startFrictionlessFlow() {
            this.mPaymentRelayStarter.start(new PaymentRelayStarter.Data(this.mStripeIntent));
        }

        private void startChallengeFlow(final @NonNull Activity activity, @NonNull Stripe3ds2AuthResult.Ares ares) {
            final StripeChallengeParameters challengeParameters = new StripeChallengeParameters();
            challengeParameters.setAcsSignedContent(ares.acsSignedContent);
            challengeParameters.set3DSServerTransactionID(ares.threeDSServerTransId);
            challengeParameters.setAcsTransactionID(ares.acsTransId);
            this.mBackgroundHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Stripe3ds2AuthCallback.this.mTransaction.doChallenge(activity, (ChallengeParameters)challengeParameters, (ChallengeStatusReceiver)PaymentAuth3ds2ChallengeStatusReceiver.create(activity, Stripe3ds2AuthCallback.this.mApiHandler, Stripe3ds2AuthCallback.this.mStripeIntent, Stripe3ds2AuthCallback.this.mSourceId, Stripe3ds2AuthCallback.this.mPublishableKey), Stripe3ds2AuthCallback.this.mMaxTimeout);
                }
            }, TimeUnit.SECONDS.toMillis(2L));
        }
    }

    private static final class ConfirmStripeIntentCallback
    implements ApiResultCallback<StripeIntent> {
        @NonNull
        private final WeakReference<Activity> mActivityRef;
        @NonNull
        private final String mPublishableKey;
        @NonNull
        private final PaymentController mPaymentController;
        private final int mRequestCode;

        private ConfirmStripeIntentCallback(@NonNull Activity activity, @NonNull String publishableKey, @NonNull PaymentController paymentController, int requestCode) {
            this.mActivityRef = new WeakReference<Activity>(activity);
            this.mPublishableKey = publishableKey;
            this.mPaymentController = paymentController;
            this.mRequestCode = requestCode;
        }

        @Override
        public void onSuccess(@NonNull StripeIntent stripeIntent) {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity != null) {
                this.mPaymentController.handleNextAction(activity, stripeIntent, this.mPublishableKey);
            }
        }

        @Override
        public void onError(@NonNull Exception e) {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity != null) {
                PaymentController.handleError(activity, this.mRequestCode, e);
            }
        }
    }

    private static final class ConfirmStripeIntentTask
    extends ApiOperation<StripeIntent> {
        @NonNull
        private final Stripe mStripe;
        @NonNull
        private final StripeIntentParams mParams;
        @NonNull
        private final String mPublishableKey;

        private ConfirmStripeIntentTask(@NonNull Stripe stripe, @NonNull StripeIntentParams params, @NonNull String publishableKey, @NonNull ApiResultCallback<StripeIntent> callback) {
            super(callback);
            this.mStripe = stripe;
            this.mParams = params;
            this.mPublishableKey = publishableKey;
        }

        @Override
        @Nullable
        StripeIntent getResult() throws StripeException {
            if (this.mParams instanceof PaymentIntentParams) {
                return this.mStripe.confirmPaymentIntentSynchronous((PaymentIntentParams)this.mParams, this.mPublishableKey);
            }
            if (this.mParams instanceof SetupIntentParams) {
                return this.mStripe.confirmSetupIntentSynchronous((SetupIntentParams)this.mParams, this.mPublishableKey);
            }
            return null;
        }
    }

    private static final class RetrieveIntentTask
    extends ApiOperation<StripeIntent> {
        @NonNull
        private final Stripe mStripe;
        @NonNull
        private final StripeIntentParams mParams;
        @NonNull
        private final String mPublishableKey;

        private RetrieveIntentTask(@NonNull Stripe stripe, @NonNull StripeIntentParams params, @NonNull String publishableKey, @NonNull ApiResultCallback<StripeIntent> callback) {
            super(callback);
            this.mStripe = stripe;
            this.mParams = params;
            this.mPublishableKey = publishableKey;
        }

        @Override
        @Nullable
        StripeIntent getResult() throws StripeException {
            if (this.mParams instanceof PaymentIntentParams) {
                return this.mStripe.retrievePaymentIntentSynchronous((PaymentIntentParams)this.mParams, this.mPublishableKey);
            }
            if (this.mParams instanceof SetupIntentParams) {
                return this.mStripe.retrieveSetupIntentSynchronous((SetupIntentParams)this.mParams, this.mPublishableKey);
            }
            return null;
        }
    }
}

