/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.Card;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceCardData;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.utils.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class CustomerSource
extends StripeModel
implements StripePaymentSource {
    @NonNull
    private final StripePaymentSource mStripePaymentSource;

    private CustomerSource(@NonNull StripePaymentSource paymentSource) {
        this.mStripePaymentSource = paymentSource;
    }

    @NonNull
    public StripePaymentSource getStripePaymentSource() {
        return this.mStripePaymentSource;
    }

    @Override
    @Nullable
    public String getId() {
        return this.mStripePaymentSource.getId();
    }

    @Nullable
    public Source asSource() {
        if (this.mStripePaymentSource instanceof Source) {
            return (Source)this.mStripePaymentSource;
        }
        return null;
    }

    @Nullable
    public String getTokenizationMethod() {
        Source paymentAsSource = this.asSource();
        Card paymentAsCard = this.asCard();
        if (paymentAsSource != null && "card".equals(paymentAsSource.getType())) {
            SourceCardData cardData = (SourceCardData)paymentAsSource.getSourceTypeModel();
            if (cardData != null) {
                return cardData.getTokenizationMethod();
            }
        } else if (paymentAsCard != null) {
            return paymentAsCard.getTokenizationMethod();
        }
        return null;
    }

    @Nullable
    public Card asCard() {
        if (this.mStripePaymentSource instanceof Card) {
            return (Card)this.mStripePaymentSource;
        }
        return null;
    }

    @NonNull
    public String getSourceType() {
        if (this.mStripePaymentSource instanceof Card) {
            return "card";
        }
        if (this.mStripePaymentSource instanceof Source) {
            return ((Source)this.mStripePaymentSource).getType();
        }
        return "unknown";
    }

    @Nullable
    public static CustomerSource fromString(@Nullable String jsonString) {
        try {
            return CustomerSource.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static CustomerSource fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String objectString = StripeJsonUtils.optString(jsonObject, "object");
        StripeModel sourceObject = "card".equals(objectString) ? Card.fromJson(jsonObject) : ("source".equals(objectString) ? Source.fromJson(jsonObject) : null);
        if (sourceObject == null) {
            return null;
        }
        return new CustomerSource((StripePaymentSource)((Object)sourceObject));
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        if (this.mStripePaymentSource instanceof Source) {
            return ((Source)this.mStripePaymentSource).toMap();
        }
        if (this.mStripePaymentSource instanceof Card) {
            return ((Card)this.mStripePaymentSource).toMap();
        }
        return new HashMap<String, Object>();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof CustomerSource && this.typedEquals((CustomerSource)obj);
    }

    private boolean typedEquals(@NonNull CustomerSource customerSource) {
        return ObjectUtils.equals(this.mStripePaymentSource, customerSource.mStripePaymentSource);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash(this.mStripePaymentSource);
    }
}

