/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.PaymentIntent;
import org.json.JSONException;
import org.json.JSONObject;

public final class Stripe3ds2Fingerprint {
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_THREE_D_SECURE_2_SOURCE = "three_d_secure_2_source";
    private static final String FIELD_DIRECTORY_SERVER_NAME = "directory_server_name";
    private static final String FIELD_SERVER_TRANSACTION_ID = "server_transaction_id";
    private static final String TYPE = "stripe_3ds2_fingerprint";
    @NonNull
    public final String source;
    @NonNull
    public final String directoryServerName;
    @NonNull
    public final String serverTransactionId;

    @NonNull
    public static Stripe3ds2Fingerprint create(@NonNull PaymentIntent.SdkData sdkData) {
        if (!sdkData.is3ds2()) {
            throw new IllegalArgumentException("Expected PaymentIntent.SdkData with type='stripe_3ds2_fingerprint'.");
        }
        return new Stripe3ds2Fingerprint((String)sdkData.data.get(FIELD_THREE_D_SECURE_2_SOURCE), Stripe3ds2Fingerprint.toDirectoryServerName((String)sdkData.data.get(FIELD_DIRECTORY_SERVER_NAME)), (String)sdkData.data.get(FIELD_SERVER_TRANSACTION_ID));
    }

    @NonNull
    static Stripe3ds2Fingerprint create(@NonNull JSONObject json) throws JSONException {
        String type = json.optString(FIELD_TYPE);
        if (!TYPE.equals(type)) {
            throw new IllegalArgumentException("Expected JSON with type='stripe_3ds2_fingerprint'. Received type='" + type + "'");
        }
        String source = json.getString(FIELD_THREE_D_SECURE_2_SOURCE);
        String directoryServerName = Stripe3ds2Fingerprint.toDirectoryServerName(json.getString(FIELD_DIRECTORY_SERVER_NAME));
        String serverTransactionId = json.getString(FIELD_SERVER_TRANSACTION_ID);
        return new Stripe3ds2Fingerprint(source, directoryServerName, serverTransactionId);
    }

    @NonNull
    private static String toDirectoryServerName(@Nullable String code) throws IllegalArgumentException {
        if ("american_express".equals(code)) {
            return "american_express";
        }
        if ("mastercard".equals(code)) {
            return "mastercard";
        }
        if ("visa".equals(code)) {
            return "visa";
        }
        throw new IllegalArgumentException("Invalid directory_server_name: " + code);
    }

    private Stripe3ds2Fingerprint(@NonNull String source, @NonNull String directoryServerName, @NonNull String serverTransactionId) {
        this.source = source;
        this.directoryServerName = directoryServerName;
        this.serverTransactionId = serverTransactionId;
    }
}

