/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.Nullable;
import java.util.List;
import java.util.Map;

class StripeResponse {
    private final int mResponseCode;
    @Nullable
    private final String mResponseBody;
    @Nullable
    private final Map<String, List<String>> mResponseHeaders;

    StripeResponse(int responseCode, @Nullable String responseBody, @Nullable Map<String, List<String>> responseHeaders) {
        this.mResponseCode = responseCode;
        this.mResponseBody = responseBody;
        this.mResponseHeaders = responseHeaders;
    }

    int getResponseCode() {
        return this.mResponseCode;
    }

    boolean isOk() {
        return this.mResponseCode == 200;
    }

    boolean hasErrorCode() {
        return this.mResponseCode < 200 || this.mResponseCode >= 300;
    }

    @Nullable
    String getResponseBody() {
        return this.mResponseBody;
    }

    @Nullable
    Map<String, List<String>> getResponseHeaders() {
        return this.mResponseHeaders;
    }

    @Nullable
    String getRequestId() {
        Map<String, List<String>> headers = this.getResponseHeaders();
        List<String> requestIdList = headers == null ? null : headers.get("Request-Id");
        String requestId = requestIdList != null && requestIdList.size() > 0 ? requestIdList.get(0) : null;
        return requestId;
    }
}

