/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.utils.ObjectUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

abstract class StripeRequest {
    static final String CHARSET = "UTF-8";
    @NonNull
    final Method method;
    @Nullable
    final Map<String, ?> params;
    @NonNull
    private final String mUrl;
    @NonNull
    private final String mMimeType;

    StripeRequest(@NonNull Method method, @NonNull String url, @Nullable Map<String, ?> params, @NonNull String mimeType) {
        this.method = method;
        this.mUrl = url;
        this.params = params;
        this.mMimeType = mimeType;
    }

    @NonNull
    String getUrl() throws UnsupportedEncodingException, InvalidRequestException {
        return Method.GET == this.method ? this.urlWithQuery() : this.mUrl;
    }

    @NonNull
    String getContentType() {
        return String.format(Locale.ROOT, "%s; charset=%s", this.mMimeType, CHARSET);
    }

    @NonNull
    abstract Map<String, String> getHeaders();

    @NonNull
    abstract byte[] getOutputBytes() throws UnsupportedEncodingException, InvalidRequestException;

    @NonNull
    String createQuery() throws InvalidRequestException, UnsupportedEncodingException {
        StringBuilder queryStringBuffer = new StringBuilder();
        for (Parameter flatParam : this.flattenParams(this.params)) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            queryStringBuffer.append(this.urlEncodePair(flatParam.key, flatParam.value));
        }
        return queryStringBuffer.toString();
    }

    @NonNull
    private String urlWithQuery() throws InvalidRequestException, UnsupportedEncodingException {
        String query = this.createQuery();
        if (query.isEmpty()) {
            return this.mUrl;
        }
        String separator = this.mUrl.contains("?") ? "&" : "?";
        return String.format(Locale.ROOT, "%s%s%s", this.mUrl, separator, query);
    }

    @NonNull
    private List<Parameter> flattenParams(@Nullable Map<String, ?> params) throws InvalidRequestException {
        return this.flattenParamsMap(params, null);
    }

    @NonNull
    private List<Parameter> flattenParamsList(@NonNull List<?> params, @NonNull String keyPrefix) throws InvalidRequestException {
        LinkedList<Parameter> flatParams = new LinkedList<Parameter>();
        if (params.isEmpty()) {
            flatParams.add(new Parameter(keyPrefix, ""));
        } else {
            String newPrefix = String.format(Locale.ROOT, "%s[]", keyPrefix);
            for (Object param : params) {
                flatParams.addAll(this.flattenParamsValue(param, newPrefix));
            }
        }
        return flatParams;
    }

    @NonNull
    private List<Parameter> flattenParamsMap(@Nullable Map<String, ?> params, @Nullable String keyPrefix) throws InvalidRequestException {
        LinkedList<Parameter> flatParams = new LinkedList<Parameter>();
        if (params == null) {
            return flatParams;
        }
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String newPrefix = keyPrefix != null ? String.format(Locale.ROOT, "%s[%s]", keyPrefix, key) : key;
            flatParams.addAll(this.flattenParamsValue(value, newPrefix));
        }
        return flatParams;
    }

    @NonNull
    private List<Parameter> flattenParamsValue(@Nullable Object value, @NonNull String keyPrefix) throws InvalidRequestException {
        List<Parameter> flatParams;
        if (value instanceof Map) {
            flatParams = this.flattenParamsMap((Map)value, keyPrefix);
        } else if (value instanceof List) {
            flatParams = this.flattenParamsList((List)value, keyPrefix);
        } else {
            if ("".equals(value)) {
                throw new InvalidRequestException("You cannot set '" + keyPrefix + "' to an empty string. We interpret empty strings as null in requests. You may set '" + keyPrefix + "' to null to delete the property.", keyPrefix, null, 0, null, null, null, null);
            }
            if (value == null) {
                flatParams = new LinkedList<Parameter>();
                flatParams.add(new Parameter(keyPrefix, ""));
            } else {
                flatParams = new LinkedList<Parameter>();
                flatParams.add(new Parameter(keyPrefix, value.toString()));
            }
        }
        return flatParams;
    }

    @NonNull
    private String urlEncodePair(@NonNull String k, @NonNull String v) throws UnsupportedEncodingException {
        return String.format(Locale.ROOT, "%s=%s", this.urlEncode(k), this.urlEncode(v));
    }

    @Nullable
    private String urlEncode(@Nullable String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET);
    }

    int getBaseHashCode() {
        return ObjectUtils.hash((Object[])new Object[]{this.method, this.mUrl, this.params});
    }

    boolean typedEquals(@NonNull StripeRequest request) {
        return ObjectUtils.equals((Object)((Object)this.method), (Object)((Object)request.method)) && ObjectUtils.equals((Object)this.mUrl, (Object)request.mUrl) && ObjectUtils.equals(this.params, request.params);
    }

    private static final class Parameter {
        @NonNull
        private final String key;
        @NonNull
        private final String value;

        Parameter(@NonNull String key, @NonNull String value) {
            this.key = key;
            this.value = value;
        }
    }

    static enum Method {
        GET("GET"),
        POST("POST"),
        DELETE("DELETE");

        @NonNull
        final String code;

        private Method(String code) {
            this.code = code;
        }
    }
}

