/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONObject;

final class AppInfo {
    @NonNull
    private final String mName;
    @Nullable
    private final String mVersion;
    @Nullable
    private final String mUrl;
    @Nullable
    private final String mPartnerId;

    @NonNull
    static AppInfo create(@NonNull String name) {
        return new AppInfo(name, null, null, null);
    }

    @NonNull
    static AppInfo create(@NonNull String name, @NonNull String version) {
        return new AppInfo(name, version, null, null);
    }

    @NonNull
    static AppInfo create(@NonNull String name, @NonNull String version, @NonNull String url) {
        return new AppInfo(name, version, url, null);
    }

    @NonNull
    static AppInfo create(@NonNull String name, @NonNull String version, @NonNull String url, @NonNull String partnerId) {
        return new AppInfo(name, version, url, partnerId);
    }

    private AppInfo(@NonNull String name, @Nullable String version, @Nullable String url, @Nullable String partnerId) {
        this.mName = Objects.requireNonNull(name);
        this.mVersion = version;
        this.mUrl = url;
        this.mPartnerId = partnerId;
    }

    @NonNull
    String toUserAgent() {
        StringBuilder str = new StringBuilder(this.mName);
        if (this.mVersion != null) {
            str.append(String.format("/%s", this.mVersion));
        }
        if (this.mUrl != null) {
            str.append(String.format(" (%s)", this.mUrl));
        }
        return str.toString();
    }

    @NonNull
    Map<String, String> createClientHeaders() {
        HashMap<String, String> appInfo = new HashMap<String, String>(3);
        ((AbstractMap)appInfo).put("name", this.mName);
        ((AbstractMap)appInfo).put("version", this.mVersion);
        ((AbstractMap)appInfo).put("url", this.mUrl);
        ((AbstractMap)appInfo).put("partnerId", this.mPartnerId);
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("application", new JSONObject(appInfo).toString());
        return header;
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj) || obj instanceof AppInfo && this.typedEquals((AppInfo)obj);
    }

    private boolean typedEquals(@NonNull AppInfo appInfo) {
        return ObjectUtils.equals((Object)this.mName, (Object)appInfo.mName) && ObjectUtils.equals((Object)this.mVersion, (Object)appInfo.mVersion) && ObjectUtils.equals((Object)this.mUrl, (Object)appInfo.mUrl) && ObjectUtils.equals((Object)this.mPartnerId, (Object)appInfo.mPartnerId);
    }

    public int hashCode() {
        return ObjectUtils.hash((Object[])new Object[]{this.mName, this.mVersion, this.mUrl, this.mPartnerId});
    }
}

