/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

final class RequestOptions {
    @Nullable
    private final String mGuid;
    @Nullable
    private final String mPublishableApiKey;
    private final int mRequestType;
    @Nullable
    private final String mStripeAccount;

    @NonNull
    static RequestOptions createForFingerprinting(@NonNull String guid) {
        return new RequestOptions(1, null, null, guid);
    }

    @NonNull
    static RequestOptions createForApi(@NonNull String publishableApiKey) {
        return new RequestOptions(0, publishableApiKey, null, null);
    }

    @NonNull
    static RequestOptions createForApi(@NonNull String publishableApiKey, @Nullable String stripeAccount) {
        return new RequestOptions(0, publishableApiKey, stripeAccount, null);
    }

    private RequestOptions(int requestType, @Nullable String publishableApiKey, @Nullable String stripeAccount, @Nullable String guid) {
        this.mGuid = guid;
        this.mPublishableApiKey = publishableApiKey;
        this.mRequestType = requestType;
        this.mStripeAccount = stripeAccount;
    }

    @Nullable
    String getGuid() {
        return this.mGuid;
    }

    @Nullable
    String getPublishableApiKey() {
        return this.mPublishableApiKey;
    }

    int getRequestType() {
        return this.mRequestType;
    }

    @Nullable
    String getStripeAccount() {
        return this.mStripeAccount;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestType {
        public static final int API = 0;
        public static final int FINGERPRINTING = 1;
    }
}

