/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class StripeJsonModel {
    @NonNull
    public abstract Map<String, Object> toMap();

    @NonNull
    public abstract JSONObject toJson();

    static void putStripeJsonModelMapIfNotNull(@NonNull Map<String, Object> upperLevelMap, @NonNull @Size(min=1L) String key, @Nullable StripeJsonModel jsonModel) {
        if (jsonModel == null) {
            return;
        }
        upperLevelMap.put(key, jsonModel.toMap());
    }

    static void putStripeJsonModelIfNotNull(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String key, @Nullable StripeJsonModel jsonModel) {
        if (jsonModel == null) {
            return;
        }
        try {
            jsonObject.put(key, (Object)jsonModel.toJson());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    static void putStripeJsonModelListIfNotNull(@NonNull Map<String, Object> upperLevelMap, @NonNull @Size(min=1L) String key, @Nullable List<? extends StripeJsonModel> jsonModelList) {
        if (jsonModelList == null) {
            return;
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < jsonModelList.size(); ++i) {
            mapList.add(jsonModelList.get(i).toMap());
        }
        upperLevelMap.put(key, mapList);
    }

    static void putStripeJsonModelListIfNotNull(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String key, @Nullable List<? extends StripeJsonModel> jsonModelList) {
        if (jsonModelList == null) {
            return;
        }
        try {
            JSONArray array = new JSONArray();
            for (StripeJsonModel stripeJsonModel : jsonModelList) {
                array.put((Object)stripeJsonModel.toJson());
            }
            jsonObject.put(key, (Object)array);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

