/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

class RequestOptions {
    static final String TYPE_QUERY = "source";
    static final String TYPE_JSON = "json_data";
    @Nullable
    private final String mGuid;
    @Nullable
    private final String mIdempotencyKey;
    @Nullable
    private final String mPublishableApiKey;
    @NonNull
    private final String mRequestType;
    @Nullable
    private final String mStripeAccount;

    private RequestOptions(@Nullable String guid, @Nullable String idempotencyKey, @Nullable String publishableApiKey, @NonNull String requestType, @Nullable String stripeAccount) {
        this.mGuid = guid;
        this.mIdempotencyKey = idempotencyKey;
        this.mPublishableApiKey = publishableApiKey;
        this.mRequestType = requestType;
        this.mStripeAccount = stripeAccount;
    }

    @Nullable
    String getGuid() {
        return this.mGuid;
    }

    @Nullable
    String getIdempotencyKey() {
        return this.mIdempotencyKey;
    }

    @Nullable
    String getPublishableApiKey() {
        return this.mPublishableApiKey;
    }

    @NonNull
    String getRequestType() {
        return this.mRequestType;
    }

    @Nullable
    String getStripeAccount() {
        return this.mStripeAccount;
    }

    public static Builder builder(@Nullable String publishableApiKey) {
        return RequestOptions.builder(publishableApiKey, TYPE_QUERY);
    }

    @NonNull
    public static Builder builder(@Nullable String publishableApiKey, @Nullable String stripeAccount, @NonNull String requestType) {
        return new Builder(publishableApiKey, requestType).setStripeAccount(stripeAccount);
    }

    @NonNull
    public static Builder builder(@Nullable String publishableApiKey, @NonNull String requestType) {
        return new Builder(publishableApiKey, requestType);
    }

    static final class Builder {
        private String guid;
        private String idempotencyKey;
        private String publishableApiKey;
        private String requestType;
        private String stripeAccount;

        Builder(@Nullable String publishableApiKey, @NonNull String requestType) {
            this.publishableApiKey = publishableApiKey;
            this.requestType = requestType;
        }

        @NonNull
        Builder setPublishableApiKey(@NonNull String publishableApiKey) {
            this.publishableApiKey = publishableApiKey;
            return this;
        }

        @NonNull
        Builder setIdempotencyKey(@Nullable String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @NonNull
        Builder setGuid(@Nullable String guid) {
            this.guid = guid;
            return this;
        }

        @NonNull
        Builder setStripeAccount(@Nullable String stripeAccount) {
            this.stripeAccount = stripeAccount;
            return this;
        }

        @NonNull
        public RequestOptions build() {
            return new RequestOptions(this.guid, this.idempotencyKey, this.publishableApiKey, this.requestType, this.stripeAccount);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestType {
    }
}

