/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentIntent
extends StripeJsonModel {
    private static final String VALUE_PAYMENT_INTENT = "payment_intent";
    static final String FIELD_ID = "id";
    static final String FIELD_OBJECT = "object";
    static final String FIELD_AMOUNT = "amount";
    static final String FIELD_CREATED = "created";
    static final String FIELD_CANCELED = "canceled_at";
    static final String FIELD_CAPTURE_METHOD = "capture_method";
    static final String FIELD_CLIENT_SECRET = "client_secret";
    static final String FIELD_CONFIRMATION_METHOD = "confirmation_method";
    static final String FIELD_CURRENCY = "currency";
    static final String FIELD_DESCRIPTION = "description";
    static final String FIELD_LIVEMODE = "livemode";
    static final String FIELD_NEXT_ACTION = "next_action";
    static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    static final String FIELD_RECEIPT_EMAIL = "receipt_email";
    static final String FIELD_SOURCE = "source";
    static final String FIELD_STATUS = "status";
    private static final String FIELD_NEXT_ACTION_TYPE = "type";
    @Nullable
    private final String mId;
    @Nullable
    private final String mObjectType;
    @NonNull
    private final List<String> mPaymentMethodTypes;
    @Nullable
    private final Long mAmount;
    @Nullable
    private final Long mCanceledAt;
    @Nullable
    private final String mCaptureMethod;
    @Nullable
    private final String mClientSecret;
    @Nullable
    private final String mConfirmationMethod;
    @Nullable
    private final Long mCreated;
    @Nullable
    private final String mCurrency;
    @Nullable
    private final String mDescription;
    @Nullable
    private final Boolean mLiveMode;
    @Nullable
    private final Map<String, Object> mNextAction;
    @Nullable
    private final String mReceiptEmail;
    @Nullable
    private final String mSource;
    @Nullable
    private final Status mStatus;

    @Nullable
    public String getId() {
        return this.mId;
    }

    @NonNull
    public List<String> getPaymentMethodTypes() {
        return this.mPaymentMethodTypes;
    }

    @Nullable
    public Long getAmount() {
        return this.mAmount;
    }

    @Nullable
    public Long getCanceledAt() {
        return this.mCanceledAt;
    }

    @Nullable
    public String getCaptureMethod() {
        return this.mCaptureMethod;
    }

    @Nullable
    public String getClientSecret() {
        return this.mClientSecret;
    }

    @Nullable
    public String getConfirmationMethod() {
        return this.mConfirmationMethod;
    }

    @Nullable
    public Long getCreated() {
        return this.mCreated;
    }

    @Nullable
    public String getCurrency() {
        return this.mCurrency;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    @Nullable
    public Boolean isLiveMode() {
        return this.mLiveMode;
    }

    public boolean requiresAction() {
        return this.mStatus == Status.RequiresAction;
    }

    @Nullable
    public Map<String, Object> getNextAction() {
        return this.mNextAction;
    }

    @Nullable
    public Uri getRedirectUrl() {
        RedirectData redirectData = this.getRedirectData();
        if (redirectData == null) {
            return null;
        }
        return redirectData.url;
    }

    @Nullable
    public RedirectData getRedirectData() {
        Object redirectToUrl;
        Map<String, Object> nextAction = Status.RequiresAction == this.mStatus ? this.mNextAction : null;
        if (nextAction == null) {
            return null;
        }
        NextActionType nextActionType = NextActionType.fromCode((String)nextAction.get(FIELD_NEXT_ACTION_TYPE));
        if (NextActionType.RedirectToUrl == nextActionType && (redirectToUrl = nextAction.get(nextActionType.code)) instanceof Map) {
            return RedirectData.create((Map)redirectToUrl);
        }
        return null;
    }

    @Nullable
    public String getReceiptEmail() {
        return this.mReceiptEmail;
    }

    @Nullable
    public String getSource() {
        return this.mSource;
    }

    @Nullable
    public Status getStatus() {
        return this.mStatus;
    }

    private PaymentIntent(@Nullable String id, @Nullable String objectType, @NonNull List<String> paymentMethodTypes, @Nullable Long amount, @Nullable Long canceledAt, @Nullable String captureMethod, @Nullable String clientSecret, @Nullable String confirmationMethod, @Nullable Long created, @Nullable String currency, @Nullable String description, @Nullable Boolean liveMode, @Nullable Map<String, Object> nextAction, @Nullable String receiptEmail, @Nullable String source, @Nullable Status status) {
        this.mId = id;
        this.mObjectType = objectType;
        this.mPaymentMethodTypes = paymentMethodTypes;
        this.mAmount = amount;
        this.mCanceledAt = canceledAt;
        this.mCaptureMethod = captureMethod;
        this.mClientSecret = clientSecret;
        this.mConfirmationMethod = confirmationMethod;
        this.mCreated = created;
        this.mCurrency = currency;
        this.mDescription = description;
        this.mLiveMode = liveMode;
        this.mNextAction = nextAction;
        this.mReceiptEmail = receiptEmail;
        this.mSource = source;
        this.mStatus = status;
    }

    @NonNull
    public static String parseIdFromClientSecret(@NonNull String clientSecret) {
        return clientSecret.split("_secret")[0];
    }

    @Nullable
    public static PaymentIntent fromString(@Nullable String jsonString) {
        try {
            return PaymentIntent.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static PaymentIntent fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null || !VALUE_PAYMENT_INTENT.equals(jsonObject.optString(FIELD_OBJECT))) {
            return null;
        }
        String id = StripeJsonUtils.optString(jsonObject, FIELD_ID);
        String objectType = StripeJsonUtils.optString(jsonObject, FIELD_OBJECT);
        List<String> paymentMethodTypes = PaymentIntent.jsonArrayToList(jsonObject.optJSONArray(FIELD_PAYMENT_METHOD_TYPES));
        Long amount = StripeJsonUtils.optLong(jsonObject, FIELD_AMOUNT);
        Long canceledAt = StripeJsonUtils.optLong(jsonObject, FIELD_CANCELED);
        String captureMethod = StripeJsonUtils.optString(jsonObject, FIELD_CAPTURE_METHOD);
        String clientSecret = StripeJsonUtils.optString(jsonObject, FIELD_CLIENT_SECRET);
        String confirmationMethod = StripeJsonUtils.optString(jsonObject, FIELD_CONFIRMATION_METHOD);
        Long created = StripeJsonUtils.optLong(jsonObject, FIELD_CREATED);
        String currency = StripeJsonUtils.optCurrency(jsonObject, FIELD_CURRENCY);
        String description = StripeJsonUtils.optString(jsonObject, FIELD_DESCRIPTION);
        Boolean livemode = StripeJsonUtils.optBoolean(jsonObject, FIELD_LIVEMODE);
        String receiptEmail = StripeJsonUtils.optString(jsonObject, FIELD_RECEIPT_EMAIL);
        Status status = Status.fromCode(StripeJsonUtils.optString(jsonObject, FIELD_STATUS));
        Map<String, Object> nextAction = StripeJsonUtils.optMap(jsonObject, FIELD_NEXT_ACTION);
        String source = StripeJsonUtils.optString(jsonObject, FIELD_SOURCE);
        return new PaymentIntent(id, objectType, paymentMethodTypes, amount, canceledAt, captureMethod, clientSecret, confirmationMethod, created, currency, description, livemode, nextAction, receiptEmail, source, status);
    }

    @NonNull
    private static List<String> jsonArrayToList(@Nullable JSONArray jsonArray) {
        ArrayList<String> list = new ArrayList<String>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                try {
                    list.add(jsonArray.getString(i));
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_ID, this.mId);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_OBJECT, this.mObjectType);
        StripeJsonUtils.putArrayIfNotNull(jsonObject, FIELD_PAYMENT_METHOD_TYPES, StripeJsonUtils.listToJsonArray(this.mPaymentMethodTypes));
        StripeJsonUtils.putLongIfNotNull(jsonObject, FIELD_AMOUNT, this.mAmount);
        StripeJsonUtils.putLongIfNotNull(jsonObject, FIELD_CANCELED, this.mCanceledAt);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_CAPTURE_METHOD, this.mCaptureMethod);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_CLIENT_SECRET, this.mClientSecret);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_CONFIRMATION_METHOD, this.mConfirmationMethod);
        StripeJsonUtils.putLongIfNotNull(jsonObject, FIELD_CREATED, this.mCreated);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_CURRENCY, this.mCurrency);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_DESCRIPTION, this.mDescription);
        StripeJsonUtils.putBooleanIfNotNull(jsonObject, FIELD_LIVEMODE, this.mLiveMode);
        StripeJsonUtils.putMapIfNotNull(jsonObject, FIELD_NEXT_ACTION, this.mNextAction);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_RECEIPT_EMAIL, this.mReceiptEmail);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_SOURCE, this.mSource);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_STATUS, this.mStatus != null ? this.mStatus.code : null);
        return jsonObject;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ((AbstractMap)map).put(FIELD_ID, this.mId);
        ((AbstractMap)map).put(FIELD_OBJECT, this.mObjectType);
        ((AbstractMap)map).put(FIELD_PAYMENT_METHOD_TYPES, this.mPaymentMethodTypes);
        ((AbstractMap)map).put(FIELD_AMOUNT, this.mAmount);
        ((AbstractMap)map).put(FIELD_CANCELED, this.mCanceledAt);
        ((AbstractMap)map).put(FIELD_CLIENT_SECRET, this.mClientSecret);
        ((AbstractMap)map).put(FIELD_CAPTURE_METHOD, this.mCaptureMethod);
        ((AbstractMap)map).put(FIELD_CONFIRMATION_METHOD, this.mConfirmationMethod);
        ((AbstractMap)map).put(FIELD_CREATED, this.mCreated);
        ((AbstractMap)map).put(FIELD_CURRENCY, this.mCurrency);
        ((AbstractMap)map).put(FIELD_DESCRIPTION, this.mDescription);
        ((AbstractMap)map).put(FIELD_LIVEMODE, this.mLiveMode);
        ((AbstractMap)map).put(FIELD_NEXT_ACTION, this.mNextAction);
        ((AbstractMap)map).put(FIELD_RECEIPT_EMAIL, this.mReceiptEmail);
        ((AbstractMap)map).put(FIELD_STATUS, this.mStatus != null ? this.mStatus.code : null);
        ((AbstractMap)map).put(FIELD_SOURCE, this.mSource);
        StripeNetworkUtils.removeNullAndEmptyParams(map);
        return map;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof PaymentIntent && this.typedEquals((PaymentIntent)obj);
    }

    private boolean typedEquals(@NonNull PaymentIntent paymentIntent) {
        return ObjectUtils.equals(this.mId, paymentIntent.mId) && ObjectUtils.equals(this.mObjectType, paymentIntent.mObjectType) && ObjectUtils.equals(this.mAmount, paymentIntent.mAmount) && ObjectUtils.equals(this.mCanceledAt, paymentIntent.mCanceledAt) && ObjectUtils.equals(this.mCaptureMethod, paymentIntent.mCaptureMethod) && ObjectUtils.equals(this.mClientSecret, paymentIntent.mClientSecret) && ObjectUtils.equals(this.mConfirmationMethod, paymentIntent.mConfirmationMethod) && ObjectUtils.equals(this.mCreated, paymentIntent.mCreated) && ObjectUtils.equals(this.mCurrency, paymentIntent.mCurrency) && ObjectUtils.equals(this.mDescription, paymentIntent.mDescription) && ObjectUtils.equals(this.mLiveMode, paymentIntent.mLiveMode) && ObjectUtils.equals(this.mReceiptEmail, paymentIntent.mReceiptEmail) && ObjectUtils.equals(this.mSource, paymentIntent.mSource) && ObjectUtils.equals((Object)this.mStatus, (Object)paymentIntent.mStatus);
    }

    public int hashCode() {
        return ObjectUtils.hash(new Object[]{this.mId, this.mObjectType, this.mAmount, this.mCanceledAt, this.mCaptureMethod, this.mClientSecret, this.mConfirmationMethod, this.mCreated, this.mCurrency, this.mDescription, this.mLiveMode, this.mReceiptEmail, this.mSource, this.mStatus});
    }

    public static class RedirectData {
        static final String FIELD_URL = "url";
        static final String FIELD_RETURN_URL = "return_url";
        @NonNull
        public final Uri url;
        @Nullable
        public final Uri returnUrl;

        @Nullable
        static RedirectData create(@NonNull Map<?, ?> redirectToUrlHash) {
            String returnUrl;
            Object urlObj = redirectToUrlHash.get(FIELD_URL);
            Object returnUrlObj = redirectToUrlHash.get(FIELD_RETURN_URL);
            String url = urlObj instanceof String ? urlObj.toString() : null;
            String string = returnUrl = returnUrlObj instanceof String ? returnUrlObj.toString() : null;
            if (url == null) {
                return null;
            }
            return new RedirectData(url, returnUrl);
        }

        private RedirectData(@NonNull String url, @Nullable String returnUrl) {
            this.url = Uri.parse((String)url);
            this.returnUrl = returnUrl != null ? Uri.parse((String)returnUrl) : null;
        }
    }

    public static enum Status {
        Canceled("canceled"),
        Processing("processing"),
        RequiresAction("requires_action"),
        RequiresAuthorization("requires_authorization"),
        RequiresCapture("requires_capture"),
        RequiresConfirmation("requires_confirmation"),
        RequiresPaymentMethod("requires_payment_method"),
        Succeeded("succeeded");

        @NonNull
        public final String code;

        private Status(String code) {
            this.code = code;
        }

        @Nullable
        public static Status fromCode(@Nullable String code) {
            if (code == null) {
                return null;
            }
            for (Status status : Status.values()) {
                if (!status.code.equals(code)) continue;
                return status;
            }
            return null;
        }

        @NonNull
        public String toString() {
            return this.code;
        }
    }

    public static enum NextActionType {
        RedirectToUrl("redirect_to_url"),
        UseStripeSdk("use_stripe_sdk");

        @NonNull
        public final String code;

        private NextActionType(String code) {
            this.code = code;
        }

        @Nullable
        public static NextActionType fromCode(@Nullable String code) {
            if (code == null) {
                return null;
            }
            for (NextActionType nextActionType : NextActionType.values()) {
                if (!nextActionType.code.equals(code)) continue;
                return nextActionType;
            }
            return null;
        }

        @NonNull
        public String toString() {
            return this.code;
        }
    }
}

