/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StripeTextUtils {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    @Nullable
    public static String nullIfBlank(@Nullable String value) {
        if (StripeTextUtils.isBlank(value)) {
            return null;
        }
        return value;
    }

    public static boolean isBlank(@Nullable String value) {
        return value == null || value.trim().length() == 0;
    }

    @Nullable
    public static String removeSpacesAndHyphens(@Nullable String cardNumberWithSpaces) {
        if (StripeTextUtils.isBlank(cardNumberWithSpaces)) {
            return null;
        }
        return cardNumberWithSpaces.replaceAll("\\s|-", "");
    }

    static boolean hasAnyPrefix(@Nullable String number, String ... prefixes) {
        if (number == null) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!number.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static String shaHashInput(@Nullable String toHash) {
        if (StripeTextUtils.isBlank(toHash)) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] bytes = toHash.getBytes("UTF-8");
            digest.update(bytes, 0, bytes.length);
            return StripeTextUtils.bytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithm) {
            return null;
        }
        catch (UnsupportedEncodingException unsupportedCoding) {
            return null;
        }
    }

    @NonNull
    private static String bytesToHex(@NonNull byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_ARRAY[v >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

