/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.PaymentSessionUtils;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.ShippingMethod;

public class PaymentSessionData
implements Parcelable {
    private static final String NO_PAYMENT = "NO_PAYMENT";
    private long mCartTotal = 0L;
    private boolean mIsPaymentReadyToCharge;
    @NonNull
    private String mSelectedPaymentMethodId = "NO_PAYMENT";
    private long mShippingTotal = 0L;
    @NonNull
    private String mPaymentResult = "incomplete";
    @Nullable
    private ShippingInformation mShippingInformation;
    @Nullable
    private ShippingMethod mShippingMethod;
    public static final Parcelable.Creator<PaymentSessionData> CREATOR = new Parcelable.Creator<PaymentSessionData>(){

        public PaymentSessionData createFromParcel(Parcel in) {
            return new PaymentSessionData(in);
        }

        public PaymentSessionData[] newArray(int size) {
            return new PaymentSessionData[size];
        }
    };

    public PaymentSessionData() {
    }

    @Nullable
    public String getSelectedPaymentMethodId() {
        return this.mSelectedPaymentMethodId.equals(NO_PAYMENT) ? null : this.mSelectedPaymentMethodId;
    }

    public long getCartTotal() {
        return this.mCartTotal;
    }

    @NonNull
    public String getPaymentResult() {
        return this.mPaymentResult;
    }

    public boolean isPaymentReadyToCharge() {
        return this.mIsPaymentReadyToCharge;
    }

    public void setPaymentReadyToCharge(boolean paymentReadyToCharge) {
        this.mIsPaymentReadyToCharge = paymentReadyToCharge;
    }

    public long getShippingTotal() {
        return this.mShippingTotal;
    }

    @Nullable
    public ShippingInformation getShippingInformation() {
        return this.mShippingInformation;
    }

    public void setShippingInformation(@Nullable ShippingInformation shippingInformation) {
        this.mShippingInformation = shippingInformation;
    }

    @Nullable
    public ShippingMethod getShippingMethod() {
        return this.mShippingMethod;
    }

    public void setShippingMethod(@Nullable ShippingMethod shippingMethod) {
        this.mShippingMethod = shippingMethod;
    }

    void setCartTotal(long cartTotal) {
        this.mCartTotal = cartTotal;
    }

    void setPaymentResult(@NonNull String result) {
        this.mPaymentResult = result;
    }

    void setSelectedPaymentMethodId(@Nullable String selectedPaymentMethodId) {
        this.mSelectedPaymentMethodId = selectedPaymentMethodId == null ? NO_PAYMENT : selectedPaymentMethodId;
    }

    void setShippingTotal(long shippingTotal) {
        this.mShippingTotal = shippingTotal;
    }

    public boolean updateIsPaymentReadyToCharge(@NonNull PaymentSessionConfig config) {
        if (StripeTextUtils.isBlank(this.getSelectedPaymentMethodId()) || config.isShippingInfoRequired() && this.getShippingInformation() == null || config.isShippingMethodRequired() && this.getShippingMethod() == null) {
            this.setPaymentReadyToCharge(false);
            return false;
        }
        this.setPaymentReadyToCharge(true);
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentSessionData that = (PaymentSessionData)o;
        if (this.mCartTotal != that.mCartTotal) {
            return false;
        }
        if (this.mIsPaymentReadyToCharge != that.mIsPaymentReadyToCharge) {
            return false;
        }
        if (this.mShippingTotal != that.mShippingTotal) {
            return false;
        }
        if (!this.mSelectedPaymentMethodId.equals(that.mSelectedPaymentMethodId)) {
            return false;
        }
        if (!this.mPaymentResult.equals(that.mPaymentResult)) {
            return false;
        }
        if (this.mShippingInformation != null ? !this.mShippingInformation.equals(that.mShippingInformation) : that.mShippingInformation != null) {
            return false;
        }
        return this.mShippingMethod != null ? this.mShippingMethod.equals(that.mShippingMethod) : that.mShippingMethod == null;
    }

    public int hashCode() {
        int result = (int)(this.mCartTotal ^ this.mCartTotal >>> 32);
        result = 31 * result + (this.mIsPaymentReadyToCharge ? 1 : 0);
        result = 31 * result + this.mSelectedPaymentMethodId.hashCode();
        result = 31 * result + (int)(this.mShippingTotal ^ this.mShippingTotal >>> 32);
        result = 31 * result + this.mPaymentResult.hashCode();
        result = 31 * result + (this.mShippingInformation != null ? this.mShippingInformation.hashCode() : 0);
        result = 31 * result + (this.mShippingMethod != null ? this.mShippingMethod.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeLong(this.mCartTotal);
        parcel.writeInt(this.mIsPaymentReadyToCharge ? 1 : 0);
        parcel.writeString(this.mPaymentResult);
        parcel.writeString(this.mSelectedPaymentMethodId);
        parcel.writeParcelable((Parcelable)this.mShippingInformation, i);
        parcel.writeParcelable((Parcelable)this.mShippingMethod, i);
        parcel.writeLong(this.mShippingTotal);
    }

    private PaymentSessionData(@NonNull Parcel in) {
        this.mCartTotal = in.readLong();
        this.mIsPaymentReadyToCharge = in.readInt() == 1;
        this.mPaymentResult = PaymentSessionUtils.paymentResultFromString(in.readString());
        this.mSelectedPaymentMethodId = in.readString();
        this.mShippingInformation = (ShippingInformation)in.readParcelable(ShippingInformation.class.getClassLoader());
        this.mShippingMethod = (ShippingMethod)in.readParcelable(ShippingMethod.class.getClassLoader());
        this.mShippingTotal = in.readLong();
    }
}

